/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.patternlanguage.emf.util.IProjectHelper;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.ui.validation.ProjectAwareUniqueClassNameValidator;

public class EMFPatternLanguageUniqueClassNameValidator
extends ProjectAwareUniqueClassNameValidator {
    @Inject
    private IProjectHelper projectHelper;

    protected boolean checkUniqueInIndex(JvmDeclaredType type, Iterable<IEObjectDescription> descriptions) {
        URI objectURI = EcoreUtil.getURI((EObject)type);
        if (objectURI.isPlatformResource()) {
            String project = objectURI.segment(1);
            return super.checkUniqueInIndex(type, Iterables.filter(descriptions, it -> {
                URI candidate = it.getEObjectURI();
                return candidate.isPlatformResource() && this.projectHelper.isStandaloneFileURI((EObject)type, candidate) && Objects.equals(candidate.segment(1), project);
            }));
        }
        return true;
    }
}

