/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.debug.variables;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;

public class ValueWrapper
implements Comparable<ValueWrapper> {
    private Value value;
    private ThreadReference threadReference;
    private static ValueWrapper NULL_WRAPPER = ValueWrapper.wrap(null, null);

    private ValueWrapper(Value value, ThreadReference threadReference) {
        this.value = value;
        this.threadReference = threadReference;
    }

    public static ValueWrapper wrap(Value value, ThreadReference threadReference) {
        return new ValueWrapper(value, threadReference);
    }

    public Value getValue() {
        return this.value;
    }

    public ThreadReference getThreadReference() {
        return this.threadReference;
    }

    public boolean isArray() {
        return this.value != null && this.value instanceof ArrayReference;
    }

    public boolean isReference() {
        return this.value != null && this.value instanceof ObjectReference;
    }

    public int getArrayLength() {
        if (this.isArray()) {
            return ((ArrayReference)this.value).length();
        }
        return 0;
    }

    public ValueWrapper get(String fieldName) {
        if (this.value == null || !(this.value instanceof ObjectReference)) {
            return NULL_WRAPPER;
        }
        Field field = ((ObjectReference)this.value).referenceType().fieldByName(fieldName);
        return ValueWrapper.wrap(field == null ? null : ((ObjectReference)this.value).getValue(field), this.threadReference);
    }

    public ValueWrapper invoke(String methodName) {
        if (this.value == null || this.threadReference == null || !(this.value instanceof ObjectReference)) {
            return NULL_WRAPPER;
        }
        Value result = null;
        int t = 0;
        Method method = null;
        List<Method> methods = ((ObjectReference)this.value).referenceType().methodsByName(methodName);
        for (Method m : methods) {
            if (!m.argumentTypeNames().isEmpty()) continue;
            method = m;
            break;
        }
        if (method != null) {
            while (result == null && t < 5) {
                try {
                    result = ((ObjectReference)this.value).invokeMethod(this.threadReference, method, Collections.emptyList(), 0);
                }
                catch (Exception e) {
                    result = null;
                }
                ++t;
            }
        }
        return ValueWrapper.wrap(result, this.threadReference);
    }

    @Override
    public int compareTo(ValueWrapper that) {
        if (this.value instanceof ObjectReference && that.value instanceof ObjectReference) {
            return Long.valueOf(((ObjectReference)this.value).uniqueID()).compareTo(((ObjectReference)that.value).uniqueID());
        }
        return Integer.valueOf(this.hashCode()).compareTo(that.hashCode());
    }

    public int hashCode() {
        if (this.value == null) {
            return super.hashCode();
        }
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ValueWrapper that = (ValueWrapper)obj;
        return this.value.equals(that.value);
    }
}

