/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BufferType;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProbeEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.UstProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.BaseEventPropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.KernelProviderPropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TargetNodePropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceChannelPropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceDomainPropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceEventPropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceProbeEventPropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceSessionPropertySource;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.UstProviderPropertySource;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.ui.views.properties.IPropertySource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlPropertiesTest {
    private TraceControlTestFacility fFacility;
    private static final String DIRECTORY = "testfiles";
    private static final String TEST_STREAM = "ListInfoTest.cfg";
    private static final String SCEN_LIST_INFO_TEST = "ListInfoTest";

    @Before
    public void setUp() {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
    }

    @After
    public void tearDown() {
        this.fFacility.dispose();
    }

    @Test
    public void testComponentProperties() throws Exception {
        IRemoteConnection host = TmfRemoteConnectionFactory.getLocalConnection();
        TestRemoteSystemProxy proxy = new TestRemoteSystemProxy(host);
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path(DIRECTORY + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        proxy.setTestFile(testfile.getAbsolutePath());
        proxy.setScenario(SCEN_LIST_INFO_TEST);
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent("myNode", root, (RemoteSystemProxy)proxy);
        root.addChild((ITraceControlComponent)node);
        node.connect();
        this.fFacility.waitForConnect(node);
        this.fFacility.waitForJobs();
        Object adapter = node.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof TargetNodePropertySource));
        TargetNodePropertySource source = (TargetNodePropertySource)adapter;
        Assert.assertNull((Object)source.getEditableValue());
        Assert.assertFalse((boolean)source.isPropertySet((Object)"target.node.name"));
        Assert.assertNotNull((Object)source.getPropertyDescriptors());
        Assert.assertEquals((Object)"myNode", (Object)source.getPropertyValue((Object)"target.node.name"));
        Assert.assertEquals((Object)TargetNodeState.CONNECTED.name(), (Object)source.getPropertyValue((Object)"target.node.state"));
        Assert.assertEquals((Object)"2.5.0", (Object)source.getPropertyValue((Object)"target.node.version"));
        Assert.assertNull((Object)source.getPropertyValue((Object)"test"));
        adapter = node.getAdapter(IChannelInfo.class);
        Assert.assertNull((Object)adapter);
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        ITraceControlComponent[] providers = groups[0].getChildren();
        Assert.assertNotNull((Object)providers);
        Assert.assertEquals((long)3L, (long)providers.length);
        KernelProviderComponent kernelProvider = (KernelProviderComponent)providers[0];
        adapter = kernelProvider.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof KernelProviderPropertySource));
        KernelProviderPropertySource kernelSource = (KernelProviderPropertySource)adapter;
        Assert.assertNotNull((Object)kernelSource.getPropertyDescriptors());
        Assert.assertEquals((Object)"Kernel", (Object)kernelSource.getPropertyValue((Object)"ust.provider.name"));
        UstProviderComponent ustProvider = (UstProviderComponent)providers[1];
        adapter = ustProvider.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof UstProviderPropertySource));
        UstProviderPropertySource ustSource = (UstProviderPropertySource)adapter;
        Assert.assertNotNull((Object)ustSource.getPropertyDescriptors());
        Assert.assertEquals((Object)"/home/user/git/lttng-ust/tests/hello.cxx/.libs/lt-hello [PID=9379]", (Object)ustSource.getPropertyValue((Object)"ust.provider.name"));
        Assert.assertEquals((Object)String.valueOf(9379), (Object)ustSource.getPropertyValue((Object)"ust.provider.pid"));
        ITraceControlComponent[] events = ustProvider.getChildren();
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.length);
        BaseEventComponent baseEventInfo = (BaseEventComponent)events[0];
        Assert.assertNotNull((Object)baseEventInfo);
        adapter = baseEventInfo.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof BaseEventPropertySource));
        BaseEventPropertySource baseSource = (BaseEventPropertySource)adapter;
        Assert.assertNotNull((Object)baseSource.getPropertyDescriptors());
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)baseSource.getPropertyValue((Object)"base.event.name"));
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT.name(), (Object)baseSource.getPropertyValue((Object)"base.event.type"));
        Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_MODULE.name(), (Object)baseSource.getPropertyValue((Object)"base.event.loglevel"));
        baseEventInfo = (BaseEventComponent)events[1];
        Assert.assertNotNull((Object)baseEventInfo);
        adapter = baseEventInfo.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof BaseEventPropertySource));
        baseSource = (BaseEventPropertySource)adapter;
        Assert.assertNotNull((Object)baseSource.getPropertyDescriptors());
        Assert.assertEquals((Object)"doublefield=float;floatfield=float;stringfield=string", (Object)baseSource.getPropertyValue((Object)"base.event.fields"));
        ITraceControlComponent[] sessions = groups[1].getChildren();
        Assert.assertNotNull((Object)sessions);
        Assert.assertEquals((long)2L, (long)sessions.length);
        TraceSessionComponent session = (TraceSessionComponent)sessions[1];
        adapter = session.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof TraceSessionPropertySource));
        TraceSessionPropertySource sessionSource = (TraceSessionPropertySource)adapter;
        Assert.assertNotNull((Object)sessionSource.getPropertyDescriptors());
        Assert.assertEquals((Object)"mysession", (Object)sessionSource.getPropertyValue((Object)"trace.session.name"));
        Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120129-084256", (Object)sessionSource.getPropertyValue((Object)"trace.session.path"));
        Assert.assertEquals((Object)TraceSessionState.ACTIVE.name(), (Object)sessionSource.getPropertyValue((Object)"trace.session.state"));
        ITraceControlComponent[] domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)2L, (long)domains.length);
        TraceDomainComponent domain = (TraceDomainComponent)domains[0];
        adapter = domain.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof TraceDomainPropertySource));
        TraceDomainPropertySource domainSource = (TraceDomainPropertySource)adapter;
        Assert.assertNotNull((Object)domainSource.getPropertyDescriptors());
        Assert.assertEquals((Object)"Kernel", (Object)domainSource.getPropertyValue((Object)"trace.domain.name"));
        Assert.assertEquals((Object)BufferType.BUFFER_SHARED.getInName(), (Object)domainSource.getPropertyValue((Object)"trace.domain.bufferType"));
        ITraceControlComponent[] channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)2L, (long)channels.length);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        TraceChannelComponent channel = (TraceChannelComponent)channels[0];
        adapter = channel.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof TraceChannelPropertySource));
        TraceChannelPropertySource channelSource = (TraceChannelPropertySource)adapter;
        Assert.assertNotNull((Object)channelSource.getPropertyDescriptors());
        Assert.assertEquals((Object)"channel0", (Object)channelSource.getPropertyValue((Object)"trace.channel.name"));
        Assert.assertEquals((Object)String.valueOf(4), (Object)channelSource.getPropertyValue((Object)"trace.channel.no.subbuffers"));
        Assert.assertEquals((Object)TraceEnablement.ENABLED.name(), (Object)channelSource.getPropertyValue((Object)"trace.channel.state"));
        Assert.assertEquals((Object)String.valueOf(false), (Object)channelSource.getPropertyValue((Object)"trace.channel.overwrite.mode"));
        Assert.assertEquals((Object)"splice()", (Object)channelSource.getPropertyValue((Object)"trace.channel.output.type"));
        Assert.assertEquals((Object)String.valueOf(200), (Object)channelSource.getPropertyValue((Object)"trace.channel.read.timer"));
        Assert.assertEquals((Object)String.valueOf(262144), (Object)channelSource.getPropertyValue((Object)"trace.channel.subbuffer.size"));
        Assert.assertEquals((Object)String.valueOf(0), (Object)channelSource.getPropertyValue((Object)"trace.channel.switch.timer"));
        Assert.assertEquals((Object)2, (Object)channelSource.getPropertyValue((Object)"trace.channel.trace.file.count"));
        Assert.assertEquals((Object)262144L, (Object)channelSource.getPropertyValue((Object)"trace.channel.trace.file.size"));
        ITraceControlComponent[] channel0Events = channel.getChildren();
        Assert.assertNotNull((Object)channel0Events);
        Assert.assertEquals((long)5L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        TraceEventComponent event = (TraceEventComponent)channel0Events[0];
        adapter = event.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof TraceEventPropertySource));
        TraceEventPropertySource eventSource = (TraceEventPropertySource)adapter;
        Assert.assertNotNull((Object)eventSource.getPropertyDescriptors());
        Assert.assertEquals((Object)"block_rq_remap", (Object)eventSource.getPropertyValue((Object)"trace.event.name"));
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG.name(), (Object)eventSource.getPropertyValue((Object)"trace.event.loglevel"));
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT.name(), (Object)eventSource.getPropertyValue((Object)"trace.event.type"));
        Assert.assertEquals((Object)TraceEnablement.ENABLED.name(), (Object)eventSource.getPropertyValue((Object)"trace.event.state"));
        Assert.assertTrue((boolean)(channel0Events[2] instanceof TraceProbeEventComponent));
        TraceProbeEventComponent probeEvent = (TraceProbeEventComponent)channel0Events[2];
        adapter = probeEvent.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof TraceProbeEventPropertySource));
        TraceProbeEventPropertySource probeEventSource = (TraceProbeEventPropertySource)adapter;
        Assert.assertNotNull((Object)probeEventSource.getPropertyDescriptors());
        Assert.assertEquals((long)4L, (long)probeEventSource.getPropertyDescriptors().length);
        Assert.assertEquals((Object)"myevent2", (Object)probeEventSource.getPropertyValue((Object)"trace.event.name"));
        Assert.assertEquals((Object)TraceEventType.PROBE.name(), (Object)probeEventSource.getPropertyValue((Object)"trace.event.type"));
        Assert.assertEquals((Object)TraceEnablement.ENABLED.name(), (Object)probeEventSource.getPropertyValue((Object)"trace.event.state"));
        Assert.assertEquals((Object)"0xc0101340", (Object)probeEventSource.getPropertyValue((Object)"trace.event.probe.address"));
        Assert.assertTrue((boolean)(channel0Events[3] instanceof TraceProbeEventComponent));
        probeEvent = (TraceProbeEventComponent)channel0Events[3];
        adapter = probeEvent.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof TraceProbeEventPropertySource));
        probeEventSource = (TraceProbeEventPropertySource)adapter;
        Assert.assertNotNull((Object)probeEventSource.getPropertyDescriptors());
        Assert.assertEquals((long)5L, (long)probeEventSource.getPropertyDescriptors().length);
        Assert.assertEquals((Object)"myevent0", (Object)probeEventSource.getPropertyValue((Object)"trace.event.name"));
        Assert.assertEquals((Object)TraceEventType.PROBE.name(), (Object)probeEventSource.getPropertyValue((Object)"trace.event.type"));
        Assert.assertEquals((Object)TraceEnablement.ENABLED.name(), (Object)probeEventSource.getPropertyValue((Object)"trace.event.state"));
        Assert.assertEquals((Object)"0x0", (Object)probeEventSource.getPropertyValue((Object)"trace.event.probe.offset"));
        Assert.assertEquals((Object)"init_post", (Object)probeEventSource.getPropertyValue((Object)"trace.event.probe.symbol"));
        event = (TraceEventComponent)domains[1].getChildren()[1].getChildren()[0];
        adapter = event.getAdapter(IPropertySource.class);
        Assert.assertEquals((Object)"with filter", (Object)event.getFilterExpression());
        event = (TraceEventComponent)domains[1].getChildren()[1].getChildren()[0];
        adapter = event.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        eventSource = (TraceEventPropertySource)adapter;
        Assert.assertEquals((Object)"== TRACE_DEBUG_LINE", (Object)eventSource.getPropertyValue((Object)"trace.event.loglevel"));
        event = (TraceEventComponent)domains[1].getChildren()[1].getChildren()[1];
        adapter = event.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        eventSource = (TraceEventPropertySource)adapter;
        Assert.assertEquals((Object)"<= TRACE_INFO", (Object)eventSource.getPropertyValue((Object)"trace.event.loglevel"));
        event = (TraceEventComponent)domains[1].getChildren()[1].getChildren()[2];
        adapter = event.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        eventSource = (TraceEventPropertySource)adapter;
        Assert.assertEquals((Object)"TRACE_DEBUG_SYSTEM", (Object)eventSource.getPropertyValue((Object)"trace.event.loglevel"));
        node.disconnect();
        node.getParent().removeChild((ITraceControlComponent)node);
    }
}

