/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.marker;

import java.util.Arrays;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.marker.AbstractBaseChartPaintListener;
import org.eclipse.swtchart.extensions.marker.IBaseChartPaintListener;
import org.eclipse.swtchart.extensions.scattercharts.BoxPlotChart;

public class BoxPlotMarker
extends AbstractBaseChartPaintListener
implements IBaseChartPaintListener {
    private static final int MAX_BOX_WIDTH = 80;
    private BoxPlotChart boxPlotChart;

    public BoxPlotMarker(BaseChart baseChart, BoxPlotChart boxPlotChart) {
        super(baseChart);
        this.boxPlotChart = boxPlotChart;
    }

    public void paintControl(PaintEvent e) {
        BaseChart baseChart = this.getBaseChart();
        ISeriesSet seriesSet = baseChart.getSeriesSet();
        GC gc = e.gc;
        IAxis xAxis = baseChart.getAxisSet().getXAxis(0);
        IAxis yAxis = baseChart.getAxisSet().getYAxis(0);
        double xLower = xAxis.getRange().lower;
        double xUpper = xAxis.getRange().upper;
        double yLower = yAxis.getRange().lower;
        double yUpper = yAxis.getRange().upper;
        ISeries[] series = seriesSet.getSeries();
        double boxWidthRatio = 0.7;
        int boxWidth = (int)((double)baseChart.getPlotArea().getBounds().width / (xUpper + 1.0 - xLower) * boxWidthRatio);
        boxWidth = Math.min(80, boxWidth);
        int categoryIndex = 0;
        while (categoryIndex < series.length) {
            double[] xData = series[categoryIndex].getXSeries();
            double[] yData = series[categoryIndex].getYSeries();
            double yMinData = Double.MAX_VALUE;
            double yMaxData = -1.7976931348623157E308;
            int index = 0;
            while (index < xData.length) {
                yMinData = Math.min(yMinData, yData[index]);
                yMaxData = Math.max(yMaxData, yData[index]);
                ++index;
            }
            int yMin = yAxis.getPixelCoordinate(yMinData, yLower, yUpper);
            int yMax = yAxis.getPixelCoordinate(yMaxData, yLower, yUpper);
            int xCenter = xAxis.getPixelCoordinate((double)categoryIndex, xLower, xUpper);
            int xMin = xCenter - boxWidth / 2;
            int xMax = xCenter + boxWidth / 2;
            Arrays.sort(yData);
            double q1 = this.getValue(0.25, yData);
            double q2 = this.getValue(0.5, yData);
            double q3 = this.getValue(0.75, yData);
            int q1Y = yAxis.getPixelCoordinate(q1, yLower, yUpper);
            int q2Y = yAxis.getPixelCoordinate(q2, yLower, yUpper);
            int q3Y = yAxis.getPixelCoordinate(q3, yLower, yUpper);
            gc.setLineStyle(1);
            gc.setLineWidth(2);
            gc.setBackground(Display.getDefault().getSystemColor(7));
            gc.setForeground(Display.getDefault().getSystemColor(2));
            int originalAlpha = gc.getAlpha();
            gc.setAlpha(100);
            gc.fillRectangle(xMin, q3Y, xMax - xMin, q1Y - q3Y);
            gc.drawRectangle(xMin, q3Y, xMax - xMin, q1Y - q3Y);
            gc.drawLine(xMin, yMin, xMax, yMin);
            gc.drawLine(xMin, yMax, xMax, yMax);
            gc.drawLine(xCenter, yMin, xCenter, q1Y);
            gc.drawLine(xCenter, yMax, xCenter, q3Y);
            gc.drawLine(xMin, q2Y, xMax, q2Y);
            gc.setAlpha(originalAlpha);
            this.grawPointSymbols(gc, series[categoryIndex], xAxis, yAxis, xCenter, boxWidth);
            ++categoryIndex;
        }
    }

    private void grawPointSymbols(GC gc, ISeries<?> series, IAxis xAxis, IAxis yAxis, int xCenter, int boxWidth) {
        if (series instanceof ILineSeries) {
            ILineSeries lineSeries = (ILineSeries)series;
            Color[] symbolColors = lineSeries.getSymbolColors();
            ILineSeries.PlotSymbolType symbolType = this.boxPlotChart.getPlotSymbolType(series.getId());
            int symbolSize = lineSeries.getSymbolSize();
            double[] xData = series.getXSeries();
            double[] yData = series.getYSeries();
            double xMinData = Double.MAX_VALUE;
            double xMaxData = -1.7976931348623157E308;
            int index = 0;
            while (index < xData.length) {
                xMinData = Math.min(xMinData, xData[index]);
                xMaxData = Math.max(xMaxData, xData[index]);
                ++index;
            }
            int i = 0;
            while (i < xData.length) {
                Color color = symbolColors.length > i ? symbolColors[i] : lineSeries.getSymbolColor();
                int x = (int)((double)xCenter - (double)boxWidth / 2.0 + (xData[i] - xMinData) / (xMaxData - xMinData) * (double)boxWidth);
                int y = yAxis.getPixelCoordinate(yData[i]);
                Color oldForeground = gc.getForeground();
                gc.setForeground(color);
                Color oldBackground = gc.getBackground();
                gc.setBackground(color);
                switch (symbolType) {
                    case CIRCLE: {
                        gc.fillOval(x - symbolSize, y - symbolSize, symbolSize * 2, symbolSize * 2);
                        break;
                    }
                    case SQUARE: {
                        gc.fillRectangle(x - symbolSize, y - symbolSize, symbolSize * 2, symbolSize * 2);
                        break;
                    }
                    case DIAMOND: {
                        int[] diamondArray = new int[]{x, y - symbolSize, x + symbolSize, y, x, y + symbolSize, x - symbolSize, y};
                        gc.fillPolygon(diamondArray);
                        break;
                    }
                    case TRIANGLE: {
                        int[] triangleArray = new int[]{x, y - symbolSize, x + symbolSize, y + symbolSize, x - symbolSize, y + symbolSize};
                        gc.fillPolygon(triangleArray);
                        break;
                    }
                    case INVERTED_TRIANGLE: {
                        int[] invertedTriangleArray = new int[]{x, y + symbolSize, x + symbolSize, y - symbolSize, x - symbolSize, y - symbolSize};
                        gc.fillPolygon(invertedTriangleArray);
                        break;
                    }
                    case CROSS: {
                        gc.setLineStyle(1);
                        gc.drawLine(x - symbolSize, y - symbolSize, x + symbolSize, y + symbolSize);
                        gc.drawLine(x - symbolSize, y + symbolSize, x + symbolSize, y - symbolSize);
                        break;
                    }
                    case PLUS: {
                        gc.setLineStyle(1);
                        gc.drawLine(x, y - symbolSize, x, y + symbolSize);
                        gc.drawLine(x - symbolSize, y, x + symbolSize, y);
                        break;
                    }
                    case EMOJI: {
                        String extendedSymbol = lineSeries.getExtendedPlotSymbolType();
                        Point extendedSymbolSize = gc.textExtent(extendedSymbol);
                        gc.drawText(extendedSymbol, x - extendedSymbolSize.x / 2, y - extendedSymbolSize.y / 2, true);
                        break;
                    }
                }
                gc.setBackground(oldBackground);
                gc.setForeground(oldForeground);
                ++i;
            }
        }
    }

    public int getIndex(double rate, int size) {
        int index = (int)(rate * (double)(size + 1));
        return index;
    }

    public double getValue(double rate, double[] data) {
        int size = data.length;
        int index = this.getIndex(rate, size);
        return data[index - 1];
    }
}

