/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.analyzer;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IUAnalyzer;

public class HostCheckAnalyzer
extends IUAnalyzer {
    private IMetadataRepository repository;

    @Override
    public void analyzeIU(IInstallableUnit iu) {
        if (iu instanceof IInstallableUnitFragment) {
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)iu;
            Collection hosts = fragment.getHost();
            for (IRequirement req : hosts) {
                VersionRange range;
                String name;
                IQueryResult results;
                IMatchExpression hostMatch = req.getMatches();
                String namespace = RequiredCapability.extractNamespace((IMatchExpression)hostMatch);
                if (!"osgi.bundle".equals(namespace) || !(results = this.repository.query(QueryUtil.createIUQuery((String)(name = RequiredCapability.extractName((IMatchExpression)hostMatch)), (VersionRange)(range = RequiredCapability.extractRange((IMatchExpression)hostMatch))), (IProgressMonitor)new NullProgressMonitor())).isEmpty()) continue;
                this.error(iu, "IU Fragment: " + iu.getId() + " cannot find host" + name + " : " + String.valueOf(range));
                return;
            }
        }
    }

    @Override
    public void preAnalysis(IMetadataRepository repo) {
        this.repository = repo;
    }
}

