/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.elements.adapters.AsynchronousDebugLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.AsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ChildrenRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.LabelRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStatusMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.AsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class AsynchronousModel {
    private ModelNode fRoot;
    private Map<Object, ModelNode[]> fElementToNodes = new HashMap<Object, ModelNode[]>();
    private Map<Object, IModelProxy> fModelProxies = new HashMap<Object, IModelProxy>();
    private AsynchronousViewer fViewer;
    private boolean fDisposed = false;
    protected IAsynchronousContentAdapter fEmptyContentAdapter = new EmptyContentAdapter();
    private List<IStatusMonitor> fPendingUpdates = new ArrayList<IStatusMonitor>();
    private List<IStatusMonitor> fViewerUpdates = new ArrayList<IStatusMonitor>();

    public AsynchronousModel(AsynchronousViewer viewer) {
        this.fViewer = viewer;
        if (DebugUIPlugin.DEBUG_MODEL) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("MODEL CREATED for: ");
            buffer.append((Object)this.fViewer);
            buffer.append(" (");
            buffer.append(this);
            buffer.append(")");
            DebugUIPlugin.trace(buffer.toString());
        }
    }

    public void init(Object root) {
        if (root != null) {
            this.fRoot = new ModelNode(null, root);
            this.mapElement(root, this.fRoot);
        }
    }

    protected AsynchronousViewer getViewer() {
        return this.fViewer;
    }

    public synchronized void dispose() {
        if (DebugUIPlugin.DEBUG_MODEL) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("MODEL DISPOSED for: ");
            buffer.append((Object)this.fViewer);
            buffer.append(" (");
            buffer.append(this);
            buffer.append(")");
            DebugUIPlugin.trace(buffer.toString());
        }
        this.fDisposed = true;
        this.cancelPendingUpdates();
        this.disposeAllModelProxies();
        ModelNode rootNode = this.getRootNode();
        if (rootNode != null) {
            rootNode.dispose();
        }
        this.fElementToNodes.clear();
    }

    public synchronized boolean isDisposed() {
        return this.fDisposed;
    }

    protected synchronized void cancelPendingUpdates() {
        Iterator<IStatusMonitor> updates = this.fPendingUpdates.iterator();
        while (updates.hasNext()) {
            IStatusMonitor update = updates.next();
            updates.remove();
            update.setCanceled(true);
        }
        this.fPendingUpdates.clear();
    }

    public synchronized void installModelProxy(Object element) {
        IModelProxy proxy;
        IModelProxyFactory modelProxyFactory;
        if (!this.fModelProxies.containsKey(element) && (modelProxyFactory = this.getModelProxyFactoryAdapter(element)) != null && (proxy = modelProxyFactory.createModelProxy(element, this.getPresentationContext())) != null) {
            this.fModelProxies.put(element, proxy);
            Job job = new Job("Model Proxy installed notification job"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        proxy.init(AsynchronousModel.this.getPresentationContext());
                        AsynchronousModel.this.getViewer().modelProxyAdded(proxy);
                        proxy.installed((Viewer)AsynchronousModel.this.getViewer());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected synchronized void disposeModelProxy(Object element) {
        IModelProxy proxy = this.fModelProxies.remove(element);
        if (proxy != null) {
            this.getViewer().modelProxyRemoved(proxy);
            proxy.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAllModelProxies() {
        Map<Object, IModelProxy> map = this.fModelProxies;
        synchronized (map) {
            for (IModelProxy proxy : this.fModelProxies.values()) {
                this.getViewer().modelProxyRemoved(proxy);
                proxy.dispose();
            }
            this.fModelProxies.clear();
        }
    }

    protected IPresentationContext getPresentationContext() {
        return this.fViewer.getPresentationContext();
    }

    protected IModelProxyFactory getModelProxyFactoryAdapter(Object element) {
        IModelProxyFactory adapter = null;
        if (element instanceof IModelProxyFactory) {
            adapter = (IModelProxyFactory)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IModelProxyFactory)adaptable.getAdapter(IModelProxyFactory.class);
        }
        return adapter;
    }

    protected synchronized void mapElement(Object element, ModelNode node) {
        ModelNode[] nodes = this.getNodes(element);
        node.remap(element);
        if (nodes == null) {
            this.fElementToNodes.put(element, new ModelNode[]{node});
        } else {
            int i = 0;
            while (i < nodes.length) {
                if (nodes[i] == node) {
                    return;
                }
                ++i;
            }
            ModelNode[] old = nodes;
            ModelNode[] newNodes = new ModelNode[old.length + 1];
            System.arraycopy(old, 0, newNodes, 0, old.length);
            newNodes[old.length] = node;
            this.fElementToNodes.put(element, newNodes);
        }
        this.installModelProxy(element);
    }

    protected synchronized void unmapNode(ModelNode node) {
        Object element = node.getElement();
        ModelNode[] nodes = this.fElementToNodes.get(element);
        if (nodes == null) {
            return;
        }
        if (nodes.length == 1) {
            this.fElementToNodes.remove(element);
            this.disposeModelProxy(element);
        } else {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node2 = nodes[i];
                if (node2 == node) {
                    ModelNode[] newNodes = new ModelNode[nodes.length - 1];
                    System.arraycopy(nodes, 0, newNodes, 0, i);
                    if (i < newNodes.length) {
                        System.arraycopy(nodes, i + 1, newNodes, i, newNodes.length - i);
                    }
                    this.fElementToNodes.put(element, newNodes);
                }
                ++i;
            }
        }
    }

    public synchronized ModelNode[] getNodes(Object element) {
        return this.fElementToNodes.get(element);
    }

    public ModelNode getRootNode() {
        return this.fRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestScheduled(IStatusMonitor update) {
        AsynchronousRequestMonitor absUpdate = (AsynchronousRequestMonitor)update;
        List<IStatusMonitor> list = this.fPendingUpdates;
        synchronized (list) {
            ListIterator<IStatusMonitor> updates = this.fPendingUpdates.listIterator();
            while (updates.hasNext()) {
                AsynchronousRequestMonitor pendingUpdate = (AsynchronousRequestMonitor)updates.next();
                if (!absUpdate.contains(pendingUpdate)) continue;
                updates.remove();
                pendingUpdate.setCanceled(true);
            }
            this.fPendingUpdates.add(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestComplete(IStatusMonitor update) {
        List<IStatusMonitor> list = this.fPendingUpdates;
        synchronized (list) {
            this.fPendingUpdates.remove(update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void viewerUpdateScheduled(IStatusMonitor update) {
        List<IStatusMonitor> list = this.fPendingUpdates;
        synchronized (list) {
            this.fViewerUpdates.add(update);
        }
    }

    protected Object[] filter(Object parent, Object[] elements) {
        ViewerFilter[] filters = this.getViewer().getFilters();
        if (filters != null) {
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                int j = 0;
                while (j < filters.length) {
                    add = filters[j].select((Viewer)this.getViewer(), parent, elements[i]);
                    if (!add) break;
                    ++j;
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }
        return elements;
    }

    protected void updateLabel(ModelNode node) {
        Object element = node.getElement();
        IAsynchronousLabelAdapter adapter = this.getLabelAdapter(element);
        if (adapter != null) {
            LabelRequestMonitor labelUpdate = new LabelRequestMonitor(node, this);
            this.requestScheduled(labelUpdate);
            adapter.retrieveLabel(element, this.getPresentationContext(), labelUpdate);
        }
    }

    protected IAsynchronousLabelAdapter getLabelAdapter(Object element) {
        IAsynchronousLabelAdapter adapter = null;
        if (element instanceof IAsynchronousLabelAdapter) {
            adapter = (IAsynchronousLabelAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IAsynchronousLabelAdapter)adaptable.getAdapter(IAsynchronousLabelAdapter.class);
        }
        if (adapter == null) {
            return new AsynchronousDebugLabelAdapter();
        }
        return adapter;
    }

    protected IAsynchronousContentAdapter getContentAdapter(Object element) {
        IAsynchronousContentAdapter adapter = null;
        if (element instanceof IAsynchronousContentAdapter) {
            adapter = (IAsynchronousContentAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IAsynchronousContentAdapter)adaptable.getAdapter(IAsynchronousContentAdapter.class);
        }
        return adapter;
    }

    public void updateChildren(ModelNode parent) {
        Object element = parent.getElement();
        IAsynchronousContentAdapter adapter = this.getContentAdapter(element);
        if (adapter == null) {
            adapter = this.fEmptyContentAdapter;
        }
        if (adapter != null) {
            ChildrenRequestMonitor update = new ChildrenRequestMonitor(parent, this);
            this.requestScheduled(update);
            adapter.retrieveChildren(element, this.getPresentationContext(), update);
        }
    }

    protected void preservingSelection(Runnable update) {
        this.getViewer().preservingSelection(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void viewerUpdateComplete(IStatusMonitor monitor) {
        List<IStatusMonitor> list = this.fPendingUpdates;
        synchronized (list) {
            this.fViewerUpdates.remove(monitor);
        }
        this.getViewer().updateComplete(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCanceled(AsynchronousRequestMonitor monitor) {
        List<IStatusMonitor> list = this.fPendingUpdates;
        synchronized (list) {
            this.fPendingUpdates.remove(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPendingUpdates() {
        List<IStatusMonitor> list = this.fViewerUpdates;
        synchronized (list) {
            return !this.fPendingUpdates.isEmpty() || !this.fViewerUpdates.isEmpty();
        }
    }

    protected abstract void add(ModelNode var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChildren(ModelNode parentNode, List<Object> kids) {
        Object[] children = this.filter(parentNode.getElement(), kids.toArray());
        AsynchronousViewer viewer = this.getViewer();
        ViewerComparator comparator = viewer.getComparator();
        if (comparator != null) {
            comparator.sort((Viewer)viewer, children);
        }
        ModelNode[] prevKids = null;
        ModelNode[] newChildren = null;
        ModelNode[] unmap = null;
        AsynchronousModel asynchronousModel = this;
        synchronized (asynchronousModel) {
            if (this.isDisposed()) {
                return;
            }
            prevKids = parentNode.getChildrenNodes();
            if (prevKids == null) {
                newChildren = new ModelNode[children.length];
                int i = 0;
                while (i < children.length) {
                    ModelNode node = new ModelNode(parentNode, children[i]);
                    this.mapElement(children[i], node);
                    newChildren[i] = node;
                    ++i;
                }
                parentNode.setChildren(newChildren);
            } else {
                newChildren = new ModelNode[children.length];
                unmap = new ModelNode[prevKids.length];
                int i = 0;
                while (i < prevKids.length) {
                    unmap[i] = prevKids[i];
                    ++i;
                }
                i = 0;
                while (i < children.length) {
                    Object child = children[i];
                    boolean found = false;
                    int j = 0;
                    while (j < prevKids.length) {
                        ModelNode prevKid = prevKids[j];
                        if (prevKid != null && child.equals(prevKid.getElement())) {
                            newChildren[i] = prevKid;
                            prevKids[j] = null;
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        newChildren[i] = new ModelNode(parentNode, child);
                        this.mapElement(child, newChildren[i]);
                    }
                    ++i;
                }
                i = 0;
                while (i < prevKids.length) {
                    ModelNode kid = prevKids[i];
                    if (kid != null) {
                        kid.dispose();
                        this.unmapNode(kid);
                    }
                    ++i;
                }
                parentNode.setChildren(newChildren);
            }
            if (DebugUIPlugin.DEBUG_MODEL) {
                DebugUIPlugin.trace("CHILDREN CHANGED: " + parentNode);
                DebugUIPlugin.trace(this.toString());
            }
        }
        ModelNode[] finalUnmap = unmap;
        this.preservingSelection(() -> {
            if (finalUnmap != null) {
                int i = 0;
                while (i < finalUnmap.length) {
                    viewer.unmapNode(finalUnmap[i]);
                    ++i;
                }
            }
            viewer.nodeChildrenChanged(parentNode);
        });
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.fRoot != null) {
            buf.append("ROOT: ");
            this.append(buf, this.fRoot, 0);
        } else {
            buf.append("ROOT: null");
        }
        return buf.toString();
    }

    private void append(StringBuffer buf, ModelNode node, int level) {
        int i = 0;
        while (i < level) {
            buf.append('\t');
            ++i;
        }
        buf.append(node);
        buf.append('\n');
        ModelNode[] childrenNodes = node.getChildrenNodes();
        if (childrenNodes != null) {
            int i2 = 0;
            while (i2 < childrenNodes.length) {
                this.append(buf, childrenNodes[i2], level + 1);
                ++i2;
            }
        }
    }

    class EmptyContentAdapter
    extends AsynchronousContentAdapter {
        EmptyContentAdapter() {
        }

        @Override
        protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
            return EMPTY;
        }

        @Override
        protected boolean hasChildren(Object element, IPresentationContext context) throws CoreException {
            return false;
        }

        @Override
        protected boolean supportsPartId(String id) {
            return true;
        }
    }
}

