/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.model;

import com.google.common.base.Splitter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.model.TMTokenDecodeData;

public final class DecodeMap {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Splitter BY_DOT_SPLITTER = Splitter.on((char)'.');
    private int lastAssignedId = 0;
    private final Map<String, int @Nullable []> scopeToTokenIds = new LinkedHashMap<String, int[]>();
    private final Map<String, @Nullable Integer> tokenToTokenId = new LinkedHashMap<String, Integer>();
    private final Map<Integer, String> tokenIdToToken = new LinkedHashMap<Integer, String>();
    public TMTokenDecodeData prevToken = new TMTokenDecodeData(EMPTY_STRING_ARRAY, new LinkedHashMap<Integer, Map<Integer, Boolean>>());

    public int[] getTokenIds(String scope) {
        int[] tokens = this.scopeToTokenIds.get(scope);
        if (tokens != null) {
            return tokens;
        }
        String[] tmpTokens = (String[])BY_DOT_SPLITTER.splitToStream((CharSequence)scope).toArray(String[]::new);
        tokens = new int[tmpTokens.length];
        int i = 0;
        while (i < tmpTokens.length) {
            String token = tmpTokens[i];
            Integer tokenId = this.tokenToTokenId.get(token);
            if (tokenId == null) {
                tokenId = ++this.lastAssignedId;
                this.tokenToTokenId.put(token, tokenId);
                this.tokenIdToToken.put(tokenId, token);
            }
            tokens[i] = tokenId;
            ++i;
        }
        this.scopeToTokenIds.put(scope, tokens);
        return tokens;
    }

    public String getToken(Map<Integer, Boolean> tokenMap) {
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        int i = 1;
        while (i <= this.lastAssignedId) {
            if (tokenMap.containsKey(i)) {
                if (isFirst) {
                    isFirst = false;
                    result.append(this.tokenIdToToken.get(i));
                } else {
                    result.append('.');
                    result.append(this.tokenIdToToken.get(i));
                }
            }
            ++i;
        }
        return result.toString();
    }
}

