/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.ui.internal.utils.UI;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;

public abstract class AbstractThemeManager
implements IThemeManager {
    final Map<String, ITheme> themes = new LinkedHashMap<String, ITheme>();
    final Map<@Nullable String, @Nullable IThemeAssociation> darkThemeAssociations = new HashMap<String, IThemeAssociation>();
    final Map<@Nullable String, @Nullable IThemeAssociation> lightThemeAssociations = new HashMap<String, IThemeAssociation>();
    protected @Nullable String defaultDarkThemeId;
    protected @Nullable String defaultLightThemeId;

    protected void registerTheme(ITheme theme) {
        this.themes.put(theme.getId(), theme);
    }

    void unregisterTheme(ITheme theme) {
        this.themes.remove(theme.getId());
    }

    @Override
    public @Nullable ITheme getThemeById(String themeId) {
        return this.themes.get(themeId);
    }

    @Override
    public ITheme[] getThemes() {
        return (ITheme[])this.themes.values().toArray(ITheme[]::new);
    }

    @Override
    public ITheme getDefaultTheme() {
        return this.getDefaultTheme(UI.isDarkEclipseTheme());
    }

    @Override
    public ITheme getDefaultTheme(boolean dark) {
        ITheme defaultTheme;
        String defaultThemeId = dark ? this.defaultDarkThemeId : this.defaultLightThemeId;
        ITheme iTheme = defaultTheme = defaultThemeId == null ? null : this.themes.get(defaultThemeId);
        if (defaultTheme != null) {
            return defaultTheme;
        }
        for (ITheme theme : this.themes.values()) {
            if (theme.isDark() != dark || !theme.isDefault()) continue;
            return theme;
        }
        throw new IllegalStateException("Should never be reached");
    }

    void setDefaultTheme(String themeId, boolean dark) {
        if (dark) {
            this.defaultDarkThemeId = themeId;
        } else {
            this.defaultLightThemeId = themeId;
        }
    }

    @Override
    public ITheme[] getThemes(boolean dark) {
        return (ITheme[])this.themes.values().stream().filter(theme -> theme.isDark() == dark).toArray(ITheme[]::new);
    }

    @Override
    public ITheme getThemeForScope(String scopeName) {
        return this.getThemeForScope(scopeName, UI.isDarkEclipseTheme());
    }

    @Override
    public ITheme getThemeForScope(String scopeName, boolean dark) {
        String themeId;
        ITheme theme;
        IThemeAssociation association;
        scopeName = ITMScope.parse((String)scopeName).getName();
        IThemeAssociation iThemeAssociation = association = dark ? this.darkThemeAssociations.get(scopeName) : this.lightThemeAssociations.get(scopeName);
        if (association != null && (theme = this.getThemeById(themeId = association.getThemeId())) != null) {
            return theme;
        }
        return this.getDefaultTheme(dark);
    }

    @Override
    public ITheme getThemeForScope(String scopeName, RGB background) {
        return this.getThemeForScope(scopeName, UI.isDarkColor(background));
    }

    @Override
    public IThemeAssociation[] getThemeAssociationsForScope(String scopeName) {
        scopeName = ITMScope.parse((String)scopeName).getName();
        ArrayList<IThemeAssociation> associations = new ArrayList<IThemeAssociation>();
        IThemeAssociation light = this.lightThemeAssociations.get(scopeName);
        if (light == null) {
            light = new ThemeAssociation(this.getDefaultTheme(false).getId(), scopeName, false);
        }
        associations.add(light);
        IThemeAssociation dark = this.darkThemeAssociations.get(scopeName);
        if (dark == null) {
            dark = new ThemeAssociation(this.getDefaultTheme(true).getId(), scopeName, true);
        }
        associations.add(dark);
        return (IThemeAssociation[])associations.toArray(IThemeAssociation[]::new);
    }

    void registerThemeAssociation(IThemeAssociation association) {
        if (association.isWhenDark()) {
            this.darkThemeAssociations.put(association.getScopeName(), association);
        } else {
            this.lightThemeAssociations.put(association.getScopeName(), association);
        }
    }

    void unregisterThemeAssociation(IThemeAssociation association) {
        if (association.isWhenDark()) {
            this.darkThemeAssociations.remove(association.getScopeName(), association);
        } else {
            this.lightThemeAssociations.remove(association.getScopeName(), association);
        }
    }

    @Override
    public IThemeAssociation[] getAllThemeAssociations() {
        return (IThemeAssociation[])Stream.concat(this.darkThemeAssociations.values().stream(), this.lightThemeAssociations.values().stream()).toArray(IThemeAssociation[]::new);
    }
}

