/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Collections;
import java.util.Optional;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ClassFilter;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.junit.runner.Runner;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.discovery.DefensiveAllDefaultPossibilitiesBuilder;

class ClassSelectorResolver
implements SelectorResolver {
    private static final DefensiveAllDefaultPossibilitiesBuilder RUNNER_BUILDER = new DefensiveAllDefaultPossibilitiesBuilder();
    private final ClassFilter classFilter;

    ClassSelectorResolver(ClassFilter classFilter) {
        this.classFilter = classFilter;
    }

    public SelectorResolver.Resolution resolve(ClassSelector selector, SelectorResolver.Context context) {
        return this.resolveTestClass(selector.getJavaClass(), context);
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId.Segment lastSegment = selector.getUniqueId().getLastSegment();
        if ("runner".equals(lastSegment.getType())) {
            String testClassName = lastSegment.getValue();
            Class testClass = (Class)ReflectionUtils.tryToLoadClass((String)testClassName).getOrThrow(cause -> new JUnitException("Unknown class: " + testClassName, (Throwable)cause));
            return this.resolveTestClass(testClass, context);
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private SelectorResolver.Resolution resolveTestClass(Class<?> testClass, SelectorResolver.Context context) {
        if (!this.classFilter.test(testClass)) {
            return SelectorResolver.Resolution.unresolved();
        }
        Runner runner = RUNNER_BUILDER.safeRunnerForClass(testClass);
        if (runner == null) {
            return SelectorResolver.Resolution.unresolved();
        }
        return context.addToParent(parent -> Optional.of(this.createRunnerTestDescriptor((TestDescriptor)parent, testClass, runner))).map(runnerTestDescriptor -> SelectorResolver.Match.exact((TestDescriptor)runnerTestDescriptor, () -> {
            runnerTestDescriptor.clearFilters();
            return Collections.emptySet();
        })).map(SelectorResolver.Resolution::match).orElse(SelectorResolver.Resolution.unresolved());
    }

    private RunnerTestDescriptor createRunnerTestDescriptor(TestDescriptor parent, Class<?> testClass, Runner runner) {
        UniqueId uniqueId = parent.getUniqueId().append("runner", testClass.getName());
        return new RunnerTestDescriptor(uniqueId, testClass, runner, RUNNER_BUILDER.isIgnored(runner));
    }
}

