import { IGDBBackend } from './types/gdb';
import { MIVarCreateResponse } from './mi/var';
import { FrameReference } from './types/session';
export interface VarObjType {
    varname: string;
    expression: string;
    numchild: string;
    children: VarObjType[];
    value: string;
    type: string;
    isVar: boolean;
    isChild: boolean;
    varType: string;
}
export declare class VarManager {
    protected gdb: IGDBBackend;
    protected readonly variableMap: Map<string, VarObjType[]>;
    constructor(gdb: IGDBBackend);
    getKey(frameRef: FrameReference, depth: number): string;
    getVars(frameRef: FrameReference | undefined, depth: number): VarObjType[] | undefined;
    getVar(frameRef: FrameReference | undefined, depth: number, expression: string, type?: string): VarObjType | undefined;
    getVarByName(frameRef: FrameReference | undefined, depth: number, varname: string): VarObjType | undefined;
    addVar(frameRef: FrameReference | undefined, depth: number, expression: string, isVar: boolean, isChild: boolean, varCreateResponse: MIVarCreateResponse, type?: string): VarObjType;
    removeVar(frameRef: FrameReference | undefined, depth: number, varname: string): Promise<void>;
    updateVar(frameRef: FrameReference | undefined, depth: number, varobj: VarObjType): Promise<VarObjType>;
}
