"use strict";
/*********************************************************************
 * Copyright (c) 2019 Arm and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const chai_1 = require("chai");
const utils_1 = require("./utils");
describe('stepout', function () {
    return __awaiter(this, void 0, void 0, function* () {
        let dc;
        beforeEach(function () {
            return __awaiter(this, void 0, void 0, function* () {
                dc = yield (0, utils_1.standardBeforeEach)();
                yield dc.launchRequest((0, utils_1.fillDefaults)(this.currentTest, {
                    program: path.join(utils_1.testProgramsDir, 'functions'),
                }));
            });
        });
        afterEach(() => __awaiter(this, void 0, void 0, function* () {
            yield dc.stop();
        }));
        it('should step out from staticfunc1 to main', () => __awaiter(this, void 0, void 0, function* () {
            yield dc.setBreakpointsRequest({
                source: {
                    name: 'functions.c',
                    path: path.join(utils_1.testProgramsDir, 'functions.c'),
                },
                breakpoints: [
                    {
                        column: 1,
                        line: 3,
                    },
                ],
            });
            yield dc.configurationDoneRequest();
            yield dc.waitForEvent('stopped');
            const scope = yield (0, utils_1.getScopes)(dc);
            yield dc.stepOutRequest({
                threadId: scope.thread.id,
            });
            const stepOutEvent = yield dc.waitForEvent('stopped');
            (0, chai_1.expect)(stepOutEvent.body.reason).eq('step');
            const stackTrace = yield dc.stackTraceRequest({
                threadId: stepOutEvent.body.threadId,
            });
            (0, chai_1.expect)(stackTrace.body.stackFrames[0].name.includes('main'));
        }));
    });
});
//# sourceMappingURL=stepout.spec.js.map