"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendInterpreterExecConsole = void 0;
function sendInterpreterExecConsole(gdb, params) {
    var _a, _b;
    // In GDB MI, -1 is not a valid value for --thread or --frame.
    // These options expect positive integer IDs. Omitting the option means "all threads"/"current frame".
    // So, only include --thread/--frame if threadId/frameId >= 0.
    let cmd = '-interpreter-exec';
    if (((_a = params.frameRef) === null || _a === void 0 ? void 0 : _a.threadId) !== undefined &&
        params.frameRef.threadId >= 0) {
        cmd += ` --thread ${params.frameRef.threadId}`;
    }
    if (((_b = params.frameRef) === null || _b === void 0 ? void 0 : _b.frameId) !== undefined &&
        params.frameRef.frameId >= 0) {
        cmd += ` --frame ${params.frameRef.frameId}`;
    }
    cmd += ` console "${params.command}"`;
    return gdb.sendCommand(cmd);
}
exports.sendInterpreterExecConsole = sendInterpreterExecConsole;
//# sourceMappingURL=interpreter.js.map