(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_preferences_lib_browser_preference-frontend-module_js-node_modules-a96d91"],{

/***/ "../../node_modules/@theia/core/shared/fuzzy/index.js":
/*!************************************************************!*\
  !*** ../../node_modules/@theia/core/shared/fuzzy/index.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! fuzzy */ "../../node_modules/fuzzy/lib/fuzzy.js");


/***/ }),

/***/ "../../node_modules/@theia/core/shared/react-dom/client/index.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/core/shared/react-dom/client/index.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! react-dom/client */ "../../node_modules/react-dom/client.js");


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/preference-frontend-contribution.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/preference-frontend-contribution.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceFrontendContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const cli_preferences_1 = __webpack_require__(/*! ../common/cli-preferences */ "../../node_modules/@theia/preferences/lib/common/cli-preferences.js");
const preference_service_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-service */ "../../node_modules/@theia/core/lib/browser/preferences/preference-service.js");
let PreferenceFrontendContribution = class PreferenceFrontendContribution {
    onStart() {
        this.CliPreferences.getPreferences().then(async (preferences) => {
            await this.preferenceService.ready;
            for (const [key, value] of preferences) {
                this.preferenceService.set(key, value, preference_service_1.PreferenceScope.User);
            }
        });
    }
};
exports.PreferenceFrontendContribution = PreferenceFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(cli_preferences_1.CliPreferences),
    tslib_1.__metadata("design:type", Object)
], PreferenceFrontendContribution.prototype, "CliPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_service_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], PreferenceFrontendContribution.prototype, "preferenceService", void 0);
exports.PreferenceFrontendContribution = PreferenceFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceFrontendContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/preference-frontend-module.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/preference-frontend-module.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindPreferences = void 0;
__webpack_require__(/*! ../../src/browser/style/index.css */ "../../node_modules/@theia/preferences/src/browser/style/index.css");
__webpack_require__(/*! ./preferences-monaco-contribution */ "../../node_modules/@theia/preferences/lib/browser/preferences-monaco-contribution.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const tab_bar_toolbar_1 = __webpack_require__(/*! @theia/core/lib/browser/shell/tab-bar-toolbar */ "../../node_modules/@theia/core/lib/browser/shell/tab-bar-toolbar/index.js");
const preference_tree_generator_1 = __webpack_require__(/*! ./util/preference-tree-generator */ "../../node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js");
const preference_bindings_1 = __webpack_require__(/*! ./preference-bindings */ "../../node_modules/@theia/preferences/lib/browser/preference-bindings.js");
const preference_widget_bindings_1 = __webpack_require__(/*! ./views/preference-widget-bindings */ "../../node_modules/@theia/preferences/lib/browser/views/preference-widget-bindings.js");
const preferences_contribution_1 = __webpack_require__(/*! ./preferences-contribution */ "../../node_modules/@theia/preferences/lib/browser/preferences-contribution.js");
const preference_scope_command_manager_1 = __webpack_require__(/*! ./util/preference-scope-command-manager */ "../../node_modules/@theia/preferences/lib/browser/util/preference-scope-command-manager.js");
const json_schema_store_1 = __webpack_require__(/*! @theia/core/lib/browser/json-schema-store */ "../../node_modules/@theia/core/lib/browser/json-schema-store.js");
const preferences_json_schema_contribution_1 = __webpack_require__(/*! ./preferences-json-schema-contribution */ "../../node_modules/@theia/preferences/lib/browser/preferences-json-schema-contribution.js");
const monaco_jsonc_editor_1 = __webpack_require__(/*! ./monaco-jsonc-editor */ "../../node_modules/@theia/preferences/lib/browser/monaco-jsonc-editor.js");
const preference_transaction_manager_1 = __webpack_require__(/*! ./preference-transaction-manager */ "../../node_modules/@theia/preferences/lib/browser/preference-transaction-manager.js");
const preference_open_handler_1 = __webpack_require__(/*! ./preference-open-handler */ "../../node_modules/@theia/preferences/lib/browser/preference-open-handler.js");
const cli_preferences_1 = __webpack_require__(/*! ../common/cli-preferences */ "../../node_modules/@theia/preferences/lib/common/cli-preferences.js");
const service_connection_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/messaging/service-connection-provider */ "../../node_modules/@theia/core/lib/browser/messaging/service-connection-provider.js");
const preference_frontend_contribution_1 = __webpack_require__(/*! ./preference-frontend-contribution */ "../../node_modules/@theia/preferences/lib/browser/preference-frontend-contribution.js");
const preference_layout_1 = __webpack_require__(/*! ./util/preference-layout */ "../../node_modules/@theia/preferences/lib/browser/util/preference-layout.js");
const preference_widget_1 = __webpack_require__(/*! ./views/preference-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-widget.js");
function bindPreferences(bind, unbind) {
    (0, preference_bindings_1.bindPreferenceProviders)(bind, unbind);
    (0, preference_widget_bindings_1.bindPreferencesWidgets)(bind);
    bind(preference_tree_generator_1.PreferenceTreeGenerator).toSelf().inSingletonScope();
    bind(preference_layout_1.PreferenceLayoutProvider).toSelf().inSingletonScope();
    (0, browser_1.bindViewContribution)(bind, preferences_contribution_1.PreferencesContribution);
    bind(preference_open_handler_1.PreferenceOpenHandler).toSelf().inSingletonScope();
    bind(browser_1.OpenHandler).toService(preference_open_handler_1.PreferenceOpenHandler);
    bind(preference_scope_command_manager_1.PreferenceScopeCommandManager).toSelf().inSingletonScope();
    bind(tab_bar_toolbar_1.TabBarToolbarContribution).toService(preferences_contribution_1.PreferencesContribution);
    bind(preferences_json_schema_contribution_1.PreferencesJsonSchemaContribution).toSelf().inSingletonScope();
    bind(json_schema_store_1.JsonSchemaContribution).toService(preferences_json_schema_contribution_1.PreferencesJsonSchemaContribution);
    bind(monaco_jsonc_editor_1.MonacoJSONCEditor).toSelf().inSingletonScope();
    bind(preference_transaction_manager_1.PreferenceTransaction).toSelf();
    bind(preference_transaction_manager_1.PreferenceTransactionFactory).toFactory(preference_transaction_manager_1.preferenceTransactionFactoryCreator);
    bind(cli_preferences_1.CliPreferences).toDynamicValue(ctx => service_connection_provider_1.ServiceConnectionProvider.createProxy(ctx.container, cli_preferences_1.CliPreferencesPath)).inSingletonScope();
    bind(preference_frontend_contribution_1.PreferenceFrontendContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(preference_frontend_contribution_1.PreferenceFrontendContribution);
    bind(browser_1.WidgetStatusBarContribution).toConstantValue((0, browser_1.noopWidgetStatusBarContribution)(preference_widget_1.PreferencesWidget));
}
exports.bindPreferences = bindPreferences;
exports["default"] = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bindPreferences(bind, unbind);
});


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/preference-open-handler.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/preference-open-handler.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2022 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceOpenHandler = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preferences_contribution_1 = __webpack_require__(/*! ./preferences-contribution */ "../../node_modules/@theia/preferences/lib/browser/preferences-contribution.js");
let PreferenceOpenHandler = class PreferenceOpenHandler {
    constructor() {
        this.id = 'preference';
    }
    canHandle(uri) {
        return uri.scheme === this.id ? 500 : -1;
    }
    async open(uri) {
        const preferencesWidget = await this.preferencesContribution.openView();
        const selector = `li[data-pref-id="${uri.path.toString()}"]:not([data-node-id^="commonly-used@"])`;
        const element = document.querySelector(selector);
        if (element instanceof HTMLElement) {
            if (element.classList.contains('hidden')) {
                // We clear the search term as we have clicked on a hidden preference
                await preferencesWidget.setSearchTerm('');
                await (0, browser_1.animationFrame)();
            }
            element.scrollIntoView({
                block: 'center'
            });
            element.focus();
            return true;
        }
        return false;
    }
};
exports.PreferenceOpenHandler = PreferenceOpenHandler;
tslib_1.__decorate([
    (0, inversify_1.inject)(preferences_contribution_1.PreferencesContribution),
    tslib_1.__metadata("design:type", preferences_contribution_1.PreferencesContribution)
], PreferenceOpenHandler.prototype, "preferencesContribution", void 0);
exports.PreferenceOpenHandler = PreferenceOpenHandler = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceOpenHandler);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/preference-tree-model.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/preference-tree-model.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceTreeModel = exports.PreferenceFilterChangeSource = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const preference_searchbar_widget_1 = __webpack_require__(/*! ./views/preference-searchbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js");
const preference_tree_generator_1 = __webpack_require__(/*! ./util/preference-tree-generator */ "../../node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js");
const fuzzy = __webpack_require__(/*! @theia/core/shared/fuzzy */ "../../node_modules/@theia/core/shared/fuzzy/index.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ./views/preference-scope-tabbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
const preference_types_1 = __webpack_require__(/*! ./util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_layout_1 = __webpack_require__(/*! ./util/preference-layout */ "../../node_modules/@theia/preferences/lib/browser/util/preference-layout.js");
var PreferenceFilterChangeSource;
(function (PreferenceFilterChangeSource) {
    PreferenceFilterChangeSource[PreferenceFilterChangeSource["Schema"] = 0] = "Schema";
    PreferenceFilterChangeSource[PreferenceFilterChangeSource["Search"] = 1] = "Search";
    PreferenceFilterChangeSource[PreferenceFilterChangeSource["Scope"] = 2] = "Scope";
})(PreferenceFilterChangeSource || (exports.PreferenceFilterChangeSource = PreferenceFilterChangeSource = {}));
let PreferenceTreeModel = class PreferenceTreeModel extends browser_1.TreeModelImpl {
    constructor() {
        super(...arguments);
        this.onTreeFilterChangedEmitter = new core_1.Emitter();
        this.onFilterChanged = this.onTreeFilterChangedEmitter.event;
        this.lastSearchedFuzzy = '';
        this.lastSearchedLiteral = '';
        this.lastSearchedTags = [];
        this._currentScope = Number(preference_types_1.Preference.DEFAULT_SCOPE.scope);
        this._isFiltered = false;
        this._currentRows = new Map();
        this._totalVisibleLeaves = 0;
    }
    get currentRows() {
        return this._currentRows;
    }
    get totalVisibleLeaves() {
        return this._totalVisibleLeaves;
    }
    get isFiltered() {
        return this._isFiltered;
    }
    get propertyList() {
        return this.schemaProvider.getCombinedSchema().properties;
    }
    get currentScope() {
        return this.scopeTracker.currentScope;
    }
    get onSchemaChanged() {
        return this.treeGenerator.onSchemaChanged;
    }
    init() {
        this.doInit();
    }
    async doInit() {
        super.init();
        this.toDispose.pushAll([
            this.treeGenerator.onSchemaChanged(newTree => this.handleNewSchema(newTree)),
            this.scopeTracker.onScopeChanged(scopeDetails => {
                this._currentScope = scopeDetails.scope;
                this.updateFilteredRows(PreferenceFilterChangeSource.Scope);
            }),
            this.filterInput.onFilterChanged(newSearchTerm => {
                this.lastSearchedTags = Array.from(newSearchTerm.matchAll(/@tag:([^\s]+)/g)).map(match => match[0].slice(5));
                const newSearchTermWithoutTags = newSearchTerm.replace(/@tag:[^\s]+/g, '');
                this.lastSearchedLiteral = newSearchTermWithoutTags;
                this.lastSearchedFuzzy = newSearchTermWithoutTags.replace(/\s/g, '');
                this._isFiltered = newSearchTerm.length > 2;
                if (this.isFiltered) {
                    this.expandAll();
                }
                else if (browser_1.CompositeTreeNode.is(this.root)) {
                    this.collapseAll(this.root);
                }
                this.updateFilteredRows(PreferenceFilterChangeSource.Search);
            }),
            this.onFilterChanged(() => {
                this.filterInput.updateResultsCount(this._totalVisibleLeaves);
            }),
            this.onTreeFilterChangedEmitter,
        ]);
        await this.preferenceService.ready;
        this.handleNewSchema(this.treeGenerator.root);
    }
    handleNewSchema(newRoot) {
        this.root = newRoot;
        if (this.isFiltered) {
            this.expandAll();
        }
        this.updateFilteredRows(PreferenceFilterChangeSource.Schema);
    }
    updateRows() {
        const root = this.root;
        this._currentRows = new Map();
        if (root) {
            this._totalVisibleLeaves = 0;
            let index = 0;
            for (const node of new browser_1.TopDownTreeIterator(root, {
                pruneCollapsed: false,
                pruneSiblings: true
            })) {
                if (browser_1.TreeNode.isVisible(node) && preference_types_1.Preference.TreeNode.is(node)) {
                    const { id } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(node.id);
                    if (browser_1.CompositeTreeNode.is(node) || this.passesCurrentFilters(node, id)) {
                        this.updateVisibleChildren(node);
                        this._currentRows.set(node.id, {
                            index: index++,
                            node,
                            depth: node.depth,
                            visibleChildren: 0,
                        });
                    }
                }
            }
        }
    }
    updateFilteredRows(source) {
        this.updateRows();
        this.onTreeFilterChangedEmitter.fire({ source });
    }
    passesCurrentFilters(node, prefID) {
        var _a;
        if (!this.schemaProvider.isValidInScope(prefID, this._currentScope)) {
            return false;
        }
        if (!this._isFiltered) {
            return true;
        }
        // When filtering, VSCode will render an item that is present in the commonly used section only once but render both its possible parents in the left-hand tree.
        // E.g. searching for editor.renderWhitespace will show one item in the main panel, but both 'Commonly Used' and 'Text Editor' in the left tree.
        // That seems counterintuitive and introduces a number of special cases, so I prefer to remove the commonly used section entirely when the user searches.
        if (node.id.startsWith(preference_layout_1.COMMONLY_USED_SECTION_PREFIX)) {
            return false;
        }
        if (!this.lastSearchedTags.every(tag => { var _a; return (_a = node.preference.data.tags) === null || _a === void 0 ? void 0 : _a.includes(tag); })) {
            return false;
        }
        return fuzzy.test(this.lastSearchedFuzzy, prefID) // search matches preference name.
            // search matches description. Fuzzy isn't ideal here because the score depends on the order of discovery.
            || ((_a = node.preference.data.description) !== null && _a !== void 0 ? _a : '').includes(this.lastSearchedLiteral);
    }
    isVisibleSelectableNode(node) {
        var _a;
        return browser_1.CompositeTreeNode.is(node) && !!((_a = this._currentRows.get(node.id)) === null || _a === void 0 ? void 0 : _a.visibleChildren);
    }
    updateVisibleChildren(node) {
        var _a, _b, _c, _d;
        if (!browser_1.CompositeTreeNode.is(node)) {
            this._totalVisibleLeaves++;
            let nextParent = ((_a = node.parent) === null || _a === void 0 ? void 0 : _a.id) && this._currentRows.get((_b = node.parent) === null || _b === void 0 ? void 0 : _b.id);
            while (nextParent && nextParent.node !== this.root) {
                if (nextParent) {
                    nextParent.visibleChildren += 1;
                }
                nextParent = ((_c = nextParent.node.parent) === null || _c === void 0 ? void 0 : _c.id) && this._currentRows.get((_d = nextParent.node.parent) === null || _d === void 0 ? void 0 : _d.id);
                if (nextParent) {
                    nextParent.isExpansible = true;
                }
            }
        }
    }
    collapseAllExcept(openNode) {
        const openNodes = [];
        while (browser_1.ExpandableTreeNode.is(openNode)) {
            openNodes.push(openNode);
            this.expandNode(openNode);
            openNode = openNode.parent;
        }
        if (browser_1.CompositeTreeNode.is(this.root)) {
            this.root.children.forEach(child => {
                if (!openNodes.includes(child) && browser_1.ExpandableTreeNode.is(child)) {
                    this.collapseNode(child);
                }
            });
        }
    }
    expandAll() {
        if (browser_1.CompositeTreeNode.is(this.root)) {
            this.root.children.forEach(child => {
                if (browser_1.ExpandableTreeNode.is(child)) {
                    this.expandNode(child);
                }
            });
        }
    }
    getNodeFromPreferenceId(id) {
        const node = this.getNode(this.treeGenerator.getNodeId(id));
        return node && preference_types_1.Preference.TreeNode.is(node) ? node : undefined;
    }
    /**
     * @returns true if selection changed, false otherwise
     */
    selectIfNotSelected(node) {
        const currentlySelected = this.selectedNodes[0];
        if (node !== currentlySelected) {
            this.selectNode(node);
            return true;
        }
        return false;
    }
};
exports.PreferenceTreeModel = PreferenceTreeModel;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceSchemaProvider),
    tslib_1.__metadata("design:type", browser_1.PreferenceSchemaProvider)
], PreferenceTreeModel.prototype, "schemaProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_searchbar_widget_1.PreferencesSearchbarWidget),
    tslib_1.__metadata("design:type", preference_searchbar_widget_1.PreferencesSearchbarWidget)
], PreferenceTreeModel.prototype, "filterInput", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_generator_1.PreferenceTreeGenerator),
    tslib_1.__metadata("design:type", preference_tree_generator_1.PreferenceTreeGenerator)
], PreferenceTreeModel.prototype, "treeGenerator", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_scope_tabbar_widget_1.PreferencesScopeTabBar),
    tslib_1.__metadata("design:type", preference_scope_tabbar_widget_1.PreferencesScopeTabBar)
], PreferenceTreeModel.prototype, "scopeTracker", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], PreferenceTreeModel.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferenceTreeModel.prototype, "init", null);
exports.PreferenceTreeModel = PreferenceTreeModel = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceTreeModel);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/preferences-contribution.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/preferences-contribution.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const os_1 = __webpack_require__(/*! @theia/core/lib/common/os */ "../../node_modules/@theia/core/lib/common/os.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const preference_widget_1 = __webpack_require__(/*! ./views/preference-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-widget.js");
const workspace_preference_provider_1 = __webpack_require__(/*! ./workspace-preference-provider */ "../../node_modules/@theia/preferences/lib/browser/workspace-preference-provider.js");
const preference_types_1 = __webpack_require__(/*! ./util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const clipboard_service_1 = __webpack_require__(/*! @theia/core/lib/browser/clipboard-service */ "../../node_modules/@theia/core/lib/browser/clipboard-service.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const browser_3 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
let PreferencesContribution = class PreferencesContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: preference_widget_1.PreferencesWidget.ID,
            widgetName: preference_widget_1.PreferencesWidget.LABEL,
            defaultWidgetOptions: {
                area: 'main',
            },
        });
    }
    registerCommands(commands) {
        commands.registerCommand(browser_1.CommonCommands.OPEN_PREFERENCES, {
            execute: async (query) => {
                const widget = await this.openView({ activate: true });
                if (typeof query === 'string') {
                    widget.setSearchTerm(query);
                }
            },
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR, {
            isEnabled: () => true,
            isVisible: w => this.withWidget(w, () => true),
            execute: (preferenceId) => {
                this.openPreferencesJSON(preferenceId);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.COPY_JSON_NAME, {
            isEnabled: preference_types_1.Preference.EditorCommandArgs.is,
            isVisible: preference_types_1.Preference.EditorCommandArgs.is,
            execute: ({ id, value }) => {
                this.clipboardService.writeText(id);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.COPY_JSON_VALUE, {
            isEnabled: preference_types_1.Preference.EditorCommandArgs.is,
            isVisible: preference_types_1.Preference.EditorCommandArgs.is,
            execute: ({ id, value }) => {
                const jsonString = `"${id}": ${JSON.stringify(value)}`;
                this.clipboardService.writeText(jsonString);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.RESET_PREFERENCE, {
            isEnabled: preference_types_1.Preference.EditorCommandArgs.is,
            isVisible: preference_types_1.Preference.EditorCommandArgs.is,
            execute: ({ id }) => {
                this.preferenceService.set(id, undefined, Number(this.scopeTracker.currentScope.scope), this.scopeTracker.currentScope.uri);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_USER_PREFERENCES, {
            execute: async () => {
                const widget = await this.openView({ activate: true });
                widget.setScope(browser_1.PreferenceScope.User);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_WORKSPACE_PREFERENCES, {
            isEnabled: () => !!this.workspaceService.workspace,
            isVisible: () => !!this.workspaceService.workspace,
            execute: async () => {
                const widget = await this.openView({ activate: true });
                widget.setScope(browser_1.PreferenceScope.Workspace);
            }
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_FOLDER_PREFERENCES, {
            isEnabled: () => !!this.workspaceService.isMultiRootWorkspaceOpened && this.workspaceService.tryGetRoots().length > 0,
            isVisible: () => !!this.workspaceService.isMultiRootWorkspaceOpened && this.workspaceService.tryGetRoots().length > 0,
            execute: () => this.openFolderPreferences(root => {
                this.openView({ activate: true });
                this.scopeTracker.setScope(root.resource);
            })
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_USER_PREFERENCES_JSON, {
            execute: async () => this.openJson(browser_1.PreferenceScope.User)
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_WORKSPACE_PREFERENCES_JSON, {
            isEnabled: () => !!this.workspaceService.workspace,
            isVisible: () => !!this.workspaceService.workspace,
            execute: async () => this.openJson(browser_1.PreferenceScope.Workspace)
        });
        commands.registerCommand(preference_types_1.PreferencesCommands.OPEN_FOLDER_PREFERENCES_JSON, {
            isEnabled: () => !!this.workspaceService.isMultiRootWorkspaceOpened && this.workspaceService.tryGetRoots().length > 0,
            isVisible: () => !!this.workspaceService.isMultiRootWorkspaceOpened && this.workspaceService.tryGetRoots().length > 0,
            execute: () => this.openFolderPreferences(root => this.openJson(browser_1.PreferenceScope.Folder, root.resource.toString()))
        });
    }
    registerMenus(menus) {
        menus.registerMenuAction(browser_1.CommonMenus.FILE_SETTINGS_SUBMENU_OPEN, {
            commandId: browser_1.CommonCommands.OPEN_PREFERENCES.id,
            label: core_1.nls.localizeByDefault('Settings'),
            order: 'a10',
        });
        menus.registerMenuAction(browser_1.CommonMenus.MANAGE_SETTINGS, {
            commandId: browser_1.CommonCommands.OPEN_PREFERENCES.id,
            label: core_1.nls.localizeByDefault('Settings'),
            order: 'a10',
        });
        menus.registerMenuAction(preference_types_1.PreferenceMenus.PREFERENCE_EDITOR_CONTEXT_MENU, {
            commandId: preference_types_1.PreferencesCommands.RESET_PREFERENCE.id,
            label: preference_types_1.PreferencesCommands.RESET_PREFERENCE.label,
            order: 'a'
        });
        menus.registerMenuAction(preference_types_1.PreferenceMenus.PREFERENCE_EDITOR_COPY_ACTIONS, {
            commandId: preference_types_1.PreferencesCommands.COPY_JSON_VALUE.id,
            label: preference_types_1.PreferencesCommands.COPY_JSON_VALUE.label,
            order: 'b'
        });
        menus.registerMenuAction(preference_types_1.PreferenceMenus.PREFERENCE_EDITOR_COPY_ACTIONS, {
            commandId: preference_types_1.PreferencesCommands.COPY_JSON_NAME.id,
            label: preference_types_1.PreferencesCommands.COPY_JSON_NAME.label,
            order: 'c'
        });
    }
    registerKeybindings(keybindings) {
        keybindings.registerKeybinding({
            command: browser_1.CommonCommands.OPEN_PREFERENCES.id,
            keybinding: (os_1.isOSX && !browser_1.isFirefox) ? 'cmd+,' : 'ctrl+,'
        });
    }
    registerToolbarItems(toolbar) {
        toolbar.registerItem({
            id: preference_types_1.PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR.id,
            command: preference_types_1.PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR.id,
            tooltip: preference_types_1.PreferencesCommands.OPEN_USER_PREFERENCES_JSON.label,
            priority: 0,
        });
    }
    async openPreferencesJSON(opener) {
        var _a;
        const { scope, activeScopeIsFolder, uri } = this.scopeTracker.currentScope;
        const scopeID = Number(scope);
        let preferenceId = '';
        if (typeof opener === 'string') {
            preferenceId = opener;
            const currentPreferenceValue = this.preferenceService.inspect(preferenceId, uri);
            const valueInCurrentScope = (_a = preference_types_1.Preference.getValueInScope(currentPreferenceValue, scopeID)) !== null && _a !== void 0 ? _a : currentPreferenceValue === null || currentPreferenceValue === void 0 ? void 0 : currentPreferenceValue.defaultValue;
            this.preferenceService.set(preferenceId, valueInCurrentScope, scopeID, uri);
        }
        let jsonEditorWidget;
        const jsonUriToOpen = await this.obtainConfigUri(scopeID, activeScopeIsFolder, uri);
        if (jsonUriToOpen) {
            jsonEditorWidget = await this.editorManager.open(jsonUriToOpen);
            if (preferenceId) {
                const text = jsonEditorWidget.editor.document.getText();
                if (preferenceId) {
                    const { index } = text.match(preferenceId);
                    const numReturns = text.slice(0, index).match(new RegExp('\n', 'g')).length;
                    jsonEditorWidget.editor.cursor = { line: numReturns, character: 4 + preferenceId.length + 4 };
                }
            }
        }
    }
    async openJson(scope, resource) {
        const jsonUriToOpen = await this.obtainConfigUri(scope, false, resource);
        if (jsonUriToOpen) {
            await this.editorManager.open(jsonUriToOpen);
        }
    }
    /**
     * Prompts which workspace root folder to open the JSON settings.
     */
    async openFolderPreferences(callback) {
        var _a;
        const roots = this.workspaceService.tryGetRoots();
        if (roots.length === 1) {
            callback(roots[0]);
        }
        else {
            const items = roots.map(root => ({
                label: root.name,
                description: root.resource.path.fsPath(),
                execute: () => callback(root)
            }));
            (_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.showQuickPick(items, { placeholder: 'Select workspace folder' });
        }
    }
    async obtainConfigUri(serializedScope, activeScopeIsFolder, resource) {
        let scope = serializedScope;
        if (activeScopeIsFolder) {
            scope = browser_1.PreferenceScope.Folder;
        }
        const resourceUri = !!resource ? resource : undefined;
        const configUri = this.preferenceService.getConfigUri(scope, resourceUri);
        if (!configUri) {
            return undefined;
        }
        if (configUri && !await this.fileService.exists(configUri)) {
            await this.fileService.create(configUri);
        }
        return configUri;
    }
    /**
     * Determine if the current widget is the PreferencesWidget.
     */
    withWidget(widget = this.tryGetWidget(), fn) {
        if (widget instanceof preference_widget_1.PreferencesWidget && widget.id === preference_widget_1.PreferencesWidget.ID) {
            return fn(widget);
        }
        return false;
    }
};
exports.PreferencesContribution = PreferencesContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], PreferencesContribution.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceProvider),
    (0, inversify_1.named)(browser_1.PreferenceScope.Workspace),
    tslib_1.__metadata("design:type", workspace_preference_provider_1.WorkspacePreferenceProvider)
], PreferencesContribution.prototype, "workspacePreferenceProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.EditorManager),
    tslib_1.__metadata("design:type", browser_2.EditorManager)
], PreferencesContribution.prototype, "editorManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], PreferencesContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(clipboard_service_1.ClipboardService),
    tslib_1.__metadata("design:type", Object)
], PreferencesContribution.prototype, "clipboardService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_widget_1.PreferencesWidget),
    tslib_1.__metadata("design:type", preference_widget_1.PreferencesWidget)
], PreferencesContribution.prototype, "scopeTracker", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.WorkspaceService),
    tslib_1.__metadata("design:type", browser_3.WorkspaceService)
], PreferencesContribution.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], PreferencesContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceSchemaProvider),
    tslib_1.__metadata("design:type", browser_1.PreferenceSchemaProvider)
], PreferencesContribution.prototype, "schema", void 0);
exports.PreferencesContribution = PreferencesContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], PreferencesContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/preferences-json-schema-contribution.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/preferences-json-schema-contribution.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesJsonSchemaContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const json_schema_store_1 = __webpack_require__(/*! @theia/core/lib/browser/json-schema-store */ "../../node_modules/@theia/core/lib/browser/json-schema-store.js");
const preference_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-contribution */ "../../node_modules/@theia/core/lib/browser/preferences/preference-contribution.js");
const preference_configurations_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-configurations */ "../../node_modules/@theia/core/lib/browser/preferences/preference-configurations.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const PREFERENCE_URI_PREFIX = 'vscode://schemas/settings/';
const USER_STORAGE_PREFIX = 'user-storage:/';
let PreferencesJsonSchemaContribution = class PreferencesJsonSchemaContribution {
    constructor() {
        this.serializeSchema = (scope) => JSON.stringify(this.schemaProvider.getSchema(scope));
    }
    registerSchemas(context) {
        this.registerSchema(browser_1.PreferenceScope.Default, context);
        this.registerSchema(browser_1.PreferenceScope.User, context);
        this.registerSchema(browser_1.PreferenceScope.Workspace, context);
        this.registerSchema(browser_1.PreferenceScope.Folder, context);
        this.workspaceService.updateSchema('settings', { $ref: this.getSchemaURIForScope(browser_1.PreferenceScope.Workspace).toString() });
        this.schemaProvider.onDidPreferenceSchemaChanged(() => this.updateInMemoryResources());
    }
    registerSchema(scope, context) {
        const scopeStr = browser_1.PreferenceScope[scope].toLowerCase();
        const uri = new uri_1.default(PREFERENCE_URI_PREFIX + scopeStr);
        this.jsonSchemaData.setSchema(uri, this.serializeSchema(scope));
        context.registerSchema({
            fileMatch: this.getFileMatch(scopeStr),
            url: uri.toString()
        });
    }
    updateInMemoryResources() {
        this.jsonSchemaData.setSchema(this.getSchemaURIForScope(browser_1.PreferenceScope.Default), this.serializeSchema(+browser_1.PreferenceScope.Default));
        this.jsonSchemaData.setSchema(this.getSchemaURIForScope(browser_1.PreferenceScope.User), this.serializeSchema(+browser_1.PreferenceScope.User));
        this.jsonSchemaData.setSchema(this.getSchemaURIForScope(browser_1.PreferenceScope.Workspace), this.serializeSchema(+browser_1.PreferenceScope.Workspace));
        this.jsonSchemaData.setSchema(this.getSchemaURIForScope(browser_1.PreferenceScope.Folder), this.serializeSchema(+browser_1.PreferenceScope.Folder));
    }
    getSchemaURIForScope(scope) {
        return new uri_1.default(PREFERENCE_URI_PREFIX + browser_1.PreferenceScope[scope].toLowerCase());
    }
    getFileMatch(scope) {
        const baseName = this.preferenceConfigurations.getConfigName() + '.json';
        return [baseName, new uri_1.default(USER_STORAGE_PREFIX + scope).resolve(baseName).toString()];
    }
};
exports.PreferencesJsonSchemaContribution = PreferencesJsonSchemaContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_contribution_1.PreferenceSchemaProvider),
    tslib_1.__metadata("design:type", preference_contribution_1.PreferenceSchemaProvider)
], PreferencesJsonSchemaContribution.prototype, "schemaProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_configurations_1.PreferenceConfigurations),
    tslib_1.__metadata("design:type", preference_configurations_1.PreferenceConfigurations)
], PreferencesJsonSchemaContribution.prototype, "preferenceConfigurations", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(json_schema_store_1.JsonSchemaDataStore),
    tslib_1.__metadata("design:type", json_schema_store_1.JsonSchemaDataStore)
], PreferencesJsonSchemaContribution.prototype, "jsonSchemaData", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], PreferencesJsonSchemaContribution.prototype, "workspaceService", void 0);
exports.PreferencesJsonSchemaContribution = PreferencesJsonSchemaContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferencesJsonSchemaContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/preferences-monaco-contribution.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/preferences-monaco-contribution.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
monaco.languages.register({
    id: 'jsonc',
    'aliases': [
        'JSON with Comments'
    ],
    'filenames': [
        'settings.json'
    ]
});


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/util/preference-layout.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/util/preference-layout.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceLayoutProvider = exports.DEFAULT_LAYOUT = exports.COMMONLY_USED_LAYOUT = exports.COMMONLY_USED_SECTION_PREFIX = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
exports.COMMONLY_USED_SECTION_PREFIX = 'commonly-used';
exports.COMMONLY_USED_LAYOUT = {
    id: exports.COMMONLY_USED_SECTION_PREFIX,
    label: core_1.nls.localizeByDefault('Commonly Used'),
    settings: [
        'files.autoSave',
        'editor.fontSize',
        'editor.fontFamily',
        'editor.tabSize',
        'editor.renderWhitespace',
        'editor.cursorStyle',
        'editor.multiCursorModifier',
        'editor.insertSpaces',
        'editor.wordWrap',
        'files.exclude',
        'files.associations'
    ]
};
exports.DEFAULT_LAYOUT = [
    {
        id: 'editor',
        label: core_1.nls.localizeByDefault('Text Editor'),
        settings: ['editor.*'],
        children: [
            {
                id: 'editor.cursor',
                label: core_1.nls.localizeByDefault('Cursor'),
                settings: ['editor.cursor*']
            },
            {
                id: 'editor.find',
                label: core_1.nls.localizeByDefault('Find'),
                settings: ['editor.find.*']
            },
            {
                id: 'editor.font',
                label: core_1.nls.localizeByDefault('Font'),
                settings: ['editor.font*']
            },
            {
                id: 'editor.format',
                label: core_1.nls.localizeByDefault('Formatting'),
                settings: ['editor.format*']
            },
            {
                id: 'editor.diffEditor',
                label: core_1.nls.localizeByDefault('Diff Editor'),
                settings: ['diffEditor.*']
            },
            {
                id: 'editor.multiDiffEditor',
                label: core_1.nls.localizeByDefault('Multi-File Diff Editor'),
                settings: ['multiDiffEditor.*']
            },
            {
                id: 'editor.minimap',
                label: core_1.nls.localizeByDefault('Minimap'),
                settings: ['editor.minimap.*']
            },
            {
                id: 'editor.suggestions',
                label: core_1.nls.localizeByDefault('Suggestions'),
                settings: ['editor.*suggest*']
            },
            {
                id: 'editor.files',
                label: core_1.nls.localizeByDefault('Files'),
                settings: ['files.*']
            }
        ]
    },
    {
        id: 'workbench',
        label: core_1.nls.localizeByDefault('Workbench'),
        settings: ['workbench.*', 'workspace.*'],
        children: [
            {
                id: 'workbench.appearance',
                label: core_1.nls.localizeByDefault('Appearance'),
                settings: [
                    'workbench.activityBar.*', 'workbench.*color*', 'workbench.fontAliasing', 'workbench.iconTheme', 'workbench.sidebar.location',
                    'workbench.*.visible', 'workbench.tips.enabled', 'workbench.tree.*', 'workbench.view.*'
                ]
            },
            {
                id: 'workbench.breadcrumbs',
                label: core_1.nls.localizeByDefault('Breadcrumbs'),
                settings: ['breadcrumbs.*']
            },
            {
                id: 'workbench.editor',
                label: core_1.nls.localizeByDefault('Editor Management'),
                settings: ['workbench.editor.*']
            },
            {
                id: 'workbench.settings',
                label: core_1.nls.localizeByDefault('Settings Editor'),
                settings: ['workbench.settings.*']
            },
            {
                id: 'workbench.zenmode',
                label: core_1.nls.localizeByDefault('Zen Mode'),
                settings: ['zenmode.*']
            },
            {
                id: 'workbench.screencastmode',
                label: core_1.nls.localizeByDefault('Screencast Mode'),
                settings: ['screencastMode.*']
            }
        ]
    },
    {
        id: 'window',
        label: core_1.nls.localizeByDefault('Window'),
        settings: ['window.*'],
        children: [
            {
                id: 'window.newWindow',
                label: core_1.nls.localizeByDefault('New Window'),
                settings: ['window.*newwindow*']
            }
        ]
    },
    {
        id: 'features',
        label: core_1.nls.localizeByDefault('Features'),
        children: [
            {
                id: 'features.accessibilitySignals',
                label: core_1.nls.localizeByDefault('Accessibility Signals'),
                settings: ['accessibility.signal*']
            },
            {
                id: 'features.accessibility',
                label: core_1.nls.localizeByDefault('Accessibility'),
                settings: ['accessibility.*']
            },
            {
                id: 'features.explorer',
                label: core_1.nls.localizeByDefault('Explorer'),
                settings: ['explorer.*', 'outline.*']
            },
            {
                id: 'features.search',
                label: core_1.nls.localizeByDefault('Search'),
                settings: ['search.*']
            },
            {
                id: 'features.debug',
                label: core_1.nls.localizeByDefault('Debug'),
                settings: ['debug.*', 'launch']
            },
            {
                id: 'features.testing',
                label: core_1.nls.localizeByDefault('Testing'),
                settings: ['testing.*']
            },
            {
                id: 'features.scm',
                label: core_1.nls.localizeByDefault('Source Control'),
                settings: ['scm.*']
            },
            {
                id: 'features.extensions',
                label: core_1.nls.localizeByDefault('Extensions'),
                settings: ['extensions.*']
            },
            {
                id: 'features.terminal',
                label: core_1.nls.localizeByDefault('Terminal'),
                settings: ['terminal.*']
            },
            {
                id: 'features.task',
                label: core_1.nls.localizeByDefault('Task'),
                settings: ['task.*']
            },
            {
                id: 'features.problems',
                label: core_1.nls.localizeByDefault('Problems'),
                settings: ['problems.*']
            },
            {
                id: 'features.output',
                label: core_1.nls.localizeByDefault('Output'),
                settings: ['output.*']
            },
            {
                id: 'features.comments',
                label: core_1.nls.localizeByDefault('Comments'),
                settings: ['comments.*']
            },
            {
                id: 'features.remote',
                label: core_1.nls.localizeByDefault('Remote'),
                settings: ['remote.*']
            },
            {
                id: 'features.timeline',
                label: core_1.nls.localizeByDefault('Timeline'),
                settings: ['timeline.*']
            },
            {
                id: 'features.toolbar',
                label: core_1.nls.localize('theia/preferences/toolbar', 'Toolbar'),
                settings: ['toolbar.*']
            },
            {
                id: 'features.notebook',
                label: core_1.nls.localizeByDefault('Notebook'),
                settings: ['notebook.*', 'interactiveWindow.*']
            },
            {
                id: 'features.mergeEditor',
                label: core_1.nls.localizeByDefault('Merge Editor'),
                settings: ['mergeEditor.*']
            },
            {
                id: 'features.chat',
                label: core_1.nls.localizeByDefault('Chat'),
                settings: ['chat.*', 'inlineChat.*']
            }
        ]
    },
    {
        id: 'application',
        label: core_1.nls.localizeByDefault('Application'),
        children: [
            {
                id: 'application.http',
                label: core_1.nls.localizeByDefault('HTTP'),
                settings: ['http.*']
            },
            {
                id: 'application.keyboard',
                label: core_1.nls.localizeByDefault('Keyboard'),
                settings: ['keyboard.*']
            },
            {
                id: 'application.update',
                label: core_1.nls.localizeByDefault('Update'),
                settings: ['update.*']
            },
            {
                id: 'application.telemetry',
                label: core_1.nls.localizeByDefault('Telemetry'),
                settings: ['telemetry.*']
            },
            {
                id: 'application.settingsSync',
                label: core_1.nls.localizeByDefault('Settings Sync'),
                settings: ['settingsSync.*']
            },
            {
                id: 'application.experimental',
                label: core_1.nls.localizeByDefault('Experimental'),
                settings: ['application.experimental.*']
            },
            {
                id: 'application.other',
                label: core_1.nls.localizeByDefault('Other'),
                settings: ['application.*']
            }
        ]
    },
    {
        id: 'security',
        label: core_1.nls.localizeByDefault('Security'),
        settings: ['security.*'],
        children: [
            {
                id: 'security.workspace',
                label: core_1.nls.localizeByDefault('Workspace'),
                settings: ['security.workspace.*']
            }
        ]
    },
    {
        id: 'ai-features',
        label: core_1.nls.localize('theia/preferences/ai-features', 'AI Features'),
        children: [
            {
                id: 'ai-features.aiEnablement',
                label: core_1.nls.localize('theia/preferences/ai-features/ai-enable', 'AI Enablement'),
                settings: ['ai-features.AiEnable.*']
            },
            {
                id: 'ai-features.anthropic',
                label: 'Anthropic',
                settings: ['ai-features.anthropic.*']
            },
            {
                id: 'ai-features.chat',
                label: core_1.nls.localizeByDefault('Chat'),
                settings: ['ai-features.chat.*']
            },
            {
                id: 'ai-features.codeCompletion',
                label: core_1.nls.localize('theia/preferences/ai-features/code-completion', 'Code Completion'),
                settings: ['ai-features.codeCompletion.*']
            },
            {
                id: 'ai-features.huggingFace',
                label: 'Hugging Face',
                settings: ['ai-features.huggingFace.*']
            },
            {
                id: 'ai-features.mcp',
                label: core_1.nls.localize('theia/preferences/ai-features/MCP', 'MCP'),
                settings: ['ai-features.mcp.*']
            },
            {
                id: 'ai-features.modelSettings',
                label: core_1.nls.localize('theia/preferences/ai-features/model-settings', 'Model Settings'),
                settings: ['ai-features.modelSettings.*']
            },
            {
                id: 'ai-features.ollama',
                label: 'Ollama',
                settings: ['ai-features.ollama']
            },
            {
                id: 'ai-features.llamafile',
                label: 'Llamafile',
                settings: ['ai-features.llamafile.*']
            },
            {
                id: 'ai-features.openAiCustom',
                label: core_1.nls.localize('theia/preferences/ai-features/open-ai-custom', '{0} Custom Models', 'Open AI'),
                settings: ['ai-features.openAiCustom.*']
            },
            {
                id: 'ai-features.openAiOfficial',
                label: core_1.nls.localize('theia/preferences/ai-features/open-ai-official', '{0} Official Models', 'Open AI'),
                settings: ['ai-features.openAiOfficial.*']
            },
            {
                id: 'ai-features.promptTemplates',
                label: core_1.nls.localize('theia/preferences/ai-features/promptTemplates', 'Prompt Templates'),
                settings: ['ai-features.promptTemplates.*']
            },
            {
                id: 'ai-features.SCANOSS',
                label: 'SCANOSS',
                settings: ['ai-features.SCANOSS.*']
            },
            {
                id: 'ai-features.workspaceFunctions',
                label: core_1.nls.localize('theia/preferences/ai-features/workspace-functions', 'Workspace Functions'),
                settings: ['ai-features.workspaceFunctions.*']
            }
        ]
    },
    {
        id: 'extensions',
        label: core_1.nls.localizeByDefault('Extensions'),
        children: [
            {
                id: 'extensions.hosted-plugin',
                label: core_1.nls.localize('theia/preferences/hostedPlugin', 'Hosted Plugin'),
                settings: ['hosted-plugin.*']
            }
        ]
    }
];
let PreferenceLayoutProvider = class PreferenceLayoutProvider {
    getLayout() {
        return exports.DEFAULT_LAYOUT;
    }
    getCommonlyUsedLayout() {
        return exports.COMMONLY_USED_LAYOUT;
    }
    hasCategory(id) {
        return [...this.getLayout(), this.getCommonlyUsedLayout()].some(e => e.id === id);
    }
    getLayoutForPreference(preferenceId) {
        const layout = this.getLayout();
        for (const section of layout) {
            const item = this.findItemInSection(section, preferenceId);
            if (item) {
                return item;
            }
        }
        return undefined;
    }
    findItemInSection(section, preferenceId) {
        // First check whether any of its children match the preferenceId.
        if (section.children) {
            for (const child of section.children) {
                const item = this.findItemInSection(child, preferenceId);
                if (item) {
                    return item;
                }
            }
        }
        // Then check whether the section itself matches the preferenceId.
        if (section.settings) {
            for (const setting of section.settings) {
                if (this.matchesSetting(preferenceId, setting)) {
                    return section;
                }
            }
        }
        return undefined;
    }
    matchesSetting(preferenceId, setting) {
        if (setting.includes('*')) {
            return this.createRegExp(setting).test(preferenceId);
        }
        return preferenceId === setting;
    }
    createRegExp(setting) {
        return new RegExp(`^${setting.replace(/\./g, '\\.').replace(/\*/g, '.*')}$`);
    }
};
exports.PreferenceLayoutProvider = PreferenceLayoutProvider;
exports.PreferenceLayoutProvider = PreferenceLayoutProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceLayoutProvider);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/util/preference-scope-command-manager.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/util/preference-scope-command-manager.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceScopeCommandManager = exports.FOLDER_SCOPE_MENU_PATH = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const preference_types_1 = __webpack_require__(/*! ./preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
/**
 * @deprecated since 1.17.0 moved to PreferenceMenus namespace.
 */
exports.FOLDER_SCOPE_MENU_PATH = preference_types_1.PreferenceMenus.FOLDER_SCOPE_MENU_PATH;
/**
 * @deprecated since 1.17.0. This work is now done in the PreferenceScopeTabbarWidget.
 */
let PreferenceScopeCommandManager = class PreferenceScopeCommandManager {
    constructor() {
        this.foldersAsCommands = [];
    }
    createFolderWorkspacesMenu(folderWorkspaces, currentFolderURI) {
        this.foldersAsCommands.forEach(folderCommand => {
            this.menuModelRegistry.unregisterMenuAction(folderCommand, exports.FOLDER_SCOPE_MENU_PATH);
            this.commandRegistry.unregisterCommand(folderCommand);
        });
        this.foldersAsCommands.length = 0;
        folderWorkspaces.forEach(folderWorkspace => {
            const folderLabel = this.labelProvider.getName(folderWorkspace.resource);
            const iconClass = currentFolderURI === folderWorkspace.resource.toString() ? (0, browser_1.codicon)('pass') : '';
            const newFolderAsCommand = {
                id: `preferenceScopeCommand:${folderWorkspace.resource.toString()}`,
                label: folderLabel,
                iconClass: iconClass
            };
            this.foldersAsCommands.push(newFolderAsCommand);
            this.commandRegistry.registerCommand(newFolderAsCommand, {
                isVisible: (callback, check) => check === 'from-tabbar',
                isEnabled: (callback, check) => check === 'from-tabbar',
                execute: (callback) => {
                    callback({ scope: browser_1.PreferenceScope.Folder, uri: folderWorkspace.resource.toString(), activeScopeIsFolder: true });
                }
            });
            this.menuModelRegistry.registerMenuAction(exports.FOLDER_SCOPE_MENU_PATH, {
                commandId: newFolderAsCommand.id,
                label: newFolderAsCommand.label
            });
        });
    }
};
exports.PreferenceScopeCommandManager = PreferenceScopeCommandManager;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.CommandRegistry),
    tslib_1.__metadata("design:type", common_1.CommandRegistry)
], PreferenceScopeCommandManager.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.MenuModelRegistry),
    tslib_1.__metadata("design:type", common_1.MenuModelRegistry)
], PreferenceScopeCommandManager.prototype, "menuModelRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], PreferenceScopeCommandManager.prototype, "labelProvider", void 0);
exports.PreferenceScopeCommandManager = PreferenceScopeCommandManager = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceScopeCommandManager);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/util/preference-tree-generator.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceTreeGenerator = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const preference_configurations_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-configurations */ "../../node_modules/@theia/core/lib/browser/preferences/preference-configurations.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
const preference_types_1 = __webpack_require__(/*! ./preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_layout_1 = __webpack_require__(/*! ./preference-layout */ "../../node_modules/@theia/preferences/lib/browser/util/preference-layout.js");
const preference_tree_label_provider_1 = __webpack_require__(/*! ./preference-tree-label-provider */ "../../node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js");
let PreferenceTreeGenerator = class PreferenceTreeGenerator {
    constructor() {
        this._idCache = new Map();
        this.onSchemaChangedEmitter = new core_1.Emitter();
        this.onSchemaChanged = this.onSchemaChangedEmitter.event;
        this.defaultTopLevelCategory = 'extensions';
        this.handleChangedSchema = debounce(this.doHandleChangedSchema, 200);
    }
    get root() {
        var _a;
        return (_a = this._root) !== null && _a !== void 0 ? _a : this.generateTree();
    }
    init() {
        this.doInit();
    }
    async doInit() {
        await this.schemaProvider.ready;
        this.schemaProvider.onDidPreferenceSchemaChanged(() => this.handleChangedSchema());
        this.handleChangedSchema();
    }
    generateTree() {
        var _a;
        this._idCache.clear();
        const preferencesSchema = this.schemaProvider.getCombinedSchema();
        const propertyNames = Object.keys(preferencesSchema.properties);
        const groups = new Map();
        const root = this.createRootNode();
        const commonlyUsedLayout = this.layoutProvider.getCommonlyUsedLayout();
        const commonlyUsed = this.getOrCreatePreferencesGroup({
            id: commonlyUsedLayout.id,
            group: commonlyUsedLayout.id,
            root,
            groups,
            label: commonlyUsedLayout.label
        });
        for (const layout of this.layoutProvider.getLayout()) {
            this.getOrCreatePreferencesGroup({
                id: layout.id,
                group: layout.id,
                root,
                groups,
                label: layout.label
            });
        }
        for (const preference of (_a = commonlyUsedLayout.settings) !== null && _a !== void 0 ? _a : []) {
            if (preference in preferencesSchema.properties) {
                this.createLeafNode(preference, commonlyUsed, preferencesSchema.properties[preference]);
            }
        }
        for (const propertyName of propertyNames) {
            const property = preferencesSchema.properties[propertyName];
            if (!property.hidden && !property.deprecationMessage && !this.preferenceConfigs.isSectionName(propertyName) && !browser_1.OVERRIDE_PROPERTY_PATTERN.test(propertyName)) {
                if (property.owner) {
                    this.createPluginLeafNode(propertyName, property, root, groups);
                }
                else {
                    this.createBuiltinLeafNode(propertyName, property, root, groups);
                }
            }
        }
        for (const group of groups.values()) {
            if (group.id !== `${preference_layout_1.COMMONLY_USED_SECTION_PREFIX}@${preference_layout_1.COMMONLY_USED_SECTION_PREFIX}`) {
                group.children.sort((a, b) => {
                    const aIsComposite = browser_1.CompositeTreeNode.is(a);
                    const bIsComposite = browser_1.CompositeTreeNode.is(b);
                    if (aIsComposite && !bIsComposite) {
                        return 1;
                    }
                    if (bIsComposite && !aIsComposite) {
                        return -1;
                    }
                    return a.id.localeCompare(b.id);
                });
            }
        }
        this._root = root;
        return root;
    }
    ;
    createBuiltinLeafNode(name, property, root, groups) {
        const { immediateParent, topLevelParent } = this.getParents(name, root, groups);
        this.createLeafNode(name, immediateParent || topLevelParent, property);
    }
    createPluginLeafNode(name, property, root, groups) {
        if (!property.owner) {
            return;
        }
        const groupID = this.defaultTopLevelCategory;
        const subgroupName = property.owner;
        const subsubgroupName = property.group;
        const hasGroup = Boolean(subsubgroupName);
        const toplevelParent = this.getOrCreatePreferencesGroup({
            id: groupID,
            group: groupID,
            root,
            groups
        });
        const subgroupID = [groupID, subgroupName].join('.');
        const subgroupParent = this.getOrCreatePreferencesGroup({
            id: subgroupID,
            group: groupID,
            root: toplevelParent,
            groups,
            expanded: hasGroup,
            label: subgroupName
        });
        const subsubgroupID = [groupID, subgroupName, subsubgroupName].join('.');
        const subsubgroupParent = hasGroup ? this.getOrCreatePreferencesGroup({
            id: subsubgroupID,
            group: subgroupID,
            root: subgroupParent,
            groups,
            depth: 2,
            label: subsubgroupName
        }) : undefined;
        this.createLeafNode(name, subsubgroupParent || subgroupParent, property);
    }
    getNodeId(preferenceId) {
        var _a;
        return (_a = this._idCache.get(preferenceId)) !== null && _a !== void 0 ? _a : '';
    }
    getParents(name, root, groups) {
        var _a, _b;
        const layoutItem = this.layoutProvider.getLayoutForPreference(name);
        const labels = ((_a = layoutItem === null || layoutItem === void 0 ? void 0 : layoutItem.id) !== null && _a !== void 0 ? _a : name).split('.');
        const groupID = this.getGroupName(labels);
        const subgroupName = groupID !== labels[0]
            ? labels[0]
            // If a layout item is present, any additional segments are sections
            // If not, then the name describes a leaf node and only non-final segments are sections.
            : layoutItem || labels.length > 2
                ? labels.at(1)
                : undefined;
        const topLevelParent = this.getOrCreatePreferencesGroup({
            id: groupID,
            group: groupID,
            root,
            groups,
            label: this.generateName(groupID)
        });
        const immediateParent = subgroupName ? this.getOrCreatePreferencesGroup({
            id: [groupID, subgroupName].join('.'),
            group: groupID,
            root: topLevelParent,
            groups,
            label: (_b = layoutItem === null || layoutItem === void 0 ? void 0 : layoutItem.label) !== null && _b !== void 0 ? _b : this.generateName(subgroupName)
        }) : undefined;
        return { immediateParent, topLevelParent };
    }
    getGroupName(labels) {
        const defaultGroup = labels[0];
        if (this.layoutProvider.hasCategory(defaultGroup)) {
            return defaultGroup;
        }
        return this.defaultTopLevelCategory;
    }
    getSubgroupName(labels, computedGroupName) {
        if (computedGroupName !== labels[0]) {
            return labels[0];
        }
        else if (labels.length > 1) {
            return labels[1];
        }
        else {
            return undefined;
        }
    }
    generateName(id) {
        return this.labelProvider.formatString(id);
    }
    doHandleChangedSchema() {
        const newTree = this.generateTree();
        this.onSchemaChangedEmitter.fire(newTree);
    }
    createRootNode() {
        return {
            id: 'root-node-id',
            name: '',
            parent: undefined,
            visible: true,
            children: []
        };
    }
    createLeafNode(property, preferencesGroup, data) {
        const { group } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(preferencesGroup.id);
        const newNode = {
            id: `${group}@${property}`,
            preferenceId: property,
            parent: preferencesGroup,
            preference: { data },
            depth: preference_types_1.Preference.TreeNode.isTopLevel(preferencesGroup) ? 1 : 2
        };
        this._idCache.set(property, newNode.id);
        browser_1.CompositeTreeNode.addChild(preferencesGroup, newNode);
        return newNode;
    }
    createPreferencesGroup(options) {
        var _a, _b;
        const newNode = {
            id: `${options.group}@${options.id}`,
            visible: true,
            parent: options.root,
            children: [],
            expanded: false,
            selected: false,
            depth: 0,
            label: options.label
        };
        const isTopLevel = preference_types_1.Preference.TreeNode.isTopLevel(newNode);
        if (!((_a = options.expanded) !== null && _a !== void 0 ? _a : isTopLevel)) {
            delete newNode.expanded;
        }
        newNode.depth = (_b = options.depth) !== null && _b !== void 0 ? _b : (isTopLevel ? 0 : 1);
        browser_1.CompositeTreeNode.addChild(options.root, newNode);
        return newNode;
    }
    getOrCreatePreferencesGroup(options) {
        const existingGroup = options.groups.get(options.id);
        if (existingGroup) {
            return existingGroup;
        }
        const newNode = this.createPreferencesGroup(options);
        options.groups.set(options.id, newNode);
        return newNode;
    }
    ;
};
exports.PreferenceTreeGenerator = PreferenceTreeGenerator;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceSchemaProvider),
    tslib_1.__metadata("design:type", browser_1.PreferenceSchemaProvider)
], PreferenceTreeGenerator.prototype, "schemaProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_configurations_1.PreferenceConfigurations),
    tslib_1.__metadata("design:type", preference_configurations_1.PreferenceConfigurations)
], PreferenceTreeGenerator.prototype, "preferenceConfigs", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_layout_1.PreferenceLayoutProvider),
    tslib_1.__metadata("design:type", preference_layout_1.PreferenceLayoutProvider)
], PreferenceTreeGenerator.prototype, "layoutProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_label_provider_1.PreferenceTreeLabelProvider),
    tslib_1.__metadata("design:type", preference_tree_label_provider_1.PreferenceTreeLabelProvider)
], PreferenceTreeGenerator.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferenceTreeGenerator.prototype, "init", null);
exports.PreferenceTreeGenerator = PreferenceTreeGenerator = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceTreeGenerator);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceTreeLabelProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const preference_types_1 = __webpack_require__(/*! ./preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_layout_1 = __webpack_require__(/*! ./preference-layout */ "../../node_modules/@theia/preferences/lib/browser/util/preference-layout.js");
let PreferenceTreeLabelProvider = class PreferenceTreeLabelProvider {
    canHandle(element) {
        return browser_1.TreeNode.is(element) && preference_types_1.Preference.TreeNode.is(element) ? 150 : 0;
    }
    getName(node) {
        if (preference_types_1.Preference.TreeNode.is(node) && node.label) {
            return node.label;
        }
        const { id } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(node.id);
        const labels = id.split('.');
        const groupName = labels[labels.length - 1];
        return this.formatString(groupName);
    }
    getPrefix(node, fullPath = false) {
        const { depth } = node;
        const { id, group } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(node.id);
        const segments = id.split('.');
        const segmentsHandled = group === segments[0] ? depth : depth - 1;
        segments.pop(); // Ignore the leaf name.
        const prefixSegments = fullPath ? segments : segments.slice(segmentsHandled);
        if (prefixSegments.length) {
            let output = prefixSegments.length > 1 ? `${this.formatString(prefixSegments[0])} › ` : `${this.formatString(prefixSegments[0])}: `;
            for (const segment of prefixSegments.slice(1)) {
                output += `${this.formatString(segment)}: `;
            }
            return output;
        }
    }
    formatString(string) {
        let formattedString = string[0].toLocaleUpperCase();
        for (let i = 1; i < string.length; i++) {
            if (this.isUpperCase(string[i]) && !/\s/.test(string[i - 1]) && !this.isUpperCase(string[i - 1])) {
                formattedString += ' ';
            }
            formattedString += string[i];
        }
        return formattedString.trim();
    }
    isUpperCase(char) {
        return char === char.toLocaleUpperCase() && char.toLocaleLowerCase() !== char.toLocaleUpperCase();
    }
};
exports.PreferenceTreeLabelProvider = PreferenceTreeLabelProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_layout_1.PreferenceLayoutProvider),
    tslib_1.__metadata("design:type", preference_layout_1.PreferenceLayoutProvider)
], PreferenceTreeLabelProvider.prototype, "layoutProvider", void 0);
exports.PreferenceTreeLabelProvider = PreferenceTreeLabelProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceTreeLabelProvider);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/util/preference-types.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceMenus = exports.PreferencesCommands = exports.Preference = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
var Preference;
(function (Preference) {
    let EditorCommandArgs;
    (function (EditorCommandArgs) {
        function is(prefObject) {
            return !!prefObject && 'id' in prefObject && 'value' in prefObject;
        }
        EditorCommandArgs.is = is;
    })(EditorCommandArgs = Preference.EditorCommandArgs || (Preference.EditorCommandArgs = {}));
    Preference.Node = Symbol('Preference.Node');
    let TreeNode;
    (function (TreeNode) {
        TreeNode.is = (node) => 'depth' in node;
        TreeNode.isTopLevel = (node) => {
            const { group, id } = TreeNode.getGroupAndIdFromNodeId(node.id);
            return group === id;
        };
        TreeNode.getGroupAndIdFromNodeId = (nodeId) => {
            const separator = nodeId.indexOf('@');
            const group = nodeId.substring(0, separator);
            const id = nodeId.substring(separator + 1, nodeId.length);
            return { group, id };
        };
    })(TreeNode = Preference.TreeNode || (Preference.TreeNode = {}));
    let CompositeTreeNode;
    (function (CompositeTreeNode) {
        CompositeTreeNode.is = (node) => !LeafNode.is(node);
    })(CompositeTreeNode = Preference.CompositeTreeNode || (Preference.CompositeTreeNode = {}));
    let LeafNode;
    (function (LeafNode) {
        LeafNode.is = (node) => 'preference' in node && !!node.preference.data;
        LeafNode.getType = (node) => LeafNode.is(node)
            ? Array.isArray(node.preference.data.type) ? node.preference.data.type[0] : node.preference.data.type
            : undefined;
    })(LeafNode = Preference.LeafNode || (Preference.LeafNode = {}));
    Preference.getValueInScope = (preferenceInfo, scope) => {
        if (!preferenceInfo) {
            return undefined;
        }
        switch (scope) {
            case browser_1.PreferenceScope.User:
                return preferenceInfo.globalValue;
            case browser_1.PreferenceScope.Workspace:
                return preferenceInfo.workspaceValue;
            case browser_1.PreferenceScope.Folder:
                return preferenceInfo.workspaceFolderValue;
            default:
                return undefined;
        }
    };
    ;
    Preference.DEFAULT_SCOPE = {
        scope: browser_1.PreferenceScope.User,
        uri: undefined,
        activeScopeIsFolder: false
    };
})(Preference || (exports.Preference = Preference = {}));
var PreferencesCommands;
(function (PreferencesCommands) {
    PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR = {
        id: 'preferences:openJson.toolbar',
        iconClass: 'codicon codicon-json'
    };
    PreferencesCommands.COPY_JSON_NAME = core_1.Command.toDefaultLocalizedCommand({
        id: 'preferences:copyJson.name',
        label: 'Copy Setting ID'
    });
    PreferencesCommands.RESET_PREFERENCE = core_1.Command.toDefaultLocalizedCommand({
        id: 'preferences:reset',
        label: 'Reset Setting'
    });
    PreferencesCommands.COPY_JSON_VALUE = core_1.Command.toDefaultLocalizedCommand({
        id: 'preferences:copyJson.value',
        label: 'Copy Setting as JSON',
    });
    PreferencesCommands.OPEN_USER_PREFERENCES = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openGlobalSettings',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open User Settings',
    });
    PreferencesCommands.OPEN_WORKSPACE_PREFERENCES = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openWorkspaceSettings',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Workspace Settings',
    });
    PreferencesCommands.OPEN_FOLDER_PREFERENCES = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openFolderSettings',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Folder Settings'
    });
    PreferencesCommands.OPEN_USER_PREFERENCES_JSON = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openSettingsJson',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Settings (JSON)'
    });
    PreferencesCommands.OPEN_WORKSPACE_PREFERENCES_JSON = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openWorkspaceSettingsFile',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Workspace Settings (JSON)',
    });
    PreferencesCommands.OPEN_FOLDER_PREFERENCES_JSON = core_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.openFolderSettingsFile',
        category: browser_1.CommonCommands.PREFERENCES_CATEGORY,
        label: 'Open Folder Settings (JSON)',
    });
})(PreferencesCommands || (exports.PreferencesCommands = PreferencesCommands = {}));
var PreferenceMenus;
(function (PreferenceMenus) {
    PreferenceMenus.PREFERENCE_EDITOR_CONTEXT_MENU = ['preferences:editor.contextMenu'];
    PreferenceMenus.PREFERENCE_EDITOR_COPY_ACTIONS = [...PreferenceMenus.PREFERENCE_EDITOR_CONTEXT_MENU, 'preferences:editor.contextMenu.copy'];
    PreferenceMenus.FOLDER_SCOPE_MENU_PATH = ['preferences:scope.menu'];
})(PreferenceMenus || (exports.PreferenceMenus = PreferenceMenus = {}));


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-array-input.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-array-input.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceArrayInputRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceArrayInputRendererContribution = exports.PreferenceArrayInputRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preference_types_1 = __webpack_require__(/*! ../../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
let PreferenceArrayInputRenderer = class PreferenceArrayInputRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    constructor() {
        super(...arguments);
        this.existingValues = new Map();
    }
    createInteractable(parent) {
        const wrapper = document.createElement('ul');
        wrapper.classList.add('preference-array');
        this.wrapper = wrapper;
        const currentValue = this.getValue();
        if (Array.isArray(currentValue)) {
            for (const [index, value] of currentValue.entries()) {
                const node = this.createExistingValue(value);
                wrapper.appendChild(node);
                this.existingValues.set(value, { node, index });
            }
        }
        const inputWrapper = this.createInput();
        wrapper.appendChild(inputWrapper);
        parent.appendChild(wrapper);
    }
    getFallbackValue() {
        return [];
    }
    createExistingValue(value) {
        const existingValue = document.createElement('li');
        existingValue.classList.add('preference-array-element');
        const valueWrapper = document.createElement('span');
        valueWrapper.classList.add('preference-array-element-val');
        valueWrapper.textContent = value;
        existingValue.appendChild(valueWrapper);
        const iconWrapper = document.createElement('span');
        iconWrapper.classList.add('preference-array-element-btn', 'remove-btn');
        const handler = this.removeItem.bind(this, value);
        iconWrapper.onclick = handler;
        iconWrapper.onkeydown = handler;
        iconWrapper.setAttribute('role', 'button');
        iconWrapper.tabIndex = 0;
        existingValue.appendChild(iconWrapper);
        const icon = document.createElement('i');
        icon.classList.add(...(0, browser_1.codiconArray)('close'));
        iconWrapper.appendChild(icon);
        return existingValue;
    }
    createInput() {
        const inputWrapper = document.createElement('li');
        this.inputWrapper = inputWrapper;
        const input = document.createElement('input');
        inputWrapper.appendChild(input);
        this.interactable = input;
        input.classList.add('preference-array-input', 'theia-input');
        input.type = 'text';
        input.placeholder = 'Add Value...';
        input.spellcheck = false;
        input.onkeydown = this.handleEnter.bind(this);
        input.setAttribute('aria-label', 'Preference String Input');
        const iconWrapper = document.createElement('span');
        inputWrapper.appendChild(iconWrapper);
        iconWrapper.classList.add('preference-array-element-btn', ...(0, browser_1.codiconArray)('add'));
        iconWrapper.setAttribute('role', 'button');
        const handler = this.addItem.bind(this);
        iconWrapper.onclick = handler;
        iconWrapper.onkeydown = handler;
        iconWrapper.tabIndex = 0;
        iconWrapper.setAttribute('aria-label', 'Submit Preference Input');
        return inputWrapper;
    }
    doHandleValueChange() {
        var _a;
        this.updateInspection();
        const values = (_a = this.getValue()) !== null && _a !== void 0 ? _a : [];
        const newValues = new Set(...values);
        for (const [value, row] of this.existingValues.entries()) {
            if (!newValues.has(value)) {
                row.node.remove();
                this.existingValues.delete(value);
            }
        }
        for (const [index, value] of values.entries()) {
            let row = this.existingValues.get(value);
            if (row) {
                row.index = index;
            }
            else {
                row = { node: this.createExistingValue(value), index };
                this.existingValues.set(value, row);
            }
            if (this.wrapper.children[index] !== row.node) {
                this.wrapper.children[index].insertAdjacentElement('beforebegin', row.node);
            }
        }
        this.updateModificationStatus();
    }
    removeItem(value) {
        const row = this.existingValues.get(value);
        if (row) {
            row.node.remove();
            this.existingValues.delete(value);
            this.setPreferenceImmediately(this.getOrderedValues());
        }
    }
    handleEnter(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            this.addItem();
        }
    }
    addItem() {
        const newItem = this.interactable.value;
        if (newItem && !this.existingValues.has(newItem)) {
            const node = this.createExistingValue(newItem);
            this.inputWrapper.insertAdjacentElement('beforebegin', node);
            this.existingValues.set(newItem, { node, index: this.existingValues.size });
            this.setPreferenceImmediately(this.getOrderedValues());
        }
        this.interactable.value = '';
    }
    getOrderedValues() {
        return Array.from(this.existingValues.entries())
            .sort(([, a], [, b]) => a.index - b.index)
            .map(([value]) => value);
    }
    dispose() {
        this.existingValues.clear();
        super.dispose();
    }
};
exports.PreferenceArrayInputRenderer = PreferenceArrayInputRenderer;
exports.PreferenceArrayInputRenderer = PreferenceArrayInputRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceArrayInputRenderer);
let PreferenceArrayInputRendererContribution = PreferenceArrayInputRendererContribution_1 = class PreferenceArrayInputRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceArrayInputRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        var _a;
        const type = preference_types_1.Preference.LeafNode.getType(node);
        return type === 'array' && ((_a = node.preference.data.items) === null || _a === void 0 ? void 0 : _a.type) === 'string' ? 2 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceArrayInputRenderer);
    }
};
exports.PreferenceArrayInputRendererContribution = PreferenceArrayInputRendererContribution;
PreferenceArrayInputRendererContribution.ID = 'preference-array-input-renderer';
exports.PreferenceArrayInputRendererContribution = PreferenceArrayInputRendererContribution = PreferenceArrayInputRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceArrayInputRendererContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-boolean-input.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-boolean-input.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceBooleanInputRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceBooleanInputRendererContribution = exports.PreferenceBooleanInputRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preference_types_1 = __webpack_require__(/*! ../../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
let PreferenceBooleanInputRenderer = class PreferenceBooleanInputRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    createInteractable(parent) {
        const interactable = document.createElement('input');
        this.interactable = interactable;
        interactable.type = 'checkbox';
        interactable.classList.add('theia-input');
        interactable.defaultChecked = Boolean(this.getValue());
        interactable.onchange = this.handleUserInteraction.bind(this);
        parent.appendChild(interactable);
    }
    getAdditionalNodeClassnames() {
        return ['boolean'];
    }
    getFallbackValue() {
        return false;
    }
    handleUserInteraction() {
        return this.setPreferenceImmediately(this.interactable.checked);
    }
    doHandleValueChange() {
        const currentValue = this.interactable.checked;
        this.updateInspection();
        const newValue = Boolean(this.getValue());
        this.updateModificationStatus(newValue);
        if (newValue !== currentValue && document.activeElement !== this.interactable) {
            this.interactable.checked = newValue;
        }
    }
};
exports.PreferenceBooleanInputRenderer = PreferenceBooleanInputRenderer;
exports.PreferenceBooleanInputRenderer = PreferenceBooleanInputRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceBooleanInputRenderer);
let PreferenceBooleanInputRendererContribution = PreferenceBooleanInputRendererContribution_1 = class PreferenceBooleanInputRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceBooleanInputRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        return preference_types_1.Preference.LeafNode.getType(node) === 'boolean' ? 2 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceBooleanInputRenderer);
    }
};
exports.PreferenceBooleanInputRendererContribution = PreferenceBooleanInputRendererContribution;
PreferenceBooleanInputRendererContribution.ID = 'preference-boolean-input-renderer';
exports.PreferenceBooleanInputRendererContribution = PreferenceBooleanInputRendererContribution = PreferenceBooleanInputRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceBooleanInputRendererContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-file-input.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-file-input.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2022 EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceSingleFilePathInputRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceSingleFilePathInputRenderer = exports.PreferenceSingleFilePathInputRendererContribution = exports.FileNodeTypeDetails = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const file_dialog_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-dialog/file-dialog-service */ "../../node_modules/@theia/filesystem/lib/browser/file-dialog/file-dialog-service.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
const preference_string_input_1 = __webpack_require__(/*! ./preference-string-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-string-input.js");
var FileNodeTypeDetails;
(function (FileNodeTypeDetails) {
    function is(typeDetails) {
        return (0, common_1.isObject)(typeDetails) && !!typeDetails.isFilepath;
    }
    FileNodeTypeDetails.is = is;
})(FileNodeTypeDetails || (exports.FileNodeTypeDetails = FileNodeTypeDetails = {}));
let PreferenceSingleFilePathInputRendererContribution = PreferenceSingleFilePathInputRendererContribution_1 = class PreferenceSingleFilePathInputRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceSingleFilePathInputRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        var _a;
        const typeDetails = node.preference.data.typeDetails;
        return FileNodeTypeDetails.is(typeDetails) && !((_a = typeDetails.selectionProps) === null || _a === void 0 ? void 0 : _a.canSelectMany) ? 5 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceSingleFilePathInputRenderer);
    }
};
exports.PreferenceSingleFilePathInputRendererContribution = PreferenceSingleFilePathInputRendererContribution;
PreferenceSingleFilePathInputRendererContribution.ID = 'preference-single-file-path-input-renderer';
exports.PreferenceSingleFilePathInputRendererContribution = PreferenceSingleFilePathInputRendererContribution = PreferenceSingleFilePathInputRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceSingleFilePathInputRendererContribution);
let PreferenceSingleFilePathInputRenderer = class PreferenceSingleFilePathInputRenderer extends preference_string_input_1.PreferenceStringInputRenderer {
    get typeDetails() {
        return this.preferenceNode.preference.data.typeDetails;
    }
    createInputWrapper() {
        const inputWrapper = document.createElement('div');
        inputWrapper.classList.add('preference-file-container');
        return inputWrapper;
    }
    createInteractable(parent) {
        const inputWrapper = this.createInputWrapper();
        super.createInteractable(inputWrapper);
        this.interactable.classList.add('preference-file-input');
        this.createBrowseButton(inputWrapper);
        parent.appendChild(inputWrapper);
    }
    createBrowseButton(parent) {
        const button = document.createElement('button');
        button.classList.add('theia-button', 'main', 'preference-file-button');
        button.textContent = nls_1.nls.localize('theia/core/file/browse', 'Browse');
        const handler = this.browse.bind(this);
        button.onclick = handler;
        button.onkeydown = handler;
        button.tabIndex = 0;
        button.setAttribute('aria-label', 'Submit Preference Input');
        parent.appendChild(button);
    }
    async browse() {
        var _a;
        const selectionProps = this.typeDetails.selectionProps;
        const title = ((_a = selectionProps === null || selectionProps === void 0 ? void 0 : selectionProps.title) !== null && _a !== void 0 ? _a : selectionProps === null || selectionProps === void 0 ? void 0 : selectionProps.canSelectFolders) ? browser_1.WorkspaceCommands.OPEN_FOLDER.dialogLabel : browser_1.WorkspaceCommands.OPEN_FILE.dialogLabel;
        const selection = await this.fileDialogService.showOpenDialog({ title, ...selectionProps });
        if (selection) {
            this.setPreferenceImmediately(selection.path.fsPath());
        }
    }
    setPreferenceImmediately(value) {
        this.interactable.value = value;
        return super.setPreferenceImmediately(value);
    }
};
exports.PreferenceSingleFilePathInputRenderer = PreferenceSingleFilePathInputRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_dialog_service_1.FileDialogService),
    tslib_1.__metadata("design:type", Object)
], PreferenceSingleFilePathInputRenderer.prototype, "fileDialogService", void 0);
exports.PreferenceSingleFilePathInputRenderer = PreferenceSingleFilePathInputRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceSingleFilePathInputRenderer);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-json-input.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-json-input.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceJSONLinkRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceJSONLinkRendererContribution = exports.PreferenceJSONLinkRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const preference_node_renderer_1 = __webpack_require__(/*! ./preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const preference_types_1 = __webpack_require__(/*! ../../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
let PreferenceJSONLinkRenderer = class PreferenceJSONLinkRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    createInteractable(parent) {
        const message = common_1.nls.localizeByDefault('Edit in settings.json');
        const interactable = document.createElement('a');
        this.interactable = interactable;
        interactable.classList.add('theia-json-input');
        interactable.setAttribute('role', 'button');
        interactable.title = message;
        interactable.textContent = message;
        interactable.onclick = this.handleUserInteraction.bind(this);
        interactable.onkeydown = this.handleUserInteraction.bind(this);
        parent.appendChild(interactable);
    }
    getFallbackValue() {
        const node = this.preferenceNode;
        const type = Array.isArray(node.preference.data.type) ? node.preference.data.type[0] : node.preference.data.type;
        switch (type) {
            case 'object':
                return {};
            case 'array':
                return [];
            case 'null':
                return null; // eslint-disable-line no-null/no-null
            default: // Should all be handled by other input types.
                return '';
        }
    }
    doHandleValueChange() {
        this.updateInspection();
        this.updateModificationStatus();
    }
    handleUserInteraction() {
        this.commandService.executeCommand(preference_types_1.PreferencesCommands.OPEN_PREFERENCES_JSON_TOOLBAR.id, this.id);
    }
};
exports.PreferenceJSONLinkRenderer = PreferenceJSONLinkRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.CommandService),
    tslib_1.__metadata("design:type", Object)
], PreferenceJSONLinkRenderer.prototype, "commandService", void 0);
exports.PreferenceJSONLinkRenderer = PreferenceJSONLinkRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceJSONLinkRenderer);
let PreferenceJSONLinkRendererContribution = PreferenceJSONLinkRendererContribution_1 = class PreferenceJSONLinkRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceJSONLinkRendererContribution_1.ID;
    }
    canHandleLeafNode(_node) {
        return 1;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceJSONLinkRenderer);
    }
};
exports.PreferenceJSONLinkRendererContribution = PreferenceJSONLinkRendererContribution;
PreferenceJSONLinkRendererContribution.ID = 'preference-json-link-renderer';
exports.PreferenceJSONLinkRendererContribution = PreferenceJSONLinkRendererContribution = PreferenceJSONLinkRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceJSONLinkRendererContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-markdown-renderer.js":
/*!**********************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-markdown-renderer.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceMarkdownRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preference_tree_model_1 = __webpack_require__(/*! ../../preference-tree-model */ "../../node_modules/@theia/preferences/lib/browser/preference-tree-model.js");
const preference_tree_label_provider_1 = __webpack_require__(/*! ../../util/preference-tree-label-provider */ "../../node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js");
const markdownit = __webpack_require__(/*! @theia/core/shared/markdown-it */ "../../node_modules/@theia/core/shared/markdown-it.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let PreferenceMarkdownRenderer = class PreferenceMarkdownRenderer {
    render(text) {
        return this.getRenderer().render(text);
    }
    renderInline(text) {
        return this.getRenderer().renderInline(text);
    }
    getRenderer() {
        var _a;
        (_a = this._renderer) !== null && _a !== void 0 ? _a : (this._renderer = this.buildMarkdownRenderer());
        return this._renderer;
    }
    buildMarkdownRenderer() {
        const engine = markdownit();
        const inlineCode = engine.renderer.rules.code_inline;
        engine.renderer.rules.code_inline = (tokens, idx, options, env, self) => {
            const token = tokens[idx];
            const content = token.content;
            if (content.length > 2 && content.startsWith('#') && content.endsWith('#')) {
                const id = content.substring(1, content.length - 1);
                // First check whether there's a preference with the given ID
                const preferenceNode = this.model.getNodeFromPreferenceId(id);
                if (preferenceNode) {
                    let name = this.labelProvider.getName(preferenceNode);
                    const prefix = this.labelProvider.getPrefix(preferenceNode, true);
                    if (prefix) {
                        name = prefix + name;
                    }
                    return `<a title="${id}" href="preference:${id}">${name}</a>`;
                }
                // If no preference was found, check whether there's a command with the given ID
                const command = this.commandRegistry.getCommand(id);
                if (command) {
                    const name = `${command.category ? `${command.category}: ` : ''}${command.label}`;
                    return `<span class="command-link" title="${id}">${name}</span>`;
                }
                // If nothing was found, print a warning
                console.warn(`Linked preference "${id}" not found.`);
            }
            return inlineCode ? inlineCode(tokens, idx, options, env, self) : '';
        };
        return engine;
    }
};
exports.PreferenceMarkdownRenderer = PreferenceMarkdownRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_model_1.PreferenceTreeModel),
    tslib_1.__metadata("design:type", preference_tree_model_1.PreferenceTreeModel)
], PreferenceMarkdownRenderer.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_label_provider_1.PreferenceTreeLabelProvider),
    tslib_1.__metadata("design:type", preference_tree_label_provider_1.PreferenceTreeLabelProvider)
], PreferenceMarkdownRenderer.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], PreferenceMarkdownRenderer.prototype, "commandRegistry", void 0);
exports.PreferenceMarkdownRenderer = PreferenceMarkdownRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceMarkdownRenderer);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js":
/*!**************************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2022 EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceHeaderRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceHeaderRendererContribution = exports.PreferenceLeafNodeRendererContribution = exports.DefaultPreferenceNodeRendererCreatorRegistry = exports.PreferenceNodeRendererCreator = exports.PreferenceNodeRendererContribution = exports.PreferenceNodeRendererCreatorRegistry = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preference_types_1 = __webpack_require__(/*! ../../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
exports.PreferenceNodeRendererCreatorRegistry = Symbol('PreferenceNodeRendererCreatorRegistry');
exports.PreferenceNodeRendererContribution = Symbol('PreferenceNodeRendererContribution');
exports.PreferenceNodeRendererCreator = Symbol('PreferenceNodeRendererCreator');
let DefaultPreferenceNodeRendererCreatorRegistry = class DefaultPreferenceNodeRendererCreatorRegistry {
    constructor(contributionProvider) {
        this.contributionProvider = contributionProvider;
        this._creators = new Map();
        this.onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        const contributions = this.contributionProvider.getContributions();
        for (const contrib of contributions) {
            contrib.registerPreferenceNodeRendererCreator(this);
        }
    }
    registerPreferenceNodeRendererCreator(creator) {
        if (this._creators.has(creator.id)) {
            console.warn(`A preference node renderer creator ${creator.id} is already registered.`);
            return core_1.Disposable.NULL;
        }
        this._creators.set(creator.id, creator);
        this.fireDidChange();
        return core_1.Disposable.create(() => this._creators.delete(creator.id));
    }
    unregisterPreferenceNodeRendererCreator(creator) {
        const id = typeof creator === 'string' ? creator : creator.id;
        if (this._creators.delete(id)) {
            this.fireDidChange();
        }
    }
    getPreferenceNodeRendererCreator(node) {
        const contributions = this.prioritize(node);
        if (contributions.length >= 1) {
            return contributions[0];
        }
        // we already bind a default creator contribution so if that happens it was deliberate
        throw new Error(`There is no contribution for ${node.id}.`);
    }
    fireDidChange() {
        this.onDidChangeEmitter.fire(undefined);
    }
    prioritize(node) {
        const prioritized = core_1.Prioritizeable.prioritizeAllSync(Array.from(this._creators.values()), creator => {
            try {
                return creator.canHandle(node);
            }
            catch {
                return 0;
            }
        });
        return prioritized.map(p => p.value);
    }
};
exports.DefaultPreferenceNodeRendererCreatorRegistry = DefaultPreferenceNodeRendererCreatorRegistry;
exports.DefaultPreferenceNodeRendererCreatorRegistry = DefaultPreferenceNodeRendererCreatorRegistry = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(core_1.ContributionProvider)),
    tslib_1.__param(0, (0, inversify_1.named)(exports.PreferenceNodeRendererContribution)),
    tslib_1.__metadata("design:paramtypes", [Object])
], DefaultPreferenceNodeRendererCreatorRegistry);
let PreferenceLeafNodeRendererContribution = class PreferenceLeafNodeRendererContribution {
    canHandle(node) {
        return preference_types_1.Preference.LeafNode.is(node) ? this.canHandleLeafNode(node) : 0;
    }
    registerPreferenceNodeRendererCreator(registry) {
        registry.registerPreferenceNodeRendererCreator(this);
    }
    createRenderer(node, container) {
        const child = container.createChild();
        child.bind(preference_types_1.Preference.Node).toConstantValue(node);
        return this.createLeafNodeRenderer(child);
    }
};
exports.PreferenceLeafNodeRendererContribution = PreferenceLeafNodeRendererContribution;
exports.PreferenceLeafNodeRendererContribution = PreferenceLeafNodeRendererContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceLeafNodeRendererContribution);
let PreferenceHeaderRendererContribution = PreferenceHeaderRendererContribution_1 = class PreferenceHeaderRendererContribution {
    constructor() {
        this.id = PreferenceHeaderRendererContribution_1.ID;
    }
    registerPreferenceNodeRendererCreator(registry) {
        registry.registerPreferenceNodeRendererCreator(this);
    }
    canHandle(node) {
        return !preference_types_1.Preference.LeafNode.is(node) ? 1 : 0;
    }
    createRenderer(node, container) {
        const grandchild = container.createChild();
        grandchild.bind(preference_types_1.Preference.Node).toConstantValue(node);
        return grandchild.get(preference_node_renderer_1.PreferenceHeaderRenderer);
    }
};
exports.PreferenceHeaderRendererContribution = PreferenceHeaderRendererContribution;
PreferenceHeaderRendererContribution.ID = 'preference-header-renderer';
exports.PreferenceHeaderRendererContribution = PreferenceHeaderRendererContribution = PreferenceHeaderRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceHeaderRendererContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceLeafNodeRenderer = exports.PreferenceHeaderRenderer = exports.PreferenceNodeRenderer = exports.SUBHEADER_CLASS = exports.HEADER_CLASS = exports.PreferenceNodeRendererFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const preference_types_1 = __webpack_require__(/*! ../../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_tree_label_provider_1 = __webpack_require__(/*! ../../util/preference-tree-label-provider */ "../../node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ../preference-scope-tabbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const debounce = __webpack_require__(/*! @theia/core/shared/lodash.debounce */ "../../node_modules/@theia/core/shared/lodash.debounce/index.js");
const preference_tree_model_1 = __webpack_require__(/*! ../../preference-tree-model */ "../../node_modules/@theia/preferences/lib/browser/preference-tree-model.js");
const preference_searchbar_widget_1 = __webpack_require__(/*! ../preference-searchbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js");
const DOMPurify = __webpack_require__(/*! @theia/core/shared/dompurify */ "../../node_modules/@theia/core/shared/dompurify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const preference_markdown_renderer_1 = __webpack_require__(/*! ./preference-markdown-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-markdown-renderer.js");
exports.PreferenceNodeRendererFactory = Symbol('PreferenceNodeRendererFactory');
exports.HEADER_CLASS = 'settings-section-category-title';
exports.SUBHEADER_CLASS = 'settings-section-subcategory-title';
let PreferenceNodeRenderer = class PreferenceNodeRenderer {
    constructor() {
        this.attached = false;
    }
    get node() {
        return this.domNode;
    }
    get nodeId() {
        return this.preferenceNode.id;
    }
    get id() {
        return this._id;
    }
    get group() {
        return this._group;
    }
    get visible() {
        return !this.node.classList.contains('hidden');
    }
    init() {
        this.setId();
        this.domNode = this.createDomNode();
    }
    setId() {
        var _a;
        const { id, group } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(this.preferenceNode.id);
        const segments = id.split('.');
        this._id = id;
        this._group = group;
        this._subgroup = (_a = (group === segments[0] ? segments[1] : segments[0])) !== null && _a !== void 0 ? _a : '';
    }
    getAdditionalNodeClassnames() {
        return [];
    }
    insertBefore(nextSibling) {
        nextSibling.insertAdjacentElement('beforebegin', this.domNode);
        this.attached = true;
    }
    insertAfter(previousSibling) {
        previousSibling.insertAdjacentElement('afterend', this.domNode);
    }
    appendTo(parent) {
        parent.appendChild(this.domNode);
    }
    prependTo(parent) {
        parent.prepend(this.domNode);
    }
    hide() {
        this.domNode.classList.add('hidden');
    }
    show() {
        this.domNode.classList.remove('hidden');
    }
    dispose() {
        this.domNode.remove();
    }
};
exports.PreferenceNodeRenderer = PreferenceNodeRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_types_1.Preference.Node),
    tslib_1.__metadata("design:type", Object)
], PreferenceNodeRenderer.prototype, "preferenceNode", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_label_provider_1.PreferenceTreeLabelProvider),
    tslib_1.__metadata("design:type", preference_tree_label_provider_1.PreferenceTreeLabelProvider)
], PreferenceNodeRenderer.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferenceNodeRenderer.prototype, "init", null);
exports.PreferenceNodeRenderer = PreferenceNodeRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceNodeRenderer);
class PreferenceHeaderRenderer extends PreferenceNodeRenderer {
    createDomNode() {
        const wrapper = document.createElement('ul');
        wrapper.className = 'settings-section';
        wrapper.id = `${this.preferenceNode.id}-editor`;
        const isCategory = preference_types_1.Preference.TreeNode.isTopLevel(this.preferenceNode);
        const hierarchyClassName = isCategory ? exports.HEADER_CLASS : exports.SUBHEADER_CLASS;
        const name = this.labelProvider.getName(this.preferenceNode);
        const label = document.createElement('li');
        label.classList.add('settings-section-title', hierarchyClassName);
        label.textContent = name;
        wrapper.appendChild(label);
        return wrapper;
    }
}
exports.PreferenceHeaderRenderer = PreferenceHeaderRenderer;
let PreferenceLeafNodeRenderer = class PreferenceLeafNodeRenderer extends PreferenceNodeRenderer {
    constructor() {
        super(...arguments);
        this.isModifiedFromDefault = false;
        this.setPreferenceWithDebounce = debounce(this.setPreferenceImmediately.bind(this), 500, { leading: false, trailing: true });
    }
    get schema() {
        return this.preferenceNode.preference.data;
    }
    init() {
        this.setId();
        this.updateInspection();
        this.domNode = this.createDomNode();
        this.updateModificationStatus();
    }
    updateInspection() {
        this.inspection = this.preferenceService.inspect(this.id, this.scopeTracker.currentScope.uri);
    }
    openLink(event) {
        if (event.target instanceof HTMLAnchorElement) {
            event.preventDefault();
            event.stopPropagation();
            // Exclude right click
            if (event.button < 2) {
                const uri = new uri_1.default(event.target.href);
                (0, browser_1.open)(this.openerService, uri);
            }
        }
    }
    createDomNode() {
        const wrapper = document.createElement('li');
        wrapper.classList.add('single-pref');
        wrapper.id = `${this.id}-editor`;
        wrapper.tabIndex = 0;
        wrapper.setAttribute('data-pref-id', this.id);
        wrapper.setAttribute('data-node-id', this.preferenceNode.id);
        const headlineWrapper = document.createElement('div');
        headlineWrapper.classList.add('pref-name');
        headlineWrapper.title = this.id;
        this.headlineWrapper = headlineWrapper;
        wrapper.appendChild(headlineWrapper);
        this.updateHeadline();
        const gutter = document.createElement('div');
        gutter.classList.add('pref-context-gutter');
        this.gutter = gutter;
        wrapper.appendChild(gutter);
        const cog = document.createElement('i');
        cog.className = `${(0, browser_1.codicon)('settings-gear', true)} settings-context-menu-btn`;
        cog.setAttribute('aria-label', 'Open Context Menu');
        cog.setAttribute('role', 'button');
        cog.onclick = this.handleCogAction.bind(this);
        cog.onkeydown = this.handleCogAction.bind(this);
        cog.title = common_1.nls.localizeByDefault('More Actions...');
        gutter.appendChild(cog);
        const contentWrapper = document.createElement('div');
        contentWrapper.classList.add('pref-content-container', ...this.getAdditionalNodeClassnames());
        wrapper.appendChild(contentWrapper);
        const { description, markdownDescription } = this.preferenceNode.preference.data;
        if (markdownDescription || description) {
            const descriptionWrapper = document.createElement('div');
            descriptionWrapper.classList.add('pref-description');
            if (markdownDescription) {
                const renderedDescription = this.markdownRenderer.render(markdownDescription);
                descriptionWrapper.onauxclick = this.openLink.bind(this);
                descriptionWrapper.onclick = this.openLink.bind(this);
                descriptionWrapper.oncontextmenu = () => false;
                descriptionWrapper.innerHTML = DOMPurify.sanitize(renderedDescription, {
                    ALLOW_UNKNOWN_PROTOCOLS: true
                });
            }
            else if (description) {
                descriptionWrapper.textContent = description;
            }
            contentWrapper.appendChild(descriptionWrapper);
        }
        const interactableWrapper = document.createElement('div');
        interactableWrapper.classList.add('pref-input');
        contentWrapper.appendChild(interactableWrapper);
        this.createInteractable(interactableWrapper);
        return wrapper;
    }
    handleCogAction({ currentTarget }) {
        var _a, _b;
        const value = (_a = preference_types_1.Preference.getValueInScope(this.inspection, this.scopeTracker.currentScope.scope)) !== null && _a !== void 0 ? _a : (_b = this.inspection) === null || _b === void 0 ? void 0 : _b.defaultValue;
        const target = currentTarget;
        if (target && value !== undefined) {
            this.showCog();
            const domRect = target.getBoundingClientRect();
            this.menuRenderer.render({
                menuPath: preference_types_1.PreferenceMenus.PREFERENCE_EDITOR_CONTEXT_MENU,
                anchor: { x: domRect.left, y: domRect.bottom },
                args: [{ id: this.id, value }],
                context: target,
                onHide: () => this.hideCog()
            });
        }
    }
    addModifiedMarking() {
        this.gutter.classList.add('theia-mod-item-modified');
    }
    removeModifiedMarking() {
        this.gutter.classList.remove('theia-mod-item-modified');
    }
    showCog() {
        this.gutter.classList.add('show-cog');
    }
    hideCog() {
        this.gutter.classList.remove('show-cog');
    }
    updateModificationStatus(knownCurrentValue) {
        const wasModified = this.isModifiedFromDefault;
        const { inspection } = this;
        const valueInCurrentScope = knownCurrentValue !== null && knownCurrentValue !== void 0 ? knownCurrentValue : preference_types_1.Preference.getValueInScope(inspection, this.scopeTracker.currentScope.scope);
        this.isModifiedFromDefault = valueInCurrentScope !== undefined && !browser_1.PreferenceProvider.deepEqual(valueInCurrentScope, inspection === null || inspection === void 0 ? void 0 : inspection.defaultValue);
        if (wasModified !== this.isModifiedFromDefault) {
            this.gutter.classList.toggle('theia-mod-item-modified', this.isModifiedFromDefault);
        }
    }
    updateHeadline(filtered = this.model.isFiltered) {
        const { headlineWrapper } = this;
        if (this.headlineWrapper.childElementCount === 0) {
            const name = this.labelProvider.getName(this.preferenceNode);
            const nameWrapper = document.createElement('span');
            nameWrapper.classList.add('preference-leaf-headline-name');
            nameWrapper.textContent = name;
            headlineWrapper.appendChild(nameWrapper);
        }
        const prefix = this.labelProvider.getPrefix(this.preferenceNode, filtered);
        const currentFirstChild = headlineWrapper.children[0];
        const currentFirstChildIsPrefix = currentFirstChild.classList.contains('preference-leaf-headline-prefix');
        if (prefix) {
            let prefixWrapper;
            if (currentFirstChildIsPrefix) {
                prefixWrapper = currentFirstChild;
            }
            else {
                prefixWrapper = document.createElement('span');
                prefixWrapper.classList.add('preference-leaf-headline-prefix');
                headlineWrapper.insertBefore(prefixWrapper, currentFirstChild);
            }
            prefixWrapper.textContent = prefix;
        }
        else if (currentFirstChildIsPrefix) {
            headlineWrapper.removeChild(currentFirstChild);
        }
        const currentLastChild = headlineWrapper.lastChild;
        if (currentLastChild.classList.contains('preference-leaf-headline-suffix')) {
            this.compareOtherModifiedScopes(headlineWrapper, currentLastChild);
        }
        else {
            this.createOtherModifiedScopes(headlineWrapper);
        }
    }
    compareOtherModifiedScopes(headlineWrapper, currentSuffix) {
        const modifiedScopes = this.getModifiedScopesAsStrings();
        if (modifiedScopes.length === 0) {
            headlineWrapper.removeChild(currentSuffix);
        }
        else {
            const modifiedMessagePrefix = currentSuffix.children[0];
            const newMessagePrefix = this.getModifiedMessagePrefix();
            if (modifiedMessagePrefix.textContent !== newMessagePrefix) {
                modifiedMessagePrefix.textContent = newMessagePrefix;
            }
            const [firstModifiedScope, secondModifiedScope] = modifiedScopes;
            const firstScopeMessage = currentSuffix.children[1];
            const secondScopeMessage = currentSuffix.children[2];
            firstScopeMessage.children[0].textContent = browser_1.PreferenceScope[firstModifiedScope];
            this.addEventHandlerToModifiedScope(firstModifiedScope, firstScopeMessage.children[0]);
            if (modifiedScopes.length === 1 && secondScopeMessage) {
                currentSuffix.removeChild(secondScopeMessage);
            }
            else if (modifiedScopes.length === 2 && !secondScopeMessage) {
                const newSecondMessage = this.createModifiedScopeMessage(secondModifiedScope);
                currentSuffix.appendChild(newSecondMessage);
            }
            // If both scopes are modified and both messages are present, do nothing.
        }
    }
    createOtherModifiedScopes(headlineWrapper) {
        const modifiedScopes = this.getModifiedScopesAsStrings();
        if (modifiedScopes.length !== 0) {
            const wrapper = document.createElement('i');
            wrapper.classList.add('preference-leaf-headline-suffix');
            headlineWrapper.appendChild(wrapper);
            const messagePrefix = this.getModifiedMessagePrefix();
            const messageWrapper = document.createElement('span');
            messageWrapper.classList.add('preference-other-modified-scope-alert');
            messageWrapper.textContent = messagePrefix;
            wrapper.appendChild(messageWrapper);
            modifiedScopes.forEach((scopeName, i) => {
                const scopeWrapper = this.createModifiedScopeMessage(scopeName);
                wrapper.appendChild(scopeWrapper);
            });
        }
    }
    createModifiedScopeMessage(scope) {
        const scopeWrapper = document.createElement('span');
        scopeWrapper.classList.add('preference-modified-scope-wrapper');
        const scopeInteractable = document.createElement('span');
        scopeInteractable.classList.add('preference-scope-underlined');
        const scopeName = browser_1.PreferenceScope[scope];
        this.addEventHandlerToModifiedScope(scope, scopeInteractable);
        scopeInteractable.textContent = scopeName;
        scopeWrapper.appendChild(scopeInteractable);
        return scopeWrapper;
    }
    getModifiedMessagePrefix() {
        return (this.isModifiedFromDefault ? common_1.nls.localizeByDefault('Also modified in') : common_1.nls.localizeByDefault('Modified in')) + ': ';
    }
    addEventHandlerToModifiedScope(scope, scopeWrapper) {
        if (scope === browser_1.PreferenceScope.User || scope === browser_1.PreferenceScope.Workspace) {
            const eventHandler = () => {
                this.scopeTracker.setScope(scope);
                this.searchbar.updateSearchTerm(this.id);
            };
            scopeWrapper.onclick = eventHandler;
            scopeWrapper.onkeydown = eventHandler;
            scopeWrapper.tabIndex = 0;
        }
        else {
            scopeWrapper.onclick = null; // eslint-disable-line no-null/no-null
            scopeWrapper.onkeydown = null; // eslint-disable-line no-null/no-null
            scopeWrapper.tabIndex = -1;
        }
    }
    getModifiedScopesAsStrings() {
        const currentScopeInView = this.scopeTracker.currentScope.scope;
        const { inspection } = this;
        const modifiedScopes = [];
        if (inspection) {
            for (const otherScope of [browser_1.PreferenceScope.User, browser_1.PreferenceScope.Workspace]) {
                if (otherScope !== currentScopeInView) {
                    const valueInOtherScope = preference_types_1.Preference.getValueInScope(inspection, otherScope);
                    if (valueInOtherScope !== undefined && !browser_1.PreferenceProvider.deepEqual(valueInOtherScope, inspection.defaultValue)) {
                        modifiedScopes.push(otherScope);
                    }
                }
            }
        }
        return modifiedScopes;
    }
    // Many preferences allow `null` and even use it as a default regardless of the declared type.
    getValue() {
        var _a;
        let currentValue = preference_types_1.Preference.getValueInScope(this.inspection, this.scopeTracker.currentScope.scope);
        if (currentValue === undefined) {
            currentValue = (_a = this.inspection) === null || _a === void 0 ? void 0 : _a.defaultValue;
        }
        return currentValue !== undefined ? currentValue : this.getFallbackValue();
    }
    setPreferenceImmediately(value) {
        return this.preferenceService.set(this.id, value, this.scopeTracker.currentScope.scope, this.scopeTracker.currentScope.uri)
            .catch(() => this.handleValueChange());
    }
    handleSearchChange(isFiltered = this.model.isFiltered) {
        this.updateHeadline(isFiltered);
    }
    handleScopeChange(isFiltered = this.model.isFiltered) {
        this.handleValueChange();
        this.updateHeadline(isFiltered);
    }
    handleValueChange() {
        this.doHandleValueChange();
        this.updateHeadline();
    }
};
exports.PreferenceLeafNodeRenderer = PreferenceLeafNodeRenderer;
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_types_1.Preference.Node),
    tslib_1.__metadata("design:type", Object)
], PreferenceLeafNodeRenderer.prototype, "preferenceNode", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], PreferenceLeafNodeRenderer.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], PreferenceLeafNodeRenderer.prototype, "menuRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_scope_tabbar_widget_1.PreferencesScopeTabBar),
    tslib_1.__metadata("design:type", preference_scope_tabbar_widget_1.PreferencesScopeTabBar)
], PreferenceLeafNodeRenderer.prototype, "scopeTracker", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_model_1.PreferenceTreeModel),
    tslib_1.__metadata("design:type", preference_tree_model_1.PreferenceTreeModel)
], PreferenceLeafNodeRenderer.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_searchbar_widget_1.PreferencesSearchbarWidget),
    tslib_1.__metadata("design:type", preference_searchbar_widget_1.PreferencesSearchbarWidget)
], PreferenceLeafNodeRenderer.prototype, "searchbar", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], PreferenceLeafNodeRenderer.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_markdown_renderer_1.PreferenceMarkdownRenderer),
    tslib_1.__metadata("design:type", preference_markdown_renderer_1.PreferenceMarkdownRenderer)
], PreferenceLeafNodeRenderer.prototype, "markdownRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferenceLeafNodeRenderer.prototype, "init", null);
exports.PreferenceLeafNodeRenderer = PreferenceLeafNodeRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceLeafNodeRenderer);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-null-input.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-null-input.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceNullRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceNullRendererContribution = exports.PreferenceNullInputRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
let PreferenceNullInputRenderer = class PreferenceNullInputRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    createInteractable(container) {
        const span = document.createElement('span');
        this.interactable = span;
        container.appendChild(span);
    }
    getFallbackValue() {
        // eslint-disable-next-line no-null/no-null
        return null;
    }
    doHandleValueChange() { }
};
exports.PreferenceNullInputRenderer = PreferenceNullInputRenderer;
exports.PreferenceNullInputRenderer = PreferenceNullInputRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
    /** For rendering preference items for which the only interesting feature is the description */
], PreferenceNullInputRenderer);
let PreferenceNullRendererContribution = PreferenceNullRendererContribution_1 = class PreferenceNullRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceNullRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        const isOnlyNull = node.preference.data.type === 'null' || Array.isArray(node.preference.data.type) && node.preference.data.type.every(candidate => candidate === 'null');
        return isOnlyNull ? 5 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceNullInputRenderer);
    }
};
exports.PreferenceNullRendererContribution = PreferenceNullRendererContribution;
PreferenceNullRendererContribution.ID = 'preference-null-renderer';
exports.PreferenceNullRendererContribution = PreferenceNullRendererContribution = PreferenceNullRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceNullRendererContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-number-input.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-number-input.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceNumberInputRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceNumberInputRendererContribution = exports.PreferenceNumberInputRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preference_types_1 = __webpack_require__(/*! ../../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
let PreferenceNumberInputRenderer = class PreferenceNumberInputRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    get errorMessage() {
        if (!this._errorMessage) {
            const errorMessage = document.createElement('div');
            errorMessage.classList.add('pref-error-notification');
            this._errorMessage = errorMessage;
        }
        return this._errorMessage;
    }
    createInteractable(parent) {
        var _a, _b;
        const interactableWrapper = document.createElement('div');
        this.interactableWrapper = interactableWrapper;
        interactableWrapper.classList.add('pref-input-container');
        const interactable = document.createElement('input');
        this.interactable = interactable;
        interactable.type = 'number';
        interactable.step = this.preferenceNode.preference.data.type === 'integer' ? '1' : 'any';
        interactable.classList.add('theia-input');
        interactable.defaultValue = (_b = (_a = this.getValue()) === null || _a === void 0 ? void 0 : _a.toString()) !== null && _b !== void 0 ? _b : '';
        interactable.oninput = this.handleUserInteraction.bind(this);
        interactable.onblur = this.handleBlur.bind(this);
        interactableWrapper.appendChild(interactable);
        parent.appendChild(interactableWrapper);
    }
    getFallbackValue() {
        return 0;
    }
    handleUserInteraction() {
        const { value, message } = this.getInputValidation(this.interactable.value);
        if (isNaN(value)) {
            this.showErrorMessage(message);
        }
        else {
            this.hideErrorMessage();
            this.setPreferenceWithDebounce(value);
        }
    }
    async handleBlur() {
        this.hideErrorMessage();
        await this.setPreferenceWithDebounce.flush();
        this.handleValueChange();
    }
    doHandleValueChange() {
        var _a;
        const { value } = this.interactable;
        const currentValue = value.length ? Number(value) : NaN;
        this.updateInspection();
        const newValue = (_a = this.getValue()) !== null && _a !== void 0 ? _a : '';
        this.updateModificationStatus(newValue);
        if (newValue !== currentValue) {
            if (document.activeElement !== this.interactable) {
                this.interactable.value = newValue.toString();
            }
            else {
                this.handleUserInteraction(); // give priority to the value of the input if it is focused.
            }
        }
    }
    getInputValidation(input) {
        const { preference: { data } } = this.preferenceNode;
        const inputValue = Number(input);
        const errorMessages = [];
        if (input === '' || isNaN(inputValue)) {
            return { value: NaN, message: core_1.nls.localizeByDefault('Value must be a number.') };
        }
        if (data.type === 'integer' && !Number.isInteger(inputValue)) {
            errorMessages.push(core_1.nls.localizeByDefault('Value must be an integer.'));
        }
        if (data.minimum !== undefined && isFinite(data.minimum)) {
            // https://json-schema.org/understanding-json-schema/reference/numeric
            // "In JSON Schema Draft 4, exclusiveMinimum and exclusiveMaximum work differently.
            // There they are boolean values, that indicate whether minimum and maximum are exclusive of the value"
            if ((0, core_1.isBoolean)(data.exclusiveMinimum) && data.exclusiveMinimum) {
                if (inputValue <= data.minimum) {
                    errorMessages.push(core_1.nls.localizeByDefault('Value must be strictly greater than {0}.', data.minimum));
                }
            }
            else {
                if (inputValue < data.minimum) {
                    errorMessages.push(core_1.nls.localizeByDefault('Value must be greater than or equal to {0}.', data.minimum));
                }
            }
        }
        if (data.maximum !== undefined && isFinite(data.maximum)) {
            // https://json-schema.org/understanding-json-schema/reference/numeric
            // "In JSON Schema Draft 4, exclusiveMinimum and exclusiveMaximum work differently.
            // There they are boolean values, that indicate whether minimum and maximum are exclusive of the value"
            if ((0, core_1.isBoolean)(data.exclusiveMaximum) && data.exclusiveMaximum) {
                if (inputValue >= data.maximum) {
                    errorMessages.push(core_1.nls.localizeByDefault('Value must be strictly less than {0}.', data.maximum));
                }
            }
            else {
                if (inputValue > data.maximum) {
                    errorMessages.push(core_1.nls.localizeByDefault('Value must be less than or equal to {0}.', data.maximum));
                }
            }
        }
        // Using JSON Schema before Draft 4 both exclusive and non-exclusive variants can be set
        if ((0, core_1.isNumber)(data.exclusiveMinimum) && isFinite(data.exclusiveMinimum)) {
            if (inputValue <= data.exclusiveMinimum) {
                errorMessages.push(core_1.nls.localizeByDefault('Value must be strictly greater than {0}.', data.exclusiveMinimum));
            }
        }
        if ((0, core_1.isNumber)(data.exclusiveMaximum) && isFinite(data.exclusiveMaximum)) {
            if (inputValue >= data.exclusiveMaximum) {
                errorMessages.push(core_1.nls.localizeByDefault('Value must be strictly less than {0}.', data.exclusiveMaximum));
            }
        }
        if ((0, core_1.isNumber)(data.multipleOf) && data.multipleOf !== 0 && !Number.isInteger(inputValue / data.multipleOf)) {
            errorMessages.push(core_1.nls.localizeByDefault('Value must be a multiple of {0}.', data.multipleOf));
        }
        return {
            value: errorMessages.length ? NaN : inputValue,
            message: errorMessages.join(' ')
        };
    }
    showErrorMessage(message) {
        this.errorMessage.textContent = message;
        this.interactableWrapper.appendChild(this.errorMessage);
    }
    hideErrorMessage() {
        this.errorMessage.remove();
    }
};
exports.PreferenceNumberInputRenderer = PreferenceNumberInputRenderer;
exports.PreferenceNumberInputRenderer = PreferenceNumberInputRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceNumberInputRenderer);
let PreferenceNumberInputRendererContribution = PreferenceNumberInputRendererContribution_1 = class PreferenceNumberInputRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceNumberInputRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        const type = preference_types_1.Preference.LeafNode.getType(node);
        return type === 'integer' || type === 'number' ? 2 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceNumberInputRenderer);
    }
};
exports.PreferenceNumberInputRendererContribution = PreferenceNumberInputRendererContribution;
PreferenceNumberInputRendererContribution.ID = 'preference-number-input-renderer';
exports.PreferenceNumberInputRendererContribution = PreferenceNumberInputRendererContribution = PreferenceNumberInputRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceNumberInputRendererContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-select-input.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-select-input.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceSelectInputRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceSelectInputRendererContribution = exports.PreferenceSelectInputRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const preference_node_renderer_1 = __webpack_require__(/*! ./preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preference_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/preference-provider */ "../../node_modules/@theia/core/lib/browser/preferences/preference-provider.js");
const select_component_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/select-component */ "../../node_modules/@theia/core/lib/browser/widgets/select-component.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const client_1 = __webpack_require__(/*! @theia/core/shared/react-dom/client */ "../../node_modules/@theia/core/shared/react-dom/client/index.js");
const strings_1 = __webpack_require__(/*! @theia/core/lib/common/strings */ "../../node_modules/@theia/core/lib/common/strings.js");
let PreferenceSelectInputRenderer = class PreferenceSelectInputRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    constructor() {
        super(...arguments);
        this.selectComponent = React.createRef();
        this.selectOptions = [];
    }
    get enumValues() {
        return this.preferenceNode.preference.data.enum;
    }
    updateSelectOptions() {
        var _a, _b, _c, _d;
        const updatedSelectOptions = [];
        const values = this.enumValues;
        const preferenceData = this.preferenceNode.preference.data;
        const defaultValue = preferenceData.default;
        for (let i = 0; i < values.length; i++) {
            const value = values[i];
            const stringValue = `${value}`;
            const label = (0, strings_1.escapeInvisibleChars)((_b = (_a = preferenceData.enumItemLabels) === null || _a === void 0 ? void 0 : _a[i]) !== null && _b !== void 0 ? _b : stringValue);
            const detail = preference_provider_1.PreferenceProvider.deepEqual(defaultValue, value) ? 'default' : undefined;
            let enumDescription = (_c = preferenceData.enumDescriptions) === null || _c === void 0 ? void 0 : _c[i];
            let markdown = false;
            const markdownEnumDescription = (_d = preferenceData.markdownEnumDescriptions) === null || _d === void 0 ? void 0 : _d[i];
            if (markdownEnumDescription) {
                enumDescription = this.markdownRenderer.renderInline(markdownEnumDescription);
                markdown = true;
            }
            updatedSelectOptions.push({
                label,
                value: stringValue,
                detail,
                description: enumDescription,
                markdown
            });
        }
        this.selectOptions = updatedSelectOptions;
    }
    createInteractable(parent) {
        this.updateSelectOptions();
        const interactable = document.createElement('div');
        const selectComponent = React.createElement(select_component_1.SelectComponent, {
            options: this.selectOptions,
            defaultValue: this.getDataValue(),
            onChange: (_, index) => this.handleUserInteraction(index),
            ref: this.selectComponent
        });
        this.interactable = interactable;
        const root = (0, client_1.createRoot)(interactable);
        root.render(selectComponent);
        parent.appendChild(interactable);
    }
    getFallbackValue() {
        const { default: schemaDefault, defaultValue, enum: enumValues } = this.preferenceNode.preference.data;
        return schemaDefault !== undefined
            ? schemaDefault : defaultValue !== undefined
            ? defaultValue
            : enumValues[0];
    }
    doHandleValueChange() {
        this.updateInspection();
        this.updateSelectOptions();
        const newValue = this.getDataValue();
        this.updateModificationStatus(this.getValue());
        if (document.activeElement !== this.interactable && this.selectComponent.current) {
            this.selectComponent.current.value = newValue;
        }
    }
    /**
     * Returns the stringified index corresponding to the currently selected value.
     */
    getDataValue() {
        const currentValue = this.getValue();
        let selected = this.enumValues.findIndex(value => preference_provider_1.PreferenceProvider.deepEqual(value, currentValue));
        if (selected === -1) {
            const fallback = this.getFallbackValue();
            selected = this.enumValues.findIndex(value => preference_provider_1.PreferenceProvider.deepEqual(value, fallback));
        }
        return Math.max(selected, 0);
    }
    handleUserInteraction(selected) {
        const value = this.enumValues[selected];
        this.setPreferenceImmediately(value);
    }
};
exports.PreferenceSelectInputRenderer = PreferenceSelectInputRenderer;
exports.PreferenceSelectInputRenderer = PreferenceSelectInputRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceSelectInputRenderer);
let PreferenceSelectInputRendererContribution = PreferenceSelectInputRendererContribution_1 = class PreferenceSelectInputRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceSelectInputRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        return node.preference.data.enum ? 3 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceSelectInputRenderer);
    }
};
exports.PreferenceSelectInputRendererContribution = PreferenceSelectInputRendererContribution;
PreferenceSelectInputRendererContribution.ID = 'preference-select-input-renderer';
exports.PreferenceSelectInputRendererContribution = PreferenceSelectInputRendererContribution = PreferenceSelectInputRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceSelectInputRendererContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-string-input.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/components/preference-string-input.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferenceStringInputRendererContribution_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferenceStringInputRendererContribution = exports.PreferenceStringInputRenderer = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const preference_types_1 = __webpack_require__(/*! ../../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
let PreferenceStringInputRenderer = class PreferenceStringInputRenderer extends preference_node_renderer_1.PreferenceLeafNodeRenderer {
    createInteractable(parent) {
        var _a;
        const interactable = document.createElement('input');
        this.interactable = interactable;
        interactable.type = 'text';
        interactable.spellcheck = false;
        interactable.classList.add('theia-input');
        interactable.defaultValue = (_a = this.getValue()) !== null && _a !== void 0 ? _a : '';
        interactable.oninput = this.handleUserInteraction.bind(this);
        interactable.onblur = this.handleBlur.bind(this);
        parent.appendChild(interactable);
    }
    getFallbackValue() {
        return '';
    }
    doHandleValueChange() {
        var _a;
        const currentValue = this.interactable.value;
        this.updateInspection();
        const newValue = (_a = this.getValue()) !== null && _a !== void 0 ? _a : '';
        this.updateModificationStatus(newValue);
        if (newValue !== currentValue) {
            if (document.activeElement !== this.interactable) {
                this.interactable.value = newValue;
            }
            else {
                this.handleUserInteraction(); // give priority to the value of the input if it is focused.
            }
        }
    }
    handleUserInteraction() {
        this.setPreferenceWithDebounce(this.interactable.value);
    }
    async handleBlur() {
        await this.setPreferenceWithDebounce.flush();
        this.handleValueChange();
    }
};
exports.PreferenceStringInputRenderer = PreferenceStringInputRenderer;
exports.PreferenceStringInputRenderer = PreferenceStringInputRenderer = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceStringInputRenderer);
let PreferenceStringInputRendererContribution = PreferenceStringInputRendererContribution_1 = class PreferenceStringInputRendererContribution extends preference_node_renderer_creator_1.PreferenceLeafNodeRendererContribution {
    constructor() {
        super(...arguments);
        this.id = PreferenceStringInputRendererContribution_1.ID;
    }
    canHandleLeafNode(node) {
        return preference_types_1.Preference.LeafNode.getType(node) === 'string' ? 2 : 0;
    }
    createLeafNodeRenderer(container) {
        return container.get(PreferenceStringInputRenderer);
    }
};
exports.PreferenceStringInputRendererContribution = PreferenceStringInputRendererContribution;
PreferenceStringInputRendererContribution.ID = 'preference-string-input-renderer';
exports.PreferenceStringInputRendererContribution = PreferenceStringInputRendererContribution = PreferenceStringInputRendererContribution_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferenceStringInputRendererContribution);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/preference-editor-widget.js":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/preference-editor-widget.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferencesEditorWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesEditorWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
/* eslint-disable @typescript-eslint/no-explicit-any */
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const throttle = __webpack_require__(/*! @theia/core/shared/lodash.throttle */ "../../node_modules/@theia/core/shared/lodash.throttle/index.js");
const deepEqual = __webpack_require__(/*! fast-deep-equal */ "../../node_modules/fast-deep-equal/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const widget_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/widget */ "../../node_modules/@theia/core/lib/browser/widgets/widget.js");
const preference_tree_model_1 = __webpack_require__(/*! ../preference-tree-model */ "../../node_modules/@theia/preferences/lib/browser/preference-tree-model.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./components/preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const preference_types_1 = __webpack_require__(/*! ../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ./preference-scope-tabbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./components/preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
const preference_layout_1 = __webpack_require__(/*! ../util/preference-layout */ "../../node_modules/@theia/preferences/lib/browser/util/preference-layout.js");
let PreferencesEditorWidget = PreferencesEditorWidget_1 = class PreferencesEditorWidget extends widget_1.BaseWidget {
    constructor() {
        super(...arguments);
        this.scrollOptions = widget_1.DEFAULT_SCROLL_OPTIONS;
        /**
         * Guards against scroll events and selection events looping into each other. Set before this widget initiates a selection.
         */
        this.currentModelSelectionId = '';
        /**
         * Permits the user to expand multiple nodes without each one being collapsed on a new selection.
         */
        this.lastUserSelection = '';
        this.isAtScrollTop = true;
        this.firstVisibleChildID = '';
        this.renderers = new Map();
        this.preferenceDataKeys = new Map();
        // The commonly used section will duplicate preference ID's, so we'll keep a separate list of them.
        this.commonlyUsedRenderers = new Map();
        this.onScroll = throttle(this.doOnScroll.bind(this), 50);
        this.shouldUpdateModelSelection = true;
    }
    init() {
        this.doInit();
    }
    async doInit() {
        this.id = PreferencesEditorWidget_1.ID;
        this.title.label = PreferencesEditorWidget_1.LABEL;
        this.addClass('settings-main');
        this.toDispose.pushAll([
            this.preferenceService.onPreferencesChanged(e => this.handlePreferenceChanges(e)),
            this.model.onFilterChanged(e => this.handleDisplayChange(e)),
            this.model.onSelectionChanged(e => this.handleSelectionChange(e)),
        ]);
        this.createContainers();
        await this.preferenceService.ready;
        this.handleDisplayChange({ source: preference_tree_model_1.PreferenceFilterChangeSource.Schema });
        this.rendererRegistry.onDidChange(() => this.handleRegistryChange());
    }
    createContainers() {
        const innerWrapper = document.createElement('div');
        innerWrapper.classList.add('settings-main-scroll-container');
        this.scrollContainer = innerWrapper;
        innerWrapper.addEventListener('scroll', this.onScroll, { passive: true });
        this.node.appendChild(innerWrapper);
        const noLeavesMessage = document.createElement('div');
        noLeavesMessage.classList.add('settings-no-results-announcement');
        noLeavesMessage.textContent = 'That search query has returned no results.';
        this.node.appendChild(noLeavesMessage);
    }
    handleDisplayChange(e) {
        const { isFiltered } = this.model;
        const currentFirstVisible = this.firstVisibleChildID;
        const leavesAreVisible = this.areLeavesVisible();
        if (e.source === preference_tree_model_1.PreferenceFilterChangeSource.Search) {
            this.handleSearchChange(isFiltered, leavesAreVisible);
        }
        else if (e.source === preference_tree_model_1.PreferenceFilterChangeSource.Scope) {
            this.handleScopeChange(isFiltered);
        }
        else if (e.source === preference_tree_model_1.PreferenceFilterChangeSource.Schema) {
            this.handleSchemaChange(isFiltered);
        }
        else {
            (0, common_1.unreachable)(e.source, 'Not all PreferenceFilterChangeSource enum variants handled.');
        }
        this.resetScroll(currentFirstVisible, e.source === preference_tree_model_1.PreferenceFilterChangeSource.Search && !isFiltered);
    }
    handleRegistryChange() {
        for (const [id, renderer, collection] of this.allRenderers()) {
            renderer.dispose();
            collection.delete(id);
        }
        this.handleDisplayChange({ source: preference_tree_model_1.PreferenceFilterChangeSource.Schema });
    }
    handleSchemaChange(isFiltered) {
        var _a;
        for (const [id, renderer, collection] of this.allRenderers()) {
            const node = this.model.getNode(renderer.nodeId);
            if (!node || (preference_types_1.Preference.LeafNode.is(node) && this.hasSchemaChanged(renderer, node))) {
                renderer.dispose();
                collection.delete(id);
            }
        }
        if (this.model.root) {
            const nodeIterator = Array.from(this.scrollContainer.children)[Symbol.iterator]();
            let nextNode = nodeIterator.next().value;
            for (const node of new browser_1.TopDownTreeIterator(this.model.root)) {
                if (preference_types_1.Preference.TreeNode.is(node)) {
                    const { collection, id } = this.analyzeIDAndGetRendererGroup(node.id);
                    const renderer = (_a = collection.get(id)) !== null && _a !== void 0 ? _a : this.rendererFactory(node);
                    if (!renderer.node.parentElement) { // If it hasn't been attached yet, it hasn't been checked for the current search.
                        this.hideIfFailsFilters(renderer, isFiltered);
                        collection.set(id, renderer);
                    }
                    if (nextNode !== renderer.node) {
                        if (nextNode) {
                            renderer.insertBefore(nextNode);
                        }
                        else {
                            renderer.appendTo(this.scrollContainer);
                        }
                    }
                    else {
                        nextNode = nodeIterator.next().value;
                    }
                }
            }
        }
    }
    handleScopeChange(isFiltered = this.model.isFiltered) {
        var _a;
        for (const [, renderer] of this.allRenderers()) {
            const isHidden = this.hideIfFailsFilters(renderer, isFiltered);
            if (isFiltered || !isHidden) {
                (_a = renderer.handleScopeChange) === null || _a === void 0 ? void 0 : _a.call(renderer, isFiltered);
            }
        }
    }
    hasSchemaChanged(renderer, node) {
        return !deepEqual(renderer.schema, node.preference.data);
    }
    handleSearchChange(isFiltered, leavesAreVisible) {
        var _a;
        if (leavesAreVisible) {
            for (const [, renderer] of this.allRenderers()) {
                const isHidden = this.hideIfFailsFilters(renderer, isFiltered);
                if (!isHidden) {
                    (_a = renderer.handleSearchChange) === null || _a === void 0 ? void 0 : _a.call(renderer, isFiltered);
                }
            }
        }
    }
    areLeavesVisible() {
        const leavesAreVisible = this.model.totalVisibleLeaves > 0;
        this.node.classList.toggle('no-results', !leavesAreVisible);
        this.scrollContainer.classList.toggle('hidden', !leavesAreVisible);
        return leavesAreVisible;
    }
    *allRenderers() {
        for (const [id, renderer] of this.commonlyUsedRenderers.entries()) {
            yield [id, renderer, this.commonlyUsedRenderers];
        }
        for (const [id, renderer] of this.renderers.entries()) {
            yield [id, renderer, this.renderers];
        }
    }
    handlePreferenceChanges(e) {
        var _a, _b, _c, _d;
        for (const id of Object.keys(e)) {
            (_b = (_a = this.commonlyUsedRenderers.get(id)) === null || _a === void 0 ? void 0 : _a.handleValueChange) === null || _b === void 0 ? void 0 : _b.call(_a);
            (_d = (_c = this.renderers.get(id)) === null || _c === void 0 ? void 0 : _c.handleValueChange) === null || _d === void 0 ? void 0 : _d.call(_c);
        }
    }
    /**
     * @returns true if the renderer is hidden, false otherwise.
     */
    hideIfFailsFilters(renderer, isFiltered) {
        const row = this.model.currentRows.get(renderer.nodeId);
        if (!row || (browser_1.CompositeTreeNode.is(row.node) && (isFiltered || row.visibleChildren === 0))) {
            renderer.hide();
            return true;
        }
        else {
            renderer.show();
            return false;
        }
    }
    resetScroll(nodeIDToScrollTo, filterWasCleared = false) {
        if (this.scrollBar) { // Absent on widget creation
            this.doResetScroll(nodeIDToScrollTo, filterWasCleared);
        }
        else {
            const interval = setInterval(() => {
                if (this.scrollBar) {
                    clearInterval(interval);
                    this.doResetScroll(nodeIDToScrollTo, filterWasCleared);
                }
            }, 500);
        }
    }
    doResetScroll(nodeIDToScrollTo, filterWasCleared = false) {
        requestAnimationFrame(() => {
            var _a;
            (_a = this.scrollBar) === null || _a === void 0 ? void 0 : _a.update();
            if (!filterWasCleared && nodeIDToScrollTo) {
                const { id, collection } = this.analyzeIDAndGetRendererGroup(nodeIDToScrollTo);
                const renderer = collection.get(id);
                if (renderer === null || renderer === void 0 ? void 0 : renderer.visible) {
                    this.scrollContainer.scrollTo(0, renderer.node.offsetHeight);
                    return;
                }
            }
            this.scrollContainer.scrollTop = 0;
        });
    }
    ;
    doOnScroll() {
        const { scrollContainer } = this;
        const firstVisibleChildID = this.findFirstVisibleChildID();
        this.setFirstVisibleChildID(firstVisibleChildID);
        if (this.isAtScrollTop && scrollContainer.scrollTop !== 0) {
            this.isAtScrollTop = false;
            this.tabbar.toggleShadow(true);
        }
        else if (!this.isAtScrollTop && scrollContainer.scrollTop === 0) {
            this.isAtScrollTop = true;
            this.tabbar.toggleShadow(false);
        }
    }
    ;
    findFirstVisibleChildID() {
        const { scrollTop } = this.scrollContainer;
        for (const [, renderer] of this.allRenderers()) {
            const { offsetTop, offsetHeight } = renderer.node;
            if (Math.abs(offsetTop - scrollTop) <= offsetHeight / 2) {
                return renderer.nodeId;
            }
        }
    }
    setFirstVisibleChildID(id) {
        if (id && id !== this.firstVisibleChildID) {
            this.firstVisibleChildID = id;
            if (!this.shouldUpdateModelSelection) {
                return;
            }
            let currentNode = this.model.getNode(id);
            let expansionAncestor;
            let selectionAncestor;
            while (currentNode && (!expansionAncestor || !selectionAncestor)) {
                if (!selectionAncestor && browser_1.SelectableTreeNode.is(currentNode)) {
                    selectionAncestor = currentNode;
                }
                if (!expansionAncestor && browser_1.ExpandableTreeNode.is(currentNode)) {
                    expansionAncestor = currentNode;
                }
                currentNode = currentNode.parent;
            }
            if (selectionAncestor) {
                this.currentModelSelectionId = selectionAncestor.id;
                expansionAncestor = expansionAncestor !== null && expansionAncestor !== void 0 ? expansionAncestor : selectionAncestor;
                this.model.selectIfNotSelected(selectionAncestor);
                if (!this.model.isFiltered && id !== this.lastUserSelection) {
                    this.lastUserSelection = '';
                    this.model.collapseAllExcept(expansionAncestor);
                }
            }
        }
    }
    handleSelectionChange(selectionEvent) {
        const node = selectionEvent[0];
        if (node && node.id !== this.currentModelSelectionId) {
            this.currentModelSelectionId = node.id;
            this.lastUserSelection = node.id;
            if (this.model.isFiltered && browser_1.CompositeTreeNode.is(node)) {
                for (const candidate of new browser_1.TopDownTreeIterator(node, { pruneSiblings: true })) {
                    const { id, collection } = this.analyzeIDAndGetRendererGroup(candidate.id);
                    const renderer = collection.get(id);
                    if (renderer === null || renderer === void 0 ? void 0 : renderer.visible) {
                        // When filtered, treat the first visible child as the selected node, since it will be the one scrolled to.
                        this.lastUserSelection = renderer.nodeId;
                        this.scrollWithoutModelUpdate(renderer.node);
                        return;
                    }
                }
            }
            else {
                const { id, collection } = this.analyzeIDAndGetRendererGroup(node.id);
                const renderer = collection.get(id);
                this.scrollWithoutModelUpdate(renderer === null || renderer === void 0 ? void 0 : renderer.node);
            }
        }
    }
    /** Ensures that we don't set the model's selection while attempting to scroll in reaction to a model selection change. */
    scrollWithoutModelUpdate(node) {
        if (!node) {
            return;
        }
        this.shouldUpdateModelSelection = false;
        this.scrollContainer.scrollTo(0, node.offsetTop);
        requestAnimationFrame(() => this.shouldUpdateModelSelection = true);
    }
    analyzeIDAndGetRendererGroup(nodeID) {
        const { id, group } = preference_types_1.Preference.TreeNode.getGroupAndIdFromNodeId(nodeID);
        const collection = group === preference_layout_1.COMMONLY_USED_SECTION_PREFIX ? this.commonlyUsedRenderers : this.renderers;
        return { id, group, collection };
    }
    getScrollContainer() {
        return this.scrollContainer;
    }
    storeState() {
        return {
            firstVisibleChildID: this.firstVisibleChildID,
        };
    }
    restoreState(oldState) {
        this.firstVisibleChildID = oldState.firstVisibleChildID;
        this.resetScroll(this.firstVisibleChildID);
    }
};
exports.PreferencesEditorWidget = PreferencesEditorWidget;
PreferencesEditorWidget.ID = 'settings.editor';
PreferencesEditorWidget.LABEL = 'Settings Editor';
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], PreferencesEditorWidget.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_model_1.PreferenceTreeModel),
    tslib_1.__metadata("design:type", preference_tree_model_1.PreferenceTreeModel)
], PreferencesEditorWidget.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_node_renderer_1.PreferenceNodeRendererFactory),
    tslib_1.__metadata("design:type", Function)
], PreferencesEditorWidget.prototype, "rendererFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_node_renderer_creator_1.PreferenceNodeRendererCreatorRegistry),
    tslib_1.__metadata("design:type", Object)
], PreferencesEditorWidget.prototype, "rendererRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceSchemaProvider),
    tslib_1.__metadata("design:type", browser_1.PreferenceSchemaProvider)
], PreferencesEditorWidget.prototype, "schemaProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_scope_tabbar_widget_1.PreferencesScopeTabBar),
    tslib_1.__metadata("design:type", preference_scope_tabbar_widget_1.PreferencesScopeTabBar)
], PreferencesEditorWidget.prototype, "tabbar", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferencesEditorWidget.prototype, "init", null);
exports.PreferencesEditorWidget = PreferencesEditorWidget = PreferencesEditorWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferencesEditorWidget);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferencesScopeTabBar_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesScopeTabBar = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const widgets_1 = __webpack_require__(/*! @theia/core/shared/@lumino/widgets */ "../../node_modules/@theia/core/shared/@lumino/widgets/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const preference_scope_command_manager_1 = __webpack_require__(/*! ../util/preference-scope-command-manager */ "../../node_modules/@theia/preferences/lib/browser/util/preference-scope-command-manager.js");
const preference_types_1 = __webpack_require__(/*! ../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const USER_TAB_LABEL = nls_1.nls.localizeByDefault('User');
const USER_TAB_INDEX = browser_1.PreferenceScope['User'];
const WORKSPACE_TAB_LABEL = nls_1.nls.localizeByDefault('Workspace');
const WORKSPACE_TAB_INDEX = browser_1.PreferenceScope['Workspace'];
const FOLDER_TAB_LABEL = nls_1.nls.localizeByDefault('Folder');
const FOLDER_TAB_INDEX = browser_1.PreferenceScope['Folder'];
const PREFERENCE_TAB_CLASSNAME = 'preferences-scope-tab';
const GENERAL_FOLDER_TAB_CLASSNAME = 'preference-folder';
const LABELED_FOLDER_TAB_CLASSNAME = 'preferences-folder-tab';
const FOLDER_DROPDOWN_CLASSNAME = 'preferences-folder-dropdown';
const FOLDER_DROPDOWN_ICON_CLASSNAME = 'preferences-folder-dropdown-icon ' + (0, browser_1.codicon)('chevron-down');
const TABBAR_UNDERLINE_CLASSNAME = 'tabbar-underline';
const SINGLE_FOLDER_TAB_CLASSNAME = `${PREFERENCE_TAB_CLASSNAME} ${GENERAL_FOLDER_TAB_CLASSNAME} ${LABELED_FOLDER_TAB_CLASSNAME}`;
const UNSELECTED_FOLDER_DROPDOWN_CLASSNAME = `${PREFERENCE_TAB_CLASSNAME} ${GENERAL_FOLDER_TAB_CLASSNAME} ${FOLDER_DROPDOWN_CLASSNAME}`;
const SELECTED_FOLDER_DROPDOWN_CLASSNAME = `${PREFERENCE_TAB_CLASSNAME} ${GENERAL_FOLDER_TAB_CLASSNAME} ${LABELED_FOLDER_TAB_CLASSNAME} ${FOLDER_DROPDOWN_CLASSNAME}`;
const SHADOW_CLASSNAME = 'with-shadow';
let PreferencesScopeTabBar = PreferencesScopeTabBar_1 = class PreferencesScopeTabBar extends widgets_1.TabBar {
    constructor() {
        super(...arguments);
        this.onScopeChangedEmitter = new common_1.Emitter();
        this.onScopeChanged = this.onScopeChangedEmitter.event;
        this.toDispose = new common_1.DisposableCollection();
        this.currentWorkspaceRoots = [];
        this.currentSelection = preference_types_1.Preference.DEFAULT_SCOPE;
        this.editorScrollAtTop = true;
        this.folderSelectionCallback = (newScope) => { this.setNewScopeSelection(newScope); };
    }
    get currentScope() {
        return this.currentSelection;
    }
    setNewScopeSelection(newSelection) {
        const stringifiedSelectionScope = newSelection.scope.toString();
        const newIndex = this.titles.findIndex(title => title.dataset.scope === stringifiedSelectionScope);
        if (newIndex !== -1) {
            this.currentSelection = newSelection;
            this.currentIndex = newIndex;
            if (newSelection.scope === browser_1.PreferenceScope.Folder) {
                this.addOrUpdateFolderTab();
            }
            this.emitNewScope();
        }
    }
    init() {
        this.id = PreferencesScopeTabBar_1.ID;
        this.setupInitialDisplay();
        this.tabActivateRequested.connect((sender, args) => {
            const scopeDetails = this.toScopeDetails(args.title);
            if (scopeDetails) {
                this.setNewScopeSelection(scopeDetails);
            }
        });
        this.toDispose.pushAll([
            this.workspaceService.onWorkspaceChanged(newRoots => this.doUpdateDisplay(newRoots)),
            this.workspaceService.onWorkspaceLocationChanged(() => this.doUpdateDisplay(this.workspaceService.tryGetRoots())),
        ]);
        const tabUnderline = document.createElement('div');
        tabUnderline.className = TABBAR_UNDERLINE_CLASSNAME;
        this.node.append(tabUnderline);
    }
    toScopeDetails(title) {
        if (title) {
            const source = 'dataset' in title ? title.dataset : title;
            const { scope, uri, activeScopeIsFolder } = source;
            return {
                scope: Number(scope),
                uri: uri || undefined,
                activeScopeIsFolder: activeScopeIsFolder === 'true' || activeScopeIsFolder === true,
            };
        }
    }
    toDataSet(scopeDetails) {
        const { scope, uri, activeScopeIsFolder } = scopeDetails;
        return {
            scope: scope.toString(),
            uri: uri !== null && uri !== void 0 ? uri : '',
            activeScopeIsFolder: activeScopeIsFolder.toString()
        };
    }
    setupInitialDisplay() {
        this.addUserTab();
        if (this.workspaceService.workspace) {
            this.addWorkspaceTab(this.workspaceService.workspace);
        }
        this.addOrUpdateFolderTab();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.addTabIndexToTabs();
    }
    addTabIndexToTabs() {
        this.node.querySelectorAll('li').forEach((tab, index) => {
            tab.tabIndex = 0;
            const handler = () => {
                if (tab.className.includes(GENERAL_FOLDER_TAB_CLASSNAME) && this.currentWorkspaceRoots.length > 1) {
                    const tabRect = tab.getBoundingClientRect();
                    this.openContextMenu(tabRect, tab, 'keypress');
                }
                else {
                    const details = this.toScopeDetails(this.titles[index]);
                    if (details) {
                        this.setNewScopeSelection(details);
                    }
                }
            };
            tab.onkeydown = handler;
            tab.onclick = handler;
        });
    }
    addUserTab() {
        this.addTab(new widgets_1.Title({
            dataset: { uri: '', scope: USER_TAB_INDEX.toString() },
            label: USER_TAB_LABEL,
            owner: this,
            className: PREFERENCE_TAB_CLASSNAME
        }));
    }
    addWorkspaceTab(currentWorkspace) {
        const scopeDetails = this.getWorkspaceDataset(currentWorkspace);
        const workspaceTabTitle = new widgets_1.Title({
            dataset: this.toDataSet(scopeDetails),
            label: WORKSPACE_TAB_LABEL,
            owner: this,
            className: PREFERENCE_TAB_CLASSNAME,
        });
        this.addTab(workspaceTabTitle);
        return workspaceTabTitle;
    }
    getWorkspaceDataset(currentWorkspace) {
        const { resource, isDirectory } = currentWorkspace;
        const scope = WORKSPACE_TAB_INDEX;
        return { uri: resource.toString(), activeScopeIsFolder: isDirectory, scope };
    }
    addOrUpdateFolderTab() {
        if (!!this.workspaceService.workspace) {
            this.currentWorkspaceRoots = this.workspaceService.tryGetRoots();
            const multipleFolderRootsAreAvailable = this.currentWorkspaceRoots && this.currentWorkspaceRoots.length > 1;
            const noFolderRootsAreAvailable = this.currentWorkspaceRoots.length === 0;
            const shouldShowFoldersSeparately = this.workspaceService.saved;
            if (!noFolderRootsAreAvailable) {
                if (!this.folderTitle) {
                    this.folderTitle = new widgets_1.Title({
                        label: '',
                        caption: FOLDER_TAB_LABEL,
                        owner: this,
                    });
                }
                this.setFolderTitleProperties(multipleFolderRootsAreAvailable);
                if (multipleFolderRootsAreAvailable || shouldShowFoldersSeparately) {
                    this.addTab(this.folderTitle);
                }
            }
            else {
                const folderTabIndex = this.titles.findIndex(title => title.caption === FOLDER_TAB_LABEL);
                if (folderTabIndex > -1) {
                    this.removeTabAt(folderTabIndex);
                }
            }
        }
    }
    setFolderTitleProperties(multipleFolderRootsAreAvailable) {
        this.folderTitle.iconClass = multipleFolderRootsAreAvailable ? FOLDER_DROPDOWN_ICON_CLASSNAME : '';
        if (this.currentSelection.scope === FOLDER_TAB_INDEX) {
            this.folderTitle.label = this.labelProvider.getName(new uri_1.default(this.currentSelection.uri));
            this.folderTitle.dataset = this.toDataSet(this.currentSelection);
            this.folderTitle.className = multipleFolderRootsAreAvailable ? SELECTED_FOLDER_DROPDOWN_CLASSNAME : SINGLE_FOLDER_TAB_CLASSNAME;
        }
        else {
            const singleFolderRoot = this.currentWorkspaceRoots[0].resource;
            const singleFolderLabel = this.labelProvider.getName(singleFolderRoot);
            const defaultURI = multipleFolderRootsAreAvailable ? '' : singleFolderRoot.toString();
            this.folderTitle.label = multipleFolderRootsAreAvailable ? FOLDER_TAB_LABEL : singleFolderLabel;
            this.folderTitle.className = multipleFolderRootsAreAvailable ? UNSELECTED_FOLDER_DROPDOWN_CLASSNAME : SINGLE_FOLDER_TAB_CLASSNAME;
            this.folderTitle.dataset = { folderTitle: 'true', scope: FOLDER_TAB_INDEX.toString(), uri: defaultURI };
        }
    }
    getFolderContextMenu(workspaceRoots = this.workspaceService.tryGetRoots()) {
        this.preferencesMenuFactory.createFolderWorkspacesMenu(workspaceRoots, this.currentSelection.uri);
    }
    handleEvent() {
        // Don't - the handlers are defined in PreferenceScopeTabbarWidget.addTabIndexToTabs()
    }
    openContextMenu(tabRect, folderTabNode, source) {
        const toDisposeOnHide = new common_1.DisposableCollection();
        for (const root of this.workspaceService.tryGetRoots()) {
            const id = `set-scope-to-${root.resource.toString()}`;
            toDisposeOnHide.pushAll([
                this.commandRegistry.registerCommand({ id }, { execute: () => this.setScope(root.resource) }),
                this.menuModelRegistry.registerMenuAction(preference_types_1.PreferenceMenus.FOLDER_SCOPE_MENU_PATH, {
                    commandId: id,
                    label: this.labelProvider.getName(root),
                })
            ]);
        }
        this.contextMenuRenderer.render({
            menuPath: preference_types_1.PreferenceMenus.FOLDER_SCOPE_MENU_PATH,
            anchor: { x: tabRect.left, y: tabRect.bottom },
            context: folderTabNode,
            onHide: () => {
                setTimeout(() => toDisposeOnHide.dispose());
                if (source === 'click') {
                    folderTabNode.blur();
                }
            }
        });
    }
    doUpdateDisplay(newRoots) {
        const folderWasRemoved = newRoots.length < this.currentWorkspaceRoots.length;
        this.currentWorkspaceRoots = newRoots;
        if (folderWasRemoved) {
            const removedFolderWasSelectedScope = !this.currentWorkspaceRoots.some(root => root.resource.toString() === this.currentSelection.uri);
            if (removedFolderWasSelectedScope) {
                this.setNewScopeSelection(preference_types_1.Preference.DEFAULT_SCOPE);
            }
        }
        this.updateWorkspaceTab();
        this.addOrUpdateFolderTab();
    }
    updateWorkspaceTab() {
        var _a;
        const currentWorkspace = this.workspaceService.workspace;
        if (currentWorkspace) {
            const workspaceTitle = (_a = this.titles.find(title => title.label === WORKSPACE_TAB_LABEL)) !== null && _a !== void 0 ? _a : this.addWorkspaceTab(currentWorkspace);
            const scopeDetails = this.getWorkspaceDataset(currentWorkspace);
            workspaceTitle.dataset = this.toDataSet(scopeDetails);
            if (this.currentSelection.scope === browser_1.PreferenceScope.Workspace) {
                this.setNewScopeSelection(scopeDetails);
            }
        }
    }
    emitNewScope() {
        this.onScopeChangedEmitter.fire(this.currentSelection);
    }
    setScope(scope) {
        const details = scope instanceof uri_1.default ? this.getDetailsForResource(scope) : this.getDetailsForScope(scope);
        if (details) {
            this.setNewScopeSelection(details);
        }
    }
    getDetailsForScope(scope) {
        const stringifiedSelectionScope = scope.toString();
        const correspondingTitle = this.titles.find(title => title.dataset.scope === stringifiedSelectionScope);
        return this.toScopeDetails(correspondingTitle);
    }
    getDetailsForResource(resource) {
        const parent = this.workspaceService.getWorkspaceRootUri(resource);
        if (!parent) {
            return undefined;
        }
        if (!this.workspaceService.isMultiRootWorkspaceOpened) {
            return this.getDetailsForScope(browser_1.PreferenceScope.Workspace);
        }
        return ({ scope: browser_1.PreferenceScope.Folder, uri: parent.toString(), activeScopeIsFolder: true });
    }
    storeState() {
        return {
            scopeDetails: this.currentScope
        };
    }
    restoreState(oldState) {
        const scopeDetails = this.toScopeDetails(oldState.scopeDetails);
        if (scopeDetails) {
            this.setNewScopeSelection(scopeDetails);
        }
    }
    toggleShadow(showShadow) {
        this.toggleClass(SHADOW_CLASSNAME, showShadow);
    }
    dispose() {
        super.dispose();
        this.toDispose.dispose();
    }
};
exports.PreferencesScopeTabBar = PreferencesScopeTabBar;
PreferencesScopeTabBar.ID = 'preferences-scope-tab-bar';
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], PreferencesScopeTabBar.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_scope_command_manager_1.PreferenceScopeCommandManager),
    tslib_1.__metadata("design:type", preference_scope_command_manager_1.PreferenceScopeCommandManager)
], PreferencesScopeTabBar.prototype, "preferencesMenuFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], PreferencesScopeTabBar.prototype, "contextMenuRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], PreferencesScopeTabBar.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.CommandRegistry),
    tslib_1.__metadata("design:type", common_1.CommandRegistry)
], PreferencesScopeTabBar.prototype, "commandRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.MenuModelRegistry),
    tslib_1.__metadata("design:type", common_1.MenuModelRegistry)
], PreferencesScopeTabBar.prototype, "menuModelRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferencesScopeTabBar.prototype, "init", null);
exports.PreferencesScopeTabBar = PreferencesScopeTabBar = PreferencesScopeTabBar_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferencesScopeTabBar);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferencesSearchbarWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesSearchbarWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const debounce = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let PreferencesSearchbarWidget = PreferencesSearchbarWidget_1 = class PreferencesSearchbarWidget extends browser_1.ReactWidget {
    constructor(options) {
        super(options);
        this.onFilterStringChangedEmitter = new core_1.Emitter();
        this.onFilterChanged = this.onFilterStringChangedEmitter.event;
        this.searchbarRef = React.createRef();
        this.resultsCount = 0;
        this.handleSearch = (e) => this.search(e.target.value);
        this.search = debounce(async (value) => {
            this.onFilterStringChangedEmitter.fire(value);
            this.update();
        }, 200);
        /**
         * Clears the search input and all search results.
         * @param e on-click mouse event.
         */
        this.clearSearchResults = async (e) => {
            const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
            if (search) {
                search.value = '';
                await this.search(search.value);
                this.update();
            }
        };
        this.focus = this.focus.bind(this);
    }
    init() {
        this.id = PreferencesSearchbarWidget_1.ID;
        this.title.label = PreferencesSearchbarWidget_1.LABEL;
        this.update();
    }
    focus() {
        if (this.searchbarRef.current) {
            this.searchbarRef.current.focus();
        }
    }
    /**
     * Renders all search bar options.
     */
    renderOptionContainer() {
        const resultsCount = this.renderResultsCountOption();
        const clearAllOption = this.renderClearAllOption();
        return React.createElement("div", { className: "option-buttons" },
            " ",
            resultsCount,
            " ",
            clearAllOption,
            " ");
    }
    /**
     * Renders a badge displaying search results count.
     */
    renderResultsCountOption() {
        let resultsFound;
        if (this.resultsCount === 0) {
            resultsFound = nls_1.nls.localizeByDefault('No Settings Found');
        }
        else if (this.resultsCount === 1) {
            resultsFound = nls_1.nls.localizeByDefault('1 Setting Found');
        }
        else {
            resultsFound = nls_1.nls.localizeByDefault('{0} Settings Found', this.resultsCount.toFixed(0));
        }
        return this.searchTermExists() ?
            (React.createElement("span", { className: "results-found", title: resultsFound }, resultsFound))
            : '';
    }
    /**
     * Renders a clear all button.
     */
    renderClearAllOption() {
        return React.createElement("span", { className: `${(0, browser_1.codicon)('clear-all')} option ${(this.searchTermExists() ? 'enabled' : '')}`, title: nls_1.nls.localizeByDefault('Clear Search Results'), onClick: this.clearSearchResults });
    }
    /**
     * Determines whether the search input currently has a value.
     * @returns true, if the search input currently has a value; false, otherwise.
     */
    searchTermExists() {
        var _a;
        return !!((_a = this.searchbarRef.current) === null || _a === void 0 ? void 0 : _a.value);
    }
    getSearchTerm() {
        const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
        return search === null || search === void 0 ? void 0 : search.value;
    }
    async updateSearchTerm(searchTerm) {
        const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
        if (!search || search.value === searchTerm) {
            return;
        }
        search.value = searchTerm;
        await this.search(search.value);
        this.update();
    }
    render() {
        const optionContainer = this.renderOptionContainer();
        return (React.createElement("div", { className: 'settings-header' },
            React.createElement("div", { className: "settings-search-container", ref: this.focus },
                React.createElement("input", { type: "text", id: PreferencesSearchbarWidget_1.SEARCHBAR_ID, spellCheck: false, placeholder: nls_1.nls.localizeByDefault('Search settings'), className: "settings-search-input theia-input", onChange: this.handleSearch, ref: this.searchbarRef }),
                optionContainer)));
    }
    /**
     * Updates the search result count.
     * @param count the result count.
     */
    updateResultsCount(count) {
        this.resultsCount = count;
        this.update();
    }
    storeState() {
        return {
            searchTerm: this.getSearchTerm()
        };
    }
    restoreState(oldState) {
        const searchInputExists = this.onDidChangeVisibility(() => {
            this.updateSearchTerm(oldState.searchTerm || '');
            searchInputExists.dispose();
        });
    }
};
exports.PreferencesSearchbarWidget = PreferencesSearchbarWidget;
PreferencesSearchbarWidget.ID = 'settings.header';
PreferencesSearchbarWidget.LABEL = 'Settings Header';
PreferencesSearchbarWidget.SEARCHBAR_ID = 'preference-searchbar';
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferencesSearchbarWidget.prototype, "init", null);
exports.PreferencesSearchbarWidget = PreferencesSearchbarWidget = PreferencesSearchbarWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.unmanaged)()),
    tslib_1.__metadata("design:paramtypes", [Object])
], PreferencesSearchbarWidget);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/preference-tree-widget.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/preference-tree-widget.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferencesTreeWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesTreeWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const preference_tree_model_1 = __webpack_require__(/*! ../preference-tree-model */ "../../node_modules/@theia/preferences/lib/browser/preference-tree-model.js");
const preference_types_1 = __webpack_require__(/*! ../util/preference-types */ "../../node_modules/@theia/preferences/lib/browser/util/preference-types.js");
let PreferencesTreeWidget = PreferencesTreeWidget_1 = class PreferencesTreeWidget extends browser_1.TreeWidget {
    constructor() {
        super(...arguments);
        this.shouldFireSelectionEvents = true;
    }
    init() {
        super.init();
        this.id = PreferencesTreeWidget_1.ID;
        this.toDispose.pushAll([
            this.model.onFilterChanged(() => {
                this.updateRows();
            }),
        ]);
    }
    doUpdateRows() {
        this.rows = new Map();
        let index = 0;
        for (const [id, nodeRow] of this.model.currentRows.entries()) {
            if (nodeRow.visibleChildren > 0 && this.isVisibleNode(nodeRow.node)) {
                this.rows.set(id, { ...nodeRow, index: index++ });
            }
        }
        this.updateScrollToRow();
    }
    isVisibleNode(node) {
        if (preference_types_1.Preference.TreeNode.isTopLevel(node)) {
            return true;
        }
        else {
            return browser_1.ExpandableTreeNode.isExpanded(node.parent) && preference_types_1.Preference.TreeNode.is(node.parent) && this.isVisibleNode(node.parent);
        }
    }
    doRenderNodeRow({ depth, visibleChildren, node, isExpansible }) {
        return this.renderNode(node, { depth, visibleChildren, isExpansible });
    }
    renderNode(node, props) {
        if (!browser_1.TreeNode.isVisible(node)) {
            return undefined;
        }
        const attributes = this.createNodeAttributes(node, props);
        const content = React.createElement("div", { className: browser_1.TREE_NODE_CONTENT_CLASS },
            this.renderExpansionToggle(node, props),
            this.renderCaption(node, props));
        return React.createElement('div', attributes, content);
    }
    renderExpansionToggle(node, props) {
        if (browser_1.ExpandableTreeNode.is(node) && !props.isExpansible) {
            return React.createElement("div", { className: 'preferences-tree-spacer' });
        }
        return super.renderExpansionToggle(node, props);
    }
    toNodeName(node) {
        var _a;
        const visibleChildren = (_a = this.model.currentRows.get(node.id)) === null || _a === void 0 ? void 0 : _a.visibleChildren;
        const baseName = this.labelProvider.getName(node);
        const printedNameWithVisibleChildren = this.model.isFiltered && visibleChildren !== undefined
            ? `${baseName} (${visibleChildren})`
            : baseName;
        return printedNameWithVisibleChildren;
    }
};
exports.PreferencesTreeWidget = PreferencesTreeWidget;
PreferencesTreeWidget.ID = 'preferences.tree';
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_model_1.PreferenceTreeModel),
    tslib_1.__metadata("design:type", preference_tree_model_1.PreferenceTreeModel)
], PreferencesTreeWidget.prototype, "model", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.TreeProps),
    tslib_1.__metadata("design:type", Object)
], PreferencesTreeWidget.prototype, "treeProps", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferencesTreeWidget.prototype, "init", null);
exports.PreferencesTreeWidget = PreferencesTreeWidget = PreferencesTreeWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferencesTreeWidget);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/preference-widget-bindings.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/preference-widget-bindings.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createPreferencesWidgetContainer = exports.bindPreferencesWidgets = void 0;
// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const contribution_provider_1 = __webpack_require__(/*! @theia/core/lib/common/contribution-provider */ "../../node_modules/@theia/core/lib/common/contribution-provider.js");
const preference_tree_model_1 = __webpack_require__(/*! ../preference-tree-model */ "../../node_modules/@theia/preferences/lib/browser/preference-tree-model.js");
const preference_tree_label_provider_1 = __webpack_require__(/*! ../util/preference-tree-label-provider */ "../../node_modules/@theia/preferences/lib/browser/util/preference-tree-label-provider.js");
const preference_array_input_1 = __webpack_require__(/*! ./components/preference-array-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-array-input.js");
const preference_boolean_input_1 = __webpack_require__(/*! ./components/preference-boolean-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-boolean-input.js");
const preference_file_input_1 = __webpack_require__(/*! ./components/preference-file-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-file-input.js");
const preference_json_input_1 = __webpack_require__(/*! ./components/preference-json-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-json-input.js");
const preference_node_renderer_1 = __webpack_require__(/*! ./components/preference-node-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer.js");
const preference_node_renderer_creator_1 = __webpack_require__(/*! ./components/preference-node-renderer-creator */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-node-renderer-creator.js");
const preference_number_input_1 = __webpack_require__(/*! ./components/preference-number-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-number-input.js");
const preference_select_input_1 = __webpack_require__(/*! ./components/preference-select-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-select-input.js");
const preference_string_input_1 = __webpack_require__(/*! ./components/preference-string-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-string-input.js");
const preference_markdown_renderer_1 = __webpack_require__(/*! ./components/preference-markdown-renderer */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-markdown-renderer.js");
const preference_editor_widget_1 = __webpack_require__(/*! ./preference-editor-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-editor-widget.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ./preference-scope-tabbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
const preference_searchbar_widget_1 = __webpack_require__(/*! ./preference-searchbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js");
const preference_tree_widget_1 = __webpack_require__(/*! ./preference-tree-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-tree-widget.js");
const preference_widget_1 = __webpack_require__(/*! ./preference-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-widget.js");
const preference_null_input_1 = __webpack_require__(/*! ./components/preference-null-input */ "../../node_modules/@theia/preferences/lib/browser/views/components/preference-null-input.js");
function bindPreferencesWidgets(bind) {
    bind(preference_tree_label_provider_1.PreferenceTreeLabelProvider).toSelf().inSingletonScope();
    bind(browser_1.LabelProviderContribution).toService(preference_tree_label_provider_1.PreferenceTreeLabelProvider);
    bind(preference_widget_1.PreferencesWidget)
        .toDynamicValue(({ container }) => createPreferencesWidgetContainer(container).get(preference_widget_1.PreferencesWidget))
        .inSingletonScope();
    bind(browser_1.WidgetFactory).toDynamicValue(({ container }) => ({
        id: preference_widget_1.PreferencesWidget.ID,
        createWidget: () => container.get(preference_widget_1.PreferencesWidget)
    })).inSingletonScope();
    (0, contribution_provider_1.bindContributionProvider)(bind, preference_node_renderer_creator_1.PreferenceNodeRendererContribution);
    bind(preference_select_input_1.PreferenceSelectInputRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_select_input_1.PreferenceSelectInputRendererContribution).inSingletonScope();
    bind(preference_array_input_1.PreferenceArrayInputRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_array_input_1.PreferenceArrayInputRendererContribution).inSingletonScope();
    bind(preference_string_input_1.PreferenceStringInputRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_string_input_1.PreferenceStringInputRendererContribution).inSingletonScope();
    bind(preference_null_input_1.PreferenceNullInputRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_null_input_1.PreferenceNullRendererContribution).inSingletonScope();
    bind(preference_boolean_input_1.PreferenceBooleanInputRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_boolean_input_1.PreferenceBooleanInputRendererContribution).inSingletonScope();
    bind(preference_number_input_1.PreferenceNumberInputRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_number_input_1.PreferenceNumberInputRendererContribution).inSingletonScope();
    bind(preference_json_input_1.PreferenceJSONLinkRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_json_input_1.PreferenceJSONLinkRendererContribution).inSingletonScope();
    bind(preference_node_renderer_1.PreferenceHeaderRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_node_renderer_creator_1.PreferenceHeaderRendererContribution).inSingletonScope();
    bind(preference_file_input_1.PreferenceSingleFilePathInputRenderer).toSelf();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererContribution).to(preference_file_input_1.PreferenceSingleFilePathInputRendererContribution).inSingletonScope();
    bind(preference_node_renderer_creator_1.DefaultPreferenceNodeRendererCreatorRegistry).toSelf().inSingletonScope();
    bind(preference_node_renderer_creator_1.PreferenceNodeRendererCreatorRegistry).toService(preference_node_renderer_creator_1.DefaultPreferenceNodeRendererCreatorRegistry);
}
exports.bindPreferencesWidgets = bindPreferencesWidgets;
function createPreferencesWidgetContainer(parent) {
    const child = (0, browser_1.createTreeContainer)(parent, {
        model: preference_tree_model_1.PreferenceTreeModel,
        widget: preference_tree_widget_1.PreferencesTreeWidget,
        props: { search: false }
    });
    child.bind(preference_editor_widget_1.PreferencesEditorWidget).toSelf();
    child.bind(preference_searchbar_widget_1.PreferencesSearchbarWidget).toSelf();
    child.bind(preference_scope_tabbar_widget_1.PreferencesScopeTabBar).toSelf();
    child.bind(preference_widget_1.PreferencesWidget).toSelf();
    child.bind(preference_node_renderer_1.PreferenceNodeRendererFactory).toFactory(({ container }) => (node) => {
        const registry = container.get(preference_node_renderer_creator_1.PreferenceNodeRendererCreatorRegistry);
        const creator = registry.getPreferenceNodeRendererCreator(node);
        return creator.createRenderer(node, container);
    });
    child.bind(preference_markdown_renderer_1.PreferenceMarkdownRenderer).toSelf().inSingletonScope();
    return child;
}
exports.createPreferencesWidgetContainer = createPreferencesWidgetContainer;


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/browser/views/preference-widget.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/browser/views/preference-widget.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var PreferencesWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PreferencesWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const preference_editor_widget_1 = __webpack_require__(/*! ./preference-editor-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-editor-widget.js");
const preference_tree_widget_1 = __webpack_require__(/*! ./preference-tree-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-tree-widget.js");
const preference_searchbar_widget_1 = __webpack_require__(/*! ./preference-searchbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-searchbar-widget.js");
const preference_scope_tabbar_widget_1 = __webpack_require__(/*! ./preference-scope-tabbar-widget */ "../../node_modules/@theia/preferences/lib/browser/views/preference-scope-tabbar-widget.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
let PreferencesWidget = PreferencesWidget_1 = class PreferencesWidget extends browser_1.Panel {
    get currentScope() {
        return this.tabBarWidget.currentScope;
    }
    setSearchTerm(query) {
        return this.searchbarWidget.updateSearchTerm(query);
    }
    setScope(scope) {
        this.tabBarWidget.setScope(scope);
    }
    onResize(msg) {
        super.onResize(msg);
        if (msg.width < 600 && this.treeWidget && !this.treeWidget.isHidden) {
            this.treeWidget.hide();
            this.editorWidget.addClass('full-pane');
        }
        else if (msg.width >= 600 && this.treeWidget && this.treeWidget.isHidden) {
            this.treeWidget.show();
            this.editorWidget.removeClass('full-pane');
        }
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.searchbarWidget.focus();
    }
    init() {
        this.id = PreferencesWidget_1.ID;
        this.title.label = PreferencesWidget_1.LABEL;
        this.title.caption = PreferencesWidget_1.LABEL;
        this.title.closable = true;
        this.addClass('theia-settings-container');
        this.title.iconClass = (0, browser_1.codicon)('settings');
        this.searchbarWidget.addClass('preferences-searchbar-widget');
        this.addWidget(this.searchbarWidget);
        this.tabBarWidget.addClass('preferences-tabbar-widget');
        this.addWidget(this.tabBarWidget);
        this.treeWidget.addClass('preferences-tree-widget');
        this.addWidget(this.treeWidget);
        this.editorWidget.addClass('preferences-editor-widget');
        this.addWidget(this.editorWidget);
        this.update();
    }
    getPreviewNode() {
        return this.node;
    }
    storeState() {
        return {
            scopeTabBarState: this.tabBarWidget.storeState(),
            editorState: this.editorWidget.storeState(),
            searchbarWidgetState: this.searchbarWidget.storeState(),
        };
    }
    restoreState(state) {
        this.tabBarWidget.restoreState(state.scopeTabBarState);
        this.editorWidget.restoreState(state.editorState);
        this.searchbarWidget.restoreState(state.searchbarWidgetState);
    }
};
exports.PreferencesWidget = PreferencesWidget;
/**
 * The widget `id`.
 */
PreferencesWidget.ID = 'settings_widget';
/**
 * The widget `label` which is used for display purposes.
 */
PreferencesWidget.LABEL = nls_1.nls.localizeByDefault('Settings');
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_editor_widget_1.PreferencesEditorWidget),
    tslib_1.__metadata("design:type", preference_editor_widget_1.PreferencesEditorWidget)
], PreferencesWidget.prototype, "editorWidget", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_tree_widget_1.PreferencesTreeWidget),
    tslib_1.__metadata("design:type", preference_tree_widget_1.PreferencesTreeWidget)
], PreferencesWidget.prototype, "treeWidget", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_searchbar_widget_1.PreferencesSearchbarWidget),
    tslib_1.__metadata("design:type", preference_searchbar_widget_1.PreferencesSearchbarWidget)
], PreferencesWidget.prototype, "searchbarWidget", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preference_scope_tabbar_widget_1.PreferencesScopeTabBar),
    tslib_1.__metadata("design:type", preference_scope_tabbar_widget_1.PreferencesScopeTabBar)
], PreferencesWidget.prototype, "tabBarWidget", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], PreferencesWidget.prototype, "init", null);
exports.PreferencesWidget = PreferencesWidget = PreferencesWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], PreferencesWidget);


/***/ }),

/***/ "../../node_modules/@theia/preferences/lib/common/cli-preferences.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/lib/common/cli-preferences.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CliPreferencesPath = exports.CliPreferences = void 0;
exports.CliPreferences = Symbol('CliPreferences');
exports.CliPreferencesPath = '/services/cli-preferences';


/***/ }),

/***/ "../../node_modules/@theia/preferences/src/browser/style/index.css":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/preferences/src/browser/style/index.css ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./index.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/index.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/@theia/userstorage/lib/browser/index.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./user-storage-uri */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./user-storage-frontend-module */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-frontend-module.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserStorageContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const disposable_1 = __webpack_require__(/*! @theia/core/lib/common/disposable */ "../../node_modules/@theia/core/lib/common/disposable.js");
const env_variables_1 = __webpack_require__(/*! @theia/core/lib/common/env-variables */ "../../node_modules/@theia/core/lib/common/env-variables/index.js");
const delegating_file_system_provider_1 = __webpack_require__(/*! @theia/filesystem/lib/common/delegating-file-system-provider */ "../../node_modules/@theia/filesystem/lib/common/delegating-file-system-provider.js");
const user_storage_uri_1 = __webpack_require__(/*! ./user-storage-uri */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js");
let UserStorageContribution = class UserStorageContribution {
    registerFileSystemProviders(service) {
        service.onWillActivateFileSystemProvider(event => {
            if (event.scheme === user_storage_uri_1.UserStorageUri.scheme) {
                event.waitUntil((async () => {
                    const provider = await this.createProvider(service);
                    service.registerProvider(user_storage_uri_1.UserStorageUri.scheme, provider);
                })());
            }
        });
    }
    getDelegate(service) {
        return service.activateProvider('file');
    }
    async getCongigDirUri() {
        return new uri_1.default(await this.environments.getConfigDirUri());
    }
    async createProvider(service) {
        const delegate = await this.getDelegate(service);
        const configDirUri = await this.getCongigDirUri();
        return new delegating_file_system_provider_1.DelegatingFileSystemProvider(delegate, {
            uriConverter: {
                to: resource => {
                    const relativePath = user_storage_uri_1.UserStorageUri.relative(resource);
                    if (relativePath) {
                        return configDirUri.resolve(relativePath).normalizePath();
                    }
                    return undefined;
                },
                from: resource => {
                    const relativePath = configDirUri.relative(resource);
                    if (relativePath) {
                        return user_storage_uri_1.UserStorageUri.resolve(relativePath);
                    }
                    return undefined;
                }
            }
        }, new disposable_1.DisposableCollection(delegate.watch(configDirUri, { excludes: [], recursive: true })));
    }
};
exports.UserStorageContribution = UserStorageContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(env_variables_1.EnvVariablesServer),
    tslib_1.__metadata("design:type", Object)
], UserStorageContribution.prototype, "environments", void 0);
exports.UserStorageContribution = UserStorageContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], UserStorageContribution);


/***/ }),

/***/ "../../node_modules/@theia/userstorage/lib/browser/user-storage-frontend-module.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/user-storage-frontend-module.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const user_storage_contribution_1 = __webpack_require__(/*! ./user-storage-contribution */ "../../node_modules/@theia/userstorage/lib/browser/user-storage-contribution.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(user_storage_contribution_1.UserStorageContribution).toSelf().inSingletonScope();
    bind(file_service_1.FileServiceContribution).toService(user_storage_contribution_1.UserStorageContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/userstorage/lib/browser/user-storage-uri.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UserStorageUri = void 0;
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
exports.UserStorageUri = new uri_1.default('user-storage:/user');


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-module */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js"), exports);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/index.css":
/*!*******************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/index.css ***!
  \*******************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_loader_dist_cjs_js_preference_context_menu_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! -!../../../../../css-loader/dist/cjs.js!./preference-context-menu.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-context-menu.css");
/* harmony import */ var _css_loader_dist_cjs_js_preference_array_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! -!../../../../../css-loader/dist/cjs.js!./preference-array.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-array.css");
/* harmony import */ var _css_loader_dist_cjs_js_preference_file_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! -!../../../../../css-loader/dist/cjs.js!./preference-file.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-file.css");
/* harmony import */ var _css_loader_dist_cjs_js_preference_object_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! -!../../../../../css-loader/dist/cjs.js!./preference-object.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-object.css");
/* harmony import */ var _css_loader_dist_cjs_js_search_input_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! -!../../../../../css-loader/dist/cjs.js!./search-input.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/search-input.css");
// Imports







var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_css_loader_dist_cjs_js_preference_context_menu_css__WEBPACK_IMPORTED_MODULE_2__["default"]);
___CSS_LOADER_EXPORT___.i(_css_loader_dist_cjs_js_preference_array_css__WEBPACK_IMPORTED_MODULE_3__["default"]);
___CSS_LOADER_EXPORT___.i(_css_loader_dist_cjs_js_preference_file_css__WEBPACK_IMPORTED_MODULE_4__["default"]);
___CSS_LOADER_EXPORT___.i(_css_loader_dist_cjs_js_preference_object_css__WEBPACK_IMPORTED_MODULE_5__["default"]);
___CSS_LOADER_EXPORT___.i(_css_loader_dist_cjs_js_search_input_css__WEBPACK_IMPORTED_MODULE_6__["default"]);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

#preferences_container_widget .lm-SplitPanel-handle {
  border-right: var(--theia-border-width) solid var(--theia-editorGroup-border);
}

#preferences_container_widget .lm-TabBar-tabIcon {
  align-items: center;
  display: flex;
  line-height: var(--theia-content-line-height) !important;
}

/* UI View */

.theia-settings-container {
  max-width: 1000px;
  padding-top: 11px;
  display: grid;
  grid-template-areas:
    "header header"
    "tabbar tabbar"
    "navbar editor";
  grid-template-columns: minmax(150px, 280px) 1fr;
  grid-template-rows: 45px 45px 1fr;
}

.theia-settings-container
  .settings-main:not(.no-results)
  .settings-no-results-announcement {
  display: none;
}

.theia-settings-container .settings-main .hidden {
  display: none;
}

.theia-settings-container .settings-no-results-announcement {
  font-weight: bold;
  font-size: var(--theia-ui-font-size3);
  padding-left: var(--theia-ui-padding);
  margin: calc(2 * var(--theia-ui-padding)) 0px;
}

.theia-settings-container .preferences-searchbar-widget {
  grid-area: header;
  margin: 3px 24px 0px 24px;
}

.theia-settings-container .preferences-tabbar-widget {
  grid-area: tabbar;
  margin: 3px 24px 0px 24px;
}

.theia-settings-container .preferences-tabbar-widget.with-shadow {
  box-shadow: 0px 6px 5px -5px var(--theia-widget-shadow);
}

.theia-settings-container
  .preferences-tabbar-widget
  .preferences-scope-tab
  .lm-TabBar-tabIcon:not(.preferences-folder-dropdown-icon) {
  display: none;
}

#theia-main-content-panel
  .theia-settings-container
  #preferences-scope-tab-bar
  .preferences-scope-tab {
  background: var(--theia-editor-background);
  border-right: unset;
  border-bottom: var(--theia-border-width) solid
    var(--theia-tab-unfocusedInactiveForeground);
  border-top: none;
}

#theia-main-content-panel .theia-settings-container .tabbar-underline {
  width: 100%;
  position: absolute;
  border-top: 1px solid var(--theia-tab-unfocusedInactiveForeground);
  z-index: -1;
}

#theia-main-content-panel
  .theia-settings-container
  #preferences-scope-tab-bar
  .preferences-scope-tab {
  color: var(--theia-panelTitle-inactiveForeground);
}

#theia-main-content-panel
  .theia-settings-container
  #preferences-scope-tab-bar
  .preferences-scope-tab:hover {
  color: var(--theia-panelTitle-activeForeground);
}

#theia-main-content-panel
  .theia-settings-container
  #preferences-scope-tab-bar
  .preferences-scope-tab.lm-mod-current {
  color: var(--theia-panelTitle-activeForeground);
  border-bottom: var(--theia-border-width) solid
    var(--theia-panelTitle-activeBorder);
}

#theia-main-content-panel
  .theia-settings-container
  #preferences-scope-tab-bar
  .preferences-scope-tab.lm-mod-current:not(.theia-mod-active) {
  border-top: unset;
}

#theia-main-content-panel
  .theia-settings-container
  #preferences-scope-tab-bar
  .preferences-scope-tab.preferences-folder-tab
  .lm-TabBar-tabLabel::after {
  content: "Folder";
  padding-left: 4px;
  font-size: 0.8em;
  color: var(--theia-tab-inactiveForeground);
}

#theia-main-content-panel
  .theia-settings-container
  #preferences-scope-tab-bar
  .preferences-scope-tab.preferences-folder-dropdown {
  position: relative;
  padding-right: 23px;
}

.preferences-folder-dropdown-icon {
  width: 15px;
  height: 15px;
  position: absolute;
  right: var(--theia-ui-padding);
}

.theia-settings-container .preferences-editor-widget {
  grid-area: editor;
  overflow: hidden;
}

.theia-settings-container .preferences-editor-widget.full-pane {
  grid-column-start: 1;
  grid-column-end: 3;
}

.theia-settings-container .preferences-tree-widget {
  grid-area: navbar;
  padding-left: 31px;
}

.theia-settings-container .preferences-tree-widget .theia-mod-selected {
  font-weight: bold;
}

.theia-settings-container .preferences-tree-widget .theia-TreeNodeSegment {
  text-overflow: ellipsis;
  overflow: hidden;
  max-width: 90%;
}

.theia-settings-container .settings-main {
  height: 100%;
  width: 100%;
  display: flex;
  flex-direction: column;
}

.theia-settings-container .settings-main-scroll-container {
  position: relative;
  box-sizing: border-box;
  width: 100%;
  padding: 0 24px;
  flex: 1 1 auto;
}

.theia-settings-container .settings-main-sticky-misc {
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex: 0 1 50px;
}

.theia-settings-container .settings-main-sticky-misc .json-button > i {
  display: inline-block;
  background: var(--theia-icon-open-json) no-repeat;
  background-position-y: 1px;
  -webkit-filter: invert(1);
  filter: invert(1);
  height: var(--theia-icon-size);
  width: var(--theia-icon-size);
}

.theia-settings-container .settings-scope > label {
  margin-right: 12px;
}

.theia-settings-container .settings-section {
  padding-left: 0;
  padding-top: var(--theia-ui-padding);
  margin-top: calc(var(--theia-ui-padding) * -1);
}

.theia-settings-container .settings-section a {
  border: none;
  color: var(--theia-foreground);
  font-weight: 500;
  outline: 0;
  text-decoration: none;
}

.theia-settings-container .command-link {
  color: var(--theia-textLink-foreground);
}

.theia-settings-container .settings-section a:hover {
  text-decoration: underline;
}

.theia-settings-container .settings-section-category-title {
  font-weight: bold;
  font-size: var(--theia-ui-font-size3);
  padding-left: calc(2 * var(--theia-ui-padding));
}

.theia-settings-container .settings-section-subcategory-title {
  font-weight: bold;
  font-size: var(--theia-ui-font-size2);
  padding-left: calc(2 * var(--theia-ui-padding));
}

.theia-settings-container .settings-section > li {
  list-style-type: none;
  margin: var(--theia-ui-padding) 0px;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: justify;
  -ms-flex-pack: justify;
  justify-content: space-between;
  -webkit-box-align: start;
  -ms-flex-align: start;
  align-items: start;
}

.theia-settings-container li.single-pref {
  list-style-type: none;
  padding: 12px 14px 18px;
  width: 100%;
  display: flex;
  flex-direction: column;
  box-sizing: border-box;
  position: relative;
}

.theia-settings-container li.single-pref p {
  margin: 0;
}

.theia-settings-container li.single-pref:hover:not(:focus) {
  background-color: var(--theia-settings-rowHoverBackground);
}

.theia-settings-container li.single-pref:focus {
  background-color: var(--theia-settings-focusedRowBackground);
  outline: 1px solid var(--theia-settings-focusedRowBorder);
}

.theia-settings-container li.single-pref .pref-context-gutter {
  position: absolute;
  height: calc(100% - 36px);
  left: -22px;
  padding-right: 8px;
  border-right: 2px hidden;
}

.theia-settings-container .settings-context-menu-btn {
  opacity: 0;
  transition: opacity 0.5s;
}

.theia-settings-container
  .single-pref:focus-within
  .pref-context-gutter
  .settings-context-menu-btn,
.theia-settings-container
  .pref-name:hover
  + .pref-context-gutter
  .settings-context-menu-btn,
.theia-settings-container .pref-context-gutter:hover .settings-context-menu-btn,
.theia-settings-container
  .pref-context-gutter.show-cog
  .settings-context-menu-btn {
  opacity: 1;
}

.theia-settings-container
  li.single-pref
  .pref-context-gutter.theia-mod-item-modified {
  border-right: 2px solid var(--theia-settings-modifiedItemIndicator);
}

.theia-settings-container li.single-pref input[type="text"] {
  -webkit-box-sizing: border-box;
  box-sizing: border-box;
}

.theia-settings-container .settings-main {
  margin: 0;
}

.theia-settings-container .settings-main-sticky {
  top: 0;
  padding-top: calc(var(--theia-ui-padding));
  margin-top: calc(var(--theia-ui-padding) * -1);
  background-color: var(--theia-editor-background);
  -webkit-box-sizing: border-box;
  box-sizing: border-box;
  z-index: 1000;
  display: flex;
  flex-direction: column;
  justify-content: space-around;
}

.theia-settings-container .pref-name {
  padding: 0;
  font-weight: bold;
}

.theia-settings-container .preference-leaf-headline-prefix {
  color: var(--theia-descriptionForeground);
}

.preferences-tree-spacer {
  padding-left: calc(var(--theia-ui-padding) / 2);
  padding-right: calc(var(--theia-ui-padding) / 2);
  min-width: var(--theia-icon-size);
  min-height: var(--theia-icon-size);
}

.theia-settings-container .pref-description {
  padding: var(--theia-ui-padding) 0;
  color: var(--theia-descriptionForeground);
  line-height: 18px;
}

.theia-settings-container .pref-description a {
  text-decoration-line: none;
  cursor: pointer;
}

.theia-settings-container .theia-select:focus {
  outline-width: 1px;
  outline-style: solid;
  outline-offset: -1px;
  opacity: 1 !important;
  outline-color: var(--theia-focusBorder);
}

.theia-settings-container .theia-input[type="text"] {
  border: 1px solid var(--theia-dropdown-border);
}

.theia-settings-container .theia-input[type="checkbox"]:focus,
.theia-settings-container .theia-input[type="number"]:focus {
  outline-width: 1px;
}

.theia-settings-container .theia-input[type="checkbox"] {
  margin-left: 0;
}

/* Remove the spinners from input[type = number] on Firefox. */
.theia-settings-container .theia-input[type="number"] {
  -webkit-appearance: textfield;
  border: 1px solid var(--theia-dropdown-border);
}

/* Remove the webkit spinners from input[type = number] on all browsers except Firefox. */
.theia-settings-container input::-webkit-outer-spin-button,
.theia-settings-container input::-webkit-inner-spin-button {
  -webkit-appearance: none;
  margin: 0;
}

.dialogContent .error:not(:empty),
.theia-settings-container .pref-content-container .pref-input .pref-input-container .pref-error-notification {
  border-style: solid;
  border-width: 1px;
  border-color: var(--theia-inputValidation-errorBorder);
  background-color: var(--theia-inputValidation-errorBackground);
  width: 100%;
  box-sizing: border-box;
  padding: var(--theia-ui-padding);
}

.theia-settings-container
  .pref-content-container
  .pref-input
  .pref-input-container {
  display: flex;
  flex-direction: column;
}

.theia-settings-container .pref-content-container a.theia-json-input {
  text-decoration: underline;
  color: var(--theia-titleBar-activeForeground);
}

.theia-settings-container .pref-content-container a.theia-json-input:hover {
  text-decoration: none;
  cursor: pointer;
}

.theia-settings-container .pref-content-container {
  width: 100%;
}

.theia-settings-container .pref-content-container .pref-input {
  padding: var(--theia-ui-padding) 0;
  width: 100%;
  max-width: 320px;
}

.theia-settings-container .pref-content-container .pref-input > select,
.theia-settings-container
  .pref-content-container
  .pref-input
  > input:not([type="checkbox"]) {
  width: 100%;
}

/* These specifications for the boolean class ensure that the
    checkbox is rendered to the left of the description.
*/
.theia-settings-container .pref-content-container.boolean {
  display: grid;
  grid-template-columns: 20px 1fr;
}

.theia-settings-container .pref-content-container.boolean .pref-description {
  grid-column-start: 2;
  grid-row-start: 1;
}

.theia-settings-container .pref-content-container.boolean .pref-input {
  grid-column-start: 1;
  grid-row-start: 1;
  margin: 0;
}

.theia-settings-container .settings-section > li:last-child {
  margin-bottom: 20px;
}

.theia-settings-container .preference-leaf-headline-suffix {
  font-weight: normal;
  color: var(--theia-descriptionForeground);
}

.theia-settings-container .preference-leaf-headline-suffix::before {
  content: " (";
}

.theia-settings-container .preference-leaf-headline-suffix::after {
  content: ")";
}

.theia-settings-container .preference-scope-underlined {
  text-decoration: underline;
  cursor: pointer;
}

.theia-settings-container
  .preference-modified-scope-wrapper:not(:last-child)::after {
  content: ", ";
}

/** Select component */

.theia-settings-container .theia-select-component {
  height: 26px;
  width: 100%;
  max-width: 320px;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/preferences/src/browser/style/index.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,6EAA6E;AAC/E;;AAEA;EACE,mBAAmB;EACnB,aAAa;EACb,wDAAwD;AAC1D;;AAEA,YAAY;;AAQZ;EACE,iBAAiB;EACjB,iBAAiB;EACjB,aAAa;EACb;;;mBAGiB;EACjB,+CAA+C;EAC/C,iCAAiC;AACnC;;AAEA;;;EAGE,aAAa;AACf;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,iBAAiB;EACjB,qCAAqC;EACrC,qCAAqC;EACrC,6CAA6C;AAC/C;;AAEA;EACE,iBAAiB;EACjB,yBAAyB;AAC3B;;AAEA;EACE,iBAAiB;EACjB,yBAAyB;AAC3B;;AAEA;EACE,uDAAuD;AACzD;;AAEA;;;;EAIE,aAAa;AACf;;AAEA;;;;EAIE,0CAA0C;EAC1C,mBAAmB;EACnB;gDAC8C;EAC9C,gBAAgB;AAClB;;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,kEAAkE;EAClE,WAAW;AACb;;AAEA;;;;EAIE,iDAAiD;AACnD;;AAEA;;;;EAIE,+CAA+C;AACjD;;AAEA;;;;EAIE,+CAA+C;EAC/C;wCACsC;AACxC;;AAEA;;;;EAIE,iBAAiB;AACnB;;AAEA;;;;;EAKE,iBAAiB;EACjB,iBAAiB;EACjB,gBAAgB;EAChB,0CAA0C;AAC5C;;AAEA;;;;EAIE,kBAAkB;EAClB,mBAAmB;AACrB;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,kBAAkB;EAClB,8BAA8B;AAChC;;AAEA;EACE,iBAAiB;EACjB,gBAAgB;AAClB;;AAEA;EACE,oBAAoB;EACpB,kBAAkB;AACpB;;AAEA;EACE,iBAAiB;EACjB,kBAAkB;AACpB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,uBAAuB;EACvB,gBAAgB;EAChB,cAAc;AAChB;;AAEA;EACE,YAAY;EACZ,WAAW;EACX,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,kBAAkB;EAClB,sBAAsB;EACtB,WAAW;EACX,eAAe;EACf,cAAc;AAChB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,8BAA8B;EAC9B,cAAc;AAChB;;AAEA;EACE,qBAAqB;EACrB,iDAAiD;EACjD,0BAA0B;EAC1B,yBAAyB;EACzB,iBAAiB;EACjB,8BAA8B;EAC9B,6BAA6B;AAC/B;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,eAAe;EACf,oCAAoC;EACpC,8CAA8C;AAChD;;AAEA;EACE,YAAY;EACZ,8BAA8B;EAC9B,gBAAgB;EAChB,UAAU;EACV,qBAAqB;AACvB;;AAEA;EACE,uCAAuC;AACzC;;AAEA;EACE,0BAA0B;AAC5B;;AAEA;EACE,iBAAiB;EACjB,qCAAqC;EACrC,+CAA+C;AACjD;;AAEA;EACE,iBAAiB;EACjB,qCAAqC;EACrC,+CAA+C;AACjD;;AAEA;EACE,qBAAqB;EACrB,mCAAmC;EACnC,oBAAoB;EACpB,oBAAoB;EACpB,aAAa;EACb,yBAAyB;EACzB,sBAAsB;EACtB,8BAA8B;EAC9B,wBAAwB;EACxB,qBAAqB;EACrB,kBAAkB;AACpB;;AAEA;EACE,qBAAqB;EACrB,uBAAuB;EACvB,WAAW;EACX,aAAa;EACb,sBAAsB;EACtB,sBAAsB;EACtB,kBAAkB;AACpB;;AAEA;EACE,SAAS;AACX;;AAEA;EACE,0DAA0D;AAC5D;;AAEA;EACE,4DAA4D;EAC5D,yDAAyD;AAC3D;;AAEA;EACE,kBAAkB;EAClB,yBAAyB;EACzB,WAAW;EACX,kBAAkB;EAClB,wBAAwB;AAC1B;;AAEA;EACE,UAAU;EACV,wBAAwB;AAC1B;;AAEA;;;;;;;;;;;;EAYE,UAAU;AACZ;;AAEA;;;EAGE,mEAAmE;AACrE;;AAEA;EACE,8BAA8B;EAC9B,sBAAsB;AACxB;;AAEA;EACE,SAAS;AACX;;AAEA;EACE,MAAM;EACN,0CAA0C;EAC1C,8CAA8C;EAC9C,gDAAgD;EAChD,8BAA8B;EAC9B,sBAAsB;EACtB,aAAa;EACb,aAAa;EACb,sBAAsB;EACtB,6BAA6B;AAC/B;;AAEA;EACE,UAAU;EACV,iBAAiB;AACnB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,+CAA+C;EAC/C,gDAAgD;EAChD,iCAAiC;EACjC,kCAAkC;AACpC;;AAEA;EACE,kCAAkC;EAClC,yCAAyC;EACzC,iBAAiB;AACnB;;AAEA;EACE,0BAA0B;EAC1B,eAAe;AACjB;;AAEA;EACE,kBAAkB;EAClB,oBAAoB;EACpB,oBAAoB;EACpB,qBAAqB;EACrB,uCAAuC;AACzC;;AAEA;EACE,8CAA8C;AAChD;;AAEA;;EAEE,kBAAkB;AACpB;;AAEA;EACE,cAAc;AAChB;;AAEA,8DAA8D;AAC9D;EACE,6BAA6B;EAC7B,8CAA8C;AAChD;;AAEA,yFAAyF;AACzF;;EAEE,wBAAwB;EACxB,SAAS;AACX;;AAEA;;EAEE,mBAAmB;EACnB,iBAAiB;EACjB,sDAAsD;EACtD,8DAA8D;EAC9D,WAAW;EACX,sBAAsB;EACtB,gCAAgC;AAClC;;AAEA;;;;EAIE,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,0BAA0B;EAC1B,6CAA6C;AAC/C;;AAEA;EACE,qBAAqB;EACrB,eAAe;AACjB;;AAEA;EACE,WAAW;AACb;;AAEA;EACE,kCAAkC;EAClC,WAAW;EACX,gBAAgB;AAClB;;AAEA;;;;;EAKE,WAAW;AACb;;AAEA;;CAEC;AACD;EACE,aAAa;EACb,+BAA+B;AACjC;;AAEA;EACE,oBAAoB;EACpB,iBAAiB;AACnB;;AAEA;EACE,oBAAoB;EACpB,iBAAiB;EACjB,SAAS;AACX;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,mBAAmB;EACnB,yCAAyC;AAC3C;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,0BAA0B;EAC1B,eAAe;AACjB;;AAEA;;EAEE,aAAa;AACf;;AAEA,sBAAsB;;AAEtB;EACE,YAAY;EACZ,WAAW;EACX,gBAAgB;AAClB","sourcesContent":["/********************************************************************************\n * Copyright (C) 2019 TypeFox and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n#preferences_container_widget .lm-SplitPanel-handle {\n  border-right: var(--theia-border-width) solid var(--theia-editorGroup-border);\n}\n\n#preferences_container_widget .lm-TabBar-tabIcon {\n  align-items: center;\n  display: flex;\n  line-height: var(--theia-content-line-height) !important;\n}\n\n/* UI View */\n\n@import url(\"./preference-context-menu.css\");\n@import url(\"./preference-array.css\");\n@import url(\"./preference-file.css\");\n@import url(\"./preference-object.css\");\n@import url(\"./search-input.css\");\n\n.theia-settings-container {\n  max-width: 1000px;\n  padding-top: 11px;\n  display: grid;\n  grid-template-areas:\n    \"header header\"\n    \"tabbar tabbar\"\n    \"navbar editor\";\n  grid-template-columns: minmax(150px, 280px) 1fr;\n  grid-template-rows: 45px 45px 1fr;\n}\n\n.theia-settings-container\n  .settings-main:not(.no-results)\n  .settings-no-results-announcement {\n  display: none;\n}\n\n.theia-settings-container .settings-main .hidden {\n  display: none;\n}\n\n.theia-settings-container .settings-no-results-announcement {\n  font-weight: bold;\n  font-size: var(--theia-ui-font-size3);\n  padding-left: var(--theia-ui-padding);\n  margin: calc(2 * var(--theia-ui-padding)) 0px;\n}\n\n.theia-settings-container .preferences-searchbar-widget {\n  grid-area: header;\n  margin: 3px 24px 0px 24px;\n}\n\n.theia-settings-container .preferences-tabbar-widget {\n  grid-area: tabbar;\n  margin: 3px 24px 0px 24px;\n}\n\n.theia-settings-container .preferences-tabbar-widget.with-shadow {\n  box-shadow: 0px 6px 5px -5px var(--theia-widget-shadow);\n}\n\n.theia-settings-container\n  .preferences-tabbar-widget\n  .preferences-scope-tab\n  .lm-TabBar-tabIcon:not(.preferences-folder-dropdown-icon) {\n  display: none;\n}\n\n#theia-main-content-panel\n  .theia-settings-container\n  #preferences-scope-tab-bar\n  .preferences-scope-tab {\n  background: var(--theia-editor-background);\n  border-right: unset;\n  border-bottom: var(--theia-border-width) solid\n    var(--theia-tab-unfocusedInactiveForeground);\n  border-top: none;\n}\n\n#theia-main-content-panel .theia-settings-container .tabbar-underline {\n  width: 100%;\n  position: absolute;\n  border-top: 1px solid var(--theia-tab-unfocusedInactiveForeground);\n  z-index: -1;\n}\n\n#theia-main-content-panel\n  .theia-settings-container\n  #preferences-scope-tab-bar\n  .preferences-scope-tab {\n  color: var(--theia-panelTitle-inactiveForeground);\n}\n\n#theia-main-content-panel\n  .theia-settings-container\n  #preferences-scope-tab-bar\n  .preferences-scope-tab:hover {\n  color: var(--theia-panelTitle-activeForeground);\n}\n\n#theia-main-content-panel\n  .theia-settings-container\n  #preferences-scope-tab-bar\n  .preferences-scope-tab.lm-mod-current {\n  color: var(--theia-panelTitle-activeForeground);\n  border-bottom: var(--theia-border-width) solid\n    var(--theia-panelTitle-activeBorder);\n}\n\n#theia-main-content-panel\n  .theia-settings-container\n  #preferences-scope-tab-bar\n  .preferences-scope-tab.lm-mod-current:not(.theia-mod-active) {\n  border-top: unset;\n}\n\n#theia-main-content-panel\n  .theia-settings-container\n  #preferences-scope-tab-bar\n  .preferences-scope-tab.preferences-folder-tab\n  .lm-TabBar-tabLabel::after {\n  content: \"Folder\";\n  padding-left: 4px;\n  font-size: 0.8em;\n  color: var(--theia-tab-inactiveForeground);\n}\n\n#theia-main-content-panel\n  .theia-settings-container\n  #preferences-scope-tab-bar\n  .preferences-scope-tab.preferences-folder-dropdown {\n  position: relative;\n  padding-right: 23px;\n}\n\n.preferences-folder-dropdown-icon {\n  width: 15px;\n  height: 15px;\n  position: absolute;\n  right: var(--theia-ui-padding);\n}\n\n.theia-settings-container .preferences-editor-widget {\n  grid-area: editor;\n  overflow: hidden;\n}\n\n.theia-settings-container .preferences-editor-widget.full-pane {\n  grid-column-start: 1;\n  grid-column-end: 3;\n}\n\n.theia-settings-container .preferences-tree-widget {\n  grid-area: navbar;\n  padding-left: 31px;\n}\n\n.theia-settings-container .preferences-tree-widget .theia-mod-selected {\n  font-weight: bold;\n}\n\n.theia-settings-container .preferences-tree-widget .theia-TreeNodeSegment {\n  text-overflow: ellipsis;\n  overflow: hidden;\n  max-width: 90%;\n}\n\n.theia-settings-container .settings-main {\n  height: 100%;\n  width: 100%;\n  display: flex;\n  flex-direction: column;\n}\n\n.theia-settings-container .settings-main-scroll-container {\n  position: relative;\n  box-sizing: border-box;\n  width: 100%;\n  padding: 0 24px;\n  flex: 1 1 auto;\n}\n\n.theia-settings-container .settings-main-sticky-misc {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  flex: 0 1 50px;\n}\n\n.theia-settings-container .settings-main-sticky-misc .json-button > i {\n  display: inline-block;\n  background: var(--theia-icon-open-json) no-repeat;\n  background-position-y: 1px;\n  -webkit-filter: invert(1);\n  filter: invert(1);\n  height: var(--theia-icon-size);\n  width: var(--theia-icon-size);\n}\n\n.theia-settings-container .settings-scope > label {\n  margin-right: 12px;\n}\n\n.theia-settings-container .settings-section {\n  padding-left: 0;\n  padding-top: var(--theia-ui-padding);\n  margin-top: calc(var(--theia-ui-padding) * -1);\n}\n\n.theia-settings-container .settings-section a {\n  border: none;\n  color: var(--theia-foreground);\n  font-weight: 500;\n  outline: 0;\n  text-decoration: none;\n}\n\n.theia-settings-container .command-link {\n  color: var(--theia-textLink-foreground);\n}\n\n.theia-settings-container .settings-section a:hover {\n  text-decoration: underline;\n}\n\n.theia-settings-container .settings-section-category-title {\n  font-weight: bold;\n  font-size: var(--theia-ui-font-size3);\n  padding-left: calc(2 * var(--theia-ui-padding));\n}\n\n.theia-settings-container .settings-section-subcategory-title {\n  font-weight: bold;\n  font-size: var(--theia-ui-font-size2);\n  padding-left: calc(2 * var(--theia-ui-padding));\n}\n\n.theia-settings-container .settings-section > li {\n  list-style-type: none;\n  margin: var(--theia-ui-padding) 0px;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: justify;\n  -ms-flex-pack: justify;\n  justify-content: space-between;\n  -webkit-box-align: start;\n  -ms-flex-align: start;\n  align-items: start;\n}\n\n.theia-settings-container li.single-pref {\n  list-style-type: none;\n  padding: 12px 14px 18px;\n  width: 100%;\n  display: flex;\n  flex-direction: column;\n  box-sizing: border-box;\n  position: relative;\n}\n\n.theia-settings-container li.single-pref p {\n  margin: 0;\n}\n\n.theia-settings-container li.single-pref:hover:not(:focus) {\n  background-color: var(--theia-settings-rowHoverBackground);\n}\n\n.theia-settings-container li.single-pref:focus {\n  background-color: var(--theia-settings-focusedRowBackground);\n  outline: 1px solid var(--theia-settings-focusedRowBorder);\n}\n\n.theia-settings-container li.single-pref .pref-context-gutter {\n  position: absolute;\n  height: calc(100% - 36px);\n  left: -22px;\n  padding-right: 8px;\n  border-right: 2px hidden;\n}\n\n.theia-settings-container .settings-context-menu-btn {\n  opacity: 0;\n  transition: opacity 0.5s;\n}\n\n.theia-settings-container\n  .single-pref:focus-within\n  .pref-context-gutter\n  .settings-context-menu-btn,\n.theia-settings-container\n  .pref-name:hover\n  + .pref-context-gutter\n  .settings-context-menu-btn,\n.theia-settings-container .pref-context-gutter:hover .settings-context-menu-btn,\n.theia-settings-container\n  .pref-context-gutter.show-cog\n  .settings-context-menu-btn {\n  opacity: 1;\n}\n\n.theia-settings-container\n  li.single-pref\n  .pref-context-gutter.theia-mod-item-modified {\n  border-right: 2px solid var(--theia-settings-modifiedItemIndicator);\n}\n\n.theia-settings-container li.single-pref input[type=\"text\"] {\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n\n.theia-settings-container .settings-main {\n  margin: 0;\n}\n\n.theia-settings-container .settings-main-sticky {\n  top: 0;\n  padding-top: calc(var(--theia-ui-padding));\n  margin-top: calc(var(--theia-ui-padding) * -1);\n  background-color: var(--theia-editor-background);\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  z-index: 1000;\n  display: flex;\n  flex-direction: column;\n  justify-content: space-around;\n}\n\n.theia-settings-container .pref-name {\n  padding: 0;\n  font-weight: bold;\n}\n\n.theia-settings-container .preference-leaf-headline-prefix {\n  color: var(--theia-descriptionForeground);\n}\n\n.preferences-tree-spacer {\n  padding-left: calc(var(--theia-ui-padding) / 2);\n  padding-right: calc(var(--theia-ui-padding) / 2);\n  min-width: var(--theia-icon-size);\n  min-height: var(--theia-icon-size);\n}\n\n.theia-settings-container .pref-description {\n  padding: var(--theia-ui-padding) 0;\n  color: var(--theia-descriptionForeground);\n  line-height: 18px;\n}\n\n.theia-settings-container .pref-description a {\n  text-decoration-line: none;\n  cursor: pointer;\n}\n\n.theia-settings-container .theia-select:focus {\n  outline-width: 1px;\n  outline-style: solid;\n  outline-offset: -1px;\n  opacity: 1 !important;\n  outline-color: var(--theia-focusBorder);\n}\n\n.theia-settings-container .theia-input[type=\"text\"] {\n  border: 1px solid var(--theia-dropdown-border);\n}\n\n.theia-settings-container .theia-input[type=\"checkbox\"]:focus,\n.theia-settings-container .theia-input[type=\"number\"]:focus {\n  outline-width: 1px;\n}\n\n.theia-settings-container .theia-input[type=\"checkbox\"] {\n  margin-left: 0;\n}\n\n/* Remove the spinners from input[type = number] on Firefox. */\n.theia-settings-container .theia-input[type=\"number\"] {\n  -webkit-appearance: textfield;\n  border: 1px solid var(--theia-dropdown-border);\n}\n\n/* Remove the webkit spinners from input[type = number] on all browsers except Firefox. */\n.theia-settings-container input::-webkit-outer-spin-button,\n.theia-settings-container input::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\n.dialogContent .error:not(:empty),\n.theia-settings-container .pref-content-container .pref-input .pref-input-container .pref-error-notification {\n  border-style: solid;\n  border-width: 1px;\n  border-color: var(--theia-inputValidation-errorBorder);\n  background-color: var(--theia-inputValidation-errorBackground);\n  width: 100%;\n  box-sizing: border-box;\n  padding: var(--theia-ui-padding);\n}\n\n.theia-settings-container\n  .pref-content-container\n  .pref-input\n  .pref-input-container {\n  display: flex;\n  flex-direction: column;\n}\n\n.theia-settings-container .pref-content-container a.theia-json-input {\n  text-decoration: underline;\n  color: var(--theia-titleBar-activeForeground);\n}\n\n.theia-settings-container .pref-content-container a.theia-json-input:hover {\n  text-decoration: none;\n  cursor: pointer;\n}\n\n.theia-settings-container .pref-content-container {\n  width: 100%;\n}\n\n.theia-settings-container .pref-content-container .pref-input {\n  padding: var(--theia-ui-padding) 0;\n  width: 100%;\n  max-width: 320px;\n}\n\n.theia-settings-container .pref-content-container .pref-input > select,\n.theia-settings-container\n  .pref-content-container\n  .pref-input\n  > input:not([type=\"checkbox\"]) {\n  width: 100%;\n}\n\n/* These specifications for the boolean class ensure that the\n    checkbox is rendered to the left of the description.\n*/\n.theia-settings-container .pref-content-container.boolean {\n  display: grid;\n  grid-template-columns: 20px 1fr;\n}\n\n.theia-settings-container .pref-content-container.boolean .pref-description {\n  grid-column-start: 2;\n  grid-row-start: 1;\n}\n\n.theia-settings-container .pref-content-container.boolean .pref-input {\n  grid-column-start: 1;\n  grid-row-start: 1;\n  margin: 0;\n}\n\n.theia-settings-container .settings-section > li:last-child {\n  margin-bottom: 20px;\n}\n\n.theia-settings-container .preference-leaf-headline-suffix {\n  font-weight: normal;\n  color: var(--theia-descriptionForeground);\n}\n\n.theia-settings-container .preference-leaf-headline-suffix::before {\n  content: \" (\";\n}\n\n.theia-settings-container .preference-leaf-headline-suffix::after {\n  content: \")\";\n}\n\n.theia-settings-container .preference-scope-underlined {\n  text-decoration: underline;\n  cursor: pointer;\n}\n\n.theia-settings-container\n  .preference-modified-scope-wrapper:not(:last-child)::after {\n  content: \", \";\n}\n\n/** Select component */\n\n.theia-settings-container .theia-select-component {\n  height: 26px;\n  width: 100%;\n  max-width: 320px;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-array.css":
/*!******************************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-array.css ***!
  \******************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.theia-settings-container .preference-array {
  list-style: none;
  padding: 0;
}

.theia-settings-container .preference-array-element {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: justify;
  -ms-flex-pack: justify;
  justify-content: space-between;
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
  padding: calc(var(--theia-ui-padding) / 2) var(--theia-ui-padding);
  border-bottom: var(--theia-panel-border) 2px solid;
}

.theia-settings-container .pref-input li:nth-last-child(2) {
  border-bottom: none;
}

.theia-settings-container .pref-input li:last-child {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
}

.theia-settings-container .preference-array-element:hover {
  background-color: rgba(50%, 50%, 50%, 0.1);
}

.theia-settings-container .preference-array-element-btn {
  width: 1.5em;
  height: 1.5em;
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: center;
  -ms-flex-pack: center;
  justify-content: center;
  -webkit-box-align: center;
  -ms-flex-align: center;
  align-items: center;
}

.theia-settings-container
  .preference-array-element
  .preference-array-element-btn {
  opacity: 0;
}

.theia-settings-container
  .preference-array-element:hover
  .preference-array-element-btn {
  opacity: 1;
}

.theia-settings-container .preference-array-element-btn:hover {
  background-color: rgba(50%, 50%, 50%, 0.1);
  cursor: pointer;
}

.theia-settings-container .preference-array .codicon.codicon-add {
  margin-left: calc((var(--theia-icon-size) + 4px) * -1);
  margin-right: 4px;
  width: var(--theia-icon-size);
  height: var(--theia-icon-size);
}

.theia-settings-container .preference-array-input {
  padding-right: calc(var(--theia-icon-size) + var(--theia-ui-padding));
  width: 100%;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/preferences/src/browser/style/preference-array.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,gBAAgB;EAChB,UAAU;AACZ;;AAEA;EACE,oBAAoB;EACpB,oBAAoB;EACpB,aAAa;EACb,yBAAyB;EACzB,sBAAsB;EACtB,8BAA8B;EAC9B,yBAAyB;EACzB,sBAAsB;EACtB,mBAAmB;EACnB,kEAAkE;EAClE,kDAAkD;AACpD;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,oBAAoB;EACpB,oBAAoB;EACpB,aAAa;EACb,yBAAyB;EACzB,sBAAsB;EACtB,mBAAmB;AACrB;;AAEA;EACE,0CAA0C;AAC5C;;AAEA;EACE,YAAY;EACZ,aAAa;EACb,oBAAoB;EACpB,oBAAoB;EACpB,aAAa;EACb,wBAAwB;EACxB,qBAAqB;EACrB,uBAAuB;EACvB,yBAAyB;EACzB,sBAAsB;EACtB,mBAAmB;AACrB;;AAEA;;;EAGE,UAAU;AACZ;;AAEA;;;EAGE,UAAU;AACZ;;AAEA;EACE,0CAA0C;EAC1C,eAAe;AACjB;;AAEA;EACE,sDAAsD;EACtD,iBAAiB;EACjB,6BAA6B;EAC7B,8BAA8B;AAChC;;AAEA;EACE,qEAAqE;EACrE,WAAW;AACb","sourcesContent":["/********************************************************************************\n * Copyright (C) 2020 Ericsson and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.theia-settings-container .preference-array {\n  list-style: none;\n  padding: 0;\n}\n\n.theia-settings-container .preference-array-element {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: justify;\n  -ms-flex-pack: justify;\n  justify-content: space-between;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  align-items: center;\n  padding: calc(var(--theia-ui-padding) / 2) var(--theia-ui-padding);\n  border-bottom: var(--theia-panel-border) 2px solid;\n}\n\n.theia-settings-container .pref-input li:nth-last-child(2) {\n  border-bottom: none;\n}\n\n.theia-settings-container .pref-input li:last-child {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  align-items: center;\n}\n\n.theia-settings-container .preference-array-element:hover {\n  background-color: rgba(50%, 50%, 50%, 0.1);\n}\n\n.theia-settings-container .preference-array-element-btn {\n  width: 1.5em;\n  height: 1.5em;\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: center;\n  -ms-flex-pack: center;\n  justify-content: center;\n  -webkit-box-align: center;\n  -ms-flex-align: center;\n  align-items: center;\n}\n\n.theia-settings-container\n  .preference-array-element\n  .preference-array-element-btn {\n  opacity: 0;\n}\n\n.theia-settings-container\n  .preference-array-element:hover\n  .preference-array-element-btn {\n  opacity: 1;\n}\n\n.theia-settings-container .preference-array-element-btn:hover {\n  background-color: rgba(50%, 50%, 50%, 0.1);\n  cursor: pointer;\n}\n\n.theia-settings-container .preference-array .codicon.codicon-add {\n  margin-left: calc((var(--theia-icon-size) + 4px) * -1);\n  margin-right: 4px;\n  width: var(--theia-icon-size);\n  height: var(--theia-icon-size);\n}\n\n.theia-settings-container .preference-array-input {\n  padding-right: calc(var(--theia-icon-size) + var(--theia-ui-padding));\n  width: 100%;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-context-menu.css":
/*!*************************************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-context-menu.css ***!
  \*************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.theia-settings-container .settings-context-menu-container {
  position: relative;
  padding-left: var(--theia-ui-padding);
}

.theia-settings-container .settings-context-menu-btn {
  cursor: pointer;
}

.theia-settings-container .settings-context-menu {
  position: absolute;
  width: var(--theia-settingsSidebar-width);
  list-style: none;
  padding: var(--theia-ui-padding);
  bottom: calc(100% + 10px);
  left: -10px;
  z-index: 9999;
  background-color: var(--theia-menu-background);
}

.theia-settings-container .settings-context-menu:before {
  content: "";
  position: absolute;
  left: 10px;
  bottom: -10px;
  width: 0;
  height: 0;
  border-left: 10px solid transparent;
  border-right: 10px solid transparent;
  border-top: 10px solid var(--theia-menu-background);
}

.theia-settings-container .settings-context-menu li {
  padding: var(--theia-ui-padding);
}

.theia-settings-container .settings-context-menu li:hover {
  background-color: var(--theia-menu-selectionBackground);
}

.theia-settings-container .settings-context-menu i {
  padding-right: var(--theia-ui-padding);
  width: var(--theia-icon-size);
  display: -webkit-inline-box;
  display: -ms-inline-flexbox;
  display: inline-flex;
  -webkit-box-pack: center;
  -ms-flex-pack: center;
  justify-content: center;
}

.theia-settings-container .pref-context-menu-btn {
  margin-left: 5px;
}

.theia-settings-container .pref-context-menu-btn:hover {
  background-color: rgba(50%, 50%, 50%, 0.1);
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/preferences/src/browser/style/preference-context-menu.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,kBAAkB;EAClB,qCAAqC;AACvC;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,kBAAkB;EAClB,yCAAyC;EACzC,gBAAgB;EAChB,gCAAgC;EAChC,yBAAyB;EACzB,WAAW;EACX,aAAa;EACb,8CAA8C;AAChD;;AAEA;EACE,WAAW;EACX,kBAAkB;EAClB,UAAU;EACV,aAAa;EACb,QAAQ;EACR,SAAS;EACT,mCAAmC;EACnC,oCAAoC;EACpC,mDAAmD;AACrD;;AAEA;EACE,gCAAgC;AAClC;;AAEA;EACE,uDAAuD;AACzD;;AAEA;EACE,sCAAsC;EACtC,6BAA6B;EAC7B,2BAA2B;EAC3B,2BAA2B;EAC3B,oBAAoB;EACpB,wBAAwB;EACxB,qBAAqB;EACrB,uBAAuB;AACzB;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,0CAA0C;AAC5C","sourcesContent":["/********************************************************************************\n * Copyright (C) 2020 Ericsson and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.theia-settings-container .settings-context-menu-container {\n  position: relative;\n  padding-left: var(--theia-ui-padding);\n}\n\n.theia-settings-container .settings-context-menu-btn {\n  cursor: pointer;\n}\n\n.theia-settings-container .settings-context-menu {\n  position: absolute;\n  width: var(--theia-settingsSidebar-width);\n  list-style: none;\n  padding: var(--theia-ui-padding);\n  bottom: calc(100% + 10px);\n  left: -10px;\n  z-index: 9999;\n  background-color: var(--theia-menu-background);\n}\n\n.theia-settings-container .settings-context-menu:before {\n  content: \"\";\n  position: absolute;\n  left: 10px;\n  bottom: -10px;\n  width: 0;\n  height: 0;\n  border-left: 10px solid transparent;\n  border-right: 10px solid transparent;\n  border-top: 10px solid var(--theia-menu-background);\n}\n\n.theia-settings-container .settings-context-menu li {\n  padding: var(--theia-ui-padding);\n}\n\n.theia-settings-container .settings-context-menu li:hover {\n  background-color: var(--theia-menu-selectionBackground);\n}\n\n.theia-settings-container .settings-context-menu i {\n  padding-right: var(--theia-ui-padding);\n  width: var(--theia-icon-size);\n  display: -webkit-inline-box;\n  display: -ms-inline-flexbox;\n  display: inline-flex;\n  -webkit-box-pack: center;\n  -ms-flex-pack: center;\n  justify-content: center;\n}\n\n.theia-settings-container .pref-context-menu-btn {\n  margin-left: 5px;\n}\n\n.theia-settings-container .pref-context-menu-btn:hover {\n  background-color: rgba(50%, 50%, 50%, 0.1);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-file.css":
/*!*****************************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-file.css ***!
  \*****************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2022 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.theia-settings-container .preference-file-container {
  position: relative;
  display: flex;
  align-items: center;
}

.theia-settings-container .preference-file-input {
  flex: 1;
  padding-right: 4px;
}

.theia-settings-container .preference-file-button {
  margin-left: 0px;
  height: calc(var(--theia-content-line-height) + 4px);
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/preferences/src/browser/style/preference-file.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,kBAAkB;EAClB,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,OAAO;EACP,kBAAkB;AACpB;;AAEA;EACE,gBAAgB;EAChB,oDAAoD;AACtD","sourcesContent":["/********************************************************************************\n * Copyright (C) 2022 EclipseSource and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.theia-settings-container .preference-file-container {\n  position: relative;\n  display: flex;\n  align-items: center;\n}\n\n.theia-settings-container .preference-file-input {\n  flex: 1;\n  padding-right: 4px;\n}\n\n.theia-settings-container .preference-file-button {\n  margin-left: 0px;\n  height: calc(var(--theia-content-line-height) + 4px);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-object.css":
/*!*******************************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/preference-object.css ***!
  \*******************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.theia-settings-container .object-preference-input-container {
  display: -webkit-box;
  display: -ms-flexbox;
  display: flex;
  -webkit-box-pack: justify;
  -ms-flex-pack: justify;
  justify-content: space-between;
  -ms-flex-wrap: wrap;
  flex-wrap: wrap;
}

.theia-settings-container .object-preference-input {
  width: 100%;
  max-height: 250px;
  resize: none;
  color: var(--theia-settings-textInputForeground);
  background-color: var(--theia-settings-textInputBackground);
  border-color: var(--theia-panel-border);
  font-size: var(--theia-code-font-size);
  margin-bottom: 10px;
}

.theia-settings-container .object-preference-input-btn-toggle {
  padding: 0 calc(var(--theia-ui-padding) / 2);
}

.theia-settings-container .object-preference-input-btn-toggle-icon {
  display: inline-block;
  background: var(--theia-icon-open-json) no-repeat;
  background-position-y: 1px;
  height: var(--theia-icon-size);
  width: var(--theia-icon-size);
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/preferences/src/browser/style/preference-object.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,oBAAoB;EACpB,oBAAoB;EACpB,aAAa;EACb,yBAAyB;EACzB,sBAAsB;EACtB,8BAA8B;EAC9B,mBAAmB;EACnB,eAAe;AACjB;;AAEA;EACE,WAAW;EACX,iBAAiB;EACjB,YAAY;EACZ,gDAAgD;EAChD,2DAA2D;EAC3D,uCAAuC;EACvC,sCAAsC;EACtC,mBAAmB;AACrB;;AAEA;EACE,4CAA4C;AAC9C;;AAEA;EACE,qBAAqB;EACrB,iDAAiD;EACjD,0BAA0B;EAC1B,8BAA8B;EAC9B,6BAA6B;AAC/B","sourcesContent":["/********************************************************************************\n * Copyright (C) 2020 Ericsson and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.theia-settings-container .object-preference-input-container {\n  display: -webkit-box;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-pack: justify;\n  -ms-flex-pack: justify;\n  justify-content: space-between;\n  -ms-flex-wrap: wrap;\n  flex-wrap: wrap;\n}\n\n.theia-settings-container .object-preference-input {\n  width: 100%;\n  max-height: 250px;\n  resize: none;\n  color: var(--theia-settings-textInputForeground);\n  background-color: var(--theia-settings-textInputBackground);\n  border-color: var(--theia-panel-border);\n  font-size: var(--theia-code-font-size);\n  margin-bottom: 10px;\n}\n\n.theia-settings-container .object-preference-input-btn-toggle {\n  padding: 0 calc(var(--theia-ui-padding) / 2);\n}\n\n.theia-settings-container .object-preference-input-btn-toggle-icon {\n  display: inline-block;\n  background: var(--theia-icon-open-json) no-repeat;\n  background-position-y: 1px;\n  height: var(--theia-icon-size);\n  width: var(--theia-icon-size);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/search-input.css":
/*!**************************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/preferences/src/browser/style/search-input.css ***!
  \**************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.theia-settings-container .settings-search-container {
  display: flex;
  align-items: center;
}

.theia-settings-container .settings-search-container .settings-search-input {
  flex: 1;
  text-indent: 8px;
  padding: calc(var(--theia-ui-padding) / 2) 0;
  box-sizing: border-box;
  border: 1px solid var(--theia-dropdown-border);
}

.theia-settings-container .settings-search-container .option-buttons {
  height: 23px;
  align-items: center;
  position: absolute;
  z-index: 999;
  right: 5px;
  display: flex;
}

.theia-settings-container .settings-search-container .clear-all {
  background: var(--theia-icon-clear);
}

.theia-settings-container .settings-search-container .results-found {
  background-color: var(--theia-badge-background);
  border-radius: 2px;
  color: var(--theia-badge-foreground);
  padding: calc(var(--theia-ui-padding) / 5) calc(var(--theia-ui-padding) / 2);
}

.theia-settings-container .settings-search-container .option {
  width: 21px;
  height: 21px;
  margin: 0 1px;
  display: inline-block;
  box-sizing: border-box;
  user-select: none;
  background-repeat: no-repeat;
  background-position: center;
  border: var(--theia-border-width) solid transparent;
  opacity: 0.7;
  cursor: pointer;
}

.theia-settings-container .settings-search-container .enabled {
  opacity: 1;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/preferences/src/browser/style/search-input.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,OAAO;EACP,gBAAgB;EAChB,4CAA4C;EAC5C,sBAAsB;EACtB,8CAA8C;AAChD;;AAEA;EACE,YAAY;EACZ,mBAAmB;EACnB,kBAAkB;EAClB,YAAY;EACZ,UAAU;EACV,aAAa;AACf;;AAEA;EACE,mCAAmC;AACrC;;AAEA;EACE,+CAA+C;EAC/C,kBAAkB;EAClB,oCAAoC;EACpC,4EAA4E;AAC9E;;AAEA;EACE,WAAW;EACX,YAAY;EACZ,aAAa;EACb,qBAAqB;EACrB,sBAAsB;EACtB,iBAAiB;EACjB,4BAA4B;EAC5B,2BAA2B;EAC3B,mDAAmD;EACnD,YAAY;EACZ,eAAe;AACjB;;AAEA;EACE,UAAU;AACZ","sourcesContent":["/********************************************************************************\n * Copyright (C) 2020 Ericsson and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.theia-settings-container .settings-search-container {\n  display: flex;\n  align-items: center;\n}\n\n.theia-settings-container .settings-search-container .settings-search-input {\n  flex: 1;\n  text-indent: 8px;\n  padding: calc(var(--theia-ui-padding) / 2) 0;\n  box-sizing: border-box;\n  border: 1px solid var(--theia-dropdown-border);\n}\n\n.theia-settings-container .settings-search-container .option-buttons {\n  height: 23px;\n  align-items: center;\n  position: absolute;\n  z-index: 999;\n  right: 5px;\n  display: flex;\n}\n\n.theia-settings-container .settings-search-container .clear-all {\n  background: var(--theia-icon-clear);\n}\n\n.theia-settings-container .settings-search-container .results-found {\n  background-color: var(--theia-badge-background);\n  border-radius: 2px;\n  color: var(--theia-badge-foreground);\n  padding: calc(var(--theia-ui-padding) / 5) calc(var(--theia-ui-padding) / 2);\n}\n\n.theia-settings-container .settings-search-container .option {\n  width: 21px;\n  height: 21px;\n  margin: 0 1px;\n  display: inline-block;\n  box-sizing: border-box;\n  user-select: none;\n  background-repeat: no-repeat;\n  background-position: center;\n  border: var(--theia-border-width) solid transparent;\n  opacity: 0.7;\n  cursor: pointer;\n}\n\n.theia-settings-container .settings-search-container .enabled {\n  opacity: 1;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_preferences_lib_browser_preference-frontend-module_js-node_modules-a96d91.js.map