"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_core_lib_electron-browser_window_electron-window-module_js"],{

/***/ "../../node_modules/@theia/core/lib/browser/window/default-secondary-window-service.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/browser/window/default-secondary-window-service.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var DefaultSecondaryWindowService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultSecondaryWindowService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2022 STMicroelectronics, Ericsson, ARM, EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const window_service_1 = __webpack_require__(/*! ./window-service */ "../../node_modules/@theia/core/lib/browser/window/window-service.js");
const saveable_1 = __webpack_require__(/*! ../saveable */ "../../node_modules/@theia/core/lib/browser/saveable.js");
const preferences_1 = __webpack_require__(/*! ../preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/core/lib/common/index.js");
const saveable_service_1 = __webpack_require__(/*! ../saveable-service */ "../../node_modules/@theia/core/lib/browser/saveable-service.js");
let DefaultSecondaryWindowService = DefaultSecondaryWindowService_1 = class DefaultSecondaryWindowService {
    constructor() {
        this.onWindowOpenedEmitter = new common_1.Emitter;
        this.onWindowOpened = this.onWindowOpenedEmitter.event;
        this.onWindowClosedEmitter = new common_1.Emitter;
        this.onWindowClosed = this.onWindowClosedEmitter.event;
        /**
         * Randomized prefix to be included in opened windows' ids.
         * This avoids conflicts when creating sub-windows from multiple theia instances (e.g. by opening Theia multiple times in the same browser)
         */
        this.prefix = crypto.getRandomValues(new Uint32Array(1))[0];
        /** Unique id. Increase after every access. */
        this.nextId = 0;
        this.secondaryWindows = [];
    }
    init() {
        // Set up messaging with secondary windows
        window.addEventListener('message', (event) => {
            console.trace('Message on main window', event);
            if (event.data.fromSecondary) {
                console.trace('Message comes from secondary window');
                return;
            }
            if (event.data.fromMain) {
                console.trace('Message has mainWindow marker, therefore ignore it');
                return;
            }
            // Filter setImmediate messages. Do not forward because these come in with very high frequency.
            // They are not needed in secondary windows because these messages are just a work around
            // to make setImmediate work in the main window: https://developer.mozilla.org/en-US/docs/Web/API/Window/setImmediate
            if (typeof event.data === 'string' && event.data.startsWith('setImmediate')) {
                return;
            }
            console.trace('Delegate main window message to secondary windows', event);
            this.secondaryWindows.forEach(secondaryWindow => {
                if (!secondaryWindow.window.closed) {
                    secondaryWindow.window.postMessage({ ...event.data, fromMain: true }, '*');
                }
            });
        });
        // Close all open windows when the main window is closed.
        this.windowService.onUnload(() => {
            // Iterate backwards because calling window.close might remove the window from the array
            for (let i = this.secondaryWindows.length - 1; i >= 0; i--) {
                this.secondaryWindows[i].close();
            }
        });
    }
    createSecondaryWindow(widget, shell) {
        var _a;
        const [height, width, left, top] = this.findSecondaryWindowCoordinates(widget);
        let options = `popup=1,width=${width},height=${height},left=${left},top=${top}`;
        if (this.preferenceService.get('window.secondaryWindowAlwaysOnTop')) {
            options += ',alwaysOnTop=true';
        }
        const newWindow = (_a = window.open(DefaultSecondaryWindowService_1.SECONDARY_WINDOW_URL, this.nextWindowId(), options)) !== null && _a !== void 0 ? _a : undefined;
        if (newWindow) {
            this.secondaryWindows.push(newWindow);
            this.onWindowOpenedEmitter.fire(newWindow);
            newWindow.addEventListener('DOMContentLoaded', () => {
                newWindow.addEventListener('beforeunload', evt => {
                    const saveable = saveable_1.Saveable.get(widget);
                    const wouldLoseState = !!saveable && saveable.dirty && this.saveResourceService.autoSave === 'off';
                    if (wouldLoseState) {
                        evt.returnValue = '';
                        evt.preventDefault();
                        return 'non-empty';
                    }
                }, { capture: true });
                newWindow.addEventListener('unload', () => {
                    const saveable = saveable_1.Saveable.get(widget);
                    shell.closeWidget(widget.id, {
                        save: !!saveable && saveable.dirty && this.saveResourceService.autoSave !== 'off'
                    });
                    const extIndex = this.secondaryWindows.indexOf(newWindow);
                    if (extIndex > -1) {
                        this.onWindowClosedEmitter.fire(newWindow);
                        this.secondaryWindows.splice(extIndex, 1);
                    }
                    ;
                });
                this.windowCreated(newWindow, widget, shell);
            });
        }
        return newWindow;
    }
    windowCreated(newWindow, widget, shell) {
        newWindow.addEventListener('unload', () => {
            shell.closeWidget(widget.id);
        });
    }
    findWindow(windowName) {
        for (const w of this.secondaryWindows) {
            if (w.name === windowName) {
                return w;
            }
        }
        return undefined;
    }
    findSecondaryWindowCoordinates(widget) {
        const clientBounds = widget.node.getBoundingClientRect();
        const preference = this.preferenceService.get('window.secondaryWindowPlacement');
        let height;
        let width;
        let left;
        let top;
        const offsetY = 20; // Offset to avoid the window title bar
        switch (preference) {
            case 'originalSize': {
                height = widget.node.clientHeight;
                width = widget.node.clientWidth;
                left = window.screenLeft + clientBounds.x;
                top = window.screenTop + (window.outerHeight - window.innerHeight) + offsetY;
                if (common_1.environment.electron.is()) {
                    top = window.screenTop + clientBounds.y;
                }
                break;
            }
            case 'halfWidth': {
                height = window.innerHeight - (window.outerHeight - window.innerHeight);
                width = window.innerWidth / 2;
                left = window.screenLeft;
                top = window.screenTop;
                if (!common_1.environment.electron.is()) {
                    height = window.innerHeight + clientBounds.y - offsetY;
                }
                break;
            }
            case 'fullSize': {
                height = window.innerHeight - (window.outerHeight - window.innerHeight);
                width = window.innerWidth;
                left = window.screenLeft;
                top = window.screenTop;
                if (!common_1.environment.electron.is()) {
                    height = window.innerHeight + clientBounds.y - offsetY;
                }
                break;
            }
        }
        return [height, width, left, top];
    }
    focus(win) {
        win.focus();
    }
    nextWindowId() {
        return `${this.prefix}-secondaryWindow-${this.nextId++}`;
    }
};
exports.DefaultSecondaryWindowService = DefaultSecondaryWindowService;
// secondary-window.html is part of Theia's generated code. It is generated by dev-packages/application-manager/src/generator/frontend-generator.ts
DefaultSecondaryWindowService.SECONDARY_WINDOW_URL = 'secondary-window.html';
tslib_1.__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    tslib_1.__metadata("design:type", Object)
], DefaultSecondaryWindowService.prototype, "windowService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(preferences_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], DefaultSecondaryWindowService.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(saveable_service_1.SaveableService),
    tslib_1.__metadata("design:type", saveable_service_1.SaveableService)
], DefaultSecondaryWindowService.prototype, "saveResourceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], DefaultSecondaryWindowService.prototype, "init", null);
exports.DefaultSecondaryWindowService = DefaultSecondaryWindowService = DefaultSecondaryWindowService_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultSecondaryWindowService);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/browser/window/default-window-service.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/browser/window/default-window-service.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultWindowService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/core/lib/common/index.js");
const core_preferences_1 = __webpack_require__(/*! ../core-preferences */ "../../node_modules/@theia/core/lib/browser/core-preferences.js");
const contribution_provider_1 = __webpack_require__(/*! ../../common/contribution-provider */ "../../node_modules/@theia/core/lib/common/contribution-provider.js");
const frontend_application_contribution_1 = __webpack_require__(/*! ../frontend-application-contribution */ "../../node_modules/@theia/core/lib/browser/frontend-application-contribution.js");
const window_1 = __webpack_require__(/*! ../../common/window */ "../../node_modules/@theia/core/lib/common/window.js");
const dialogs_1 = __webpack_require__(/*! ../dialogs */ "../../node_modules/@theia/core/lib/browser/dialogs.js");
const frontend_application_state_1 = __webpack_require__(/*! ../../common/frontend-application-state */ "../../node_modules/@theia/core/lib/common/frontend-application-state.js");
let DefaultWindowService = class DefaultWindowService {
    constructor() {
        this.allowVetoes = true;
        this.onUnloadEmitter = new common_1.Emitter();
    }
    get onUnload() {
        return this.onUnloadEmitter.event;
    }
    onStart(app) {
        this.frontendApplication = app;
        this.registerUnloadListeners();
    }
    openNewWindow(url) {
        window.open(url, undefined, 'noopener');
        return undefined;
    }
    openNewDefaultWindow() {
        this.openNewWindow(`#${window_1.DEFAULT_WINDOW_HASH}`);
    }
    focus() {
        window.focus();
    }
    /**
     * Returns a list of actions that {@link FrontendApplicationContribution}s would like to take before shutdown
     * It is expected that this will succeed - i.e. return an empty array - at most once per session. If no vetoes are received
     * during any cycle, no further checks will be made. In that case, shutdown should proceed unconditionally.
     */
    collectContributionUnloadVetoes() {
        var _a;
        const vetoes = [];
        if (this.allowVetoes) {
            const shouldConfirmExit = this.corePreferences['application.confirmExit'];
            for (const contribution of this.contributions.getContributions()) {
                const veto = (_a = contribution.onWillStop) === null || _a === void 0 ? void 0 : _a.call(contribution, this.frontendApplication);
                if (veto && shouldConfirmExit !== 'never') { // Ignore vetoes if we should not prompt the user on exit.
                    if (frontend_application_contribution_1.OnWillStopAction.is(veto)) {
                        vetoes.push(veto);
                    }
                    else {
                        vetoes.push({ reason: 'No reason given', action: () => false });
                    }
                }
            }
            vetoes.sort((a, b) => { var _a, _b; return ((_a = a.priority) !== null && _a !== void 0 ? _a : -Infinity) - ((_b = b.priority) !== null && _b !== void 0 ? _b : -Infinity); });
            if (vetoes.length === 0 && shouldConfirmExit === 'always') {
                vetoes.push({ reason: 'application.confirmExit preference', action: () => (0, dialogs_1.confirmExit)() });
            }
            if (vetoes.length === 0) {
                this.allowVetoes = false;
            }
        }
        return vetoes;
    }
    /**
     * Implement the mechanism to detect unloading of the page.
     */
    registerUnloadListeners() {
        window.addEventListener('beforeunload', event => this.handleBeforeUnloadEvent(event));
        // In a browser, `unload` is correctly fired when the page unloads, unlike Electron.
        // If `beforeunload` is cancelled, the user will be prompted to leave or stay.
        // If the user stays, the page won't be unloaded, so `unload` is not fired.
        // If the user leaves, the page will be unloaded, so `unload` is fired.
        window.addEventListener('unload', () => this.onUnloadEmitter.fire());
    }
    async isSafeToShutDown(stopReason) {
        const vetoes = this.collectContributionUnloadVetoes();
        if (vetoes.length === 0) {
            return true;
        }
        const preparedValues = await Promise.all(vetoes.map(e => { var _a; return (_a = e.prepare) === null || _a === void 0 ? void 0 : _a.call(e, stopReason); }));
        console.debug('Shutdown prevented by', vetoes.map(({ reason }) => reason).join(', '));
        for (let i = 0; i < vetoes.length; i++) {
            try {
                const result = await vetoes[i].action(preparedValues[i], stopReason);
                if (!result) {
                    return false;
                }
            }
            catch (e) {
                console.error(e);
            }
        }
        console.debug('OnWillStop actions resolved; allowing shutdown');
        this.allowVetoes = false;
        return true;
    }
    setSafeToShutDown() {
        this.allowVetoes = false;
    }
    /**
     * Called when the `window` is about to `unload` its resources.
     * At this point, the `document` is still visible and the [`BeforeUnloadEvent`](https://developer.mozilla.org/en-US/docs/Web/API/Window/beforeunload_event)
     * event will be canceled if the return value of this method is `false`.
     *
     * In Electron, handleCloseRequestEvent is is run instead.
     */
    handleBeforeUnloadEvent(event) {
        const vetoes = this.collectContributionUnloadVetoes();
        if (vetoes.length) {
            // In the browser, we don't call the functions because this has to finish in a single tick, so we treat any desired action as a veto.
            console.debug('Shutdown prevented by', vetoes.map(({ reason }) => reason).join(', '));
            return this.preventUnload(event);
        }
        console.debug('Shutdown will proceed.');
    }
    /**
     * Notify the browser that we do not want to unload.
     *
     * Notes:
     *  - Shows a confirmation popup in browsers.
     *  - Prevents the window from closing without confirmation in electron.
     *
     * @param event The beforeunload event
     */
    preventUnload(event) {
        event.returnValue = '';
        event.preventDefault();
        return '';
    }
    reload() {
        this.isSafeToShutDown(frontend_application_state_1.StopReason.Reload).then(isSafe => {
            if (isSafe) {
                window.location.reload();
            }
        });
    }
};
exports.DefaultWindowService = DefaultWindowService;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_preferences_1.CorePreferences),
    tslib_1.__metadata("design:type", Object)
], DefaultWindowService.prototype, "corePreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(contribution_provider_1.ContributionProvider),
    (0, inversify_1.named)(frontend_application_contribution_1.FrontendApplicationContribution),
    tslib_1.__metadata("design:type", Object)
], DefaultWindowService.prototype, "contributions", void 0);
exports.DefaultWindowService = DefaultWindowService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultWindowService);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/common/window.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@theia/core/lib/common/window.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DEFAULT_WINDOW_HASH = void 0;
/**
 * The window hash value that is used to spawn a new default window.
 */
exports.DEFAULT_WINDOW_HASH = '!empty';


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/electron-clipboard-service.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/electron-clipboard-service.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2019 RedHat and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronClipboardService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// eslint-disable-next-line import/no-extraneous-dependencies
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
let ElectronClipboardService = class ElectronClipboardService {
    readText() {
        return window.electronTheiaCore.readClipboard();
    }
    writeText(value) {
        window.electronTheiaCore.writeClipboard(value);
    }
};
exports.ElectronClipboardService = ElectronClipboardService;
exports.ElectronClipboardService = ElectronClipboardService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ElectronClipboardService);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/electron-uri-handler.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/electron-uri-handler.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronUriHandlerContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! ../browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/core/lib/common/index.js");
let ElectronUriHandlerContribution = class ElectronUriHandlerContribution {
    initialize() {
        window.electronTheiaCore.setOpenUrlHandler(async (url) => {
            const uri = new common_1.URI(url);
            try {
                const handler = await this.openenerService.getOpener(uri);
                if (handler) {
                    await handler.open(uri);
                    return true;
                }
            }
            catch (e) {
                // no handler
            }
            return false;
        });
    }
};
exports.ElectronUriHandlerContribution = ElectronUriHandlerContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], ElectronUriHandlerContribution.prototype, "openenerService", void 0);
exports.ElectronUriHandlerContribution = ElectronUriHandlerContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ElectronUriHandlerContribution);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/window/electron-frontend-application-state.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/window/electron-frontend-application-state.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronFrontendApplicationStateService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const frontend_application_state_1 = __webpack_require__(/*! ../../browser/frontend-application-state */ "../../node_modules/@theia/core/lib/browser/frontend-application-state.js");
let ElectronFrontendApplicationStateService = class ElectronFrontendApplicationStateService extends frontend_application_state_1.FrontendApplicationStateService {
    doSetState(state) {
        super.doSetState(state);
        window.electronTheiaCore.applicationStateChanged(state);
    }
};
exports.ElectronFrontendApplicationStateService = ElectronFrontendApplicationStateService;
exports.ElectronFrontendApplicationStateService = ElectronFrontendApplicationStateService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ElectronFrontendApplicationStateService);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/window/electron-secondary-window-service.js":
/*!*******************************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/window/electron-secondary-window-service.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 STMicroelectronics, Ericsson, ARM, EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronSecondaryWindowService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const default_secondary_window_service_1 = __webpack_require__(/*! ../../browser/window/default-secondary-window-service */ "../../node_modules/@theia/core/lib/browser/window/default-secondary-window-service.js");
let ElectronSecondaryWindowService = class ElectronSecondaryWindowService extends default_secondary_window_service_1.DefaultSecondaryWindowService {
    focus(win) {
        window.electronTheiaCore.focusWindow(win.name);
    }
    windowCreated(newWindow, widget, shell) {
        window.electronTheiaCore.setMenuBarVisible(false, newWindow.name);
        window.electronTheiaCore.setSecondaryWindowCloseRequestHandler(newWindow.name, () => this.canClose(widget, shell));
    }
    async canClose(widget, shell) {
        await shell.closeWidget(widget.id);
        return widget.isDisposed;
    }
};
exports.ElectronSecondaryWindowService = ElectronSecondaryWindowService;
exports.ElectronSecondaryWindowService = ElectronSecondaryWindowService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ElectronSecondaryWindowService);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/window/electron-window-module.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/window/electron-window-module.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const browser_1 = __webpack_require__(/*! ../../browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const clipboard_service_1 = __webpack_require__(/*! ../../browser/clipboard-service */ "../../node_modules/@theia/core/lib/browser/clipboard-service.js");
const frontend_application_contribution_1 = __webpack_require__(/*! ../../browser/frontend-application-contribution */ "../../node_modules/@theia/core/lib/browser/frontend-application-contribution.js");
const frontend_application_state_1 = __webpack_require__(/*! ../../browser/frontend-application-state */ "../../node_modules/@theia/core/lib/browser/frontend-application-state.js");
const secondary_window_service_1 = __webpack_require__(/*! ../../browser/window/secondary-window-service */ "../../node_modules/@theia/core/lib/browser/window/secondary-window-service.js");
const window_service_1 = __webpack_require__(/*! ../../browser/window/window-service */ "../../node_modules/@theia/core/lib/browser/window/window-service.js");
const electron_main_window_service_1 = __webpack_require__(/*! ../../electron-common/electron-main-window-service */ "../../node_modules/@theia/core/lib/electron-common/electron-main-window-service.js");
const electron_clipboard_service_1 = __webpack_require__(/*! ../electron-clipboard-service */ "../../node_modules/@theia/core/lib/electron-browser/electron-clipboard-service.js");
const electron_ipc_connection_source_1 = __webpack_require__(/*! ../messaging/electron-ipc-connection-source */ "../../node_modules/@theia/core/lib/electron-browser/messaging/electron-ipc-connection-source.js");
const electron_frontend_application_state_1 = __webpack_require__(/*! ./electron-frontend-application-state */ "../../node_modules/@theia/core/lib/electron-browser/window/electron-frontend-application-state.js");
const electron_secondary_window_service_1 = __webpack_require__(/*! ./electron-secondary-window-service */ "../../node_modules/@theia/core/lib/electron-browser/window/electron-secondary-window-service.js");
const electron_window_preferences_1 = __webpack_require__(/*! ./electron-window-preferences */ "../../node_modules/@theia/core/lib/electron-browser/window/electron-window-preferences.js");
const electron_window_service_1 = __webpack_require__(/*! ./electron-window-service */ "../../node_modules/@theia/core/lib/electron-browser/window/electron-window-service.js");
const external_app_open_handler_1 = __webpack_require__(/*! ./external-app-open-handler */ "../../node_modules/@theia/core/lib/electron-browser/window/external-app-open-handler.js");
const electron_uri_handler_1 = __webpack_require__(/*! ../electron-uri-handler */ "../../node_modules/@theia/core/lib/electron-browser/electron-uri-handler.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/core/lib/common/index.js");
const window_title_service_1 = __webpack_require__(/*! ../../browser/window/window-title-service */ "../../node_modules/@theia/core/lib/browser/window/window-title-service.js");
exports["default"] = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(electron_main_window_service_1.ElectronMainWindowService).toDynamicValue(context => electron_ipc_connection_source_1.ElectronIpcConnectionProvider.createProxy(context.container, electron_main_window_service_1.electronMainWindowServicePath)).inSingletonScope();
    (0, electron_window_preferences_1.bindWindowPreferences)(bind);
    bind(window_service_1.WindowService).to(electron_window_service_1.ElectronWindowService).inSingletonScope();
    bind(frontend_application_contribution_1.FrontendApplicationContribution).toService(window_service_1.WindowService);
    bind(electron_uri_handler_1.ElectronUriHandlerContribution).toSelf().inSingletonScope();
    bind(frontend_application_contribution_1.FrontendApplicationContribution).toService(electron_uri_handler_1.ElectronUriHandlerContribution);
    bind(clipboard_service_1.ClipboardService).to(electron_clipboard_service_1.ElectronClipboardService).inSingletonScope();
    rebind(frontend_application_state_1.FrontendApplicationStateService).to(electron_frontend_application_state_1.ElectronFrontendApplicationStateService).inSingletonScope();
    bind(secondary_window_service_1.SecondaryWindowService).to(electron_secondary_window_service_1.ElectronSecondaryWindowService).inSingletonScope();
    bind(external_app_open_handler_1.ExternalAppOpenHandler).toSelf().inSingletonScope();
    bind(browser_1.OpenHandler).toService(external_app_open_handler_1.ExternalAppOpenHandler);
    (0, common_1.bindContributionProvider)(bind, window_title_service_1.WindowTitleContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/window/electron-window-preferences.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/window/electron-window-preferences.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindWindowPreferences = exports.createElectronWindowPreferences = exports.ElectronWindowPreferences = exports.ElectronWindowPreferenceContribution = exports.ElectronWindowConfiguration = exports.electronWindowPreferencesSchema = exports.ZoomLevel = void 0;
const nls_1 = __webpack_require__(/*! ../../common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const preferences_1 = __webpack_require__(/*! ../../browser/preferences */ "../../node_modules/@theia/core/lib/browser/preferences/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/core/lib/common/index.js");
var ZoomLevel;
(function (ZoomLevel) {
    ZoomLevel.DEFAULT = 0;
    // copied from https://github.com/microsoft/vscode/blob/dda96b69bfc63f309e60cfc5f98cb863c46b32ac/src/vs/workbench/electron-sandbox/actions/windowActions.ts#L47-L48
    ZoomLevel.MIN = -8;
    ZoomLevel.MAX = 9;
    // amount to increment or decrement the window zoom level.
    ZoomLevel.VARIATION = 0.5;
})(ZoomLevel || (exports.ZoomLevel = ZoomLevel = {}));
exports.electronWindowPreferencesSchema = {
    type: 'object',
    properties: {
        'window.zoomLevel': {
            'type': 'number',
            'default': ZoomLevel.DEFAULT,
            'minimum': ZoomLevel.MIN,
            'maximum': ZoomLevel.MAX,
            'scope': 'application',
            // eslint-disable-next-line max-len
            'description': nls_1.nls.localizeByDefault("Adjust the default zoom level for all windows. Each increment above `0` (e.g. `1`) or below (e.g. `-1`) represents zooming `20%` larger or smaller. You can also enter decimals to adjust the zoom level with a finer granularity. See {0} for configuring if the 'Zoom In' and 'Zoom Out' commands apply the zoom level to all windows or only the active window.")
        },
        'window.titleBarStyle': {
            type: 'string',
            enum: ['native', 'custom'],
            default: common_1.isWindows ? 'custom' : 'native',
            scope: 'application',
            // eslint-disable-next-line max-len
            description: nls_1.nls.localizeByDefault('Adjust the appearance of the window title bar to be native by the OS or custom. On Linux and Windows, this setting also affects the application and context menu appearances. Changes require a full restart to apply.'),
            included: !common_1.isOSX
        },
    }
};
class ElectronWindowConfiguration {
}
exports.ElectronWindowConfiguration = ElectronWindowConfiguration;
exports.ElectronWindowPreferenceContribution = Symbol('ElectronWindowPreferenceContribution');
exports.ElectronWindowPreferences = Symbol('ElectronWindowPreferences');
function createElectronWindowPreferences(preferences, schema = exports.electronWindowPreferencesSchema) {
    return (0, preferences_1.createPreferenceProxy)(preferences, schema);
}
exports.createElectronWindowPreferences = createElectronWindowPreferences;
function bindWindowPreferences(bind) {
    bind(exports.ElectronWindowPreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(preferences_1.PreferenceService);
        const contribution = ctx.container.get(exports.ElectronWindowPreferenceContribution);
        return createElectronWindowPreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.ElectronWindowPreferenceContribution).toConstantValue({ schema: exports.electronWindowPreferencesSchema });
    bind(preferences_1.PreferenceContribution).toService(exports.ElectronWindowPreferenceContribution);
}
exports.bindWindowPreferences = bindWindowPreferences;


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/window/electron-window-service.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/window/electron-window-service.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronWindowService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const default_window_service_1 = __webpack_require__(/*! ../../browser/window/default-window-service */ "../../node_modules/@theia/core/lib/browser/window/default-window-service.js");
const electron_main_window_service_1 = __webpack_require__(/*! ../../electron-common/electron-main-window-service */ "../../node_modules/@theia/core/lib/electron-common/electron-main-window-service.js");
const electron_window_preferences_1 = __webpack_require__(/*! ./electron-window-preferences */ "../../node_modules/@theia/core/lib/electron-browser/window/electron-window-preferences.js");
const connection_management_1 = __webpack_require__(/*! ../../common/messaging/connection-management */ "../../node_modules/@theia/core/lib/common/messaging/connection-management.js");
const frontend_id_provider_1 = __webpack_require__(/*! ../../browser/messaging/frontend-id-provider */ "../../node_modules/@theia/core/lib/browser/messaging/frontend-id-provider.js");
let ElectronWindowService = class ElectronWindowService extends default_window_service_1.DefaultWindowService {
    constructor() {
        super(...arguments);
        /**
         * Lock to prevent multiple parallel executions of the `beforeunload` listener.
         */
        this.isUnloading = false;
        /**
         * Close the window right away when `true`, else check if we can unload.
         */
        this.closeOnUnload = false;
    }
    openNewWindow(url, { external } = {}) {
        this.delegate.openNewWindow(url, { external });
        return undefined;
    }
    openNewDefaultWindow(params) {
        this.delegate.openNewDefaultWindow(params);
    }
    focus() {
        window.electronTheiaCore.focusWindow();
    }
    init() {
        // Update the default zoom level on startup when the preferences event is fired.
        this.electronWindowPreferences.onPreferenceChanged(e => {
            if (e.preferenceName === 'window.zoomLevel') {
                this.updateWindowZoomLevel();
            }
        });
        window.electronTheiaCore.onAboutToClose(() => {
            this.connectionCloseService.markForClose(this.frontendIdProvider.getId());
        });
    }
    registerUnloadListeners() {
        window.electronTheiaCore.setCloseRequestHandler(reason => this.isSafeToShutDown(reason));
        window.addEventListener('unload', () => {
            this.onUnloadEmitter.fire();
        });
    }
    /**
     * Updates the window zoom level based on the preference value.
     */
    async updateWindowZoomLevel() {
        const preferredZoomLevel = this.electronWindowPreferences['window.zoomLevel'];
        if (await window.electronTheiaCore.getZoomLevel() !== preferredZoomLevel) {
            window.electronTheiaCore.setZoomLevel(preferredZoomLevel);
        }
    }
    reload(params) {
        if (params) {
            const newLocation = new URL(location.href);
            if (params.search) {
                const query = Object.entries(params.search).map(([name, value]) => `${name}=${value}`).join('&');
                newLocation.search = query;
            }
            if (params.hash) {
                newLocation.hash = '#' + params.hash;
            }
            window.electronTheiaCore.requestReload(newLocation.toString());
        }
        else {
            window.electronTheiaCore.requestReload();
        }
    }
};
exports.ElectronWindowService = ElectronWindowService;
tslib_1.__decorate([
    (0, inversify_1.inject)(frontend_id_provider_1.FrontendIdProvider),
    tslib_1.__metadata("design:type", Object)
], ElectronWindowService.prototype, "frontendIdProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(electron_main_window_service_1.ElectronMainWindowService),
    tslib_1.__metadata("design:type", Object)
], ElectronWindowService.prototype, "delegate", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(electron_window_preferences_1.ElectronWindowPreferences),
    tslib_1.__metadata("design:type", Object)
], ElectronWindowService.prototype, "electronWindowPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(connection_management_1.ConnectionCloseService),
    tslib_1.__metadata("design:type", Object)
], ElectronWindowService.prototype, "connectionCloseService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], ElectronWindowService.prototype, "init", null);
exports.ElectronWindowService = ElectronWindowService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ElectronWindowService);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-browser/window/external-app-open-handler.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-browser/window/external-app-open-handler.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var ExternalAppOpenHandler_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExternalAppOpenHandler = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! inversify */ "../../node_modules/inversify/lib/cjs/index.js");
const http_open_handler_1 = __webpack_require__(/*! ../../browser/http-open-handler */ "../../node_modules/@theia/core/lib/browser/http-open-handler.js");
let ExternalAppOpenHandler = ExternalAppOpenHandler_1 = class ExternalAppOpenHandler {
    constructor() {
        this.id = 'external-app';
    }
    canHandle(uri, options) {
        return (options && options.openExternalApp) ? ExternalAppOpenHandler_1.PRIORITY : -1;
    }
    async open(uri) {
        // For files 'file:' scheme, system accepts only the path.
        // For other protocols e.g. 'vscode:' we use the full URI to propagate target app information.
        window.electronTheiaCore.openWithSystemApp(uri.toString(true));
        return undefined;
    }
};
exports.ExternalAppOpenHandler = ExternalAppOpenHandler;
ExternalAppOpenHandler.PRIORITY = http_open_handler_1.HttpOpenHandler.PRIORITY + 100;
exports.ExternalAppOpenHandler = ExternalAppOpenHandler = ExternalAppOpenHandler_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ExternalAppOpenHandler);


/***/ }),

/***/ "../../node_modules/@theia/core/lib/electron-common/electron-main-window-service.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@theia/core/lib/electron-common/electron-main-window-service.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2020 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElectronMainWindowService = exports.electronMainWindowServicePath = void 0;
exports.electronMainWindowServicePath = '/services/electron-window';
exports.ElectronMainWindowService = Symbol('ElectronMainWindowService');


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_core_lib_electron-browser_window_electron-window-module_js.js.map