"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-history_lib_browser_ai-history-contribution_js"],{

/***/ "../../node_modules/@theia/ai-history/lib/browser/ai-history-communication-card.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-history/lib/browser/ai-history-communication-card.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommunicationCard = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
// Format JSON with error handling
const formatJson = (data) => {
    try {
        return JSON.stringify(data, undefined, 2).split(/(?:\\r)?\\n/).flatMap((stringChunk, i) => [stringChunk, React.createElement("br", { key: stringChunk + i })]);
    }
    catch (error) {
        console.error('Error formatting JSON:', error);
        return 'Error formatting data';
    }
};
// Format the timestamp for better readability
const formatTimestamp = (timestamp) => new Date(timestamp).toLocaleString(undefined, {
    year: 'numeric',
    month: 'short',
    day: 'numeric',
    hour: '2-digit',
    minute: '2-digit',
    second: '2-digit'
});
const CommunicationCard = ({ entry }) => (React.createElement("div", { className: 'theia-card', role: "article", "aria-label": `Communication log for request ${entry.requestId}` },
    React.createElement("div", { className: 'theia-card-meta' },
        React.createElement("span", { className: 'theia-card-request-id' },
            core_1.nls.localize('theia/ai/history/communication-card/requestId', 'Request ID'),
            ": ",
            entry.requestId),
        React.createElement("span", { className: 'theia-card-session-id' },
            core_1.nls.localize('theia/ai/history/communication-card/sessionId', 'Session ID'),
            ": ",
            entry.sessionId)),
    React.createElement("div", { className: 'theia-card-content' },
        entry.request && (React.createElement("div", { className: 'theia-card-request' },
            React.createElement("h2", null, core_1.nls.localize('theia/ai/history/communication-card/request', 'Request')),
            React.createElement("details", { key: `request-${entry.requestId}` },
                React.createElement("summary", null,
                    React.createElement("h3", null,
                        core_1.nls.localize('theia/ai/history/communication-card/request/summary', 'Request'),
                        " ",
                        entry.requestId)),
                React.createElement("div", { className: 'theia-card-request-messages' },
                    React.createElement("h4", null, core_1.nls.localize('theia/ai/history/communication-card/request/messages', 'Messages')),
                    React.createElement("ul", { className: 'theia-card-request-messages-list' }, entry.request.map((message, index) => (React.createElement("li", { key: `message-${entry.requestId}-${index}`, className: "message-item" },
                        React.createElement("pre", { className: "message-content" }, formatJson(message)))))))))),
        entry.response && (React.createElement("div", { className: 'theia-card-response' },
            React.createElement("h2", null, core_1.nls.localize('theia/ai/history/communication-card/response', 'Response')),
            React.createElement("details", { key: `response-${entry.requestId}` },
                React.createElement("summary", null,
                    React.createElement("h3", null,
                        core_1.nls.localize('theia/ai/history/communication-card/response/summary', 'Response'),
                        " ",
                        entry.requestId)),
                React.createElement("div", { className: 'theia-card-response-messages' },
                    React.createElement("h4", null, core_1.nls.localize('theia/ai/history/communication-card/response/messages', 'Messages')),
                    React.createElement("ul", { className: 'theia-card-response-messages-list' }, entry.response.map((message, index) => (React.createElement("li", { key: `message-${entry.requestId}-${index}`, className: "message-item" },
                        React.createElement("pre", { className: "message-content" }, formatJson(message))))))))))),
    React.createElement("div", { className: 'theia-card-meta' },
        React.createElement("span", { className: 'theia-card-timestamp' },
            core_1.nls.localize('theia/ai/history/communication-card/timestamp', 'Timestamp'),
            ": ",
            formatTimestamp(entry.timestamp)),
        entry.responseTime !== undefined && (React.createElement("span", { className: 'theia-card-response-time' },
            core_1.nls.localize('theia/ai/history/communication-card/responseTime', 'Response Time'),
            ": ",
            entry.responseTime,
            "ms")))));
exports.CommunicationCard = CommunicationCard;


/***/ }),

/***/ "../../node_modules/@theia/ai-history/lib/browser/ai-history-contribution.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-history/lib/browser/ai-history-contribution.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIHistoryViewContribution = exports.AI_HISTORY_VIEW_CLEAR = exports.AI_HISTORY_VIEW_SORT_REVERSE_CHRONOLOGICALLY = exports.AI_HISTORY_VIEW_SORT_CHRONOLOGICALLY = exports.OPEN_AI_HISTORY_VIEW = exports.AI_HISTORY_TOGGLE_COMMAND_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const browser_2 = __webpack_require__(/*! @theia/ai-core/lib/browser */ "../../node_modules/@theia/ai-core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const ai_history_widget_1 = __webpack_require__(/*! ./ai-history-widget */ "../../node_modules/@theia/ai-history/lib/browser/ai-history-widget.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
exports.AI_HISTORY_TOGGLE_COMMAND_ID = 'aiHistory:toggle';
exports.OPEN_AI_HISTORY_VIEW = core_1.Command.toLocalizedCommand({
    id: 'aiHistory:open',
    label: 'Open AI History view',
});
exports.AI_HISTORY_VIEW_SORT_CHRONOLOGICALLY = core_1.Command.toLocalizedCommand({
    id: 'aiHistory:sortChronologically',
    label: 'AI History: Sort chronologically',
    iconClass: (0, browser_1.codicon)('arrow-down')
});
exports.AI_HISTORY_VIEW_SORT_REVERSE_CHRONOLOGICALLY = core_1.Command.toLocalizedCommand({
    id: 'aiHistory:sortReverseChronologically',
    label: 'AI History: Sort reverse chronologically',
    iconClass: (0, browser_1.codicon)('arrow-up')
});
exports.AI_HISTORY_VIEW_CLEAR = core_1.Command.toLocalizedCommand({
    id: 'aiHistory:clear',
    label: 'AI History: Clear History',
    iconClass: (0, browser_1.codicon)('clear-all')
});
let AIHistoryViewContribution = class AIHistoryViewContribution extends browser_2.AIViewContribution {
    constructor() {
        super({
            widgetId: ai_history_widget_1.AIHistoryView.ID,
            widgetName: ai_history_widget_1.AIHistoryView.LABEL,
            defaultWidgetOptions: {
                area: 'bottom',
                rank: 100
            },
            toggleCommandId: exports.AI_HISTORY_TOGGLE_COMMAND_ID,
        });
        this.chronologicalChangedEmitter = new core_1.Emitter();
        this.chronologicalStateChanged = this.chronologicalChangedEmitter.event;
    }
    async initializeLayout(_app) {
        await this.openView();
    }
    registerCommands(registry) {
        super.registerCommands(registry);
        registry.registerCommand(exports.OPEN_AI_HISTORY_VIEW, {
            execute: () => this.openView({ activate: true }),
        });
        registry.registerCommand(exports.AI_HISTORY_VIEW_SORT_CHRONOLOGICALLY, {
            isEnabled: widget => this.withHistoryWidget(widget, historyView => !historyView.isChronological),
            isVisible: widget => this.withHistoryWidget(widget, historyView => !historyView.isChronological),
            execute: widget => this.withHistoryWidget(widget, historyView => {
                historyView.sortHistory(true);
                this.chronologicalChangedEmitter.fire();
                return true;
            })
        });
        registry.registerCommand(exports.AI_HISTORY_VIEW_SORT_REVERSE_CHRONOLOGICALLY, {
            isEnabled: widget => this.withHistoryWidget(widget, historyView => historyView.isChronological),
            isVisible: widget => this.withHistoryWidget(widget, historyView => historyView.isChronological),
            execute: widget => this.withHistoryWidget(widget, historyView => {
                historyView.sortHistory(false);
                this.chronologicalChangedEmitter.fire();
                return true;
            })
        });
        registry.registerCommand(exports.AI_HISTORY_VIEW_CLEAR, {
            isEnabled: widget => this.withHistoryWidget(widget),
            isVisible: widget => this.withHistoryWidget(widget),
            execute: widget => this.withHistoryWidget(widget, () => {
                this.clearHistory();
                return true;
            })
        });
    }
    clearHistory() {
        this.recordingService.clearHistory();
    }
    withHistoryWidget(widget = this.tryGetWidget(), predicate = () => true) {
        return widget instanceof ai_history_widget_1.AIHistoryView ? predicate(widget) : false;
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: exports.AI_HISTORY_VIEW_SORT_CHRONOLOGICALLY.id,
            command: exports.AI_HISTORY_VIEW_SORT_CHRONOLOGICALLY.id,
            tooltip: core_1.nls.localize('theia/ai/history/sortChronologically/tooltip', 'Sort chronologically'),
            isVisible: widget => this.withHistoryWidget(widget),
            onDidChange: this.chronologicalStateChanged
        });
        registry.registerItem({
            id: exports.AI_HISTORY_VIEW_SORT_REVERSE_CHRONOLOGICALLY.id,
            command: exports.AI_HISTORY_VIEW_SORT_REVERSE_CHRONOLOGICALLY.id,
            tooltip: core_1.nls.localize('theia/ai/history/sortReverseChronologically/tooltip', 'Sort reverse chronologically'),
            isVisible: widget => this.withHistoryWidget(widget),
            onDidChange: this.chronologicalStateChanged
        });
        registry.registerItem({
            id: exports.AI_HISTORY_VIEW_CLEAR.id,
            command: exports.AI_HISTORY_VIEW_CLEAR.id,
            tooltip: core_1.nls.localize('theia/ai/history/clear/tooltip', 'Clear History of all agents'),
            isVisible: widget => this.withHistoryWidget(widget)
        });
    }
};
exports.AIHistoryViewContribution = AIHistoryViewContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.CommunicationRecordingService),
    tslib_1.__metadata("design:type", Object)
], AIHistoryViewContribution.prototype, "recordingService", void 0);
exports.AIHistoryViewContribution = AIHistoryViewContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], AIHistoryViewContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-history/lib/browser/ai-history-widget.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-history/lib/browser/ai-history-widget.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


var AIHistoryView_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AIHistoryView = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const ai_history_communication_card_1 = __webpack_require__(/*! ./ai-history-communication-card */ "../../node_modules/@theia/ai-history/lib/browser/ai-history-communication-card.js");
const select_component_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/select-component */ "../../node_modules/@theia/core/lib/browser/widgets/select-component.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let AIHistoryView = AIHistoryView_1 = class AIHistoryView extends browser_1.ReactWidget {
    constructor() {
        super();
        this._state = { chronological: false };
        this.id = AIHistoryView_1.ID;
        this.title.label = AIHistoryView_1.LABEL;
        this.title.caption = AIHistoryView_1.LABEL;
        this.title.closable = true;
        this.title.iconClass = (0, browser_1.codicon)('history');
    }
    get state() {
        return this._state;
    }
    set state(state) {
        this._state = state;
        this.update();
    }
    storeState() {
        return this.state;
    }
    restoreState(oldState) {
        const copy = (0, core_1.deepClone)(this.state);
        if (oldState.chronological) {
            copy.chronological = oldState.chronological;
        }
        this.state = copy;
    }
    init() {
        this.update();
        this.toDispose.push(this.recordingService.onDidRecordRequest(entry => this.historyContentUpdated(entry)));
        this.toDispose.push(this.recordingService.onDidRecordResponse(entry => this.historyContentUpdated(entry)));
        this.toDispose.push(this.recordingService.onStructuralChange(() => this.update()));
        this.selectAgent(this.agentService.getAllAgents()[0]);
    }
    selectAgent(agent) {
        this.selectedAgent = agent;
        this.update();
    }
    historyContentUpdated(entry) {
        var _a;
        if (entry.agentId === ((_a = this.selectedAgent) === null || _a === void 0 ? void 0 : _a.id)) {
            this.update();
        }
    }
    render() {
        var _a;
        const selectionChange = (value) => {
            this.selectedAgent = this.agentService.getAllAgents().find(agent => agent.id === value.value);
            this.update();
        };
        const agents = this.agentService.getAllAgents();
        if (agents.length === 0) {
            return (React.createElement("div", { className: 'agent-history-widget' },
                React.createElement("div", { className: 'theia-card no-content' }, core_1.nls.localize('theia/ai/history/view/noAgent', 'No agent available.'))));
        }
        return (React.createElement("div", { className: 'agent-history-widget' },
            React.createElement(select_component_1.SelectComponent, { options: agents.map(agent => ({
                    value: agent.id,
                    label: agent.name,
                    description: agent.description || ''
                })), onChange: selectionChange, defaultValue: (_a = this.selectedAgent) === null || _a === void 0 ? void 0 : _a.id }),
            React.createElement("div", { className: 'agent-history' }, this.renderHistory())));
    }
    renderHistory() {
        if (!this.selectedAgent) {
            return React.createElement("div", { className: 'theia-card no-content' }, core_1.nls.localize('theia/ai/history/view/noAgentSelected', 'No agent selected.'));
        }
        const history = [...this.recordingService.getHistory(this.selectedAgent.id)];
        if (history.length === 0) {
            return React.createElement("div", { className: 'theia-card no-content' }, core_1.nls.localize('theia/ai/history/view/noHistoryForAgent', 'No history available for the selected agent \'{0}\'', this.selectedAgent.name));
        }
        if (!this.state.chronological) {
            history.reverse();
        }
        return history.map(entry => React.createElement(ai_history_communication_card_1.CommunicationCard, { key: entry.requestId, entry: entry }));
    }
    onClick(e, agent) {
        e.stopPropagation();
        this.selectAgent(agent);
    }
    sortHistory(chronological) {
        this.state = { ...(0, core_1.deepClone)(this.state), chronological: chronological };
    }
    get isChronological() {
        return this.state.chronological === true;
    }
};
exports.AIHistoryView = AIHistoryView;
AIHistoryView.ID = 'ai-history-widget';
AIHistoryView.LABEL = core_1.nls.localize('theia/ai/history/view/label', 'AI Agent History [Alpha]');
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.CommunicationRecordingService),
    tslib_1.__metadata("design:type", Object)
], AIHistoryView.prototype, "recordingService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], AIHistoryView.prototype, "agentService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], AIHistoryView.prototype, "init", null);
exports.AIHistoryView = AIHistoryView = AIHistoryView_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], AIHistoryView);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-history_lib_browser_ai-history-contribution_js.js.map