"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = void 0;
const React = __importStar(require("react"));
const table_header_1 = require("./table-header");
const table_body_1 = require("./table-body");
const sort_1 = require("./sort");
class Table extends React.Component {
    constructor(props) {
        super(props);
        this.onSortChange = (sortColumn) => {
            let newSortConfigs = [...this.props.sortConfig];
            newSortConfigs = newSortConfigs.map((config) => {
                if (config.column === sortColumn) {
                    return Object.assign(Object.assign({}, config), { sortState: (0, sort_1.nextSortState)(config.sortState) });
                }
                else {
                    return Object.assign(Object.assign({}, config), { sortState: sort_1.sortState.default });
                }
            });
            const newSortedNodes = (0, sort_1.sortNodes)(this.props.nodes, newSortConfigs);
            this.props.onSortConfigChange(newSortConfigs);
            this.props.onSort(newSortedNodes);
        };
        const sortableCols = [];
        const config = [];
        this.props.headers.forEach((header, columnIndex) => {
            if (header.sortable) {
                config.push({ column: header.title, columnIndex: columnIndex, sortState: sort_1.sortState.default });
                sortableCols.push(header.title);
            }
        });
        this.props.onSortConfigChange(config);
        this.sortableColumns = sortableCols;
    }
    render() {
        const gridTemplateColumns = this.props.headers
            .map(() => 'max-content')
            .join(' ')
            .concat(' minmax(0px, 1fr)');
        return (React.createElement("div", null,
            React.createElement("table", { style: { gridTemplateColumns: gridTemplateColumns }, className: this.props.className },
                this.props.showHeader && (React.createElement(table_header_1.TableHeader, { columns: this.props.headers, sortableColumns: this.sortableColumns, onSort: this.onSortChange, sortConfig: this.props.sortConfig })),
                React.createElement(table_body_1.TableBody, Object.assign({}, this.props, { nodes: (0, sort_1.sortNodes)(this.props.nodes, this.props.sortConfig) })))));
    }
}
exports.Table = Table;
//# sourceMappingURL=table.js.map