"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sortNodes = exports.nextSortState = exports.sortState = void 0;
const icons_1 = __importDefault(require("./icons"));
exports.sortState = {
    asc: icons_1.default.sortUp,
    desc: icons_1.default.sortDown,
    default: icons_1.default.sort
};
const nextSortState = (currentState) => {
    if (currentState === exports.sortState.default || currentState === exports.sortState.desc) {
        return exports.sortState.asc;
    }
    else if (currentState === exports.sortState.asc) {
        return exports.sortState.desc;
    }
    else {
        return exports.sortState.default;
    }
};
exports.nextSortState = nextSortState;
const sortNodes = (nodes, sortConfig) => {
    const sortedNodes = [...nodes];
    const orderToSort = sortConfig.find((config) => config.sortState !== exports.sortState.default);
    if (orderToSort) {
        sortedNodes.sort((node1, node2) => {
            const index = orderToSort.columnIndex;
            const value1 = node1.labels[index];
            const value2 = node2.labels[index];
            let comp = 0;
            if (!value1 && value2) {
                comp = -1;
            }
            else if (value1 && !value2) {
                comp = 1;
            }
            else if (!value1 && !value2) {
                comp = 0;
            }
            else {
                const number1 = parseValue(value1);
                const number2 = parseValue(value2);
                if (number1 !== undefined && number2 !== undefined) {
                    if (number1 < number2) {
                        comp = -1;
                    }
                    else if (number1 > number2) {
                        comp = 1;
                    }
                    else {
                        comp = 0;
                    }
                }
                else {
                    comp = value1.localeCompare(value2);
                }
            }
            return orderToSort.sortState === exports.sortState.asc ? comp : -comp;
        });
        sortedNodes.forEach((node) => {
            if (node.children.length) {
                node.children = (0, exports.sortNodes)(node.children, sortConfig);
            }
        });
    }
    return sortedNodes;
};
exports.sortNodes = sortNodes;
const parseValue = (valueString) => {
    let floatNumber = NaN;
    let factor = -1;
    const valueArray = valueString.split(' ');
    if (valueArray.length === 1) {
        floatNumber = Number.parseFloat(valueString);
        factor = 1;
    }
    else if (valueArray.length === 2) {
        const value = valueArray[0];
        const unit = valueArray[1];
        if (unit === 'ns' || unit === '%') {
            factor = 1;
        }
        else if (unit === 'us' || unit === '\u00B5' + 's') {
            factor = 1000;
        }
        else if (unit === 'ms') {
            factor = 1000 * 1000;
        }
        else if (unit === 's') {
            factor = 1000 * 1000 * 1000;
        }
        else {
            return undefined;
        }
        floatNumber = Number.parseFloat(value);
    }
    if (!Number.isNaN(floatNumber)) {
        return floatNumber * factor;
    }
    return undefined;
};
//# sourceMappingURL=sort.js.map