"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeGraphChartSelectionRange = void 0;
var time_graph_rectangle_1 = require("../components/time-graph-rectangle");
var time_graph_viewport_layer_1 = require("./time-graph-viewport-layer");
var TimeGraphChartSelectionRange = /** @class */ (function (_super) {
    __extends(TimeGraphChartSelectionRange, _super);
    function TimeGraphChartSelectionRange(id, style) {
        var _this = _super.call(this, id) || this;
        _this.color = 0x0000ff;
        _this.isScalable = false;
        if (style && style.color) {
            _this.color = style.color;
        }
        return _this;
    }
    TimeGraphChartSelectionRange.prototype.updateScaleAndPosition = function () {
        if (this.unitController.selectionRange && this.selectionRange) {
            var firstCursorPosition = this.getWorldPixel(this.unitController.selectionRange.start);
            var width = this.getPixel(this.unitController.selectionRange.end - this.unitController.selectionRange.start);
            this.selectionRange.update({
                position: {
                    x: firstCursorPosition,
                    y: 0
                },
                height: this.stateController.canvasDisplayHeight,
                width: width
            });
        }
    };
    TimeGraphChartSelectionRange.prototype.afterAddToContainer = function () {
        var _this = this;
        this._updateHandler = function () { return _this.update(); };
        this.stateController.onWorldRender(this._updateHandler);
        this.unitController.onSelectionRangeChange(this._updateHandler);
        this.stateController.onScaleFactorChange(this._updateHandler);
        this.update();
    };
    TimeGraphChartSelectionRange.prototype.removeSelectionRange = function () {
        this.removeChildren();
        delete this.selectionRange;
    };
    TimeGraphChartSelectionRange.prototype.update = function () {
        if (this.unitController.selectionRange) {
            /**
             * When user selects a range on the timeline chart, the selection position must correspond to the cursor of the user,
             * and not the timeline chart itself since scaling might be applied.
             */
            var firstCursorPosition = this.getWorldPixel(this.unitController.selectionRange.start);
            var secondCursorPosition = this.getWorldPixel(this.unitController.selectionRange.end);
            if (secondCursorPosition !== firstCursorPosition) {
                if (!this.selectionRange) {
                    this.selectionRange = new time_graph_rectangle_1.TimeGraphRectangle({
                        color: this.color,
                        opacity: 0.2,
                        position: {
                            x: firstCursorPosition,
                            y: 0
                        },
                        height: this.stateController.canvasDisplayHeight,
                        width: secondCursorPosition - firstCursorPosition
                    });
                    this.addChild(this.selectionRange);
                }
                else {
                    this.selectionRange.update({
                        position: {
                            x: firstCursorPosition,
                            y: 0
                        },
                        height: this.stateController.canvasDisplayHeight,
                        width: secondCursorPosition - firstCursorPosition
                    });
                }
            }
            else {
                this.removeSelectionRange();
            }
        }
        else {
            this.removeSelectionRange();
        }
    };
    TimeGraphChartSelectionRange.prototype.destroy = function () {
        if (this.unitController) {
            this.stateController.removeWorldRenderHandler(this._updateHandler);
            this.unitController.removeSelectionRangeChangedHandler(this._updateHandler);
        }
        _super.prototype.destroy.call(this);
    };
    return TimeGraphChartSelectionRange;
}(time_graph_viewport_layer_1.TimeGraphViewportLayer));
exports.TimeGraphChartSelectionRange = TimeGraphChartSelectionRange;
//# sourceMappingURL=time-graph-chart-selection-range.js.map