"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bindTraceOverviewPreferences = void 0;
const browser_1 = require("@theia/core/lib/browser");
const trace_overview_preference_1 = require("./trace-overview-preference");
function bindTraceOverviewPreferences(bind) {
    bind(trace_overview_preference_1.OverviewPreferences)
        .toDynamicValue(ctx => {
        const preferences = ctx.container.get(browser_1.PreferenceService);
        return (0, browser_1.createPreferenceProxy)(preferences, trace_overview_preference_1.OverviewSchema);
    })
        .inSingletonScope();
    bind(browser_1.PreferenceContribution).toConstantValue({
        schema: trace_overview_preference_1.OverviewSchema
    });
}
exports.bindTraceOverviewPreferences = bindTraceOverviewPreferences;
//# sourceMappingURL=trace-overview-binding.js.map