/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTesterCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureProcessor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractFieldRefactoring;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.code.IntroduceParameterRefactoring;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.AssignToVariableAssistProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RefactoringCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.ChangeSignatureHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.ActionMessages;
import org.eclipse.jdt.ls.core.internal.text.correction.AssignToVariableAssistCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionUtility;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.Refactoring;

public class RefactorProposalUtility {
    public static final String APPLY_REFACTORING_COMMAND_ID = "java.action.applyRefactoringCommand";
    public static final String EXTRACT_VARIABLE_ALL_OCCURRENCE_COMMAND = "extractVariableAllOccurrence";
    public static final String EXTRACT_VARIABLE_COMMAND = "extractVariable";
    public static final String ASSIGN_VARIABLE_COMMAND = "assignVariable";
    public static final String EXTRACT_CONSTANT_COMMAND = "extractConstant";
    public static final String EXTRACT_METHOD_COMMAND = "extractMethod";
    public static final String EXTRACT_FIELD_COMMAND = "extractField";
    public static final String EXTRACT_INTERFACE_COMMAND = "extractInterface";
    public static final String CHANGE_SIGNATURE_COMMAND = "changeSignature";
    public static final String ASSIGN_FIELD_COMMAND = "assignField";
    public static final String CONVERT_VARIABLE_TO_FIELD_COMMAND = "convertVariableToField";
    public static final String MOVE_FILE_COMMAND = "moveFile";
    public static final String MOVE_INSTANCE_METHOD_COMMAND = "moveInstanceMethod";
    public static final String MOVE_STATIC_MEMBER_COMMAND = "moveStaticMember";
    public static final String MOVE_TYPE_COMMAND = "moveType";
    public static final String INTRODUCE_PARAMETER_COMMAND = "introduceParameter";

    /*
     * WARNING - void declaration
     */
    public static List<CUCorrectionProposal> getMoveRefactoringProposals(CodeActionParams params, IInvocationContext context) {
        int relevance = 6;
        List kindOfActions = params.getContext().getOnly();
        boolean alwaysShowMove = kindOfActions != null && kindOfActions.contains("refactor");
        ASTNode node = context.getCoveredNode();
        if (node == null) {
            node = context.getCoveringNode();
        }
        node = RefactorProposalUtility.getDeclarationNode(node, alwaysShowMove);
        ICompilationUnit cu = context.getCompilationUnit();
        String uri = JDTUtils.toURI(cu);
        if (cu != null && node != null) {
            try {
                if (node instanceof MethodDeclaration || node instanceof FieldDeclaration || node instanceof AbstractTypeDeclaration) {
                    String displayName = RefactorProposalUtility.getDisplayName(node);
                    String label = alwaysShowMove ? ActionMessages.MoveRefactoringAction_label : Messages.format(ActionMessages.MoveRefactoringAction_templateLabel, displayName);
                    int memberType = node.getNodeType();
                    String enclosingTypeName = RefactorProposalUtility.getEnclosingType(node);
                    String projectName = cu.getJavaProject().getProject().getName();
                    ASTNode aSTNode = node;
                    if (aSTNode instanceof AbstractTypeDeclaration) {
                        void typeDecl;
                        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)aSTNode;
                        AbstractTypeDeclaration cfr_ignored_0 = (AbstractTypeDeclaration)aSTNode;
                        MoveTypeInfo moveTypeInfo = new MoveTypeInfo(displayName, enclosingTypeName, projectName);
                        if (RefactorProposalUtility.isMoveInnerAvailable((AbstractTypeDeclaration)typeDecl)) {
                            moveTypeInfo.addDestinationKind("newFile");
                        }
                        if (RefactorProposalUtility.isMoveStaticMemberAvailable(node)) {
                            moveTypeInfo.addDestinationKind("class");
                        }
                        if (moveTypeInfo.isMoveAvaiable()) {
                            return Collections.singletonList(new CUCorrectionCommandProposal(label, "refactor.move", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_TYPE_COMMAND, params, moveTypeInfo)));
                        }
                        return Collections.singletonList(new CUCorrectionCommandProposal(label, "refactor.move", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_FILE_COMMAND, params, new MoveFileInfo(uri))));
                    }
                    if (JdtFlags.isStatic((BodyDeclaration)((BodyDeclaration)node))) {
                        if (RefactorProposalUtility.isMoveStaticMemberAvailable(node)) {
                            return Collections.singletonList(new CUCorrectionCommandProposal(label, "refactor.move", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_STATIC_MEMBER_COMMAND, params, new MoveMemberInfo(displayName, memberType, enclosingTypeName, projectName))));
                        }
                    } else {
                        ASTNode aSTNode2 = node;
                        if (aSTNode2 instanceof MethodDeclaration) {
                            void methodDecl;
                            MethodDeclaration moveTypeInfo = (MethodDeclaration)aSTNode2;
                            MethodDeclaration cfr_ignored_1 = (MethodDeclaration)aSTNode2;
                            if (RefactorProposalUtility.isMoveMethodAvailable((MethodDeclaration)methodDecl)) {
                                return Collections.singletonList(new CUCorrectionCommandProposal(label, "refactor.move", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_INSTANCE_METHOD_COMMAND, params, new MoveMemberInfo(displayName))));
                            }
                        }
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return Collections.emptyList();
        }
        return alwaysShowMove ? Collections.singletonList(new CUCorrectionCommandProposal(ActionMessages.MoveRefactoringAction_label, "refactor.move", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(MOVE_FILE_COMMAND, params, new MoveFileInfo(uri)))) : Collections.emptyList();
    }

    /*
     * Unable to fully structure code
     */
    private static ASTNode getDeclarationNode(ASTNode node, boolean alwaysShowMove) {
        block4: {
            block3: {
                if (node == null) {
                    return null;
                }
                if (!alwaysShowMove) break block3;
                while (node != null && !(node instanceof BodyDeclaration)) {
                    node = node.getParent();
                }
                break block4;
            }
            if (!(node instanceof BodyDeclaration)) ** GOTO lbl12
            return null;
lbl-1000:
            // 1 sources

            {
                node = node.getParent();
lbl12:
                // 2 sources

                ** while (node != null && !(node instanceof BodyDeclaration) && !(node instanceof Statement))
            }
        }
        return node;
    }

    private static boolean isMoveMethodAvailable(MethodDeclaration declaration) throws JavaModelException {
        IMethod method;
        IMethodBinding methodBinding = declaration.resolveBinding();
        IMethod iMethod = method = methodBinding == null ? null : (IMethod)methodBinding.getJavaElement();
        return method != null && RefactoringAvailabilityTester.isMoveMethodAvailable(method);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isMoveStaticMemberAvailable(ASTNode declaration) throws JavaModelException {
        ASTNode aSTNode = declaration;
        if (aSTNode instanceof MethodDeclaration) {
            void methodDecl;
            MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
            IMethodBinding method = methodDecl.resolveBinding();
            return method != null && RefactoringAvailabilityTesterCore.isMoveStaticAvailable((IMember)((IMember)method.getJavaElement()));
        }
        ASTNode aSTNode2 = declaration;
        if (aSTNode2 instanceof FieldDeclaration) {
            void fieldDecl;
            FieldDeclaration method = (FieldDeclaration)aSTNode2;
            FieldDeclaration cfr_ignored_1 = (FieldDeclaration)aSTNode2;
            ArrayList<IField> members = new ArrayList<IField>();
            for (Object fragment : fieldDecl.fragments()) {
                IVariableBinding variable = ((VariableDeclarationFragment)fragment).resolveBinding();
                if (variable == null) continue;
                members.add((IField)variable.getJavaElement());
            }
            return RefactoringAvailabilityTesterCore.isMoveStaticMembersAvailable((IMember[])members.toArray(new IMember[0]));
        }
        ASTNode aSTNode3 = declaration;
        if (aSTNode3 instanceof AbstractTypeDeclaration) {
            void typeDecl;
            AbstractTypeDeclaration members = (AbstractTypeDeclaration)aSTNode3;
            AbstractTypeDeclaration cfr_ignored_2 = (AbstractTypeDeclaration)aSTNode3;
            ITypeBinding type = typeDecl.resolveBinding();
            return type != null && RefactoringAvailabilityTesterCore.isMoveStaticAvailable((IMember)((IType)type.getJavaElement()));
        }
        return false;
    }

    private static boolean isMoveInnerAvailable(AbstractTypeDeclaration declaration) throws JavaModelException {
        ITypeBinding type = declaration.resolveBinding();
        if (type != null) {
            return RefactoringAvailabilityTester.isMoveInnerAvailable((IType)type.getJavaElement());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static String getDisplayName(ASTNode declaration) {
        ASTNode aSTNode = declaration;
        if (aSTNode instanceof MethodDeclaration) {
            void methodDecl;
            MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
            IMethodBinding method = methodDecl.resolveBinding();
            if (method != null) {
                String name = method.getName();
                CharSequence[] parameters = (String[])Stream.of(method.getParameterTypes()).map(type -> type.getName()).toArray(String[]::new);
                return name + "(" + String.join((CharSequence)",", parameters) + ")";
            }
        } else {
            ASTNode aSTNode2 = declaration;
            if (aSTNode2 instanceof FieldDeclaration) {
                void fieldDecl;
                FieldDeclaration method = (FieldDeclaration)aSTNode2;
                FieldDeclaration cfr_ignored_1 = (FieldDeclaration)aSTNode2;
                ArrayList<String> fieldNames = new ArrayList<String>();
                for (Object fragment : fieldDecl.fragments()) {
                    IVariableBinding variable = ((VariableDeclarationFragment)fragment).resolveBinding();
                    if (variable == null) continue;
                    fieldNames.add(variable.getName());
                }
                return String.join((CharSequence)",", fieldNames);
            }
            ASTNode aSTNode3 = declaration;
            if (aSTNode3 instanceof AbstractTypeDeclaration) {
                void typeDecl;
                AbstractTypeDeclaration fieldNames = (AbstractTypeDeclaration)aSTNode3;
                AbstractTypeDeclaration cfr_ignored_2 = (AbstractTypeDeclaration)aSTNode3;
                ITypeBinding type2 = typeDecl.resolveBinding();
                if (type2 != null) {
                    return type2.getName();
                }
            }
        }
        return null;
    }

    private static String getEnclosingType(ASTNode declaration) {
        ASTNode node = declaration == null ? null : declaration.getParent();
        ITypeBinding type = ASTNodes.getEnclosingType((ASTNode)node);
        return type == null ? null : type.getQualifiedName();
    }

    public static List<CUCorrectionProposal> getExtractVariableProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, boolean inferSelectionSupport) throws CoreException {
        return RefactorProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, false, inferSelectionSupport);
    }

    public static List<CUCorrectionProposal> getExtractVariableCommandProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, boolean inferSelectionSupport) throws CoreException {
        return RefactorProposalUtility.getExtractVariableProposals(params, context, problemsAtLocation, true, inferSelectionSupport);
    }

    public static CUCorrectionProposal getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, boolean inferSelectionSupport) throws CoreException {
        return RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, null, false, inferSelectionSupport);
    }

    public static CUCorrectionProposal getExtractMethodCommandProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, boolean inferSelectionSupport) throws CoreException {
        return RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, null, true, inferSelectionSupport);
    }

    private static List<CUCorrectionProposal> getExtractVariableProposals(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        if (!RefactorProposalUtility.supportsExtractVariable(context)) {
            return null;
        }
        ArrayList<CUCorrectionProposal> proposals = new ArrayList<CUCorrectionProposal>();
        CUCorrectionProposal proposal = RefactorProposalUtility.getExtractVariableAllOccurrenceProposal(params, context, problemsAtLocation, null, returnAsCommand, inferSelectionSupport);
        if (proposal != null) {
            proposals.add(proposal);
        }
        if ((proposal = RefactorProposalUtility.getExtractVariableProposal(params, context, problemsAtLocation, null, returnAsCommand, inferSelectionSupport)) != null) {
            proposals.add(proposal);
        }
        if ((proposal = RefactorProposalUtility.getExtractConstantProposal(params, context, problemsAtLocation, null, returnAsCommand, inferSelectionSupport)) != null) {
            proposals.add(proposal);
        }
        return proposals;
    }

    private static boolean supportsExtractVariable(IInvocationContext context) {
        Expression expression;
        ITypeBinding binding;
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof Expression)) {
            if (context.getSelectionLength() != 0) {
                return false;
            }
            node = context.getCoveringNode();
            if (!(node instanceof Expression)) {
                return false;
            }
        }
        return (binding = (expression = (Expression)node).resolveTypeBinding()) != null && !Bindings.isVoidType((ITypeBinding)binding);
    }

    public static CUCorrectionProposal getExtractVariableAllOccurrenceProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractVariableAllOccurrenceProposal(params, context, problemsAtLocation, formatterOptions, returnAsCommand, false);
    }

    private static CUCorrectionProposal getExtractVariableAllOccurrenceProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_all_description;
        int relevance = context.getSelectionLength() == 0 ? 0 : (problemsAtLocation ? 3 : 6);
        if (inferSelectionSupport && context.getSelectionLength() == 0) {
            ASTNode parent = context.getCoveringNode();
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractTempRefactoring refactoring = new ExtractTempRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength());
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    return new CUCorrectionCommandProposal(label, "refactor.extract.variable", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_ALL_OCCURRENCE_COMMAND, params));
                }
                parent = parent.getParent();
            }
            return null;
        }
        ExtractTempRefactoring extractTempRefactoring = new ExtractTempRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        if (extractTempRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.extract.variable", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_ALL_OCCURRENCE_COMMAND, params));
            }
            extractTempRefactoring.setReplaceAllOccurrences(true);
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractTempRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoring.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.variable", cu, extractTempRefactoring, relevance){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static CUCorrectionProposal getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractVariableProposal(params, context, problemsAtLocation, formatterOptions, returnAsCommand, false);
    }

    private static CUCorrectionProposal getExtractVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_description;
        int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
        if (inferSelectionSupport && context.getSelectionLength() == 0) {
            ASTNode parent = context.getCoveringNode();
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractTempRefactoring refactoring = new ExtractTempRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength());
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    return new CUCorrectionCommandProposal(label, "refactor.extract.variable", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_COMMAND, params));
                }
                parent = parent.getParent();
            }
            return null;
        }
        ExtractTempRefactoring extractTempRefactoringSelectedOnly = new ExtractTempRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        extractTempRefactoringSelectedOnly.setReplaceAllOccurrences(false);
        if (extractTempRefactoringSelectedOnly.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.extract.variable", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_VARIABLE_COMMAND, params));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractTempRefactoringSelectedOnly.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoringSelectedOnly.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.variable", cu, extractTempRefactoringSelectedOnly, relevance){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static boolean containsMatchingProblem(IProblemLocationCore[] locations, int problemId) {
        if (locations != null) {
            IProblemLocationCore[] iProblemLocationCoreArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                IProblemLocationCore location = iProblemLocationCoreArray[n2];
                if ("org.eclipse.jdt.core.problem".equals(location.getMarkerType()) && location.getProblemId() == problemId) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static CUCorrectionProposal getAssignVariableProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, IProblemLocationCore[] locations) throws CoreException {
        ASTNode node = context.getCoveringNode();
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof ExpressionStatement)) {
            return null;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return null;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = Bindings.normalizeTypeBinding((ITypeBinding)typeBinding)) == null) {
            return null;
        }
        if (RefactorProposalUtility.containsMatchingProblem(locations, 536871060)) {
            return null;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
        if (returnAsCommand) {
            return new AssignToVariableAssistCommandProposal(cu, "refactor.assign.variable", 1, expressionStatement, typeBinding, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(ASSIGN_VARIABLE_COMMAND, params));
        }
        return new AssignToVariableAssistProposal(cu, "refactor.assign.variable", 1, expressionStatement, typeBinding, relevance);
    }

    public static CUCorrectionProposal getAssignFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, IProblemLocationCore[] locations) throws CoreException {
        ASTNode node = context.getCoveringNode();
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof ExpressionStatement)) {
            return null;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return null;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = Bindings.normalizeTypeBinding((ITypeBinding)typeBinding)) == null) {
            return null;
        }
        if (RefactorProposalUtility.containsMatchingProblem(locations, 536871060)) {
            return null;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode type = ASTResolving.findParentType((ASTNode)expression);
        if (type != null) {
            int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
            if (returnAsCommand) {
                return new AssignToVariableAssistCommandProposal(cu, "refactor.assign.field", 2, expressionStatement, typeBinding, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(ASSIGN_FIELD_COMMAND, params));
            }
            return new AssignToVariableAssistProposal(cu, "refactor.assign.field", 2, expressionStatement, typeBinding, relevance);
        }
        return null;
    }

    public static CUCorrectionProposal getGenericExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        CUCorrectionProposal proposal = RefactorProposalUtility.getConvertVariableToFieldProposal(params, context, problemsAtLocation, formatterOptions, initializeIn, returnAsCommand);
        if (proposal != null) {
            return proposal;
        }
        return RefactorProposalUtility.getExtractFieldProposal(params, context, problemsAtLocation, formatterOptions, initializeIn, returnAsCommand, inferSelectionSupport);
    }

    public static CUCorrectionProposal getExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractFieldProposal(params, context, problemsAtLocation, formatterOptions, initializeIn, returnAsCommand, false);
    }

    private static CUCorrectionProposal getExtractFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        if (!RefactorProposalUtility.supportsExtractVariable(context)) {
            return null;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        String label = CorrectionMessages.QuickAssistProcessor_extract_to_field_description;
        int relevance = context.getSelectionLength() == 0 ? -1 : (problemsAtLocation ? 2 : 5);
        if (context.getSelectionLength() == 0 && inferSelectionSupport) {
            ASTNode parent = context.getCoveringNode();
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractFieldRefactoring refactoring = new ExtractFieldRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength());
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    List<String> scopes;
                    InitializeScope scope = InitializeScope.fromName(initializeIn);
                    if (scope != null) {
                        refactoring.setInitializeIn(scope.ordinal());
                    }
                    if (!(scopes = RefactorProposalUtility.getInitializeScopes(refactoring)).isEmpty()) {
                        return new CUCorrectionCommandProposal(label, "refactor.extract.field", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_FIELD_COMMAND, params));
                    }
                }
                parent = parent.getParent();
            }
            return null;
        }
        ExtractFieldRefactoring extractFieldRefactoringSelectedOnly = new ExtractFieldRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength());
        extractFieldRefactoringSelectedOnly.setFormatterOptions(formatterOptions);
        if (extractFieldRefactoringSelectedOnly.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            InitializeScope scope = InitializeScope.fromName(initializeIn);
            if (scope != null) {
                extractFieldRefactoringSelectedOnly.setInitializeIn(scope.ordinal());
            }
            if (returnAsCommand) {
                List<String> scopes = RefactorProposalUtility.getInitializeScopes(extractFieldRefactoringSelectedOnly);
                return new CUCorrectionCommandProposal(label, "refactor.extract.field", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_FIELD_COMMAND, params, new ExtractFieldInfo(scopes)));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractFieldRefactoringSelectedOnly.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.field", cu, extractFieldRefactoringSelectedOnly, relevance){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractFieldRefactoring etr = (ExtractFieldRefactoring)refactoring;
                    etr.setFieldName(etr.guessFieldName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static List<String> getInitializeScopes(ExtractFieldRefactoring refactoring) throws CoreException {
        ArrayList<String> scopes = new ArrayList<String>();
        if (refactoring.canEnableSettingDeclareInMethod()) {
            scopes.add(InitializeScope.CURRENT_METHOD.getName());
        }
        if (refactoring.canEnableSettingDeclareInFieldDeclaration()) {
            scopes.add(InitializeScope.FIELD_DECLARATION.getName());
        }
        if (refactoring.canEnableSettingDeclareInConstructors()) {
            scopes.add(InitializeScope.CLASS_CONSTRUCTORS.getName());
        }
        return scopes;
    }

    public static CUCorrectionProposal getExtractConstantProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractConstantProposal(params, context, problemsAtLocation, formatterOptions, returnAsCommand, false);
    }

    private static CUCorrectionProposal getExtractConstantProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        String label = CorrectionMessages.QuickAssistProcessor_extract_to_constant_description;
        int relevance = context.getSelectionLength() == 0 ? -2 : (problemsAtLocation ? 1 : 4);
        if (inferSelectionSupport && context.getSelectionLength() == 0) {
            ASTNode parent = context.getCoveringNode();
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractConstantRefactoring refactoring = new ExtractConstantRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength());
                if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    return new CUCorrectionCommandProposal(label, "refactor.extract.constant", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_CONSTANT_COMMAND, params));
                }
                parent = parent.getParent();
            }
            return null;
        }
        ExtractConstantRefactoring extractConstRefactoring = new ExtractConstantRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formatterOptions);
        if (extractConstRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.extract.constant", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_CONSTANT_COMMAND, params));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractConstRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractConstRefactoring.setCheckResultForCompileProblems(false);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.constant", cu, extractConstRefactoring, relevance){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractConstantRefactoring etr = (ExtractConstantRefactoring)refactoring;
                    etr.setConstantName(etr.guessConstantName());
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static CUCorrectionProposal getConvertVariableToFieldProposal(CodeActionParams params, IInvocationContext context, boolean problemsAtLocation, Map formatterOptions, String initializeIn, boolean returnAsCommand) throws CoreException {
        SimpleName name;
        IBinding binding;
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof SimpleName)) {
            if (context.getSelectionLength() != 0) {
                return null;
            }
            node = context.getCoveringNode();
            if (!(node instanceof SimpleName)) {
                return null;
            }
        }
        if (!((binding = (name = (SimpleName)node).resolveBinding()) instanceof IVariableBinding)) {
            return null;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return null;
        }
        ASTNode decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
        if (decl == null || decl.getLocationInParent() != VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
            return null;
        }
        PromoteTempToFieldRefactoring refactoring = new PromoteTempToFieldRefactoring((VariableDeclaration)decl);
        refactoring.setFormatterOptions(formatterOptions);
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            InitializeScope scope = InitializeScope.fromName(initializeIn);
            if (scope != null) {
                refactoring.setInitializeIn(scope.ordinal());
            }
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_field_description;
            if (returnAsCommand) {
                ArrayList<String> scopes = new ArrayList<String>();
                if (refactoring.canEnableSettingDeclareInMethod()) {
                    scopes.add(InitializeScope.CURRENT_METHOD.getName());
                }
                if (refactoring.canEnableSettingDeclareInFieldDeclaration()) {
                    scopes.add(InitializeScope.FIELD_DECLARATION.getName());
                }
                if (refactoring.canEnableSettingDeclareInConstructors()) {
                    scopes.add(InitializeScope.CLASS_CONSTRUCTORS.getName());
                }
                return new CUCorrectionCommandProposal(label, "refactor.extract.field", context.getCompilationUnit(), 5, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(CONVERT_VARIABLE_TO_FIELD_COMMAND, params, new ExtractFieldInfo(scopes)));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            refactoring.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.field", context.getCompilationUnit(), (Refactoring)refactoring, 5){

                @Override
                protected void init(Refactoring refactoring) throws CoreException {
                    PromoteTempToFieldRefactoring etr = (PromoteTempToFieldRefactoring)refactoring;
                    String[] names = etr.guessFieldNames();
                    if (names.length > 0) {
                        etr.setFieldName(names[0]);
                    }
                }
            };
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static CUCorrectionProposal getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Map formattingOptions, boolean returnAsCommand) throws CoreException {
        return RefactorProposalUtility.getExtractMethodProposal(params, context, coveringNode, problemsAtLocation, formattingOptions, returnAsCommand, false);
    }

    private static CUCorrectionProposal getExtractMethodProposal(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Map formattingOptions, boolean returnAsCommand, boolean inferSelectionSupport) throws CoreException {
        int relevance;
        if (!(coveringNode instanceof Expression || coveringNode instanceof Statement || coveringNode instanceof Block)) {
            return null;
        }
        if (coveringNode instanceof Block) {
            List statements = ((Block)coveringNode).statements();
            int startIndex = RefactorProposalUtility.getIndex(context.getSelectionOffset(), statements);
            if (startIndex == -1) {
                return null;
            }
            int endIndex = RefactorProposalUtility.getIndex(context.getSelectionOffset() + context.getSelectionLength(), statements);
            if (endIndex == -1 || endIndex <= startIndex) {
                return null;
            }
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength(), formattingOptions);
        String suggestedName = RefactorProposalUtility.proposeMethodNameHeuristic(context, coveringNode);
        String uniqueMethodName = RefactorProposalUtility.getUniqueMethodName(coveringNode, suggestedName);
        extractMethodRefactoring.setMethodName(uniqueMethodName);
        String label = CorrectionMessages.QuickAssistProcessor_extractmethod_description;
        int n = relevance = problemsAtLocation ? 1 : 4;
        if (context.getSelectionLength() == 0) {
            if (!inferSelectionSupport) {
                return null;
            }
            ASTNode parent = coveringNode;
            while (parent != null && parent instanceof Expression) {
                if (parent instanceof ParenthesizedExpression) {
                    parent = parent.getParent();
                    continue;
                }
                ExtractMethodRefactoring refactoring = new ExtractMethodRefactoring(context.getASTRoot(), parent.getStartPosition(), parent.getLength(), formattingOptions);
                if (refactoring.checkInferConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    return new CUCorrectionCommandProposal(label, "refactor.extract.function", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_METHOD_COMMAND, params));
                }
                parent = parent.getParent();
            }
            return null;
        }
        if (extractMethodRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.extract.function", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_METHOD_COMMAND, params));
            }
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractMethodRefactoring.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.extract.function", cu, extractMethodRefactoring, relevance);
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    private static String proposeMethodNameHeuristic(IInvocationContext context, ASTNode coveringNode) {
        Expression leftHandSide;
        IProblem problem;
        NodeFinder finder;
        ASTNode nodeVar;
        int selStart = context.getSelectionOffset();
        int selEnd = context.getSelectionOffset() + context.getSelectionLength();
        CompilationUnit cu = context.getASTRoot();
        Optional<IProblem> res = Arrays.asList(cu.getProblems()).stream().filter(p -> p.getID() == 536870973).filter(p -> p.getSourceStart() >= selStart && p.getSourceEnd() <= selEnd).max((p1, p2) -> p1.getSourceStart() - p2.getSourceStart());
        if (res.isPresent() && (nodeVar = (finder = new NodeFinder((ASTNode)cu, (problem = res.get()).getSourceStart(), problem.getSourceEnd() - problem.getSourceStart())).getCoveringNode()) instanceof SimpleName) {
            return "get" + StringUtils.capitalize((String)((SimpleName)nodeVar).getIdentifier());
        }
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength((int)context.getSelectionOffset(), (int)context.getSelectionLength()), true);
        cu.accept((ASTVisitor)analyzer);
        List varDeclStatements = Arrays.asList(analyzer.getSelectedNodes()).stream().filter(e -> e.getNodeType() == 60).collect(Collectors.toList());
        if (varDeclStatements.isEmpty() && coveringNode.getNodeType() == 60) {
            varDeclStatements.add(coveringNode);
        } else if (coveringNode.getNodeType() == 21 && ((ExpressionStatement)coveringNode).getExpression().getNodeType() == 7 && (leftHandSide = ((Assignment)((ExpressionStatement)coveringNode).getExpression()).getLeftHandSide()).getNodeType() == 42) {
            return "get" + StringUtils.capitalize((String)((SimpleName)leftHandSide).getIdentifier());
        }
        if (!varDeclStatements.isEmpty()) {
            VariableDeclarationStatement lastStatement = (VariableDeclarationStatement)varDeclStatements.get(varDeclStatements.size() - 1);
            List fragments = lastStatement.fragments();
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            String identifier = fragment.getName().getIdentifier();
            return "get" + StringUtils.capitalize((String)identifier);
        }
        return "extracted";
    }

    public static CUCorrectionProposal getIntroduceParameterRefactoringProposals(CodeActionParams params, IInvocationContext context, ASTNode coveringNode, boolean returnAsCommand, IProblemLocationCore[] problemLocations) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        IntroduceParameterRefactoring introduceParameterRefactoring = new IntroduceParameterRefactoring(cu, context.getSelectionOffset(), context.getSelectionLength());
        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
        introduceParameterRefactoring.setLinkedProposalModel(linkedProposalModel);
        if (introduceParameterRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            int relevance;
            introduceParameterRefactoring.setParameterName(introduceParameterRefactoring.guessedParameterName());
            String label = RefactoringCoreMessages.IntroduceParameterRefactoring_name + "...";
            int n = relevance = problemLocations != null && problemLocations.length > 0 ? 1 : 4;
            if (returnAsCommand) {
                return new CUCorrectionCommandProposal(label, "refactor.introduce.parameter", cu, relevance, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(INTRODUCE_PARAMETER_COMMAND, params));
            }
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, "refactor.introduce.parameter", cu, introduceParameterRefactoring, relevance);
            proposal.setLinkedProposalModel(linkedProposalModel);
            return proposal;
        }
        return null;
    }

    public static ChangeCorrectionProposal getExtractInterfaceProposal(CodeActionParams params, IInvocationContext context) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        IType type = cu.findPrimaryType();
        if (type == null) {
            return null;
        }
        try {
            CodeGenerationSettings settings = PreferenceManager.getCodeGenerationSettings(cu);
            ExtractInterfaceProcessor processor = new ExtractInterfaceProcessor(type, settings);
            if (RefactoringAvailabilityTester.isExtractInterfaceAvailable(type) && processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                return new CUCorrectionCommandProposal(CorrectionMessages.RefactorProcessor_extract_interface, "refactor.extract.interface", cu, 7, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(EXTRACT_INTERFACE_COMMAND, params));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ChangeCorrectionProposal getChangeSignatureProposal(CodeActionParams params, IInvocationContext context) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        ASTNode methodNode = CodeActionUtility.inferASTNode(context.getCoveringNode(), MethodDeclaration.class);
        if (methodNode == null) {
            return null;
        }
        IMethodBinding methodBinding = ((MethodDeclaration)methodNode).resolveBinding();
        if (methodBinding == null) {
            return null;
        }
        IJavaElement element = methodBinding.getJavaElement();
        IJavaElement iJavaElement = element;
        if (iJavaElement instanceof IMethod) {
            IMethod iMethod = (IMethod)iJavaElement;
            IMethod cfr_ignored_0 = (IMethod)iJavaElement;
            try {
                void method;
                ChangeSignatureProcessor processor = new ChangeSignatureProcessor((IMethod)method);
                if (RefactoringAvailabilityTester.isChangeSignatureAvailable((IMethod)method) && processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                    Object info3;
                    ArrayList<ChangeSignatureHandler.MethodParameter> parameters = new ArrayList<ChangeSignatureHandler.MethodParameter>();
                    for (ParameterInfo info2 : processor.getParameterInfos()) {
                        parameters.add(new ChangeSignatureHandler.MethodParameter(info2.getOldTypeName(), info2.getOldName(), info2.getDefaultValue() == null ? "null" : info2.getDefaultValue(), info2.getOldIndex()));
                    }
                    ArrayList<ChangeSignatureHandler.MethodException> exceptions = new ArrayList<ChangeSignatureHandler.MethodException>();
                    for (Object info3 : processor.getExceptionInfos()) {
                        exceptions.add(new ChangeSignatureHandler.MethodException(info3.getFullyQualifiedName(), info3.getElement().getHandleIdentifier()));
                    }
                    info3 = new ChangeSignatureInfo(method.getHandleIdentifier(), JdtFlags.getVisibilityString((int)processor.getVisibility()), processor.getReturnTypeString(), method.getElementName(), (ChangeSignatureHandler.MethodParameter[])parameters.toArray(ChangeSignatureHandler.MethodParameter[]::new), (ChangeSignatureHandler.MethodException[])exceptions.toArray(ChangeSignatureHandler.MethodException[]::new));
                    String label = Messages.format(org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages.ChangeSignatureRefactoring_change_signature_for, new String[]{method.getElementName()});
                    return new CUCorrectionCommandProposal(label, "refactor.change.signature", cu, 7, APPLY_REFACTORING_COMMAND_ID, Arrays.asList(CHANGE_SIGNATURE_COMMAND, params, info3));
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getUniqueMethodName(ASTNode astNode, String suggestedName) throws JavaModelException {
        while (astNode != null && !(astNode instanceof TypeDeclaration) && !(astNode instanceof AnonymousClassDeclaration)) {
            astNode = astNode.getParent();
        }
        ASTNode aSTNode = astNode;
        if (aSTNode instanceof TypeDeclaration) {
            void typeDecl;
            TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode;
            TypeDeclaration cfr_ignored_0 = (TypeDeclaration)aSTNode;
            ITypeBinding typeBinding = typeDecl.resolveBinding();
            if (typeBinding == null) {
                return suggestedName;
            }
            IType type = (IType)typeBinding.getJavaElement();
            if (type == null) {
                return suggestedName;
            }
            IMethod[] methods = type.getMethods();
            int suggestedPostfix = 2;
            Object resultName = suggestedName;
            while (suggestedPostfix < 1000) {
                if (!RefactorProposalUtility.hasMethod(methods, (String)resultName)) {
                    return resultName;
                }
                resultName = suggestedName + suggestedPostfix++;
            }
        }
        return suggestedName;
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (name.equals(method.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int getIndex(int offset, List<Statement> statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = statements.get(i);
            if (offset <= s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }

    public static class ChangeSignatureInfo {
        public String methodIdentifier;
        public String modifier;
        public String returnType;
        public String methodName;
        public ChangeSignatureHandler.MethodParameter[] parameters;
        public ChangeSignatureHandler.MethodException[] exceptions;

        public ChangeSignatureInfo(String methodIdentifier, String modifier, String returnType, String methodName, ChangeSignatureHandler.MethodParameter[] parameters, ChangeSignatureHandler.MethodException[] exceptions) {
            this.methodIdentifier = methodIdentifier;
            this.modifier = modifier;
            this.returnType = returnType;
            this.methodName = methodName;
            this.parameters = parameters;
            this.exceptions = exceptions;
        }
    }

    public static class ExtractFieldInfo {
        List<String> initializedScopes;

        public ExtractFieldInfo(List<String> scopes) {
            this.initializedScopes = scopes;
        }
    }

    public static enum InitializeScope {
        FIELD_DECLARATION("Field declaration"),
        CURRENT_METHOD("Current method"),
        CLASS_CONSTRUCTORS("Class constructors");

        private final String name;

        private InitializeScope(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static InitializeScope fromName(String name) {
            if (name != null) {
                InitializeScope[] initializeScopeArray = InitializeScope.values();
                int n = initializeScopeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    InitializeScope scope = initializeScopeArray[n2];
                    if (scope.name.equals(name)) {
                        return scope;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public static class MoveFileInfo {
        public String uri;

        public MoveFileInfo(String uri) {
            this.uri = uri;
        }
    }

    public static class MoveMemberInfo {
        public String displayName;
        public int memberType;
        public String enclosingTypeName;
        public String projectName;

        public MoveMemberInfo(String displayName, int memberType, String enclosingTypeName, String projectName) {
            this.displayName = displayName;
            this.memberType = memberType;
            this.enclosingTypeName = enclosingTypeName;
            this.projectName = projectName;
        }

        public MoveMemberInfo(String displayName, String enclosingTypeName, String projectName) {
            this(displayName, 0, enclosingTypeName, projectName);
        }

        public MoveMemberInfo(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class MoveTypeInfo
    extends MoveMemberInfo {
        public List<String> supportedDestinationKinds = new ArrayList<String>();

        public MoveTypeInfo(String displayName, String enclosingTypeName, String projectName) {
            super(displayName, 55, enclosingTypeName, projectName);
        }

        public void addDestinationKind(String kind) {
            this.supportedDestinationKinds.add(kind);
        }

        public boolean isMoveAvaiable() {
            return !this.supportedDestinationKinds.isEmpty();
        }
    }
}

