/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.ls.core.internal.corext.util.CollectionsUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public abstract class RenameMethodProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
IDelegateUpdating {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private SearchResultGroup[] fOccurrences;
    private boolean fUpdateReferences;
    private IMethod fMethod;
    private Set<IMethod> fMethodsToRename;
    private TextChangeManager fChangeManager;
    private WorkingCopyOwner fWorkingCopyOwner;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;
    protected boolean fInitialized = false;

    protected RenameMethodProcessor(IMethod method) {
        this(method, new TextChangeManager(true), null);
        this.fIsComposite = false;
    }

    protected RenameMethodProcessor(IMethod method, TextChangeManager manager, GroupCategorySet categorySet) {
        this.initialize(method);
        this.fChangeManager = manager;
        this.fCategorySet = categorySet;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        this.fIsComposite = true;
    }

    protected void initialize(IMethod method) {
        this.assignMethod(method);
        if (!this.fInitialized) {
            if (method != null) {
                this.setNewElementName(method.getElementName());
            }
            this.fUpdateReferences = true;
            this.initializeWorkingCopyOwner();
        }
    }

    protected void initializeWorkingCopyOwner() {
        this.fWorkingCopyOwner = new WorkingCopyOwner(){};
    }

    protected void setData(RenameMethodProcessor other) {
        this.fUpdateReferences = other.fUpdateReferences;
        this.setNewElementName(other.getNewElementName());
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.renameMethodProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fMethod);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameMethodRefactoring_name;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fMethod);
    }

    public Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        RenameArguments args = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        for (IMethod method : this.fMethodsToRename) {
            result.rename(method, args);
        }
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        return ResourceUtil.getFiles((ICompilationUnit[])this.fChangeManager.getAllCompilationUnits());
    }

    @Override
    public int getSaveMode() {
        return 4;
    }

    public final String getCurrentElementName() {
        return this.fMethod.getElementName();
    }

    public final RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus status = Checks.checkName((String)newName, (IStatus)JavaConventionsUtil.validateMethodName((String)newName, (IJavaElement)this.fMethod));
        if (status.isOK() && !Checks.startsWithLowerCase((String)newName)) {
            status = RefactoringStatus.createWarningStatus((String)(this.fIsComposite ? Messages.format((String)RefactoringCoreMessages.Checks_method_names_lowercase2, (Object[])new String[]{BasicElementLabels.getJavaElementName((String)newName), this.getDeclaringTypeLabel()}) : RefactoringCoreMessages.Checks_method_names_lowercase));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fMethod, (String)newName)) {
            status.addFatalError(this.fIsComposite ? Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_same_name2, (Object[])new String[]{BasicElementLabels.getJavaElementName((String)newName), this.getDeclaringTypeLabel()}) : RefactoringCoreMessages.RenameMethodRefactoring_same_name, JavaStatusContext.create((IMember)this.fMethod));
        }
        return status;
    }

    private String getDeclaringTypeLabel() {
        return JavaElementLabelsCore.getElementLabel((IJavaElement)this.fMethod.getDeclaringType(), (long)0x200009L);
    }

    public Object getNewElement() {
        return this.fMethod.getDeclaringType().getMethod(this.getNewElementName(), this.fMethod.getParameterTypes());
    }

    public final IMethod getMethod() {
        return this.fMethod;
    }

    private void initializeMethodsToRename(IProgressMonitor pm, ReferencesInBinaryContext binaryRefs) throws CoreException {
        if (this.fMethodsToRename == null) {
            IMethod[] rippleMethods = RippleMethodFinder2.getRelatedMethods((IMethod)this.getMethod(), (ReferencesInBinaryContext)binaryRefs, (IProgressMonitor)pm, null);
            this.fMethodsToRename = new HashSet<IMethod>();
            IMethod[] iMethodArray = rippleMethods;
            int n = rippleMethods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (!method.isLambdaMethod()) {
                    this.fMethodsToRename.add(method);
                }
                ++n2;
            }
        }
    }

    protected void setMethodsToRename(IMethod[] methods) {
        this.fMethodsToRename = new HashSet<IMethod>(Arrays.asList(methods));
    }

    protected Set<IMethod> getMethodsToRename() {
        return this.fMethodsToRename;
    }

    protected void assignMethod(IMethod method) {
        this.fMethod = method;
    }

    public final void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableDelegateUpdating() {
        return true;
    }

    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    public void setDelegateUpdating(boolean updating) {
        this.fDelegateUpdating = updating;
    }

    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public void setDeprecateDelegates(boolean deprecate) {
        this.fDelegateDeprecation = deprecate;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (!this.fMethod.exists()) {
            String message = Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_deleted, (Object)BasicElementLabels.getFileName((ITypeRoot)this.fMethod.getCompilationUnit()));
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        RefactoringStatus result = Checks.checkAvailability((IJavaElement)this.fMethod);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
        if (JdtFlags.isNative((IMember)this.fMethod)) {
            result.addError(RefactoringCoreMessages.RenameMethodRefactoring_no_native);
        }
        return result;
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            boolean mustAnalyzeShadowing;
            RefactoringStatus result = new RefactoringStatus();
            pm.beginTask("", 9);
            if (!Checks.isAvailable((IJavaElement)this.fMethod)) {
                result.addFatalError(RefactoringCoreMessages.RenameMethodProcessor_is_binary, JavaStatusContext.create((IMember)this.fMethod));
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_checkingPreconditions);
            result.merge(this.checkNewElementName(this.getNewElementName()));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            IMethod[] newNameMethods = this.searchForDeclarationsOfClashingMethods((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (newNameMethods.length == 0) {
                mustAnalyzeShadowing = false;
                pm.worked(1);
            } else {
                boolean hasOldRefsInInnerTypes;
                IType[] outerTypes = this.searchForOuterTypesOfReferences(newNameMethods, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                mustAnalyzeShadowing = outerTypes.length > 0 ? true : (hasOldRefsInInnerTypes = true);
            }
            String binaryRefsDescription = Messages.format((String)RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, (Object)BasicElementLabels.getJavaElementName((String)this.getCurrentElementName()));
            ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
            this.initializeMethodsToRename((IProgressMonitor)new SubProgressMonitor(pm, 1), binaryRefs);
            pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_searchingForReferences);
            this.fOccurrences = this.getOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 3), result, binaryRefs);
            binaryRefs.addErrorIfNecessary(result);
            pm.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_checkingPreconditions);
            if (this.fUpdateReferences) {
                result.merge(this.checkRelatedMethods());
            }
            result.merge(this.analyzeCompilationUnits());
            pm.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            if (this.fUpdateReferences && mustAnalyzeShadowing) {
                result.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            } else {
                pm.worked(1);
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private IType[] searchForOuterTypesOfReferences(IMethod[] newNameMethods, IProgressMonitor pm) throws CoreException {
        final HashSet outerTypesOfReferences = new HashSet();
        SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])newNameMethods, (int)2);
        IJavaSearchScope scope = RenameMethodProcessor.createRefactoringScope(this.getMethod());
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (!(element instanceof IMember)) {
                    return;
                }
                IMember member = (IMember)element;
                IType declaring = member.getDeclaringType();
                if (declaring == null) {
                    return;
                }
                IType outer = declaring.getDeclaringType();
                if (outer != null) {
                    outerTypesOfReferences.add(declaring);
                }
            }
        };
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        return outerTypesOfReferences.toArray(new IType[outerTypesOfReferences.size()]);
    }

    private IMethod[] searchForDeclarationsOfClashingMethods(IProgressMonitor pm) throws CoreException {
        final ArrayList results = new ArrayList();
        SearchPattern pattern = this.createNewMethodPattern();
        if (pattern == null) {
            return new IMethod[0];
        }
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.getMethod().getJavaProject());
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object method = match.getElement();
                if (method instanceof IMethod) {
                    results.add((IMethod)method);
                } else {
                    JavaLanguageServerPlugin.logError("Unexpected element in search match: " + match.toString());
                }
            }
        };
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
        return results.toArray(new IMethod[results.size()]);
    }

    private SearchPattern createNewMethodPattern() {
        StringBuilder stringPattern = new StringBuilder(this.getNewElementName()).append('(');
        int paramCount = this.getMethod().getNumberOfParameters();
        int i = 0;
        while (i < paramCount) {
            if (i > 0) {
                stringPattern.append(',');
            }
            stringPattern.append('*');
            ++i;
        }
        stringPattern.append(')');
        return SearchPattern.createPattern((String)stringPattern.toString(), (int)1, (int)0, (int)24);
    }

    protected final IJavaSearchScope createRefactoringScope() throws CoreException {
        return RenameMethodProcessor.createRefactoringScope(this.fMethod);
    }

    protected static final IJavaSearchScope createRefactoringScope(IMethod method) throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)method, (boolean)true, (boolean)false);
    }

    protected SearchPattern createOccurrenceSearchPattern() {
        HashSet<IMethod> methods = new HashSet<IMethod>(this.fMethodsToRename);
        methods.add(this.fMethod);
        IMethod[] ms = methods.toArray(new IMethod[methods.size()]);
        return RefactoringSearchEngine.createOrPattern((IJavaElement[])ms, (int)3);
    }

    protected SearchResultGroup[] getOccurrences() {
        return this.fOccurrences;
    }

    private SearchResultGroup[] getOccurrences(IProgressMonitor pm, RefactoringStatus status, ReferencesInBinaryContext binaryRefs) throws CoreException {
        SearchPattern pattern = this.createOccurrenceSearchPattern();
        return RefactoringSearchEngine.search((SearchPattern)pattern, (IJavaSearchScope)this.createRefactoringScope(), (CollectingSearchRequestor)new MethodOccurenceCollector(this.getMethod().getElementName(), binaryRefs), (IProgressMonitor)pm, (RefactoringStatus)status);
    }

    private RefactoringStatus checkRelatedMethods() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        for (IMethod method : this.fMethodsToRename) {
            result.merge(Checks.checkIfConstructorName((IMethod)method, (String)this.getNewElementName(), (String)method.getDeclaringType().getElementName()));
            Object[] msgData = new String[]{BasicElementLabels.getJavaElementName((String)method.getElementName()), BasicElementLabels.getJavaElementName((String)method.getDeclaringType().getFullyQualifiedName('.'))};
            if (!method.exists()) {
                result.addFatalError(Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_not_in_model, (Object[])msgData));
                continue;
            }
            if (method.isBinary()) {
                result.addFatalError(Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_no_binary, (Object[])msgData));
            }
            if (method.isReadOnly()) {
                result.addFatalError(Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_no_read_only, (Object[])msgData));
            }
            if (!JdtFlags.isNative((IMember)method)) continue;
            result.addError(Messages.format((String)RefactoringCoreMessages.RenameMethodRefactoring_no_native_1, (Object[])msgData));
        }
        return result;
    }

    private RefactoringStatus analyzeCompilationUnits() throws CoreException {
        if (this.fOccurrences.length == 0) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits((SearchResultGroup[])this.fOccurrences, (RefactoringStatus)result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles((SearchResultGroup[])this.fOccurrences));
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor pm) throws CoreException {
        newDeclarationWCs = null;
        try {
            pm.beginTask("", 4);
            result = new RefactoringStatus();
            declarationCUs = this.getDeclarationCUs();
            newDeclarationWCs = RenameAnalyzeUtil.createNewWorkingCopies((ICompilationUnit[])declarationCUs, (TextChangeManager)this.fChangeManager, (WorkingCopyOwner)this.fWorkingCopyOwner, (SubProgressMonitor)new SubProgressMonitor(pm, 1));
            wcOldMethods = new IMethod[this.fMethodsToRename.size()];
            wcNewMethods = new IMethod[this.fMethodsToRename.size()];
            i = 0;
            for (IMethod method : this.fMethodsToRename) {
                newCu = RenameAnalyzeUtil.findWorkingCopyForCu((ICompilationUnit[])newDeclarationWCs, (ICompilationUnit)method.getCompilationUnit());
                typeWc = (IType)JavaModelUtil.findInCompilationUnit((ICompilationUnit)newCu, (IJavaElement)method.getDeclaringType());
                if (typeWc == null) {
                    --i;
                    wcOldMethods = CollectionsUtil.toArray(Arrays.asList(wcOldMethods).subList(0, wcOldMethods.length - 1), IMethod.class);
                    wcNewMethods = CollectionsUtil.toArray(Arrays.asList(wcNewMethods).subList(0, wcNewMethods.length - 1), IMethod.class);
                } else {
                    wcOldMethods[i] = this.getMethodInWorkingCopy(method, this.getCurrentElementName(), typeWc);
                    wcNewMethods[i] = this.getMethodInWorkingCopy(method, this.getNewElementName(), typeWc);
                }
                ++i;
            }
            newOccurrences = this.batchFindNewOccurrences(wcNewMethods, wcOldMethods, newDeclarationWCs, (IProgressMonitor)new SubProgressMonitor(pm, 3), result);
            result.merge(RenameAnalyzeUtil.analyzeRenameChanges2((TextChangeManager)this.fChangeManager, (SearchResultGroup[])this.fOccurrences, (SearchResultGroup[])newOccurrences, (String)this.getNewElementName()));
            var13_12 = result;
            return var13_12;
        }
        finally {
            pm.done();
            if (newDeclarationWCs == null) return var13_12;
            var17_13 = newDeclarationWCs;
            var16_15 = newDeclarationWCs.length;
            var15_17 = 0;
            ** while (var15_17 < var16_15)
        }
lbl-1000:
        // 1 sources

        {
            newDeclarationWC = var17_13[var15_17];
            newDeclarationWC.discardWorkingCopy();
            ++var15_17;
            continue;
        }
lbl37:
        // 1 sources

        return var13_12;
    }

    /*
     * Unable to fully structure code
     */
    private SearchResultGroup[] batchFindNewOccurrences(IMethod[] wcNewMethods, final IMethod[] wcOldMethods, ICompilationUnit[] newDeclarationWCs, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        block7: {
            pm.beginTask("", 2);
            refsPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])wcNewMethods, (int)2);
            searchParticipants = SearchUtils.getDefaultSearchParticipants();
            scope = RefactoringScopeFactory.create((IMember[])wcNewMethods);
            requestor = this.getDelegateUpdating() != false ? new MethodOccurenceCollector(this.getNewElementName()){

                @Override
                public void acceptSearchMatch(ICompilationUnit unit, SearchMatch match) throws CoreException {
                    IMethod[] iMethodArray = wcOldMethods;
                    int n = wcOldMethods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod occurrence = iMethodArray[n2];
                        if (occurrence.equals(match.getElement())) {
                            return;
                        }
                        ++n2;
                    }
                    super.acceptSearchMatch(unit, match);
                }
            } : new MethodOccurenceCollector(this.getNewElementName());
            searchEngine = new SearchEngine(this.fWorkingCopyOwner);
            needWCs = new ArrayList<ICompilationUnit>();
            declaringCUs = new HashSet<ICompilationUnit>(newDeclarationWCs.length);
            var16_13 = newDeclarationWCs;
            var15_16 = newDeclarationWCs.length;
            var14_19 = 0;
            while (var14_19 < var15_16) {
                newDeclarationWC = var16_13[var14_19];
                declaringCUs.add(newDeclarationWC.getPrimary());
                ++var14_19;
            }
            var16_13 = this.fOccurrences;
            var15_16 = this.fOccurrences.length;
            var14_19 = 0;
            while (var14_19 < var15_16) {
                occurrence = var16_13[var14_19];
                cu = occurrence.getCompilationUnit();
                if (!declaringCUs.contains(cu)) {
                    needWCs.add(cu);
                }
                ++var14_19;
            }
            otherWCs = null;
            try {
                otherWCs = RenameAnalyzeUtil.createNewWorkingCopies((ICompilationUnit[])needWCs.toArray(new ICompilationUnit[needWCs.size()]), (TextChangeManager)this.fChangeManager, (WorkingCopyOwner)this.fWorkingCopyOwner, (SubProgressMonitor)new SubProgressMonitor(pm, 1));
                searchEngine.search(refsPattern, searchParticipants, scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            finally {
                pm.done();
                if (otherWCs == null) break block7;
                var18_27 = otherWCs;
                var17_25 = otherWCs.length;
                var16_15 = 0;
                ** while (var16_15 < var17_25)
            }
lbl-1000:
            // 1 sources

            {
                otherWC = var18_27[var16_15];
                otherWC.discardWorkingCopy();
                ++var16_15;
                continue;
            }
        }
        newResults = RefactoringSearchEngine.groupByCu((List)requestor.getResults(), (RefactoringStatus)status);
        return newResults;
    }

    private ICompilationUnit[] getDeclarationCUs() {
        HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
        for (IMethod method : this.fMethodsToRename) {
            cus.add(method.getCompilationUnit());
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    private IMethod getMethodInWorkingCopy(IMethod method, String elementName, IType typeWc) {
        String[] paramTypeSignatures = method.getParameterTypes();
        return typeWc.getMethod(elementName, paramTypeSignatures);
    }

    private static IMethod[] classesDeclareMethodName(ITypeHierarchy hier, List<IType> classes, IMethod method, String newName) throws CoreException {
        HashSet<IMethod> result = new HashSet<IMethod>();
        IType type = method.getDeclaringType();
        List<IType> subtypes = Arrays.asList(hier.getAllSubtypes(type));
        int parameterCount = method.getParameterTypes().length;
        boolean isMethodPrivate = JdtFlags.isPrivate((IMember)method);
        for (IType clazz : classes) {
            boolean isSubclass = subtypes.contains(clazz);
            IMethod[] iMethodArray = clazz.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                IMethod foundMethod = Checks.findMethod((String)newName, (int)parameterCount, (boolean)false, (IMethod[])new IMethod[]{m});
                if (foundMethod != null && (isSubclass || type.equals(clazz) || !isMethodPrivate && !JdtFlags.isPrivate((IMember)m))) {
                    result.add(foundMethod);
                }
                ++n2;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    static final IMethod[] hierarchyDeclaresMethodName(IProgressMonitor pm, ITypeHierarchy hierarchy, IMethod method, String newName) throws CoreException {
        try {
            IType[] implementingClasses;
            IMethod[] foundInImplementingClasses;
            IMethod[] foundInHierarchyClasses;
            HashSet<IMethod> result = new HashSet<IMethod>();
            IType type = method.getDeclaringType();
            IMethod foundMethod = Checks.findMethod((String)newName, (int)method.getParameterTypes().length, (boolean)false, (IType)type);
            if (foundMethod != null) {
                result.add(foundMethod);
            }
            if ((foundInHierarchyClasses = RenameMethodProcessor.classesDeclareMethodName(hierarchy, Arrays.asList(hierarchy.getAllClasses()), method, newName)) != null) {
                result.addAll(Arrays.asList(foundInHierarchyClasses));
            }
            if ((foundInImplementingClasses = RenameMethodProcessor.classesDeclareMethodName(hierarchy, Arrays.asList(implementingClasses = hierarchy.getImplementingClasses(type)), method, newName)) != null) {
                result.addAll(Arrays.asList(foundInImplementingClasses));
            }
            IMethod[] iMethodArray = result.toArray(new IMethod[result.size()]);
            return iMethodArray;
        }
        finally {
            if (pm != null) {
                pm.done();
            }
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            TextChange[] changes = this.fChangeManager.getAllChanges();
            ArrayList<TextChange> list = new ArrayList<TextChange>(changes.length);
            list.addAll(Arrays.asList(changes));
            String project = null;
            IJavaProject javaProject = this.fMethod.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589826;
            try {
                if (!Flags.isPrivate((int)this.fMethod.getFlags())) {
                    flags |= 4;
                }
            }
            catch (JavaModelException exception) {
                JavaLanguageServerPlugin.logException(exception);
            }
            IType declaring = this.fMethod.getDeclaringType();
            try {
                if (declaring.isAnonymous() || declaring.isLocal()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaLanguageServerPlugin.logException(exception);
            }
            String description = Messages.format((String)RefactoringCoreMessages.RenameMethodProcessor_descriptor_description_short, (Object)BasicElementLabels.getJavaElementName((String)this.fMethod.getElementName()));
            String header = Messages.format((String)RefactoringCoreMessages.RenameMethodProcessor_descriptor_description, (Object[])new String[]{JavaElementLabelsCore.getTextLabel((Object)this.fMethod, (long)2235681801344L), BasicElementLabels.getJavaElementName((String)this.getNewElementName())});
            String comment = new JDTRefactoringDescriptorComment(project, (Object)this, header).asString();
            RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor((String)"org.eclipse.jdt.ui.rename.method");
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setJavaElement((IJavaElement)this.fMethod);
            descriptor.setNewName(this.getNewElementName());
            descriptor.setUpdateReferences(this.fUpdateReferences);
            descriptor.setKeepOriginal(this.fDelegateUpdating);
            descriptor.setDeprecateDelegate(this.fDelegateDeprecation);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameMethodProcessor_change_name, list.toArray(new Change[list.size()]));
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    protected TextChangeManager createChanges(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        if (!this.fIsComposite) {
            this.fChangeManager.clear();
        }
        this.addOccurrences(this.fChangeManager, pm, status);
        return this.fChangeManager;
    }

    protected void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", this.fOccurrences.length);
        SearchResultGroup[] searchResultGroupArray = this.fOccurrences;
        int n = this.fOccurrences.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup occurrence = searchResultGroupArray[n2];
            ICompilationUnit cu = occurrence.getCompilationUnit();
            if (cu != null) {
                ArrayList<SearchMatch> declarationsInThisCu = new ArrayList<SearchMatch>();
                ArrayList<SearchMatch> referencesInThisCu = new ArrayList<SearchMatch>();
                SearchMatch[] searchMatchArray = occurrence.getSearchResults();
                int n3 = searchMatchArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    SearchMatch result = searchMatchArray[n4];
                    if (result instanceof MethodDeclarationMatch) {
                        declarationsInThisCu.add(result);
                    } else {
                        referencesInThisCu.add(result);
                    }
                    ++n4;
                }
                if (declarationsInThisCu.size() > 0) {
                    if (this.fDelegateUpdating) {
                        CompilationUnitRewrite rewrite = new CompilationUnitRewrite(cu);
                        rewrite.setResolveBindings(true);
                        for (SearchMatch element : declarationsInThisCu) {
                            MethodDeclaration method = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)((IMethod)element.getElement()), (CompilationUnit)rewrite.getRoot());
                            DelegateMethodCreator creator = new DelegateMethodCreator();
                            creator.setDeclareDeprecated(this.fDelegateDeprecation);
                            creator.setDeclaration((BodyDeclaration)method);
                            creator.setSourceRewrite(rewrite);
                            creator.setNewElementName(this.getNewElementName());
                            creator.prepareDelegate();
                            creator.createEdit();
                        }
                        CompilationUnitChange changeForThisCu = rewrite.createChange(true);
                        changeForThisCu.setKeepPreviewEdits(true);
                        manager.manage(cu, (TextChange)changeForThisCu);
                    }
                    for (SearchMatch element : declarationsInThisCu) {
                        this.simpleUpdate(element, cu, manager.get(cu));
                    }
                }
                if (this.fUpdateReferences) {
                    for (SearchMatch element : referencesInThisCu) {
                        this.simpleUpdate(element, cu, manager.get(cu));
                    }
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n2;
        }
        pm.done();
    }

    private void simpleUpdate(SearchMatch element, ICompilationUnit cu, TextChange textChange) {
        String editName = RefactoringCoreMessages.RenameMethodRefactoring_update_occurrence;
        ReplaceEdit replaceEdit = this.createReplaceEdit(element, cu);
        this.addTextEdit(textChange, editName, replaceEdit);
    }

    protected final ReplaceEdit createReplaceEdit(SearchMatch searchResult, ICompilationUnit cu) {
        if (searchResult.isImplicit()) {
            StringBuilder sb = new StringBuilder(this.getNewElementName());
            if ("insert".equals(cu.getJavaProject().getOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", true))) {
                sb.append(' ');
            }
            sb.append('=');
            if ("insert".equals(cu.getJavaProject().getOption("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", true))) {
                sb.append(' ');
            }
            return new ReplaceEdit(searchResult.getOffset(), 0, sb.toString());
        }
        return new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), this.getNewElementName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final RefactoringStatus initialize(JavaRefactoringArguments extended) {
        this.fInitialized = true;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
        IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement((String)extended.getProject(), (String)handle, (boolean)false);
        String refactoring = this.getProcessorName();
        if (!(element instanceof IMethod)) return JavaRefactoringDescriptorUtil.createInputFatalStatus((Object)element, (String)refactoring, (String)"org.eclipse.jdt.ui.rename.method");
        IMethod method = (IMethod)element;
        IType declaring = method.getDeclaringType();
        if (declaring == null || !declaring.exists()) return JavaRefactoringDescriptorUtil.createInputFatalStatus((Object)element, (String)refactoring, (String)"org.eclipse.jdt.ui.rename.method");
        IMethod[] methods = declaring.findMethods(method);
        if (methods == null || methods.length != 1 || methods[0] == null) return JavaRefactoringDescriptorUtil.createInputFatalStatus(null, (String)refactoring, (String)"org.eclipse.jdt.ui.rename.method");
        if (!methods[0].exists()) {
            return JavaRefactoringDescriptorUtil.createInputFatalStatus((Object)methods[0], (String)refactoring, (String)"org.eclipse.jdt.ui.rename.method");
        }
        this.assignMethod(methods[0]);
        this.initializeWorkingCopyOwner();
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"name"));
        }
        this.setNewElementName(name);
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"references"));
        }
        this.fUpdateReferences = Boolean.parseBoolean(references);
        String delegate = extended.getAttribute(ATTRIBUTE_DELEGATE);
        if (delegate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_DELEGATE));
        }
        this.fDelegateUpdating = Boolean.parseBoolean(delegate);
        String deprecate = extended.getAttribute(ATTRIBUTE_DEPRECATE);
        if (deprecate == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_DEPRECATE));
        }
        this.fDelegateDeprecation = Boolean.parseBoolean(deprecate);
        return new RefactoringStatus();
    }

    protected void addTextEdit(TextChange change, String editName, ReplaceEdit replaceEdit) {
        if (this.fIsComposite) {
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)editName, (TextEdit)replaceEdit, (GroupCategorySet)this.fCategorySet);
        } else {
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)editName, (TextEdit)replaceEdit);
        }
    }
}

