/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.internal.core.refactoring.resource.UndoDeleteResourceChange;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ResourceUndoState;

public class DeleteSourceManipulationChange
extends AbstractDeleteChange {
    private final String fHandle;

    public DeleteSourceManipulationChange(ISourceManipulation sm, boolean isExecuteChange) {
        Assert.isNotNull((Object)sm);
        this.fHandle = DeleteSourceManipulationChange.getJavaElement(sm).getHandleIdentifier();
        if (isExecuteChange) {
            if (sm instanceof ICompilationUnit) {
                this.setValidationMethod(0);
            } else {
                this.setValidationMethod(2);
            }
        } else {
            this.setValidationMethod(3);
        }
    }

    public String getName() {
        IJavaElement javaElement = DeleteSourceManipulationChange.getJavaElement(this.getSourceManipulation());
        return Messages.format(RefactoringCoreMessages.DeleteSourceManipulationChange_0, JavaElementLabelsCore.getElementLabel((IJavaElement)javaElement, (long)0x200009L));
    }

    public Object getModifiedElement() {
        return JavaCore.create((String)this.fHandle);
    }

    protected IResource getModifiedResource() {
        IJavaElement elem = JavaCore.create((String)this.fHandle);
        if (elem != null) {
            return elem.getResource();
        }
        return null;
    }

    @Override
    protected Change doDelete(IProgressMonitor pm) throws CoreException {
        ISourceManipulation element = this.getSourceManipulation();
        if (element instanceof ICompilationUnit) {
            pm.beginTask("", 2);
            ICompilationUnit unit = (ICompilationUnit)element;
            DeleteSourceManipulationChange.saveCUnitIfNeeded(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IResource resource = unit.getResource();
            return new UndoDeleteResourceChange(ResourceUndoState.fromResource((IResource)resource));
        }
        if (element instanceof IPackageFragment) {
            ICompilationUnit[] units = ((IPackageFragment)element).getCompilationUnits();
            pm.beginTask("", units.length + 1);
            int i = 0;
            while (i < units.length) {
                DeleteSourceManipulationChange.saveCUnitIfNeeded(units[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                ++i;
            }
            element.delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            return new NullChange();
        }
        element.delete(false, pm);
        return null;
    }

    private ISourceManipulation getSourceManipulation() {
        return (ISourceManipulation)this.getModifiedElement();
    }

    private static IJavaElement getJavaElement(ISourceManipulation sm) {
        return (IJavaElement)sm;
    }

    private static void saveCUnitIfNeeded(ICompilationUnit unit, IProgressMonitor pm) throws CoreException {
        DeleteSourceManipulationChange.saveFileIfNeeded((IFile)unit.getResource(), pm);
    }
}

