/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;

public class QuickAssistProcessorUtil {
    public static IMethodBinding getFunctionalMethodForMethodReference(MethodReference methodReference) {
        ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)methodReference);
        if (targetTypeBinding == null) {
            return null;
        }
        IMethodBinding functionalMethod = targetTypeBinding.getFunctionalInterfaceMethod();
        if (functionalMethod != null && functionalMethod.isSynthetic()) {
            functionalMethod = Bindings.findOverriddenMethodInType(functionalMethod.getDeclaringClass(), functionalMethod);
        }
        return functionalMethod;
    }

    public static LambdaExpression convertMethodRefernceToLambda(MethodReference methodReference, IMethodBinding functionalMethod, CompilationUnit astRoot, ASTRewrite rewrite, LinkedProposalModelCore linkedProposalModel, boolean createBlockBody) throws JavaModelException {
        AST ast = astRoot.getAST();
        LambdaExpression lambda = ast.newLambdaExpression();
        String[] lambdaParamNames = QuickAssistProcessorUtil.getUniqueParameterNames(methodReference, functionalMethod);
        List lambdaParameters = lambda.parameters();
        int i = 0;
        while (i < lambdaParamNames.length) {
            String paramName = lambdaParamNames[i];
            VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
            SimpleName name = ast.newSimpleName(paramName);
            lambdaParameter.setName(name);
            lambdaParameters.add(lambdaParameter);
            if (linkedProposalModel != null) {
                linkedProposalModel.getPositionGroup(name.getIdentifier(), true).addPosition(rewrite.track((ASTNode)name), i == 0);
            }
            ++i;
        }
        int noOfLambdaParameters = lambdaParamNames.length;
        lambda.setParentheses(noOfLambdaParameters != 1);
        ITypeBinding returnTypeBinding = functionalMethod.getReturnType();
        IMethodBinding referredMethodBinding = methodReference.resolveMethodBinding();
        if (methodReference instanceof CreationReference) {
            CreationReference creationRef = (CreationReference)methodReference;
            Type type = creationRef.getType();
            if (type instanceof ArrayType) {
                ArrayCreation arrayCreation = ast.newArrayCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)arrayCreation, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)arrayCreation);
                }
                ArrayType arrayType = (ArrayType)type;
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                arrayCreation.setType(ast.newArrayType(copiedElementType, arrayType.getDimensions()));
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                arrayCreation.dimensions().add(name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)cic, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)cic);
                }
                ITypeBinding typeBinding = type.resolveBinding();
                if (!(type instanceof ParameterizedType) && typeBinding != null && typeBinding.getTypeDeclaration().isGenericType()) {
                    cic.setType((Type)ast.newParameterizedType((Type)rewrite.createCopyTarget((ASTNode)type)));
                } else {
                    cic.setType((Type)rewrite.createCopyTarget((ASTNode)type));
                }
                List<SimpleName> invocationArgs = QuickAssistProcessorUtil.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
                cic.arguments().addAll(invocationArgs);
                if (linkedProposalModel != null) {
                    for (SimpleName name : invocationArgs) {
                        linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                    }
                }
                cic.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
            }
        } else if (referredMethodBinding != null && Modifier.isStatic((int)referredMethodBinding.getModifiers())) {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            Expression expr = null;
            boolean hasConflict = QuickAssistProcessorUtil.hasConflict(methodReference.getStartPosition(), referredMethodBinding, 17, astRoot);
            if (hasConflict || !Bindings.isSuperType(referredMethodBinding.getDeclaringClass(), ASTNodes.getEnclosingType((ASTNode)methodReference)) || methodReference.typeArguments().size() != 0) {
                Type type;
                ITypeBinding typeBinding;
                if (methodReference instanceof ExpressionMethodReference) {
                    ExpressionMethodReference expressionMethodReference = (ExpressionMethodReference)methodReference;
                    expr = (Expression)rewrite.createCopyTarget((ASTNode)expressionMethodReference.getExpression());
                } else if (methodReference instanceof TypeMethodReference && (typeBinding = (type = ((TypeMethodReference)methodReference).getType()).resolveBinding()) != null) {
                    ImportRewrite importRewrite = StubUtility.createImportRewrite(astRoot, true);
                    expr = ast.newName(importRewrite.addImport(typeBinding));
                }
            }
            methodInvocation.setExpression(expr);
            SimpleName methodName = QuickAssistProcessorUtil.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessorUtil.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else if (methodReference instanceof SuperMethodReference) {
            SuperMethodInvocation superMethodInvocation = ast.newSuperMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)superMethodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)superMethodInvocation);
            }
            Name superQualifier = ((SuperMethodReference)methodReference).getQualifier();
            if (superQualifier != null) {
                superMethodInvocation.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
            }
            SimpleName methodName = QuickAssistProcessorUtil.getMethodInvocationName(methodReference);
            superMethodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessorUtil.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            superMethodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            superMethodInvocation.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else {
            methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            boolean isTypeReference = QuickAssistProcessorUtil.isTypeReferenceToInstanceMethod(methodReference);
            if (isTypeReference) {
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                methodInvocation.setExpression((Expression)name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                Expression expr = ((ExpressionMethodReference)methodReference).getExpression();
                if (!(expr instanceof ThisExpression) || methodReference.typeArguments().size() != 0) {
                    methodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expr));
                }
            }
            SimpleName methodName = QuickAssistProcessorUtil.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessorUtil.getInvocationArguments(ast, isTypeReference ? 1 : 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessorUtil.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        }
        rewrite.replace((ASTNode)methodReference, (ASTNode)lambda, null);
        return lambda;
    }

    public static Block getBlockBodyForLambda(Expression bodyExpr, ITypeBinding returnTypeBinding, AST ast) {
        ExpressionStatement statementInBlockBody;
        if (ast.resolveWellKnownType("void").isEqualTo((IBinding)returnTypeBinding)) {
            ExpressionStatement expressionStatement;
            statementInBlockBody = expressionStatement = ast.newExpressionStatement(bodyExpr);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(bodyExpr);
            statementInBlockBody = returnStatement;
        }
        Block blockBody = ast.newBlock();
        blockBody.statements().add(statementInBlockBody);
        return blockBody;
    }

    public static List<Type> getCopiedTypeArguments(ASTRewrite rewrite, List<Type> typeArguments) {
        ArrayList<Type> copiedTypeArgs = new ArrayList<Type>();
        for (Type typeArg : typeArguments) {
            copiedTypeArgs.add((Type)rewrite.createCopyTarget((ASTNode)typeArg));
        }
        return copiedTypeArgs;
    }

    private static SimpleName getMethodInvocationName(MethodReference methodReference) {
        SimpleName name = null;
        if (methodReference instanceof ExpressionMethodReference) {
            name = ((ExpressionMethodReference)methodReference).getName();
        } else if (methodReference instanceof TypeMethodReference) {
            name = ((TypeMethodReference)methodReference).getName();
        } else if (methodReference instanceof SuperMethodReference) {
            name = ((SuperMethodReference)methodReference).getName();
        }
        return name;
    }

    public static String[] getUniqueParameterNames(MethodReference methodReference, IMethodBinding functionalMethod) throws JavaModelException {
        String[] originalParameterNames = ((IMethod)functionalMethod.getJavaElement()).getParameterNames();
        String[] newNames = new String[originalParameterNames.length];
        HashSet<String> excludedNames = new HashSet<String>(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodReference));
        int i = 0;
        while (i < originalParameterNames.length) {
            String paramName = originalParameterNames[i];
            if (excludedNames.contains(paramName)) {
                HashSet<String> allNamesToExclude = new HashSet<String>(excludedNames);
                Collections.addAll(allNamesToExclude, originalParameterNames);
                String newParamName = QuickAssistProcessorUtil.createName(paramName, allNamesToExclude);
                excludedNames.add(newParamName);
                newNames[i] = newParamName;
            } else {
                newNames[i] = paramName;
            }
            ++i;
        }
        return newNames;
    }

    private static String createName(String nameRoot, Set<String> excludedNames) {
        String candidate;
        int i = 1;
        while (excludedNames.remove(candidate = nameRoot + i++)) {
        }
        return candidate;
    }

    private static List<SimpleName> getInvocationArguments(AST ast, int begIndex, int noOfLambdaParameters, String[] lambdaParamNames) {
        ArrayList<SimpleName> args = new ArrayList<SimpleName>();
        int i = begIndex;
        while (i < noOfLambdaParameters) {
            args.add(ast.newSimpleName(lambdaParamNames[i]));
            ++i;
        }
        return args;
    }

    private static boolean hasConflict(int startPosition, IMethodBinding referredMethodBinding, int flags, CompilationUnit cu) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(cu);
        IBinding[] iBindingArray = analyzer.getDeclarationsInScope(startPosition, flags);
        int n = iBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding decl = iBindingArray[n2];
            if (decl.getName().equals(referredMethodBinding.getName()) && !referredMethodBinding.getMethodDeclaration().isEqualTo(decl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isTypeReferenceToInstanceMethod(MethodReference methodReference) {
        IBinding nameBinding;
        Expression expression;
        if (methodReference instanceof TypeMethodReference) {
            return true;
        }
        return methodReference instanceof ExpressionMethodReference && (expression = ((ExpressionMethodReference)methodReference).getExpression()) instanceof Name && (nameBinding = ((Name)expression).resolveBinding()) instanceof ITypeBinding;
    }

    public static void changeLambdaBodyToBlock(LambdaExpression lambda, AST ast, ASTRewrite rewrite) {
        Expression bodyExpr = (Expression)rewrite.createMoveTarget(lambda.getBody());
        Block blockBody = QuickAssistProcessorUtil.getBlockBodyForLambda(bodyExpr, lambda.resolveMethodBinding().getReturnType(), ast);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)blockBody, null);
    }

    public static List<ASTNode> getCoveredAutoClosableNodes(List<ASTNode> astNodes) {
        ArrayList<ASTNode> autoClosableNodes = new ArrayList<ASTNode>();
        for (ASTNode astNode : astNodes) {
            if (QuickAssistProcessorUtil.isAutoClosable(astNode)) {
                autoClosableNodes.add(astNode);
                continue;
            }
            return autoClosableNodes;
        }
        return autoClosableNodes;
    }

    public static int findEndPostion(ASTNode node) {
        int end = node.getStartPosition() + node.getLength();
        Map<SimpleName, IVariableBinding> nodeSimpleNameBindings = QuickAssistProcessorUtil.getVariableStatementBinding(node);
        ArrayList<SimpleName> nodeNames = new ArrayList<SimpleName>(nodeSimpleNameBindings.keySet());
        if (nodeNames.isEmpty()) {
            return -1;
        }
        SimpleName nodeSimpleName = (SimpleName)nodeNames.get(0);
        SimpleName[] coveredNodeBindings = LinkedNodeFinder.findByNode(node.getRoot(), nodeSimpleName);
        if (coveredNodeBindings.length == 0) {
            return -1;
        }
        SimpleName[] simpleNameArray = coveredNodeBindings;
        int n = coveredNodeBindings.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName astNode = simpleNameArray[n2];
            end = Math.max(end, astNode.getStartPosition() + astNode.getLength());
            ++n2;
        }
        return end;
    }

    public static Map<SimpleName, IVariableBinding> getVariableStatementBinding(ASTNode astNode) {
        final HashMap<SimpleName, IVariableBinding> variableBindings = new HashMap<SimpleName, IVariableBinding>();
        astNode.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationStatement node) {
                for (Object o : node.fragments()) {
                    VariableDeclarationFragment vdf;
                    SimpleName name;
                    IBinding binding;
                    if (!(o instanceof VariableDeclarationFragment) || !((binding = (name = (vdf = (VariableDeclarationFragment)o).getName()).resolveBinding()) instanceof IVariableBinding)) continue;
                    variableBindings.put(name, (IVariableBinding)binding);
                    break;
                }
                return false;
            }
        });
        return variableBindings;
    }

    public static boolean isAutoClosable(ITypeBinding typeBinding) {
        return Bindings.findTypeInHierarchy(typeBinding, "java.lang.AutoCloseable") != null;
    }

    public static boolean isAutoClosable(ASTNode astNode) {
        Map<SimpleName, IVariableBinding> simpleNames = QuickAssistProcessorUtil.getVariableStatementBinding(astNode);
        block3: for (Map.Entry<SimpleName, IVariableBinding> entry : simpleNames.entrySet()) {
            ITypeBinding typeBinding = null;
            switch (entry.getKey().getParent().getNodeType()) {
                case 7: 
                case 59: 
                case 60: {
                    typeBinding = entry.getValue().getType();
                    break;
                }
                default: {
                    continue block3;
                }
            }
            if (typeBinding == null || !QuickAssistProcessorUtil.isAutoClosable(typeBinding)) continue;
            return true;
        }
        return false;
    }

    public static int getIndex(int offset, List<Statement> statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = statements.get(i);
            if (offset <= s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }
}

