/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.model.builder;

import com.microsoft.java.test.plugin.model.JavaTestItem;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import com.microsoft.java.test.plugin.util.TestItemUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.lsp4j.Range;

public class JavaTestItemBuilder {
    private static final String DEFAULT_PACKAGE_NAME = "<Default Package>";
    private IJavaElement element;
    private TestLevel level;
    private TestKind kind;

    public JavaTestItemBuilder setJavaElement(IJavaElement element) {
        this.element = element;
        return this;
    }

    public JavaTestItemBuilder setLevel(TestLevel level) {
        this.level = level;
        return this;
    }

    public JavaTestItemBuilder setKind(TestKind kind) {
        this.kind = kind;
        return this;
    }

    public JavaTestItem build() throws JavaModelException {
        String displayName;
        if (this.element == null || this.level == null || this.kind == null) {
            throw new IllegalArgumentException("Failed to build Java test item due to missing arguments");
        }
        String uri = null;
        if (this.element instanceof IJavaProject) {
            IJavaProject javaProject = (IJavaProject)this.element;
            IProject project = javaProject.getProject();
            if (ProjectUtils.isVisibleProject((IProject)project)) {
                displayName = project.getName();
            } else {
                IPath realPath = ProjectUtils.getProjectRealFolder((IProject)project);
                displayName = realPath.lastSegment();
                uri = realPath.toFile().toURI().toString();
            }
        } else {
            displayName = this.element instanceof IPackageFragment && ((IPackageFragment)this.element).isDefaultPackage() ? DEFAULT_PACKAGE_NAME : JavaElementLabels.getElementLabel((IJavaElement)this.element, (long)JavaElementLabels.ALL_DEFAULT);
        }
        String fullName = TestItemUtils.parseFullName(this.element, this.level, this.kind);
        if (uri == null) {
            uri = JDTUtils.getFileURI((IResource)this.element.getResource());
        }
        Range range = null;
        if (this.level == TestLevel.CLASS || this.level == TestLevel.METHOD) {
            range = TestItemUtils.parseTestItemRange(this.element);
        }
        String projectName = this.element.getJavaProject().getProject().getName();
        JavaTestItem result = new JavaTestItem(displayName, fullName, projectName, uri, range, this.level, this.kind);
        result.setJdtHandler(this.element.getHandleIdentifier());
        return result;
    }
}

