"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RawKeybinding = exports.Keybinding = void 0;
var Keybinding;
(function (Keybinding) {
    /**
     * Compares two keybindings for equality.
     * Can optionally ignore the keybinding and/or args property in the comparison.
     * @param a The first Keybinding in the comparison
     * @param b The second Keybinding in the comparison
     * @param ignoreKeybinding Ignore the 'keybinding' property in the comparison
     * @param ignoreArgs Ignore the 'args' property in the comparison
     */
    function equals(a, b, ignoreKeybinding = false, ignoreArgs = false) {
        if (a.command === b.command &&
            (a.context || '') === (b.context || '') &&
            (a.when || '') === (b.when || '') &&
            (ignoreKeybinding || a.keybinding === b.keybinding) &&
            (ignoreArgs || (a.args || '') === (b.args || ''))) {
            return true;
        }
        return false;
    }
    Keybinding.equals = equals;
    /**
     * Returns a new object only containing properties which
     * are described on the `Keybinding` API.
     *
     * @param binding the binding to create an API object for.
     */
    function apiObjectify(binding) {
        return {
            command: binding.command,
            keybinding: retrieveKeybinding(binding),
            context: binding.context,
            when: binding.when,
            args: binding.args
        };
    }
    Keybinding.apiObjectify = apiObjectify;
    function retrieveKeybinding(binding) {
        var _a, _b;
        return (_b = (_a = binding.keybinding) !== null && _a !== void 0 ? _a : binding.key) !== null && _b !== void 0 ? _b : '';
    }
    Keybinding.retrieveKeybinding = retrieveKeybinding;
    /**
     * Returns with the string representation of the binding.
     * Any additional properties which are not described on
     * the `Keybinding` API will be ignored.
     *
     * @param binding the binding to stringify.
     */
    function stringify(binding) {
        return JSON.stringify(apiObjectify(binding));
    }
    Keybinding.stringify = stringify;
    /* Determine whether object is a KeyBinding */
    function is(arg) {
        return !!arg && typeof arg === 'object' && 'command' in arg && 'keybinding' in arg;
    }
    Keybinding.is = is;
})(Keybinding = exports.Keybinding || (exports.Keybinding = {}));
var RawKeybinding;
(function (RawKeybinding) {
    function is(candidate) {
        return typeof candidate === 'object' && !!candidate && 'command' in candidate && 'key' in candidate;
    }
    RawKeybinding.is = is;
})(RawKeybinding = exports.RawKeybinding || (exports.RawKeybinding = {}));
//# sourceMappingURL=keybinding.js.map