/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.LanguageServer;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;

public final class ParentProcessWatcher
implements Runnable,
Function<MessageConsumer, MessageConsumer> {
    private static final long INACTIVITY_DELAY_SECS = 30000L;
    private static final boolean isJava1x = System.getProperty("java.version").startsWith("1.");
    private static final int POLL_DELAY_SECS = 10;
    private volatile long lastActivityTime;
    private final LanguageServer server;
    private ScheduledFuture<?> task;
    private ScheduledExecutorService service;

    public ParentProcessWatcher(LanguageServer server) {
        this.server = server;
        this.service = Executors.newScheduledThreadPool(1);
        this.task = this.service.scheduleWithFixedDelay(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        if (!this.parentProcessStillRunning()) {
            JavaLanguageServerPlugin.logInfo("Parent process stopped running, forcing server exit");
            this.task.cancel(true);
            this.server.exit();
        }
    }

    private boolean parentProcessStillRunning() {
        long pid = this.server.getParentProcessId();
        if (pid == 0L || this.lastActivityTime > System.currentTimeMillis() - 30000L) {
            return true;
        }
        String command = "win32".equals(Platform.getOS()) ? "cmd /c \"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"" : "kill -0 " + pid;
        Process process = null;
        boolean finished = false;
        try {
            process = Runtime.getRuntime().exec(command);
            finished = process.waitFor(10L, TimeUnit.SECONDS);
            if (!finished) {
                process.destroy();
                finished = process.waitFor(10L, TimeUnit.SECONDS);
            }
            if ("win32".equals(Platform.getOS()) && finished && process.exitValue() > 1) {
                JavaLanguageServerPlugin.logInfo("The tasklist command: '" + command + "' returns " + process.exitValue());
                return true;
            }
            boolean bl = !finished || process.exitValue() == 0;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return true;
        }
        finally {
            if (process != null) {
                if (!finished) {
                    process.destroyForcibly();
                }
                if ("win32".equals(Platform.getOS())) {
                    if (!isJava1x) {
                        Closeables.closeQuietly((InputStream)process.getInputStream());
                        Closeables.closeQuietly((InputStream)process.getErrorStream());
                        try {
                            Closeables.close((Closeable)process.getOutputStream(), (boolean)false);
                        }
                        catch (IOException iOException) {}
                    }
                    System.gc();
                }
            }
        }
    }

    @Override
    public MessageConsumer apply(MessageConsumer consumer) {
        return message -> {
            this.lastActivityTime = System.currentTimeMillis();
            consumer.consume(message);
        };
    }
}

