"use strict";
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectableTreeNode = exports.TreeSelection = exports.TreeSelectionService = void 0;
const tree_1 = require("./tree");
/**
 * The tree selection service.
 */
exports.TreeSelectionService = Symbol('TreeSelectionService');
var TreeSelection;
(function (TreeSelection) {
    /**
     * Enumeration of selection types.
     */
    let SelectionType;
    (function (SelectionType) {
        SelectionType[SelectionType["DEFAULT"] = 0] = "DEFAULT";
        SelectionType[SelectionType["TOGGLE"] = 1] = "TOGGLE";
        SelectionType[SelectionType["RANGE"] = 2] = "RANGE";
    })(SelectionType = TreeSelection.SelectionType || (TreeSelection.SelectionType = {}));
    function is(arg) {
        return !!arg && 'node' in arg;
    }
    TreeSelection.is = is;
    function isRange(arg) {
        return isSelectionTypeOf(arg, SelectionType.RANGE);
    }
    TreeSelection.isRange = isRange;
    function isToggle(arg) {
        return isSelectionTypeOf(arg, SelectionType.TOGGLE);
    }
    TreeSelection.isToggle = isToggle;
    function isSelectionTypeOf(arg, expected) {
        if (arg === undefined) {
            return false;
        }
        const type = typeof arg === 'number' ? arg : arg.type;
        return type === expected;
    }
})(TreeSelection = exports.TreeSelection || (exports.TreeSelection = {}));
var SelectableTreeNode;
(function (SelectableTreeNode) {
    function is(node) {
        return !!node && 'selected' in node;
    }
    SelectableTreeNode.is = is;
    function isSelected(node) {
        return is(node) && node.selected;
    }
    SelectableTreeNode.isSelected = isSelected;
    /**
     * @deprecated @since 1.27.0. Use TreeFocusService to track the focused node.
     */
    function hasFocus(node) {
        return is(node) && node.focus === true;
    }
    SelectableTreeNode.hasFocus = hasFocus;
    function isVisible(node) {
        return is(node) && tree_1.TreeNode.isVisible(node);
    }
    SelectableTreeNode.isVisible = isVisible;
    function getVisibleParent(node) {
        if (node) {
            if (isVisible(node.parent)) {
                return node.parent;
            }
            return getVisibleParent(node.parent);
        }
    }
    SelectableTreeNode.getVisibleParent = getVisibleParent;
})(SelectableTreeNode = exports.SelectableTreeNode || (exports.SelectableTreeNode = {}));
//# sourceMappingURL=tree-selection.js.map