/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectListItemRule
extends GenerationSimpleRule {
    private int index;
    boolean useIndices = false;
    private String[] selectedItems;
    private int[] selectedIndices;
    private org.eclipse.swt.widgets.List list;

    @Override
    public boolean appliesTo(Event event) {
        return event.widget instanceof org.eclipse.swt.widgets.List && event.type == 13;
    }

    @Override
    public void initializeForEvent(Event event) {
        this.list = (org.eclipse.swt.widgets.List)event.widget;
        this.index = WidgetUtils.getIndex((Control)this.list);
        this.selectedIndices = this.list.getSelectionIndices();
        this.selectedItems = this.list.getSelection();
        String[] stringArray = this.list.getSelection();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String selectedItem = stringArray[n2];
            int nbOccurrences = 0;
            String[] stringArray2 = this.list.getItems();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String item = stringArray2[n4];
                if (item.equals(selectedItem)) {
                    ++nbOccurrences;
                }
                ++n4;
            }
            if (nbOccurrences > 1) {
                this.useIndices = true;
            }
            ++n2;
        }
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder code = new StringBuilder();
        code.append("bot.list(");
        if (this.index != 0) {
            code.append(this.index);
        }
        code.append(")");
        code.append(".select(");
        if (this.useIndices) {
            int i = 0;
            while (i < this.selectedIndices.length) {
                code.append(this.selectedIndices[i]);
                if (i < this.selectedIndices.length - 1) {
                    code.append(", ");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.selectedItems.length) {
                code.append('\"');
                code.append(this.selectedItems[i]);
                code.append('\"');
                if (i < this.selectedIndices.length - 1) {
                    code.append(", ");
                }
                ++i;
            }
        }
        code.append(')');
        actions.add(code.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    public org.eclipse.swt.widgets.List getWidget() {
        return this.list;
    }
}

