/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_is extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_cop = "kopt\u00edska";
        final String metaValue_gu = "g\u00fajarat\u00ed";
        final String metaValue_km = "kmer";
        final String metaValue_kn = "kannada";
        final String metaValue_te = "tel\u00fag\u00fa";
        final Object[][] data = new Object[][] {
            { "001", "Heimurinn" },
            { "002", "Afr\u00edka" },
            { "003", "Nor\u00f0ur-Amer\u00edka" },
            { "005", "Su\u00f0ur-Amer\u00edka" },
            { "009", "Eyja\u00e1lfa" },
            { "011", "Vestur-Afr\u00edka" },
            { "013", "Mi\u00f0-Amer\u00edka" },
            { "014", "Austur-Afr\u00edka" },
            { "015", "Nor\u00f0ur-Afr\u00edka" },
            { "017", "Mi\u00f0-Afr\u00edka" },
            { "018", "Su\u00f0urhluti Afr\u00edku" },
            { "019", "Amer\u00edka" },
            { "021", "Amer\u00edka nor\u00f0an Mex\u00edk\u00f3" },
            { "029", "Kar\u00edbahafi\u00f0" },
            { "030", "Austur-As\u00eda" },
            { "034", "Su\u00f0ur-As\u00eda" },
            { "035", "Su\u00f0austur-As\u00eda" },
            { "039", "Su\u00f0ur-Evr\u00f3pa" },
            { "053", "\u00c1stralas\u00eda" },
            { "054", "Melanes\u00eda" },
            { "057", "M\u00edkr\u00f3nes\u00edusv\u00e6\u00f0i\u00f0" },
            { "061", "P\u00f3l\u00fdnes\u00eda" },
            { "142", "As\u00eda" },
            { "143", "Mi\u00f0-As\u00eda" },
            { "145", "Vestur-As\u00eda" },
            { "150", "Evr\u00f3pa" },
            { "151", "Austur-Evr\u00f3pa" },
            { "154", "Nor\u00f0ur-Evr\u00f3pa" },
            { "155", "Vestur-Evr\u00f3pa" },
            { "202", "Afr\u00edka sunnan Sahara" },
            { "419", "R\u00f3manska Amer\u00edka" },
            { "AC", "Ascension-eyja" },
            { "AD", "Andorra" },
            { "AE", "Sameinu\u00f0u arab\u00edsku furstad\u00e6min" },
            { "AF", "Afganistan" },
            { "AG", "Ant\u00edgva og Barb\u00fada" },
            { "AI", "Angvilla" },
            { "AL", "Alban\u00eda" },
            { "AM", "Armen\u00eda" },
            { "AO", "Ang\u00f3la" },
            { "AQ", "Su\u00f0urskautslandi\u00f0" },
            { "AR", "Argent\u00edna" },
            { "AS", "Bandar\u00edska Sam\u00f3a" },
            { "AT", "Austurr\u00edki" },
            { "AU", "\u00c1stral\u00eda" },
            { "AW", "Ar\u00faba" },
            { "AX", "\u00c1landseyjar" },
            { "AZ", "Aserba\u00eddsjan" },
            { "BA", "Bosn\u00eda og Herseg\u00f3v\u00edna" },
            { "BB", "Barbados" },
            { "BD", "Bangladess" },
            { "BE", "Belg\u00eda" },
            { "BF", "B\u00fark\u00edna Fas\u00f3" },
            { "BG", "B\u00falgar\u00eda" },
            { "BH", "Barein" },
            { "BI", "B\u00far\u00fand\u00ed" },
            { "BJ", "Ben\u00edn" },
            { "BL", "Sankti Bart\u00f3l\u00f3meusareyjar" },
            { "BM", "Berm\u00fadaeyjar" },
            { "BN", "Br\u00fanei" },
            { "BO", "B\u00f3liv\u00eda" },
            { "BQ", "Kar\u00edbahafshluti Hollands" },
            { "BR", "Brasil\u00eda" },
            { "BS", "Bahamaeyjar" },
            { "BT", "B\u00fatan" },
            { "BV", "Bouveteyja" },
            { "BW", "Botsvana" },
            { "BY", "Hv\u00edta-R\u00fassland" },
            { "BZ", "Bel\u00eds" },
            { "CA", "Kanada" },
            { "CC", "K\u00f3koseyjar (Keeling)" },
            { "CD", "Kong\u00f3-Kinshasa" },
            { "CF", "Mi\u00f0-Afr\u00edkul\u00fd\u00f0veldi\u00f0" },
            { "CG", "Kong\u00f3-Brazzaville" },
            { "CH", "Sviss" },
            { "CI", "F\u00edlabeinsstr\u00f6ndin" },
            { "CK", "Cooks-eyjar" },
            { "CL", "S\u00edle" },
            { "CM", "Kamer\u00fan" },
            { "CN", "K\u00edna" },
            { "CO", "K\u00f3lumb\u00eda" },
            { "CP", "Clipperton-eyja" },
            { "CR", "Kostar\u00edka" },
            { "CU", "K\u00faba" },
            { "CV", "Gr\u00e6nh\u00f6f\u00f0aeyjar" },
            { "CW", "Curacao" },
            { "CX", "J\u00f3laey" },
            { "CY", "K\u00fdpur" },
            { "CZ", "T\u00e9kkland" },
            { "DE", "\u00de\u00fdskaland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dj\u00edb\u00fat\u00ed" },
            { "DK", "Danm\u00f6rk" },
            { "DM", "D\u00f3min\u00edka" },
            { "DO", "D\u00f3min\u00edska l\u00fd\u00f0veldi\u00f0" },
            { "DZ", "Als\u00edr" },
            { "EA", "Ceuta og Melilla" },
            { "EC", "Ekvador" },
            { "EE", "Eistland" },
            { "EG", "Egyptaland" },
            { "EH", "Vestur-Sahara" },
            { "ER", "Er\u00edtrea" },
            { "ES", "Sp\u00e1nn" },
            { "ET", "E\u00fe\u00ed\u00f3p\u00eda" },
            { "EU", "Evr\u00f3pusambandi\u00f0" },
            { "EZ", "Evrusv\u00e6\u00f0i\u00f0" },
            { "FI", "Finnland" },
            { "FJ", "F\u00eddj\u00edeyjar" },
            { "FK", "Falklandseyjar" },
            { "FM", "M\u00edkr\u00f3nes\u00eda" },
            { "FO", "F\u00e6reyjar" },
            { "FR", "Frakkland" },
            { "GA", "Gabon" },
            { "GB", "Bretland" },
            { "GD", "Grenada" },
            { "GE", "Georg\u00eda" },
            { "GF", "Franska Gv\u00e6jana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "G\u00edbraltar" },
            { "GL", "Gr\u00e6nland" },
            { "GM", "Gamb\u00eda" },
            { "GN", "G\u00ednea" },
            { "GP", "Gvadel\u00fapeyjar" },
            { "GQ", "Mi\u00f0baugs-G\u00ednea" },
            { "GR", "Grikkland" },
            { "GS", "Su\u00f0ur-Georg\u00eda og Su\u00f0ur-Sandv\u00edkureyjar" },
            { "GT", "Gvatemala" },
            { "GU", "Gvam" },
            { "GW", "G\u00ednea-Biss\u00e1" },
            { "GY", "Gv\u00e6jana" },
            { "HK", "s\u00e9rstj\u00f3rnarsv\u00e6\u00f0i\u00f0 Hong Kong" },
            { "HM", "Heard og McDonaldseyjar" },
            { "HN", "Hond\u00faras" },
            { "HR", "Kr\u00f3at\u00eda" },
            { "HT", "Ha\u00edt\u00ed" },
            { "HU", "Ungverjaland" },
            { "IC", "Kanar\u00edeyjar" },
            { "ID", "Ind\u00f3nes\u00eda" },
            { "IE", "\u00cdrland" },
            { "IL", "\u00cdsrael" },
            { "IM", "M\u00f6n" },
            { "IN", "Indland" },
            { "IO", "Bresku Indlandshafseyjar" },
            { "IQ", "\u00cdrak" },
            { "IR", "\u00cdran" },
            { "IS", "\u00cdsland" },
            { "IT", "\u00cdtal\u00eda" },
            { "JE", "Jersey" },
            { "JM", "Jama\u00edka" },
            { "JO", "J\u00f3rdan\u00eda" },
            { "JP", "Japan" },
            { "KE", "Ken\u00eda" },
            { "KG", "Kirgistan" },
            { "KH", "Kamb\u00f3d\u00eda" },
            { "KI", "K\u00edribat\u00ed" },
            { "KM", "K\u00f3moreyjar" },
            { "KN", "Sankti Kitts og Nevis" },
            { "KP", "Nor\u00f0ur-K\u00f3rea" },
            { "KR", "Su\u00f0ur-K\u00f3rea" },
            { "KW", "K\u00faveit" },
            { "KY", "Caymaneyjar" },
            { "KZ", "Kasakstan" },
            { "LA", "Laos" },
            { "LB", "L\u00edbanon" },
            { "LC", "Sankti L\u00fas\u00eda" },
            { "LI", "Liechtenstein" },
            { "LK", "Sr\u00ed Lanka" },
            { "LR", "L\u00edber\u00eda" },
            { "LS", "Les\u00f3t\u00f3" },
            { "LT", "Lith\u00e1en" },
            { "LU", "L\u00faxemborg" },
            { "LV", "Lettland" },
            { "LY", "L\u00edb\u00eda" },
            { "MA", "Marokk\u00f3" },
            { "MC", "M\u00f3nak\u00f3" },
            { "MD", "Mold\u00f3va" },
            { "ME", "Svartfjallaland" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalleyjar" },
            { "MK", "Nor\u00f0ur-Maked\u00f3n\u00eda" },
            { "ML", "Mal\u00ed" },
            { "MM", "Mjanmar (B\u00farma)" },
            { "MN", "Mong\u00f3l\u00eda" },
            { "MO", "s\u00e9rstj\u00f3rnarsv\u00e6\u00f0i\u00f0 Maka\u00f3" },
            { "MP", "Nor\u00f0ur-Mar\u00edanaeyjar" },
            { "MQ", "Martin\u00edk" },
            { "MR", "M\u00e1ritan\u00eda" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "M\u00e1rit\u00edus" },
            { "MV", "Mald\u00edveyjar" },
            { "MW", "Malav\u00ed" },
            { "MX", "Mex\u00edk\u00f3" },
            { "MY", "Malas\u00eda" },
            { "MZ", "M\u00f3samb\u00edk" },
            { "NA", "Namib\u00eda" },
            { "NC", "N\u00fdja-Kaled\u00f3n\u00eda" },
            { "NE", "N\u00edger" },
            { "NF", "Norfolkeyja" },
            { "NG", "N\u00edger\u00eda" },
            { "NI", "N\u00edkaragva" },
            { "NL", "Holland" },
            { "NO", "Noregur" },
            { "NP", "Nepal" },
            { "NR", "N\u00e1r\u00fa" },
            { "NU", "Niue" },
            { "NZ", "N\u00fdja-Sj\u00e1land" },
            { "OM", "\u00d3man" },
            { "PA", "Panama" },
            { "PE", "Per\u00fa" },
            { "PF", "Franska P\u00f3l\u00fdnes\u00eda" },
            { "PG", "Pap\u00faa N\u00fdja-G\u00ednea" },
            { "PH", "Filippseyjar" },
            { "PK", "Pakistan" },
            { "PL", "P\u00f3lland" },
            { "PM", "Sankti Pierre og Miquelon" },
            { "PN", "Pitcairn-eyjar" },
            { "PR", "P\u00faert\u00f3 R\u00edk\u00f3" },
            { "PS", "Heimastj\u00f3rnarsv\u00e6\u00f0i Palest\u00ednumanna" },
            { "PT", "Port\u00fagal" },
            { "PW", "Pal\u00e1" },
            { "PY", "Paragv\u00e6" },
            { "QA", "Katar" },
            { "QO", "Ytri Eyja\u00e1lfa" },
            { "RE", "R\u00e9union" },
            { "RO", "R\u00famen\u00eda" },
            { "RS", "Serb\u00eda" },
            { "RU", "R\u00fassland" },
            { "RW", "R\u00faanda" },
            { "SA", "S\u00e1di-Arab\u00eda" },
            { "SB", "Sal\u00f3monseyjar" },
            { "SC", "Seychelles-eyjar" },
            { "SD", "S\u00fadan" },
            { "SE", "Sv\u00ed\u00fej\u00f3\u00f0" },
            { "SG", "Singap\u00far" },
            { "SH", "Sankti Helena" },
            { "SI", "Sl\u00f3ven\u00eda" },
            { "SJ", "Svalbar\u00f0i og Jan Mayen" },
            { "SK", "Sl\u00f3vak\u00eda" },
            { "SL", "S\u00ederra Le\u00f3ne" },
            { "SM", "San Mar\u00edn\u00f3" },
            { "SN", "Senegal" },
            { "SO", "S\u00f3mal\u00eda" },
            { "SR", "S\u00far\u00ednam" },
            { "SS", "Su\u00f0ur-S\u00fadan" },
            { "ST", "Sa\u00f3 T\u00f3me og Prins\u00edpe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00fdrland" },
            { "SZ", "Svas\u00edland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- og Caicoseyjar" },
            { "TD", "Tsjad" },
            { "TF", "Fr\u00f6nsku su\u00f0l\u00e6gu landsv\u00e6\u00f0in" },
            { "TG", "T\u00f3g\u00f3" },
            { "TH", "Ta\u00edland" },
            { "TJ", "Tads\u00edkistan" },
            { "TK", "T\u00f3kel\u00e1" },
            { "TL", "T\u00edmor-Leste" },
            { "TM", "T\u00farkmenistan" },
            { "TN", "T\u00fanis" },
            { "TO", "Tonga" },
            { "TR", "Tyrkland" },
            { "TT", "Tr\u00ednidad og T\u00f3bag\u00f3" },
            { "TV", "T\u00faval\u00fa" },
            { "TW", "Ta\u00edvan" },
            { "TZ", "Tansan\u00eda" },
            { "UA", "\u00dakra\u00edna" },
            { "UG", "\u00daganda" },
            { "UM", "Sm\u00e1eyjar Bandar\u00edkjanna" },
            { "UN", "Sameinu\u00f0u \u00fej\u00f3\u00f0irnar" },
            { "US", "Bandar\u00edkin" },
            { "UY", "\u00dar\u00fagv\u00e6" },
            { "UZ", "\u00dasbekistan" },
            { "VA", "Vat\u00edkani\u00f0" },
            { "VC", "Sankti Vinsent og Grenad\u00edneyjar" },
            { "VE", "Venes\u00faela" },
            { "VG", "Bresku J\u00f3mfr\u00faaeyjar" },
            { "VI", "Bandar\u00edsku J\u00f3mfr\u00faaeyjar" },
            { "VN", "V\u00edetnam" },
            { "VU", "Van\u00faat\u00fa" },
            { "WF", "Wallis- og F\u00fat\u00fanaeyjar" },
            { "WS", "Sam\u00f3a" },
            { "XA", "gervihreimur" },
            { "XB", "gervista\u00f0ur" },
            { "XK", "K\u00f3s\u00f3v\u00f3" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Su\u00f0ur-Afr\u00edka" },
            { "ZM", "Samb\u00eda" },
            { "ZW", "Simbabve" },
            { "ZZ", "\u00d3\u00feekkt sv\u00e6\u00f0i" },
            { "aa", "af\u00e1r" },
            { "ab", "abkas\u00edska" },
            { "ae", "avest\u00edska" },
            { "af", "afr\u00edkanska" },
            { "ak", "akan" },
            { "am", "amhar\u00edska" },
            { "an", "aragonska" },
            { "ar", "arab\u00edska" },
            { "as", "assamska" },
            { "av", "avar\u00edska" },
            { "ay", "a\u00edmara" },
            { "az", "aserska" },
            { "ba", "bask\u00edr" },
            { "be", "hv\u00edtr\u00fassneska" },
            { "bg", "b\u00falgarska" },
            { "bi", "b\u00edslama" },
            { "bm", "bambara" },
            { "bn", "bengalska" },
            { "bo", "t\u00edbeska" },
            { "br", "bret\u00f3nska" },
            { "bs", "bosn\u00edska" },
            { "ca", "katal\u00f3nska" },
            { "ce", "tsjetsjenska" },
            { "ch", "kamorr\u00f3" },
            { "co", "kors\u00edska" },
            { "cr", "kr\u00ed" },
            { "cs", "t\u00e9kkneska" },
            { "cu", "kirkjuslavneska" },
            { "cv", "sj\u00favas" },
            { "cy", "velska" },
            { "da", "danska" },
            { "de", "\u00fe\u00fdska" },
            { "dv", "d\u00edveh\u00ed" },
            { "dz", "dsongka" },
            { "ee", "ewe" },
            { "el", "gr\u00edska" },
            { "en", "enska" },
            { "eo", "esperant\u00f3" },
            { "es", "sp\u00e6nska" },
            { "et", "eistneska" },
            { "eu", "baskneska" },
            { "fa", "persneska" },
            { "ff", "f\u00fala" },
            { "fi", "finnska" },
            { "fj", "f\u00eddjeyska" },
            { "fo", "f\u00e6reyska" },
            { "fr", "franska" },
            { "fy", "vesturfr\u00edsneska" },
            { "ga", "\u00edrska" },
            { "gd", "skosk gel\u00edska" },
            { "gl", "galis\u00edska" },
            { "gn", "gvaran\u00ed" },
            { "gu", metaValue_gu },
            { "gv", "manska" },
            { "ha", "h\u00e1sa" },
            { "he", "hebreska" },
            { "hi", "hind\u00ed" },
            { "ho", "h\u00edr\u00edm\u00f3t\u00fa" },
            { "hr", "kr\u00f3at\u00edska" },
            { "ht", "ha\u00edt\u00edska" },
            { "hu", "ungverska" },
            { "hy", "armenska" },
            { "hz", "herer\u00f3" },
            { "ia", "interlingua" },
            { "id", "ind\u00f3nes\u00edska" },
            { "ie", "interlingve" },
            { "ig", "\u00edgb\u00f3" },
            { "ii", "s\u00eds\u00faanj\u00ed" },
            { "ik", "\u00edn\u00fap\u00edak" },
            { "io", "\u00edd\u00f3" },
            { "is", "\u00edslenska" },
            { "it", "\u00edtalska" },
            { "iu", "in\u00faktit\u00fat" },
            { "ja", "japanska" },
            { "jv", "javanska" },
            { "ka", "georg\u00edska" },
            { "kg", "kong\u00f3ska" },
            { "ki", "k\u00edk\u00faj\u00fa" },
            { "kj", "k\u00faanjama" },
            { "kk", "kasakska" },
            { "kl", "gr\u00e6nlenska" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "k\u00f3reska" },
            { "kr", "kan\u00far\u00ed" },
            { "ks", "kasm\u00edrska" },
            { "ku", "k\u00fard\u00edska" },
            { "kv", "kom\u00edska" },
            { "kw", "kornbreska" },
            { "ky", "kirgiska" },
            { "la", "lat\u00edna" },
            { "lb", "l\u00faxemborg\u00edska" },
            { "lg", "ganda" },
            { "li", "limb\u00farg\u00edska" },
            { "ln", "lingala" },
            { "lo", "la\u00f3" },
            { "lt", "lith\u00e1\u00edska" },
            { "lu", "l\u00fabakatanga" },
            { "lv", "lettneska" },
            { "mg", "malagas\u00edska" },
            { "mh", "marshallska" },
            { "mi", "maor\u00ed" },
            { "mk", "maked\u00f3nska" },
            { "ml", "malajalam" },
            { "mn", "mong\u00f3lska" },
            { "mr", "marat\u00ed" },
            { "ms", "mala\u00edska" },
            { "mt", "maltneska" },
            { "my", "b\u00farmneska" },
            { "na", "n\u00e1r\u00faska" },
            { "nb", "norskt b\u00f3km\u00e1l" },
            { "nd", "nor\u00f0ur-ndebele" },
            { "ne", "nepalska" },
            { "ng", "ndonga" },
            { "nl", "hollenska" },
            { "nn", "n\u00fdnorska" },
            { "no", "norska" },
            { "nr", "su\u00f0urndebele" },
            { "nv", "navah\u00f3" },
            { "ny", "n\u00fdanja" },
            { "oc", "oks\u00edtan\u00edska" },
            { "oj", "ojibva" },
            { "om", "oromo" },
            { "or", "\u00f3r\u00eda" },
            { "os", "osset\u00edska" },
            { "pa", "p\u00fanjab\u00ed" },
            { "pi", "pal\u00ed" },
            { "pl", "p\u00f3lska" },
            { "ps", "past\u00fa" },
            { "pt", "port\u00fagalska" },
            { "qu", "kvesj\u00faa" },
            { "rm", "r\u00f3manska" },
            { "rn", "r\u00fand\u00ed" },
            { "ro", "r\u00famenska" },
            { "ru", "r\u00fassneska" },
            { "rw", "k\u00ednjarvanda" },
            { "sa", "sanskr\u00edt" },
            { "sc", "sard\u00ednska" },
            { "sd", "sind\u00ed" },
            { "se", "nor\u00f0ursam\u00edska" },
            { "sg", "sang\u00f3" },
            { "sh", "serb\u00f3kr\u00f3at\u00edska" },
            { "si", "singal\u00edska" },
            { "sk", "sl\u00f3vak\u00edska" },
            { "sl", "sl\u00f3venska" },
            { "sm", "sam\u00f3ska" },
            { "sn", "shona" },
            { "so", "s\u00f3malska" },
            { "sq", "albanska" },
            { "sr", "serbneska" },
            { "ss", "svat\u00ed" },
            { "st", "su\u00f0urs\u00f3t\u00f3" },
            { "su", "s\u00fandanska" },
            { "sv", "s\u00e6nska" },
            { "sw", "svah\u00edl\u00ed" },
            { "ta", "tam\u00edlska" },
            { "te", metaValue_te },
            { "tg", "tadsjikska" },
            { "th", "ta\u00edlenska" },
            { "ti", "t\u00edgrinja" },
            { "tk", "t\u00farkmenska" },
            { "tl", "tagalog" },
            { "tn", "ts\u00faana" },
            { "to", "tongverska" },
            { "tr", "tyrkneska" },
            { "ts", "tsonga" },
            { "tt", "tatarska" },
            { "tw", "tv\u00ed" },
            { "ty", "tah\u00edt\u00edska" },
            { "ug", "\u00fa\u00edg\u00far" },
            { "uk", "\u00fakra\u00ednska" },
            { "ur", "\u00fard\u00fa" },
            { "uz", "\u00fasbekska" },
            { "ve", "venda" },
            { "vi", "v\u00edetnamska" },
            { "vo", "volapyk" },
            { "wa", "vall\u00f3nska" },
            { "wo", "volof" },
            { "xh", "s\u00f3sa" },
            { "yi", "jidd\u00edska" },
            { "yo", "j\u00f3r\u00faba" },
            { "za", "s\u00faang" },
            { "zh", "k\u00ednverska" },
            { "zu", "s\u00fal\u00fa" },
            { "ace", "akk\u00edska" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "ad\u00fdge" },
            { "afh", "afr\u00edh\u00edl\u00ed" },
            { "agq", "aghem" },
            { "ain", "a\u00ednu (Japan)" },
            { "akk", "akkad\u00edska" },
            { "ale", "ale\u00faska" },
            { "alt", "su\u00f0uralta\u00edska" },
            { "ang", "fornenska" },
            { "ann", "obolo" },
            { "anp", "ang\u00edka" },
            { "arc", "arame\u00edska" },
            { "arn", "mapuche" },
            { "arp", "arapah\u00f3" },
            { "ars", "najdi-arab\u00edska" },
            { "arw", "aravakska" },
            { "asa", "asu" },
            { "ast", "ast\u00far\u00edska" },
            { "atj", "atikamekw" },
            { "awa", "avad\u00ed" },
            { "bal", "bal\u00fak\u00ed" },
            { "ban", "bal\u00edska" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgn", "vesturbalots\u00ed" },
            { "bho", "bojp\u00far\u00ed" },
            { "bik", "b\u00edkol" },
            { "bin", "b\u00edn\u00ed" },
            { "bla", "siksika" },
            { "bra", "bra\u00ed" },
            { "brx", "b\u00f3d\u00f3" },
            { "bss", "bakossi" },
            { "bua", "b\u00far\u00edat" },
            { "bug", "b\u00fag\u00edska" },
            { "byn", "bl\u00edn" },
            { "cad", "kadd\u00f3" },
            { "car", "kar\u00edbam\u00e1l" },
            { "cay", "kaj\u00faga" },
            { "cch", "atsam" },
            { "ccp", "tsjakma" },
            { "ceb", "keb\u00faan\u00f3" },
            { "cgg", "k\u00edga" },
            { "chb", "s\u00edbsja" },
            { "chg", "sjagata\u00ed" },
            { "chk", "sj\u00fak\u00edska" },
            { "chm", "mar\u00ed" },
            { "chn", "s\u00edn\u00fak" },
            { "cho", "sjokt\u00e1" },
            { "chp", "s\u00edpev\u00edska" },
            { "chr", "Cherokee-m\u00e1l" },
            { "chy", "sjeyen" },
            { "ckb", "mi\u00f0k\u00fard\u00edska" },
            { "clc", "chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "michif" },
            { "crh", "kr\u00edmtyrkneska" },
            { "crj", "su\u00f0austur-cree" },
            { "crk", "nehiyawak" },
            { "crl", "nor\u00f0austur-cree" },
            { "crm", "moose cree" },
            { "crr", "Kar\u00f3l\u00ednu-algonkv\u00ednska" },
            { "crs", "seychelles-kre\u00f3lska" },
            { "csb", "kas\u00fab\u00edska" },
            { "csw", "maskekon" },
            { "dak", "dak\u00f3ta" },
            { "dar", "dargva" },
            { "dav", "ta\u00edta" },
            { "del", "delaver" },
            { "den", "slavneska" },
            { "dgr", "dogr\u00edb" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogr\u00ed" },
            { "dsb", "l\u00e1gsorbneska" },
            { "dua", "d\u00faala" },
            { "dum", "mi\u00f0hollenska" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dj\u00fala" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "ef\u00edk" },
            { "egy", "fornegypska" },
            { "eka", "ekaj\u00fak" },
            { "elx", "elam\u00edt" },
            { "enm", "mi\u00f0enska" },
            { "ewo", "evond\u00f3" },
            { "fan", "fang" },
            { "fat", "fant\u00ed" },
            { "fil", "filippseyska" },
            { "fon", "f\u00f3n" },
            { "frc", "cajun-franska" },
            { "frm", "mi\u00f0franska" },
            { "fro", "fornfranska" },
            { "frr", "nor\u00f0urfr\u00edsneska" },
            { "frs", "austurfr\u00edsneska" },
            { "fur", "fr\u00ed\u00falska" },
            { "gaa", "ga" },
            { "gag", "gag\u00e1s" },
            { "gan", "gan" },
            { "gay", "gaj\u00f3" },
            { "gba", "gbaja" },
            { "gez", "g\u00eds" },
            { "gil", "gilberska" },
            { "gmh", "mi\u00f0h\u00e1\u00fe\u00fdska" },
            { "goh", "fornh\u00e1\u00fe\u00fdska" },
            { "gon", "gond\u00ed" },
            { "gor", "gorontal\u00f3" },
            { "got", "gotneska" },
            { "grb", "gerb\u00f3" },
            { "grc", "forngr\u00edska" },
            { "gsw", "svissnesk \u00fe\u00fdska" },
            { "guz", "gusii" },
            { "gwi", "gv\u00eds\u00edn" },
            { "hai", "ha\u00edda" },
            { "haw", "hava\u00edska" },
            { "hax", "su\u00f0ur-ha\u00edda" },
            { "hil", "h\u00edliga\u00ednon" },
            { "hit", "hettit\u00edska" },
            { "hmn", "hmong" },
            { "hsb", "h\u00e1sorbneska" },
            { "hup", "h\u00fapa" },
            { "hur", "halkomelem" },
            { "iba", "\u00edban" },
            { "ibb", "ibibio" },
            { "ikt", "vestur-kanad\u00edskt in\u00faktit\u00fat" },
            { "ilo", "\u00edlok\u00f3" },
            { "inh", "ing\u00fas" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "masj\u00e1me" },
            { "jpr", "gy\u00f0ingapersneska" },
            { "jrb", "gy\u00f0ingaarab\u00edska" },
            { "kaa", "karakalpak" },
            { "kab", "kab\u00edle" },
            { "kac", "kas\u00edn" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kav\u00ed" },
            { "kbd", "kabard\u00edska" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "gr\u00e6nh\u00f6f\u00f0eyska" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "kas\u00ed" },
            { "kho", "kotaska" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimb\u00fand\u00fa" },
            { "koi", "k\u00f3m\u00ed-permyak" },
            { "kok", "konkan\u00ed" },
            { "kos", "kosraska" },
            { "kpe", "kpelle" },
            { "krc", "karasa\u00edbalkar" },
            { "krl", "kar\u00e9lska" },
            { "kru", "k\u00far\u00fak" },
            { "ksb", "sjambala" },
            { "ksf", "baf\u00eda" },
            { "ksh", "k\u00f6ln\u00edska" },
            { "kum", "k\u00fam\u00edk" },
            { "kut", "k\u00fatena\u00ed" },
            { "kwk", "kwak\u02bcwala" },
            { "lad", "lad\u00ednska" },
            { "lag", "lang\u00ed" },
            { "lah", "landa" },
            { "lam", "lamba" },
            { "lez", "lesg\u00edska" },
            { "lil", "lillooet" },
            { "lkt", "lak\u00f3ta" },
            { "lol", "mong\u00f3" },
            { "lou", "kre\u00f3lska (Louisiana)" },
            { "loz", "lozi" },
            { "lrc", "nor\u00f0url\u00far\u00ed" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "l\u00faisen\u00f3" },
            { "lun", "l\u00fanda" },
            { "luo", "l\u00fa\u00f3" },
            { "lus", "l\u00fasa\u00ed" },
            { "luy", "luyia" },
            { "mad", "mad\u00farska" },
            { "mag", "magah\u00ed" },
            { "mai", "ma\u00edt\u00edl\u00ed" },
            { "mak", "makasar" },
            { "man", "manding\u00f3" },
            { "mas", "masa\u00ed" },
            { "mdf", "moksa" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "mer\u00fa" },
            { "mfe", "m\u00e1rit\u00edska" },
            { "mga", "mi\u00f0\u00edrska" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "mikmak" },
            { "min", "m\u00ednangkab\u00e1" },
            { "mnc", "mansj\u00fa" },
            { "mni", "man\u00edp\u00far\u00ed" },
            { "moe", "innu-aimun" },
            { "moh", "m\u00f3h\u00edska" },
            { "mos", "moss\u00ed" },
            { "mua", "mundang" },
            { "mul", "m\u00f6rg tungum\u00e1l" },
            { "mus", "kr\u00edk" },
            { "mwl", "mirandes\u00edska" },
            { "mwr", "marvar\u00ed" },
            { "myv", "ersja" },
            { "mzn", "masanderan\u00ed" },
            { "nap", "nap\u00f3l\u00edska" },
            { "naq", "nama" },
            { "nds", "l\u00e1g\u00fe\u00fdska; l\u00e1gsaxneska" },
            { "new", "nevar\u00ed" },
            { "nia", "n\u00edas" },
            { "niu", "n\u00edveska" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "n\u00f3ga\u00ed" },
            { "non", "norr\u00e6na" },
            { "nqo", "n\u2019ko" },
            { "nso", "nor\u00f0urs\u00f3t\u00f3" },
            { "nus", "n\u00faer" },
            { "nwc", "klass\u00edsk nevar\u00edska" },
            { "nym", "njamves\u00ed" },
            { "nyn", "nyankole" },
            { "nyo", "nj\u00f3r\u00f3" },
            { "nzi", "ns\u00edma" },
            { "ojb", "nor\u00f0vestur-ojibwa" },
            { "ojc", "ojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "vestur-ojibwa" },
            { "oka", "okanagan" },
            { "osa", "\u00f3sage" },
            { "ota", "tyrkneska, ott\u00f3man" },
            { "pag", "pangas\u00ednm\u00e1l" },
            { "pal", "palav\u00ed" },
            { "pam", "pampanga" },
            { "pap", "pap\u00edament\u00f3" },
            { "pau", "pal\u00e1ska" },
            { "pcm", "n\u00edger\u00edskt pidgin" },
            { "peo", "fornpersneska" },
            { "phn", "f\u00f6nik\u00edska" },
            { "pis", "pijin" },
            { "pon", "ponpeiska" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "pr\u00fassneska" },
            { "pro", "fornpr\u00f3vensalska" },
            { "quc", "kiche" },
            { "raj", "rajastan\u00ed" },
            { "rap", "rapan\u00fa\u00ed" },
            { "rar", "rar\u00f3tongska" },
            { "rhg", "rohingja" },
            { "rof", "romb\u00f3" },
            { "rom", "roman\u00ed" },
            { "rup", "ar\u00famenska" },
            { "rwk", "r\u00faa" },
            { "sad", "sandave" },
            { "sah", "jak\u00fat" },
            { "sam", "samversk arame\u00edska" },
            { "saq", "samb\u00far\u00fa" },
            { "sas", "sasak" },
            { "sat", "santal\u00ed" },
            { "sba", "ngambay" },
            { "sbp", "sang\u00fa" },
            { "scn", "sikileyska" },
            { "sco", "skoska" },
            { "sdh", "su\u00f0urk\u00fard\u00edska" },
            { "seh", "sena" },
            { "sel", "selk\u00fap" },
            { "ses", "ko\u00edrabor\u00f3-senn\u00ed" },
            { "sga", "forn\u00edrska" },
            { "shi", "tachelhit" },
            { "shn", "sjan" },
            { "sid", "s\u00eddam\u00f3" },
            { "slh", "su\u00f0ur-lushootseed" },
            { "sma", "su\u00f0ursam\u00edska" },
            { "smj", "l\u00falesam\u00edska" },
            { "smn", "enaresam\u00edska" },
            { "sms", "skoltesam\u00edska" },
            { "snk", "s\u00f3ninke" },
            { "sog", "sogd\u00eden" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "str", "Straits-salis\u00edanska" },
            { "suk", "s\u00fak\u00fama" },
            { "sus", "s\u00fas\u00fa" },
            { "sux", "s\u00famerska" },
            { "swb", "shimaor\u00edska" },
            { "syc", "klass\u00edsk s\u00fdrlenska" },
            { "syr", "s\u00fdrlenska" },
            { "tce", "su\u00f0ur-tutchone" },
            { "tem", "t\u00edmne" },
            { "teo", "tes\u00f3" },
            { "ter", "teren\u00f3" },
            { "tet", "tet\u00fam" },
            { "tgx", "tag\u00edska" },
            { "tht", "tahltan" },
            { "tig", "t\u00edgre" },
            { "tiv", "t\u00edv" },
            { "tkl", "t\u00f3kel\u00e1ska" },
            { "tlh", "klingonska" },
            { "tli", "tlingit" },
            { "tmh", "tamasjek" },
            { "tog", "tongverska (nyasa)" },
            { "tok", "toki pona" },
            { "tpi", "tokpisin" },
            { "trv", "tar\u00f3k\u00f3" },
            { "tsi", "tsims\u00edska" },
            { "ttm", "nor\u00f0ur-tutchone" },
            { "tum", "t\u00famb\u00faka" },
            { "tvl", "t\u00faval\u00faska" },
            { "twq", "tasawaq" },
            { "tyv", "t\u00fav\u00ednska" },
            { "tzm", "tamazight" },
            { "udm", "\u00fadm\u00fart" },
            { "uga", "\u00fagar\u00edt\u00edska" },
            { "umb", "\u00famb\u00fand\u00fa" },
            { "und", "\u00f3\u00feekkt tungum\u00e1l" },
            { "vai", "va\u00ed" },
            { "vot", "vot\u00edska" },
            { "vun", "vunj\u00f3" },
            { "wae", "valser" },
            { "wal", "volayatta" },
            { "war", "vara\u00ed" },
            { "was", "vasj\u00f3" },
            { "wbp", "varlpiri" },
            { "wuu", "wu-k\u00ednverska" },
            { "xal", "kalm\u00fakska" },
            { "xog", "s\u00f3ga" },
            { "yao", "ja\u00f3" },
            { "yap", "jap\u00edska" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kant\u00f3nska" },
            { "zap", "sap\u00f3tek" },
            { "zbl", "blisst\u00e1kn" },
            { "zen", "senaga" },
            { "zgh", "sta\u00f0la\u00f0 marokk\u00f3skt tamazight" },
            { "zun", "s\u00fan\u00ed" },
            { "zxx", "ekkert tungum\u00e1laefni" },
            { "zza", "z\u00e1z\u00e1\u00edska" },
            { "Adlm", "adlam" },
            { "Arab", "arab\u00edskt" },
            { "Aran", "nastaliq" },
            { "Armn", "armenskt" },
            { "Bali", "balines\u00edska" },
            { "Batk", "batak\u00edska" },
            { "Beng", "bengalskt" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahm\u00edska" },
            { "Brai", "blindraletur" },
            { "Cakm", "chakma" },
            { "Cans", "samr\u00e6mt kanad\u00edskt samst\u00f6fuletur frumbyggja" },
            { "Cher", "cherok\u00ed" },
            { "Copt", metaValue_cop },
            { "Cyrl", "kyrill\u00edskt" },
            { "Deva", "devanagari" },
            { "Ethi", "e\u00fe\u00ed\u00f3p\u00edskt" },
            { "Geor", "georg\u00edskt" },
            { "Grek", "gr\u00edskt" },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "k\u00ednverskt" },
            { "Hans", "einfalda\u00f0" },
            { "Hant", "hef\u00f0bundi\u00f0" },
            { "Hebr", "hebreskt" },
            { "Hira", "hiragana" },
            { "Hrkt", "jap\u00f6nsk samst\u00f6fuletur" },
            { "Jamo", "jamo" },
            { "Java", "javanes\u00edska" },
            { "Jpan", "japanskt" },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", "k\u00f3reskt" },
            { "Laoo", "lao" },
            { "Latn", "latneskt" },
            { "Mand", "manda\u00edska" },
            { "Mlym", "malalajam" },
            { "Mong", "mong\u00f3lskt" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "mjanmarskt" },
            { "Nkoo", "n-k\u00f3" },
            { "Olck", "ol chiki" },
            { "Orya", "oriya" },
            { "Rohg", "hanifi" },
            { "Sinh", "sinhala" },
            { "Sund", "sundanes\u00edska" },
            { "Syrc", "syriak\u00edska" },
            { "Taml", "tam\u00edlskt" },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagh" },
            { "Thaa", "thaana" },
            { "Thai", "ta\u00edlenskt" },
            { "Tibt", "t\u00edbeskt" },
            { "Vaii", "vai" },
            { "Yiii", "y\u00ed" },
            { "Zmth", "st\u00e6r\u00f0fr\u00e6\u00f0it\u00e1kn" },
            { "Zsye", "emoji-t\u00e1kn" },
            { "Zsym", "t\u00e1kn" },
            { "Zxxx", "\u00f3skrifa\u00f0" },
            { "Zyyy", "almennt" },
            { "Zzzz", "\u00f3\u00feekkt letur" },
            { "de_AT", "austurr\u00edsk \u00fe\u00fdska" },
            { "de_CH", "svissnesk h\u00e1\u00fe\u00fdska" },
            { "en_AU", "\u00e1str\u00f6lsk enska" },
            { "en_CA", "kanad\u00edsk enska" },
            { "en_GB", "bresk enska" },
            { "en_US", "bandar\u00edsk enska" },
            { "es_ES", "evr\u00f3psk sp\u00e6nska" },
            { "es_MX", "mex\u00edk\u00f3sk sp\u00e6nska" },
            { "fa_AF", "dar\u00ed" },
            { "fr_CA", "kanad\u00edsk franska" },
            { "fr_CH", "svissnesk franska" },
            { "nl_BE", "fl\u00e6mska" },
            { "pt_BR", "bras\u00edl\u00edsk port\u00fagalska" },
            { "pt_PT", "evr\u00f3psk port\u00fagalska" },
            { "ro_MD", "mold\u00f3vska" },
            { "sw_CD", "kong\u00f3svah\u00edl\u00ed" },
            { "ar_001", "st\u00f6\u00f0lu\u00f0 n\u00fat\u00edmaarab\u00edska" },
            { "es_419", "r\u00f3m\u00f6nsk-amer\u00edsk sp\u00e6nska" },
            { "key.ca", "T\u00edmatal" },
            { "key.cf", "Gjaldmi\u00f0ilssni\u00f0" },
            { "key.co", "R\u00f6\u00f0un" },
            { "key.cu", "Gjaldmi\u00f0ill" },
            { "key.hc", "T\u00edmakerfi (12 e\u00f0a 24)" },
            { "key.lb", "L\u00ednuskipting" },
            { "key.ms", "M\u00e6lingakerfi" },
            { "key.nu", "T\u00f6lur" },
            { "key.tz", "T\u00edmabelti" },
            { "key.va", "Landssta\u00f0alsafbrig\u00f0i" },
            { "nds_NL", "l\u00e1gsaxneska" },
            { "zh_Hans", "k\u00ednverska (einf\u00f6ldu\u00f0)" },
            { "zh_Hant", "k\u00ednverska (hef\u00f0bundin)" },
            { "type.ca.roc", "Minguo t\u00edmatal" },
            { "type.co.eor", "Evr\u00f3pskar reglur um r\u00f6\u00f0un" },
            { "type.hc.h11", "12 t\u00edma kerfi (0\u201311)" },
            { "type.hc.h12", "12 t\u00edma kerfi (1\u201312)" },
            { "type.hc.h23", "24 t\u00edma kerfi (0\u201323)" },
            { "type.hc.h24", "24 t\u00edma kerfi (1\u201324)" },
            { "type.m0.bgn", "US BGN umritun" },
            { "type.nu.ahom", "ahom-t\u00f6lur" },
            { "type.nu.arab", "Arab\u00edskar-indverskar t\u00f6lur" },
            { "type.nu.armn", "Armenskir t\u00f6lustafir" },
            { "type.nu.beng", "Bengalskar t\u00f6lur" },
            { "type.nu.cakm", "Chakma-t\u00f6lur" },
            { "type.nu.deva", "Devanagari t\u00f6lur" },
            { "type.nu.ethi", "E\u00fe\u00ed\u00f3p\u00edskir t\u00f6lustafir" },
            { "type.nu.geor", "Georg\u00edskir t\u00f6lustafir" },
            { "type.nu.grek", "Gr\u00edskir t\u00f6lustafir" },
            { "type.nu.gujr", "Gujarati-t\u00f6lur" },
            { "type.nu.guru", "Gurmukhi-t\u00f6lur" },
            { "type.nu.hans", "Einfalda\u00f0ir k\u00ednverskir t\u00f6lustafir" },
            { "type.nu.hant", "Hef\u00f0bundnir k\u00ednverskir t\u00f6lustafir" },
            { "type.nu.hebr", "Hebreskir t\u00f6lustafir" },
            { "type.nu.java", "Javanskar t\u00f6lur" },
            { "type.nu.jpan", "Japanskir t\u00f6lustafir" },
            { "type.nu.khmr", "Kmer\u00edskar t\u00f6lur" },
            { "type.nu.knda", "Kannada-t\u00f6lur" },
            { "type.nu.laoo", "Lao-t\u00f6lur" },
            { "type.nu.latn", "Vestr\u00e6nar t\u00f6lur" },
            { "type.nu.mlym", "Malayalam-t\u00f6lur" },
            { "type.nu.mong", "Mong\u00f3lskar t\u00f6lur" },
            { "type.nu.mtei", "Meetei mayek-t\u00f6lur" },
            { "type.nu.mymr", "Mjanmarskar t\u00f6lur" },
            { "type.nu.olck", "Ol chiki-t\u00f6lur" },
            { "type.nu.orya", "Odia-t\u00f6lur" },
            { "type.nu.taml", "Hef\u00f0bundnir tam\u00edlskir t\u00f6lustafir" },
            { "type.nu.telu", "Tel\u00fag\u00fa-t\u00f6lur" },
            { "type.nu.thai", "T\u00e6lenskar t\u00f6lur" },
            { "type.nu.tibt", "T\u00edbeskir t\u00f6lustafir" },
            { "type.nu.vaii", "Vai-t\u00f6lustafir" },
            { "type.ca.dangi", "Dangi t\u00edmatal" },
            { "type.co.ducet", "Sj\u00e1lfgefin Unicode-r\u00f6\u00f0un" },
            { "type.lb.loose", "Laus l\u00ednuskipting" },
            { "type.nu.roman", "R\u00f3mverskir t\u00f6lustafir" },
            { "type.ca.coptic", "Kopt\u00edskt t\u00edmatal" },
            { "type.ca.hebrew", "Hebreskt t\u00edmatal" },
            { "type.ca.indian", "indverskt dagatal" },
            { "type.co.compat", "Fyrri r\u00f6\u00f0un, til samr\u00e6mis" },
            { "type.co.pinyin", "Pinyin-r\u00f6\u00f0un" },
            { "type.co.search", "Almenn leit" },
            { "type.co.stroke", "Strikar\u00f6\u00f0un" },
            { "type.co.unihan", "R\u00f6\u00f0un eftir grunnstrikum" },
            { "type.d0.fwidth", "Full breidd" },
            { "type.d0.hwidth", "H\u00e1lfbreidd" },
            { "type.lb.normal", "Venjuleg l\u00ednuskipting" },
            { "type.lb.strict", "Str\u00f6ng l\u00ednuskipting" },
            { "type.m0.ungegn", "UN GEGN umritun" },
            { "type.ms.metric", "Metrakerfi" },
            { "type.nu.native", "Upprunalegir t\u00f6lustafir" },
            { "type.ca.chinese", "K\u00ednversk t\u00edmatal" },
            { "type.ca.islamic", "\u00cdslamskt t\u00edmatal" },
            { "type.ca.iso8601", "ISO-8601 t\u00edmatal" },
            { "type.ca.persian", "Persneskt t\u00edmatal" },
            { "type.cf.account", "B\u00f3khaldsgjaldmi\u00f0ill" },
            { "type.co.big5han", "hef\u00f0bundin k\u00ednversk r\u00f6\u00f0un - Big5" },
            { "type.d0.npinyin", "T\u00f6lulegur" },
            { "type.nu.arabext", "Auknar arab\u00edskar-indverskar t\u00f6lur" },
            { "type.nu.armnlow", "Armenskar l\u00e1gstafat\u00f6lur" },
            { "type.nu.finance", "Vi\u00f0skiptafr\u00e6\u00f0ileg t\u00f6luor\u00f0" },
            { "type.nu.greklow", "Gr\u00edskar l\u00e1gstafat\u00f6lur" },
            { "type.nu.hanidec", "K\u00ednverskir tugat\u00f6lustafir" },
            { "type.nu.hansfin", "Einfalda\u00f0ar k\u00ednverskar fj\u00e1rm\u00e1lat\u00f6lur" },
            { "type.nu.hantfin", "Hef\u00f0bundnar k\u00ednverskar fj\u00e1rm\u00e1lat\u00f6lur" },
            { "type.nu.jpanfin", "Japanskar fj\u00e1rm\u00e1lat\u00f6lur" },
            { "type.nu.tamldec", "Tam\u00edlskar t\u00f6lur" },
            { "type.ca.buddhist", "B\u00fadd\u00edskt t\u00edmatal" },
            { "type.ca.ethiopic", "E\u00fe\u00ed\u00f3p\u00edskt t\u00edmatal" },
            { "type.ca.japanese", "Japanskt t\u00edmatal" },
            { "type.cf.standard", "Sta\u00f0la\u00f0 gjaldmi\u00f0ilssni\u00f0" },
            { "type.co.phonetic", "Hlj\u00f3\u00f0fr\u00e6\u00f0ileg r\u00f6\u00f0" },
            { "type.co.reformed", "Endurb\u00e6tt r\u00f6\u00f0" },
            { "type.co.searchjl", "Leita eftir upphafssamhlj\u00f3\u00f0a \u00ed Hangul" },
            { "type.co.standard", "St\u00f6\u00f0lu\u00f0 r\u00f6\u00f0un" },
            { "type.ms.uksystem", "Breskt m\u00e6lingakerfi" },
            { "type.ms.ussystem", "Bandar\u00edskt m\u00e6lingakerfi" },
            { "type.nu.fullwide", "T\u00f6lur \u00ed fullri breidd" },
            { "type.nu.romanlow", "R\u00f3mverskar l\u00e1gstafat\u00f6lur" },
            { "type.ca.gregorian", "Gregor\u00edskt t\u00edmatal" },
            { "type.co.gb2312han", "einf\u00f6ldu\u00f0 k\u00ednversk r\u00f6\u00f0un - GB2312" },
            { "type.co.phonebook", "S\u00edmaskr\u00e1arr\u00f6\u00f0un" },
            { "type.co.dictionary", "Or\u00f0ab\u00f3karr\u00f6\u00f0" },
            { "type.co.traditional", "Hef\u00f0bundin" },
            { "type.nu.traditional", "Hef\u00f0bundin t\u00f6lut\u00e1kn" },
            { "type.ca.islamic-civil", "\u00cdslamskt borgaradagatal" },
            { "type.ca.islamic-umalqura", "\u00cdslamskt dagatal (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "E\u00fe\u00ed\u00f3p\u00edskt \u2018amete alem\u2019 t\u00edmatal" },
        };
        return data;
    }
}
