/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.AddToIndexOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.operations.GitScopeUtil;
import org.eclipse.ui.IWorkbenchPart;

public class AddToIndexActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IResource[] resourcesInScope;
        IResource[] sel = this.getSelectedResources(event);
        if (sel.length == 0) {
            return null;
        }
        try {
            IWorkbenchPart part = this.getPart(event);
            resourcesInScope = GitScopeUtil.getRelatedChanges(part, sel);
        }
        catch (InterruptedException e) {
            return null;
        }
        final AddToIndexOperation operation = new AddToIndexOperation(resourcesInScope);
        String jobname = UIText.AddToIndexAction_addingFiles;
        Job job = new Job(jobname){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    operation.execute(monitor);
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.ADD_TO_INDEX.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(operation.getSchedulingRule());
        job.schedule();
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.haveSelectedResourcesWithRepository();
    }
}

