/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.scattercharts;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesData;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;

public class ScatterChart
extends ScrollableChart {
    public ScatterChart() {
        this.setData("org.eclipse.e4.ui.css.CssClassName", "ScatterChart");
    }

    public ScatterChart(Composite parent, int style) {
        super(parent, style);
        this.setData("org.eclipse.e4.ui.css.CssClassName", "ScatterChart");
    }

    public void addSeriesData(List<IScatterSeriesData> scatterSeriesDataList) {
        if (scatterSeriesDataList != null && !scatterSeriesDataList.isEmpty()) {
            BaseChart baseChart = this.getBaseChart();
            baseChart.suspendUpdate(true);
            for (IScatterSeriesData scatterSeriesData : scatterSeriesDataList) {
                try {
                    ISeriesData seriesData = scatterSeriesData.getSeriesData();
                    ISeriesData optimizedSeriesData = this.calculateSeries(seriesData, Integer.MAX_VALUE);
                    IScatterSeriesSettings scatterSeriesSettings = scatterSeriesData.getSettings();
                    scatterSeriesSettings.getSeriesSettingsHighlight();
                    ILineSeries scatterSeries = (ILineSeries)this.createSeries(optimizedSeriesData, scatterSeriesSettings);
                    baseChart.applySeriesSettings((ISeries<?>)scatterSeries, scatterSeriesSettings);
                }
                catch (SeriesException seriesException) {
                    // empty catch block
                }
            }
            baseChart.suspendUpdate(false);
            this.adjustRange(true);
            baseChart.redraw();
        }
    }
}

