/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.SelectionListenerFactory;

public class PartSelectionListener
implements ISelectionListener,
INullSelectionListener {
    private final ISelectionListener fCallbackListener;
    private final IWorkbenchPart fTargetPart;
    private Predicate<SelectionListenerFactory.ISelectionModel> fPredicate;
    private IWorkbenchPart fCurrentSelectionPart;
    private IWorkbenchPart fLastDeliveredPart;
    private ISelection fCurrentSelection;
    private ISelection fLastDeliveredSelection;

    public PartSelectionListener(IWorkbenchPart part, ISelectionListener callbackListener, Predicate<SelectionListenerFactory.ISelectionModel> predicate) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)callbackListener);
        Assert.isNotNull(predicate);
        this.fTargetPart = part;
        this.fCallbackListener = callbackListener;
        this.fPredicate = predicate;
        this.addPartListener(part);
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.saveCurrentSelection(part, selection);
        if (this.fPredicate.test(this.getModel())) {
            this.doCallback(part, selection);
        }
    }

    private void doCallback(IWorkbenchPart part, ISelection selection) {
        if (selection == null && this.fCallbackListener instanceof INullSelectionListener) {
            this.fCallbackListener.selectionChanged(part, selection);
            this.saveLastDelivered(part, selection);
        } else if (selection != null) {
            this.fCallbackListener.selectionChanged(part, selection);
            this.saveLastDelivered(part, selection);
        }
    }

    private SelectionListenerFactory.ISelectionModel getModel() {
        return new SelectionListenerFactory.ISelectionModel(){

            @Override
            public IWorkbenchPart getTargetPart() {
                return PartSelectionListener.this.fTargetPart;
            }

            @Override
            public IWorkbenchPart getLastDeliveredSelectionPart() {
                return PartSelectionListener.this.fLastDeliveredPart;
            }

            @Override
            public ISelection getLastDeliveredSelection() {
                return PartSelectionListener.this.fLastDeliveredSelection;
            }

            @Override
            public IWorkbenchPart getCurrentSelectionPart() {
                return PartSelectionListener.this.fCurrentSelectionPart;
            }

            @Override
            public ISelection getCurrentSelection() {
                return PartSelectionListener.this.fCurrentSelection;
            }

            @Override
            public boolean isTargetPartVisible() {
                return PartSelectionListener.this.fTargetPart.getSite().getPage().isPartVisible(PartSelectionListener.this.fTargetPart);
            }

            @Override
            public boolean isSelectionPartVisible() {
                return this.getCurrentSelectionPart() != null && this.getCurrentSelectionPart().getSite().getPage().isPartVisible(this.getCurrentSelectionPart());
            }
        };
    }

    private void addPartListener(IWorkbenchPart part) {
        IPartService partService = (IPartService)part.getSite().getService(IPartService.class);
        partService.addPartListener(new IPartListener2(){

            @Override
            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == PartSelectionListener.this.fTargetPart) {
                    PartSelectionListener.this.selectionChanged(PartSelectionListener.this.fCurrentSelectionPart, PartSelectionListener.this.fCurrentSelection);
                }
            }

            @Override
            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == PartSelectionListener.this.fTargetPart) {
                    PartSelectionListener.this.fTargetPart.getSite().getPage().removeSelectionListener(PartSelectionListener.this);
                }
            }
        });
    }

    private void saveCurrentSelection(IWorkbenchPart part, ISelection selection) {
        this.fCurrentSelectionPart = part;
        this.fCurrentSelection = selection;
    }

    private void saveLastDelivered(IWorkbenchPart part, ISelection selection) {
        this.fLastDeliveredPart = part;
        this.fLastDeliveredSelection = selection;
    }

    public PartSelectionListener addPredicate(Predicate<SelectionListenerFactory.ISelectionModel> predicate) {
        if (predicate != null) {
            this.fPredicate = this.fPredicate.and(predicate);
        }
        return this;
    }
}

