/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.outline;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObjectListener;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ADTContentOutlineRefreshJob;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;

public class ADTContentOutlineProvider
implements ITreeContentProvider,
IADTObjectListener {
    protected Viewer viewer = null;
    protected Object oldInput;
    protected Object newInput;
    protected ADTContentOutlineRefreshJob refreshJob;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITreeElement) {
            Object[] children = ((ITreeElement)parentElement).getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    Object child = children[i];
                    if (child instanceof IADTObject) {
                        ((IADTObject)child).registerListener(this);
                    }
                    ++i;
                }
            }
            return children;
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ITreeElement) {
            return ((ITreeElement)element).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        Object input = this.viewer.getInput();
        if (input instanceof IADTObject) {
            this.removeListener((IADTObject)input);
        }
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
            this.refreshJob = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.oldInput = oldInput;
        this.newInput = newInput;
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
        this.refreshJob = new ADTContentOutlineRefreshJob(viewer);
    }

    public void propertyChanged(Object object, String property) {
        this.refreshJob.refresh((IADTObject)object);
    }

    private void removeListener(IADTObject model) {
        model.unregisterListener(this);
        ITreeElement[] children = null;
        if (model instanceof ITreeElement) {
            children = ((ITreeElement)((Object)model)).getChildren();
        }
        if (children != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                ITreeElement child = children[i];
                if (child instanceof IADTObject && model != child) {
                    this.removeListener((IADTObject)((Object)child));
                }
                ++i;
            }
        }
    }
}

