/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.facet.DrillSidewaysScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;

class DrillSidewaysQuery<K extends Collector, R>
extends Query {
    final Query baseQuery;
    final List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers;
    final List<List<K>> managedDrillSidewaysCollectors;
    final Query[] drillDownQueries;
    final boolean scoreSubDocsAtOnce;

    DrillSidewaysQuery(Query baseQuery, List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers, Query[] drillDownQueries, boolean scoreSubDocsAtOnce) {
        this(baseQuery, drillSidewaysCollectorManagers, Collections.synchronizedList(new ArrayList()), drillDownQueries, scoreSubDocsAtOnce);
    }

    private DrillSidewaysQuery(Query baseQuery, List<? extends CollectorManager<K, R>> drillSidewaysCollectorManagers, List<List<K>> managedDrillSidewaysCollectors, Query[] drillDownQueries, boolean scoreSubDocsAtOnce) {
        this.baseQuery = Objects.requireNonNull(baseQuery);
        this.drillSidewaysCollectorManagers = drillSidewaysCollectorManagers;
        this.drillDownQueries = drillDownQueries;
        this.scoreSubDocsAtOnce = scoreSubDocsAtOnce;
        this.managedDrillSidewaysCollectors = managedDrillSidewaysCollectors;
    }

    public String toString(String field) {
        return "DrillSidewaysQuery";
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewrittenQuery;
        Query newQuery = this.baseQuery;
        while ((rewrittenQuery = newQuery.rewrite(indexSearcher)) != newQuery) {
            newQuery = rewrittenQuery;
        }
        if (newQuery == this.baseQuery) {
            return super.rewrite(indexSearcher);
        }
        return new DrillSidewaysQuery<K, R>(newQuery, this.drillSidewaysCollectorManagers, this.managedDrillSidewaysCollectors, this.drillDownQueries, this.scoreSubDocsAtOnce);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight baseWeight = this.baseQuery.createWeight(searcher, scoreMode, boost);
        final Weight[] drillDowns = new Weight[this.drillDownQueries.length];
        for (int dim = 0; dim < this.drillDownQueries.length; ++dim) {
            drillDowns[dim] = searcher.createWeight(searcher.rewrite(this.drillDownQueries[dim]), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return new Weight(this){

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return baseWeight.explain(context, doc);
            }

            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                final ScorerSupplier baseScorerSupplier = baseWeight.scorerSupplier(context);
                int drillDownCount = drillDowns.length;
                ArrayList<Collector> sidewaysCollectors = new ArrayList<Collector>(drillDownCount);
                DrillSidewaysQuery.this.managedDrillSidewaysCollectors.add(sidewaysCollectors);
                final DrillSidewaysScorer.DocsAndCost[] dims = new DrillSidewaysScorer.DocsAndCost[drillDownCount];
                int nullCount = 0;
                for (int dim = 0; dim < dims.length; ++dim) {
                    Scorer scorer = drillDowns[dim].scorer(context);
                    if (scorer == null) {
                        ++nullCount;
                        scorer = new ConstantScoreScorer(0.0f, scoreMode, DocIdSetIterator.empty());
                    }
                    Collector sidewaysCollector = DrillSidewaysQuery.this.drillSidewaysCollectorManagers.get(dim).newCollector();
                    sidewaysCollectors.add(dim, sidewaysCollector);
                    dims[dim] = new DrillSidewaysScorer.DocsAndCost(scorer, sidewaysCollector.getLeafCollector(context));
                }
                if (baseScorerSupplier == null || nullCount > 1) {
                    for (DrillSidewaysScorer.DocsAndCost dim : dims) {
                        dim.sidewaysLeafCollector.finish();
                    }
                    return null;
                }
                Arrays.sort(dims, Comparator.comparingLong(o -> o.approximation.cost()));
                return new ScorerSupplier(){

                    public Scorer get(long leadCost) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public BulkScorer bulkScorer() throws IOException {
                        return new DrillSidewaysScorer(context, baseScorerSupplier.get(Long.MAX_VALUE), dims, DrillSidewaysQuery.this.scoreSubDocsAtOnce);
                    }

                    public long cost() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.baseQuery);
        result = 31 * result + Arrays.hashCode(this.drillDownQueries);
        result = 31 * result + Objects.hashCode(this.drillSidewaysCollectorManagers);
        return result;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DrillSidewaysQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(DrillSidewaysQuery<?, ?> other) {
        return Objects.equals(this.baseQuery, other.baseQuery) && Arrays.equals(this.drillDownQueries, other.drillDownQueries) && Objects.equals(this.drillSidewaysCollectorManagers, other.drillSidewaysCollectorManagers);
    }
}

