/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.IMappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CompilationDirectorySourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.osgi.util.NLS;

public class SourceFoldersRelativePathSourceContainer
extends CompositeSourceContainer
implements IMappingSourceContainer {
    public static final String TYPE_ID = CDebugCorePlugin.getUniqueIdentifier() + ".containerType.sourceFoldersRelativePath";
    private final IProject fOwnProject;
    private IProject fProject;
    private boolean fSearchReferencedProjects;

    public SourceFoldersRelativePathSourceContainer(IProject project, boolean referenced) {
        this.fOwnProject = project;
        this.fProject = project;
        this.fSearchReferencedProjects = referenced;
    }

    public void init(ISourceLookupDirector director) {
        super.init(director);
        if (this.fProject == null && director != null) {
            this.fProject = SourceUtils.getLaunchConfigurationProject(director);
        }
    }

    public void dispose() {
        this.fProject = this.fOwnProject;
        super.dispose();
    }

    public boolean isComposite() {
        return true;
    }

    public boolean isSearchReferencedProjects() {
        return this.fSearchReferencedProjects;
    }

    public String getName() {
        return this.fProject == null ? InternalSourceLookupMessages.SourceFoldersRelativePathSourceContainer_0 : NLS.bind((String)InternalSourceLookupMessages.SourceFoldersRelativePathSourceContainer_1, (Object)this.fProject.getName());
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SourceFoldersRelativePathSourceContainer) {
            SourceFoldersRelativePathSourceContainer loc = (SourceFoldersRelativePathSourceContainer)obj;
            return this.fProject == null ? loc.fProject == null : this.fProject.equals((Object)loc.fProject);
        }
        return false;
    }

    public int hashCode() {
        return TYPE_ID.hashCode() * 31 + (this.fProject == null ? 0 : this.fProject.hashCode());
    }

    @Override
    public IPath getCompilationPath(String sourceName) {
        if (this.fProject == null) {
            return null;
        }
        ICProject cProject = CModelManager.getDefault().create(this.fProject);
        Path path = new Path(sourceName);
        IFile[] iFileArray = ResourceLookup.findFilesForLocation((IPath)path);
        int n = iFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            ISourceRoot root = cProject.findSourceRoot((IResource)file);
            if (root != null) {
                return path.makeRelativeTo(root.getResource().getLocation());
            }
            ++n2;
        }
        return null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        if (this.fProject != null && this.fProject.isOpen()) {
            if (this.isSearchReferencedProjects()) {
                IProject[] projects = SourceUtils.getAllReferencedProjects(this.fProject);
                ISourceContainer[] folders = this.createCompilationDirectoryContainers(this.fProject);
                ArrayList<ISourceContainer> containers = new ArrayList<ISourceContainer>(folders.length + projects.length);
                ISourceContainer[] iSourceContainerArray = folders;
                int n = folders.length;
                int n2 = 0;
                while (n2 < n) {
                    ISourceContainer folder = iSourceContainerArray[n2];
                    containers.add(folder);
                    ++n2;
                }
                iSourceContainerArray = projects;
                n = projects.length;
                n2 = 0;
                while (n2 < n) {
                    ISourceContainer ref = iSourceContainerArray[n2];
                    if (ref.exists() && ref.isOpen()) {
                        SourceFoldersRelativePathSourceContainer container = new SourceFoldersRelativePathSourceContainer((IProject)ref, false);
                        container.init(this.getDirector());
                        containers.add(container);
                    }
                    ++n2;
                }
                return containers.toArray(new ISourceContainer[containers.size()]);
            }
            return this.createCompilationDirectoryContainers(this.fProject);
        }
        return new ISourceContainer[0];
    }

    private ISourceContainer[] createCompilationDirectoryContainers(IProject project) throws CoreException {
        ICProject cProject = CModelManager.getDefault().create(project);
        ISourceRoot[] roots = cProject.getAllSourceRoots();
        ArrayList<CompilationDirectorySourceContainer> list = new ArrayList<CompilationDirectorySourceContainer>(roots.length);
        ISourceRoot[] iSourceRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceRoot root = iSourceRootArray[n2];
            IContainer folder = root.getResource();
            CompilationDirectorySourceContainer container = new CompilationDirectorySourceContainer(folder.getLocation(), false);
            container.init(this.getDirector());
            list.add(container);
            ++n2;
        }
        return list.toArray(new ISourceContainer[list.size()]);
    }
}

