/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.fx.behaviors;

import javafx.scene.Node;
import org.eclipse.gef.common.collections.MultisetChangeListener;
import org.eclipse.gef.layout.LayoutContext;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.zest.fx.parts.AbstractLabelPart;

public abstract class AbstractLayoutBehavior
extends AbstractBehavior {
    private MultisetChangeListener<IVisualPart<? extends Node>> anchoredsChangeListener = new MultisetChangeListener<IVisualPart<? extends Node>>(){

        public void onChanged(MultisetChangeListener.Change<? extends IVisualPart<? extends Node>> change) {
            boolean isRelevantChange = false;
            while (change.next()) {
                if (!(change.getElement() instanceof IContentPart)) continue;
                isRelevantChange = true;
                break;
            }
            if (isRelevantChange) {
                AbstractLayoutBehavior.this.layoutLabels();
            }
        }
    };

    protected void doActivate() {
        super.doActivate();
        IContentPart cp = (IContentPart)this.getHost();
        this.getHost().getAnchoredsUnmodifiable().addListener(this.anchoredsChangeListener);
    }

    protected void doDeactivate() {
        this.getHost().getAnchoredsUnmodifiable().removeListener(this.anchoredsChangeListener);
        super.doDeactivate();
    }

    protected abstract LayoutContext getLayoutContext();

    protected void layoutLabels() {
        for (IVisualPart anchored : this.getHost().getAnchoredsUnmodifiable().elementSet()) {
            if (anchored.getViewer() == null || !(anchored instanceof AbstractLabelPart)) continue;
            AbstractLabelPart labelPart = (AbstractLabelPart)anchored;
            labelPart.recomputeLabelPosition();
        }
    }

    protected abstract void postLayout();

    protected abstract void preLayout();
}

