/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.internal.behaviors;

import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.gef.fx.internal.nodes.IBendableCurve;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class BendableCurveClickableAreaBehavior
extends AbstractBehavior {
    private static final double ABSOLUTE_CLICKABLE_WIDTH = 8.0;
    private DoubleBinding clickableAreaBinding;
    private final ChangeListener<? super Number> scaleXListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            BendableCurveClickableAreaBehavior.this.clickableAreaBinding.invalidate();
        }
    };

    @Override
    protected void doActivate() {
        this.clickableAreaBinding = new DoubleBinding(){

            protected double computeValue() {
                double localClickableWidth = 8.0 / ((InfiniteCanvasViewer)BendableCurveClickableAreaBehavior.this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().getMxx();
                return Math.min(localClickableWidth, 8.0);
            }
        };
        Node visual = this.getHost().getVisual();
        if (visual instanceof IBendableCurve) {
            ((IBendableCurve)visual).clickableAreaWidthProperty().bind((ObservableValue)this.clickableAreaBinding);
        }
        ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().mxxProperty().addListener(this.scaleXListener);
    }

    @Override
    protected void doDeactivate() {
        this.clickableAreaBinding.dispose();
        ((InfiniteCanvasViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentTransform().mxxProperty().removeListener(this.scaleXListener);
    }
}

