/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.uitree;

import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateInfo;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.Messages;
import org.eclipse.cdt.ui.templateengine.uitree.IUIElementTreeBuilderHelper;
import org.eclipse.cdt.ui.templateengine.uitree.SimpleUIElementGroup;
import org.eclipse.cdt.ui.templateengine.uitree.UIAttributes;
import org.eclipse.cdt.ui.templateengine.uitree.UIElement;
import org.eclipse.cdt.ui.templateengine.uitree.UIGroupTypeEnum;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIBooleanWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIBrowseWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UISelectWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UISpecialListWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIStringListWidget;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UITextWidget;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UIElementTreeBuilderHelper
implements IUIElementTreeBuilderHelper {
    private static final String TEMPLATE_ENGINE_ERROR = Messages.getString("TemplateEngineMessage.Error");
    private TemplateDescriptor templateDescriptor = null;
    private TemplateInfo templateInfo;

    public UIElementTreeBuilderHelper(TemplateDescriptor templateDescriptor, TemplateInfo templateInfo) {
        this.templateDescriptor = templateDescriptor;
        this.templateInfo = templateInfo;
    }

    public List<Element> getPropertyGroupList() {
        return this.templateDescriptor.getPropertyGroupList();
    }

    @Override
    public UIElement getUIElement(Element element) {
        UIAttributes uiAttributes = new UIAttributes(this.templateInfo);
        NamedNodeMap list = element.getAttributes();
        int i = 0;
        while (i < list.getLength()) {
            Node attribute = list.item(i);
            uiAttributes.put(attribute.getNodeName(), attribute.getNodeValue());
            ++i;
        }
        return this.getUIWidget(element, uiAttributes);
    }

    private UIElement getUIWidget(Element element, UIAttributes uiAttributes) {
        UIElement widgetElement = null;
        String id = (String)uiAttributes.get("id");
        String type = (String)uiAttributes.get("type");
        if (type == null || type.length() == 0) {
            return null;
        }
        if (Boolean.parseBoolean((String)uiAttributes.get("hidden"))) {
            return null;
        }
        if (type.equalsIgnoreCase("input")) {
            widgetElement = new UITextWidget(uiAttributes);
        } else if (type.equalsIgnoreCase("multiline")) {
            widgetElement = new UITextWidget(uiAttributes);
        } else if (type.equalsIgnoreCase("select")) {
            String defaultValue = element.getAttribute("default");
            LinkedHashMap<String, String> value2name = new LinkedHashMap<String, String>();
            for (Element item : TemplateEngine.getChildrenOfElement((Element)element)) {
                String msg;
                String label = item.getAttribute("label");
                String value = item.getAttribute("name");
                if (value.length() == 0) {
                    value = item.getAttribute("value");
                }
                if (label == null || value == null) {
                    msg = MessageFormat.format(Messages.getString("UIElementTreeBuilderHelper.InvalidEmptyLabel"), id);
                    CUIPlugin.log(TEMPLATE_ENGINE_ERROR, new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", msg)));
                    continue;
                }
                if (value2name.put(value, label) == null) continue;
                msg = MessageFormat.format(Messages.getString("UIElementTreeBuilderHelper.InvalidNonUniqueValue"), value, id);
                CUIPlugin.log(TEMPLATE_ENGINE_ERROR, new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", msg)));
            }
            widgetElement = new UISelectWidget(uiAttributes, value2name, defaultValue);
        } else if (type.equalsIgnoreCase("boolean")) {
            String defaultValue = element.getAttribute("default");
            boolean b = Boolean.parseBoolean(defaultValue);
            widgetElement = new UIBooleanWidget(uiAttributes, b);
        } else if (type.equalsIgnoreCase("browse")) {
            widgetElement = new UIBrowseWidget(uiAttributes, false);
        } else if (type.equalsIgnoreCase("browsedir")) {
            widgetElement = new UIBrowseWidget(uiAttributes, true);
        } else if (type.equalsIgnoreCase("stringlist")) {
            widgetElement = new UIStringListWidget(uiAttributes);
        } else if (type.equalsIgnoreCase("speciallist")) {
            widgetElement = new UISpecialListWidget(uiAttributes);
        } else if (type.equalsIgnoreCase(UIGroupTypeEnum.PAGES_ONLY.getId())) {
            widgetElement = new SimpleUIElementGroup(uiAttributes);
        } else if (!type.equalsIgnoreCase(UIGroupTypeEnum.PAGES_TAB.getId())) {
            String msg = MessageFormat.format(Messages.getString("UIElementTreeBuilderHelper.UnknownWidgetType0"), type);
            CUIPlugin.log(TEMPLATE_ENGINE_ERROR, new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", msg)));
        }
        return widgetElement;
    }
}

