/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.VariableDeclarationFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class VariableDeclarationCleanUpCore
extends AbstractCleanUp {
    public VariableDeclarationCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public VariableDeclarationCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    private boolean requireAST() {
        boolean addFinal = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!addFinal) {
            return false;
        }
        return this.isEnabled("cleanup.make_private_fields_final") || this.isEnabled("cleanup.make_parameters_final") || this.isEnabled("cleanup.make_local_variable_final");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean addFinal = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!addFinal) {
            return null;
        }
        return VariableDeclarationFixCore.createCleanUp(compilationUnit, this.isEnabled("cleanup.make_private_fields_final"), this.isEnabled("cleanup.make_parameters_final"), this.isEnabled("cleanup.make_local_variable_final"));
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_private_fields_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalField_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_parameters_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalParameters_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final")) {
            result.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalLocals_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_private_fields_final")) {
            bld.append("private final int i= 0;\n");
        } else {
            bld.append("private int i= 0;\n");
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_parameters_final")) {
            bld.append("public void foo(final int j) {\n");
        } else {
            bld.append("public void foo(int j) {\n");
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final")) {
            bld.append("    final int k;\n");
            bld.append("    int h;\n");
            bld.append("    h= 0;\n");
            bld.append("}\n");
        } else {
            bld.append("    int k, h;\n");
            bld.append("    h= 0;\n");
            bld.append("}\n\n");
        }
        return bld.toString();
    }
}

