/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.perspective;

import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.wst.project.facet.ProductManager;

public class J2EEPerspective
implements IPerspectiveFactory {
    protected static String ID_SERVERS_VIEW = "org.eclipse.wst.server.ui.ServersView";
    protected static String ID_J2EE_HIERARCHY_VIEW = "org.eclipse.ui.navigator.ProjectExplorer";
    private static String ID_WST_SNIPPETS_VIEW = "org.eclipse.wst.common.snippets.internal.ui.SnippetsView";
    private static final String ID_SEARCH_VIEW = "org.eclipse.search.ui.views.SearchView";
    private static final String ID_DATA_VIEW = "org.eclipse.datatools.connectivity.DataSourceExplorerNavigator";
    private static final String ID_CONSOLE_VIEW = "org.eclipse.ui.console.ConsoleView";
    private static final String ID_MARKERS_VIEW = "org.eclipse.ui.views.AllMarkersView";
    private static final String ID_TASKLIST_VIEW = "org.eclipse.mylyn.tasks.ui.views.tasks";
    private static final String ID_TERMINAL_VIEW = "org.eclipse.tm.terminal.view.ui.TerminalsView";
    private static final String ID_GIT_REPO_VIEW = "org.eclipse.egit.ui.RepositoriesView";
    private static final String ID_GIT_STG_VIEW = "org.eclipse.egit.ui.internal.staging.StagingView";

    public J2EEPerspective() {
        String viewerID = ProductManager.getProperty((String)"idPerspectiveHierarchyView");
        if (viewerID != null) {
            if (PlatformUI.getWorkbench().getViewRegistry().find(viewerID) != null) {
                ID_J2EE_HIERARCHY_VIEW = viewerID;
            }
        } else {
            viewerID = J2EEPlugin.getDefault().getJ2EEPreferences().getString("perspective_hierarchy_view_id");
            if (viewerID != null && PlatformUI.getWorkbench().getViewRegistry().find(viewerID) != null) {
                ID_J2EE_HIERARCHY_VIEW = viewerID;
            }
        }
    }

    public void createInitialLayout(IPageLayout layout) {
        this.defineLayout(layout);
        this.defineActions(layout);
    }

    public void defineActions(IPageLayout layout) {
        layout.addActionSet("org.eclipse.jst.j2ee.J2eeMainActionSet");
        layout.addActionSet("org.eclipse.jdt.ui.JavaActionSet");
        layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        layout.addActionSet("org.eclipse.debug.ui.debugActionSet");
        layout.addShowViewShortcut(ID_J2EE_HIERARCHY_VIEW);
        layout.addShowViewShortcut(ID_SERVERS_VIEW);
        layout.addShowViewShortcut(ID_DATA_VIEW);
        layout.addShowViewShortcut("org.eclipse.ui.views.BookmarkView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
        layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        layout.addShowViewShortcut(ID_WST_SNIPPETS_VIEW);
        layout.addShowViewShortcut(ID_MARKERS_VIEW);
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut(ID_TASKLIST_VIEW);
        layout.addShowViewShortcut(ID_TERMINAL_VIEW);
        layout.addShowViewShortcut("org.eclipse.jdt.ui.PackagesView");
        layout.addShowViewShortcut(ID_SEARCH_VIEW);
        layout.addShowViewShortcut(ID_CONSOLE_VIEW);
        layout.addShowInPart(ID_J2EE_HIERARCHY_VIEW);
        layout.addShowInPart("org.eclipse.jdt.ui.PackagesView");
    }

    public void defineLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeft = layout.createFolder("topLeft", 1, 0.2f, editorArea);
        topLeft.addView(ID_J2EE_HIERARCHY_VIEW);
        topLeft.addPlaceholder("org.eclipse.jdt.ui.PackagesView");
        topLeft.addPlaceholder("org.eclipse.ui.navigator.ProjectExplorer");
        topLeft.addPlaceholder("org.eclipse.jdt.ui.TypeHierarchy");
        topLeft.addPlaceholder("org.eclipse.debug.ui.DebugView");
        topLeft.addPlaceholder(ID_SEARCH_VIEW);
        topLeft.addPlaceholder(ID_GIT_REPO_VIEW);
        IFolderLayout bottomRight = layout.createFolder("bottomRight", 4, 0.8f, editorArea);
        bottomRight.addView("org.eclipse.ui.views.ProblemView");
        bottomRight.addView(ID_SERVERS_VIEW);
        this.addViewIfPresent(bottomRight, ID_TERMINAL_VIEW);
        this.addViewIfPresent(bottomRight, ID_DATA_VIEW);
        bottomRight.addView("org.eclipse.ui.views.PropertySheet");
        bottomRight.addPlaceholder(ID_WST_SNIPPETS_VIEW);
        bottomRight.addPlaceholder(ID_MARKERS_VIEW);
        bottomRight.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        bottomRight.addPlaceholder("org.eclipse.ui.views.TaskList");
        bottomRight.addPlaceholder(ID_CONSOLE_VIEW);
        bottomRight.addPlaceholder("org.eclipse.ui.views.ProgressView");
        bottomRight.addPlaceholder(ID_GIT_STG_VIEW);
        bottomRight.addPlaceholder("org.eclipse.jdt.ui.JavadocView");
        bottomRight.addPlaceholder("org.eclipse.jdt.ui.MembersView");
        bottomRight.addPlaceholder("org.eclipse.jdt.ui.SourceView");
        IFolderLayout topRight = layout.createFolder("topRight", 2, 0.8f, editorArea);
        topRight.addView("org.eclipse.ui.views.ContentOutline");
        topRight.addPlaceholder("org.eclipse.ui.views.minimap.MinimapView");
        topLeft.addPlaceholder("org.eclipse.debug.ui.VariableView");
        topLeft.addPlaceholder("org.eclipse.debug.ui.ExpressionView");
        topLeft.addPlaceholder("org.eclipse.debug.ui.BreakpointView");
        topLeft.addPlaceholder("org.eclipse.debug.ui.MemoryView");
    }

    private void addViewIfPresent(IFolderLayout layout, String viewID) {
        IViewDescriptor descriptor = PlatformUI.getWorkbench().getViewRegistry().find(viewID);
        if (descriptor != null) {
            layout.addView(viewID);
        } else {
            layout.addPlaceholder(viewID);
        }
    }
}

