/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.enumeration;

import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.enumeration.EmptyEnumeration;
import org.eclipse.jpt.common.utility.internal.enumeration.IteratorEnumeration;
import org.eclipse.jpt.common.utility.internal.iterator.EnumerationIterator;

public final class EnumerationTools {
    /*
     * Unable to fully structure code
     */
    public static boolean contains(Enumeration<?> enumeration, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(enumeration.nextElement())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (enumeration.hasMoreElements())
            }
        }
        return false;
    }

    public static boolean containsAll(Enumeration<?> enumeration, Collection<?> collection) {
        return CollectionTools.hashSet(EnumerationTools.iterator(enumeration)).containsAll(collection);
    }

    public static boolean containsAll(Enumeration<?> enumeration, int enumerationSize, Collection<?> collection) {
        return CollectionTools.hashSet(EnumerationTools.iterator(enumeration), enumerationSize).containsAll(collection);
    }

    public static boolean containsAll(Enumeration<?> enumeration, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.hashSet(EnumerationTools.iterator(enumeration)), iterable);
    }

    public static boolean containsAll(Enumeration<?> enumeration, int enumerationSize, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.hashSet(EnumerationTools.iterator(enumeration), enumerationSize), iterable);
    }

    public static boolean containsAll(Enumeration<?> enumeration1, Enumeration<?> enumeration2) {
        return CollectionTools.containsAll(CollectionTools.hashSet(EnumerationTools.iterator(enumeration1)), EnumerationTools.iterator(enumeration2));
    }

    public static boolean containsAll(Enumeration<?> enumeration1, int enumeration1Size, Enumeration<?> enumeration2) {
        return CollectionTools.containsAll(CollectionTools.hashSet(EnumerationTools.iterator(enumeration1), enumeration1Size), EnumerationTools.iterator(enumeration2));
    }

    public static boolean containsAll(Enumeration<?> enumeration, Object ... array) {
        return CollectionTools.containsAll(CollectionTools.hashSet(EnumerationTools.iterator(enumeration)), array);
    }

    public static boolean containsAll(Enumeration<?> enumeration, int enumerationSize, Object ... array) {
        return CollectionTools.containsAll(CollectionTools.hashSet(EnumerationTools.iterator(enumeration), enumerationSize), array);
    }

    public static boolean elementsAreDifferent(Enumeration<?> enumeration1, Enumeration<?> enumeration2) {
        return !EnumerationTools.elementsAreEqual(enumeration1, enumeration2);
    }

    public static boolean elementsAreEqual(Enumeration<?> enumeration1, Enumeration<?> enumeration2) {
        while (enumeration1.hasMoreElements() && enumeration2.hasMoreElements()) {
            if (!ObjectTools.notEquals(enumeration1.nextElement(), enumeration2.nextElement())) continue;
            return false;
        }
        return !enumeration1.hasMoreElements() && !enumeration2.hasMoreElements();
    }

    public static boolean elementsAreIdentical(Enumeration<?> enumeration1, Enumeration<?> enumeration2) {
        while (enumeration1.hasMoreElements() && enumeration2.hasMoreElements()) {
            if (enumeration1.nextElement() == enumeration2.nextElement()) continue;
            return false;
        }
        return !enumeration1.hasMoreElements() && !enumeration2.hasMoreElements();
    }

    public static boolean elementsAreNotIdentical(Enumeration<?> enumeration1, Enumeration<?> enumeration2) {
        return !EnumerationTools.elementsAreIdentical(enumeration1, enumeration2);
    }

    public static <E> Enumeration<E> emptyEnumeration() {
        return EmptyEnumeration.instance();
    }

    public static <E> Enumeration<E> enumeration(Iterable<E> iterable) {
        return EnumerationTools.enumeration(iterable.iterator());
    }

    public static <E> Enumeration<E> enumeration(Iterator<E> iterator) {
        return new IteratorEnumeration<E>(iterator);
    }

    public static <E> E get(Enumeration<? extends E> enumeration, int index) {
        int i = 0;
        while (enumeration.hasMoreElements()) {
            E next = enumeration.nextElement();
            if (i++ != index) continue;
            return next;
        }
        throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(index)) + ':' + String.valueOf(i));
    }

    public static int hashCode(Enumeration<?> enumeration) {
        int hash = 1;
        while (enumeration.hasMoreElements()) {
            Object next = enumeration.nextElement();
            hash = 31 * hash + (next == null ? 0 : next.hashCode());
        }
        return hash;
    }

    public static int indexOf(Enumeration<?> enumeration, Object value) {
        return enumeration.hasMoreElements() ? EnumerationTools.indexOf_(enumeration, value, 0) : -1;
    }

    public static int indexOf(Enumeration<?> enumeration, Object value, int startIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        } else {
            int i = 0;
            while (enumeration.hasMoreElements() && i < startIndex) {
                enumeration.nextElement();
                ++i;
            }
        }
        return enumeration.hasMoreElements() ? EnumerationTools.indexOf_(enumeration, value, startIndex) : -1;
    }

    private static int indexOf_(Enumeration<?> enumeration, Object value, int startIndex) {
        if (value == null) {
            int i = startIndex;
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = startIndex;
            while (enumeration.hasMoreElements()) {
                if (value.equals(enumeration.nextElement())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Enumeration<?> enumeration, Object value) {
        int last = -1;
        if (value == null) {
            int i = 0;
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() == null) {
                    last = i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (enumeration.hasMoreElements()) {
                if (value.equals(enumeration.nextElement())) {
                    last = i;
                }
                ++i;
            }
        }
        return last;
    }

    public static int lastIndexOf(Enumeration<?> enumeration, Object value, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        return enumeration.hasMoreElements() ? EnumerationTools.lastIndexOf_(enumeration, value, startIndex) : -1;
    }

    private static int lastIndexOf_(Enumeration<?> enumeration, Object value, int startIndex) {
        int last = -1;
        if (value == null) {
            int i = 0;
            while (enumeration.hasMoreElements()) {
                if (i > startIndex) {
                    return last;
                }
                if (enumeration.nextElement() == null) {
                    last = i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (enumeration.hasMoreElements()) {
                if (i > startIndex) {
                    return last;
                }
                if (value.equals(enumeration.nextElement())) {
                    last = i;
                }
                ++i;
            }
        }
        return last;
    }

    public static <E> E last(Enumeration<E> enumeration) {
        E last;
        do {
            last = enumeration.nextElement();
        } while (enumeration.hasMoreElements());
        return last;
    }

    public static int size(Enumeration<?> enumeration) {
        int size = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++size;
        }
        return size;
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return !enumeration.hasMoreElements();
    }

    public static <E extends Comparable<? super E>> Enumeration<E> sort(Enumeration<? extends E> enumeration) {
        return EnumerationTools.sort(enumeration, null);
    }

    public static <E extends Comparable<? super E>> Enumeration<E> sort(Enumeration<? extends E> enumeration, int enumerationSize) {
        return EnumerationTools.sort(enumeration, null, enumerationSize);
    }

    public static <E2, E1 extends E2> Enumeration<E2> sort(Enumeration<E1> enumeration, Comparator<? super E1> comparator) {
        return ListTools.sort(CollectionTools.vector(EnumerationTools.iterator(enumeration)), comparator).elements();
    }

    public static <E2, E1 extends E2> Enumeration<E2> sort(Enumeration<E1> enumeration, Comparator<? super E1> comparator, int enumerationSize) {
        return ListTools.sort(CollectionTools.vector(EnumerationTools.iterator(enumeration), enumerationSize), comparator).elements();
    }

    public static <E> Iterator<E> iterator(Enumeration<? extends E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    private EnumerationTools() {
        throw new UnsupportedOperationException();
    }
}

