/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.util;

import java.util.HashMap;
import java.util.Map;

public enum TabStyle {
    TAB("tab"),
    SPACES("space"),
    MIXED("mixed");

    private final String name;
    private static final Map<String, TabStyle> byName;

    static {
        byName = new HashMap<String, TabStyle>();
        byName.put(TAB.getName(), TAB);
        byName.put(SPACES.getName(), SPACES);
        byName.put(MIXED.getName(), MIXED);
    }

    private TabStyle(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static TabStyle forName(String name) {
        return byName.get(name);
    }

    public static TabStyle forName(String name, TabStyle deflt) {
        TabStyle result = TabStyle.forName(name);
        return result != null ? result : deflt;
    }
}

