/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceType;

public class FakeType
extends SourceType {
    private int flags = 64;
    private int offset;
    private int length;
    private boolean hasSpecialOffsets = false;
    private int nameOffset;
    private int nameLength;

    public FakeType(ModelElement sourceModule, String name) {
        super(sourceModule, name);
    }

    public FakeType(ModelElement sourceModule, String name, int flags) {
        super(sourceModule, name);
        this.flags = flags;
    }

    public FakeType(ModelElement parent, String name, int flags, int offset, int length, int nameOffset, int nameLength) {
        super(parent, name);
        this.flags = flags;
        this.offset = offset;
        this.length = length;
        this.nameOffset = nameOffset;
        this.nameLength = nameLength;
        this.hasSpecialOffsets = true;
    }

    @Override
    public ISourceRange getNameRange() throws ModelException {
        if (this.hasSpecialOffsets) {
            return new SourceRange(this.nameOffset, this.nameLength);
        }
        return super.getNameRange();
    }

    @Override
    public ISourceRange getSourceRange() throws ModelException {
        if (this.hasSpecialOffsets) {
            return new SourceRange(this.offset, this.length);
        }
        return super.getSourceRange();
    }

    @Override
    public IScriptProject getScriptProject() {
        return this.parent.getScriptProject();
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }
}

