/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.caching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;

public abstract class ModelCacheListener
implements IResourceChangeListener,
IElementChangedListener {
    protected void remove(ISourceModule module) {
    }

    protected void remove(IScriptProject element) {
    }

    protected void remove(IScriptFolder element) {
    }

    protected void remove(IProject element) {
    }

    protected void remove(IProjectFragment element) {
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        IModelElementDelta delta = event.getDelta();
        this.processDelta(delta);
    }

    private void processDelta(IModelElementDelta delta) {
        IModelElement element = delta.getElement();
        if (delta.getKind() == 2 || delta.getKind() == 4 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 4) != 0) {
            if (element.getElementType() != 5 && element.getElementType() != 3 && element.getElementType() != 4 && element.getElementType() != 1 && element.getElementType() != 2) {
                ISourceModule module = (ISourceModule)element.getAncestor(5);
                this.remove(module);
            }
            if (element.getElementType() == 5) {
                this.remove((ISourceModule)element);
            }
        }
        if (element.getElementType() == 2 && delta.getKind() == 4 && (delta.getFlags() & 0x20000) != 0) {
            this.remove((IScriptProject)element);
            return;
        }
        if ((delta.getFlags() & 8) != 0) {
            IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
            int i = 0;
            while (i < affectedChildren.length) {
                IModelElementDelta child = affectedChildren[i];
                this.processDelta(child);
                ++i;
            }
        } else if ((delta.getKind() == 2 || delta.getKind() == 4) && element.getElementType() == 4) {
            if (delta.getAffectedChildren().length == 0) {
                this.remove((IScriptFolder)element);
            }
        } else if ((delta.getKind() == 2 || delta.getKind() == 4) && element.getElementType() == 3 && delta.getAffectedChildren().length == 0) {
            this.remove((IProjectFragment)element);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int eventType = event.getType();
        IResource resource = event.getResource();
        switch (eventType) {
            case 4: {
                if (resource.getType() == 4 && DLTKLanguageManager.hasScriptNature((IProject)resource)) {
                    this.remove((IProject)resource);
                }
                return;
            }
        }
    }
}

