/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.core.SourceRefElement;

public class DuplicateResolver {
    public static Resolver create() {
        return new DuplicateResolverImpl();
    }

    private static class Counter {
        int value;

        private Counter() {
        }
    }

    private static class DuplicateResolverImpl
    extends HashMap<SourceRefElement, Counter>
    implements Resolver {
        private DuplicateResolverImpl() {
        }

        @Override
        public void resolveDuplicates(SourceRefElement handle) {
            Assert.isTrue((handle.occurrenceCount == 1 ? 1 : 0) != 0);
            Counter counter = (Counter)this.get(handle);
            if (counter == null) {
                counter = new Counter();
                counter.value = handle.occurrenceCount;
                this.put(handle, counter);
            } else {
                ++counter.value;
                handle.occurrenceCount = counter.value;
            }
        }
    }

    public static interface Resolver {
        public void resolveDuplicates(SourceRefElement var1);
    }
}

