/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;
import org.eclipse.dltk.internal.core.search.IndexSelector;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class ModuleFactory {
    private final HandleFactory handleFactory;
    private final IDLTKSearchScope scope;

    public ModuleFactory(IDLTKSearchScope scope) {
        this(new HandleFactory(), scope);
    }

    ModuleFactory(HandleFactory handleFactory, IDLTKSearchScope scope) {
        this.handleFactory = handleFactory;
        this.scope = scope;
    }

    public ISourceModule create(SearchDocument searchDocument) {
        if (searchDocument instanceof WorkingCopyDocument) {
            return ((WorkingCopyDocument)searchDocument).workingCopy;
        }
        Openable openable = this.handleFactory.createOpenable(searchDocument.getPath(), this.scope);
        return openable instanceof ISourceModule ? (ISourceModule)((Object)openable) : null;
    }

    public static ISourceModule[] selectWorkingCopies(SearchDocument[] searchDocuments) {
        ArrayList<ISourceModule> copies = new ArrayList<ISourceModule>();
        int i = 0;
        int length = searchDocuments.length;
        while (i < length) {
            SearchDocument document = searchDocuments[i];
            if (document instanceof WorkingCopyDocument) {
                copies.add(((WorkingCopyDocument)document).workingCopy);
            }
            ++i;
        }
        return copies.toArray(new ISourceModule[copies.size()]);
    }

    public static SearchDocument[] addWorkingCopies(SearchPattern pattern, SearchDocument[] indexMatches, ISourceModule[] copies, SearchParticipant participant) {
        int remainingWorkingCopiesSize;
        Map<String, SearchDocument> workingCopyDocuments = ModuleFactory.workingCopiesThatCanSeeFocus(copies, pattern.focus, pattern.isPolymorphicSearch(), participant);
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        int i = 0;
        while (i < length) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() == participant && (workingCopyDocument = workingCopyDocuments.remove(searchDocument.getPath())) != null) {
                if (matches == null) {
                    matches = new SearchDocument[length];
                    System.arraycopy(indexMatches, 0, matches, 0, length);
                }
                matches[i] = workingCopyDocument;
            }
            ++i;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            int index = length;
            for (SearchDocument document : workingCopyDocuments.values()) {
                matches[index++] = document;
            }
        }
        return matches;
    }

    private static Map<String, SearchDocument> workingCopiesThatCanSeeFocus(ISourceModule[] copies, IModelElement focus, boolean isPolymorphicSearch, SearchParticipant participant) {
        if (copies == null) {
            return Collections.emptyMap();
        }
        if (focus != null) {
            while (!(focus instanceof IScriptProject) && !(focus instanceof ArchiveProjectFragment)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, SearchDocument> result = new HashMap<String, SearchDocument>();
        int i = 0;
        int length = copies.length;
        while (i < length) {
            ISourceModule workingCopy = copies[i];
            IPath projectOrArchive = MatchLocator.getProjectOrArchive(workingCopy).getPath();
            if (focus == null || IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrArchive)) {
                boolean external = false;
                IProjectFragment frag = (IProjectFragment)workingCopy.getAncestor(3);
                if (frag != null) {
                    external = frag.isExternal();
                }
                result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy, participant, external));
            }
            ++i;
        }
        return result;
    }

    private static class WorkingCopyDocument
    extends DLTKSearchDocument {
        public ISourceModule workingCopy;

        WorkingCopyDocument(ISourceModule workingCopy, SearchParticipant participant, boolean external) {
            super(workingCopy.getPath().toString(), WorkingCopyDocument.getContents(workingCopy), participant, external, workingCopy.getScriptProject().getProject());
            this.workingCopy = workingCopy;
        }

        private static char[] getContents(ISourceModule workingCopy) {
            try {
                return workingCopy.getSourceAsCharArray();
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return new char[0];
            }
        }

        @Override
        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }
}

