/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.task;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.compiler.task.TodoTask;

public abstract class TaskTagUtils {
    private static final String TAG_SEPARATOR = ",";
    private static final String PRIORITY_SEPARATOR = ";";

    public static List<TodoTask> decodeTaskTags(String tags) {
        String[] tagPairs = TaskTagUtils.getTokens(tags, TAG_SEPARATOR);
        ArrayList<TodoTask> elements = new ArrayList<TodoTask>();
        int i = 0;
        while (i < tagPairs.length) {
            String[] values = TaskTagUtils.getTokens(tagPairs[i], PRIORITY_SEPARATOR);
            TodoTask task = new TodoTask();
            task.name = values[0];
            task.priority = values.length == 2 ? values[1] : "NORMAL";
            elements.add(task);
            ++i;
        }
        return elements;
    }

    public static String encodeTaskTags(List<TodoTask> elements) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < elements.size()) {
            TodoTask task = elements.get(i);
            if (i > 0) {
                sb.append(TAG_SEPARATOR);
            }
            sb.append(task.name);
            sb.append(PRIORITY_SEPARATOR);
            sb.append(task.priority);
            ++i;
        }
        String string = sb.toString();
        return string;
    }

    public static List<TodoTask> getDefaultTags() {
        ArrayList<TodoTask> defaultTags = new ArrayList<TodoTask>();
        defaultTags.add(new TodoTask("FIXME", "HIGH"));
        defaultTags.add(new TodoTask("TODO", "NORMAL"));
        defaultTags.add(new TodoTask("XXX", "NORMAL"));
        return defaultTags;
    }

    @Deprecated
    public static void initializeDefaultValues(Preferences store) {
        TaskTagUtils.initializeDefaultValues(store, null);
    }

    @Deprecated
    public static void initializeDefaultValues(Preferences store, List<TodoTask> taskTags) {
        store.setDefault("org.eclipse.dltk.coretasks.enabled", true);
        store.setDefault("org.eclipse.dltk.coretasks.case_sensitive", true);
        store.setDefault("org.eclipse.dltk.coretasks.tags", TaskTagUtils.encodeTaskTags(taskTags != null ? taskTags : TaskTagUtils.getDefaultTags()));
    }

    public static void initializeDefaultValues(IEclipsePreferences prefs) {
        prefs.putBoolean("org.eclipse.dltk.coretasks.enabled", true);
        prefs.putBoolean("org.eclipse.dltk.coretasks.case_sensitive", true);
        prefs.put("org.eclipse.dltk.coretasks.tags", TaskTagUtils.encodeTaskTags(TaskTagUtils.getDefaultTags()));
    }

    public static boolean isValidName(String newText) {
        return newText.indexOf(TAG_SEPARATOR.charAt(0)) < 0 && newText.indexOf(PRIORITY_SEPARATOR.charAt(0)) < 0;
    }

    private static String[] getTokens(String text, String separator) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int nTokens = tok.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken().trim();
            ++i;
        }
        return res;
    }
}

