/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.rules;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.text.rules.IScriptWordDetector;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class ScriptWordRule
implements IRule {
    protected static final int UNDEFINED = -1;
    protected IWordDetector fDetector;
    protected IToken fDefaultToken;
    protected int fColumn = -1;
    protected Map<String, IToken> fWords = new HashMap<String, IToken>();
    private StringBuffer fBuffer = new StringBuffer();
    private boolean fIgnoreCase = false;
    private int fLastSeenEnd = 0;
    private String fLastSeen = "";
    private Map<String, IToken> fNext = new HashMap<String, IToken>();

    public ScriptWordRule(IWordDetector detector) {
        this(detector, Token.UNDEFINED, false);
    }

    public ScriptWordRule(IWordDetector detector, IToken defaultToken) {
        this(detector, defaultToken, false);
    }

    public ScriptWordRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
        Assert.isNotNull((Object)detector);
        Assert.isNotNull((Object)defaultToken);
        this.fDetector = detector;
        this.fDefaultToken = defaultToken;
        this.fIgnoreCase = ignoreCase;
    }

    public void addWord(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        this.fWords.put(word, token);
    }

    public void addNextTokenAfterSeen(String word, IToken token) {
        Assert.isNotNull((Object)word);
        Assert.isNotNull((Object)token);
        this.fNext.put(word, token);
    }

    public void setColumnConstraint(int column) {
        if (column < 0) {
            column = -1;
        }
        this.fColumn = column;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c;
        if (this.fDetector instanceof IScriptWordDetector && scanner.getColumn() > 0) {
            scanner.unread();
            c = scanner.read();
            if (!((IScriptWordDetector)this.fDetector).isPriorCharValid((char)c)) {
                return Token.UNDEFINED;
            }
        }
        if (this.fDetector.isWordStart((char)(c = scanner.read())) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String buffer = this.fBuffer.toString();
            if (this.fNext.containsKey(this.fLastSeen) && !buffer.startsWith(this.fLastSeen) && scanner.getColumn() > this.fLastSeenEnd) {
                IToken replace = this.fNext.get(this.fLastSeen);
                this.fLastSeen = buffer;
                this.fLastSeenEnd = scanner.getColumn();
                return replace;
            }
            IToken token = this.fWords.get(buffer);
            if (this.fIgnoreCase) {
                for (String key : this.fWords.keySet()) {
                    if (!buffer.equalsIgnoreCase(key)) continue;
                    token = this.fWords.get(key);
                    break;
                }
            }
            if (token != null) {
                this.fLastSeen = buffer;
                this.fLastSeenEnd = scanner.getColumn();
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

