/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import com.ibm.icu.text.MessageFormat;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.launching.AbstractRuntimeBuildpathEntry;
import org.eclipse.dltk.internal.launching.RuntimeBuildpathEntry;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultProjectBuildpathEntry
extends AbstractRuntimeBuildpathEntry {
    public static final String TYPE_ID = "org.eclipse.dltk.launching.buildpathentry.defaultBuildpath";
    private boolean fExportedEntriesOnly = false;

    public DefaultProjectBuildpathEntry() {
    }

    public DefaultProjectBuildpathEntry(IScriptProject project) {
        this.setScriptProject(project);
    }

    @Override
    protected void buildMemento(Document document, Element memento) throws CoreException {
        memento.setAttribute("project", this.getScriptProject().getElementName());
        memento.setAttribute("exportedEntriesOnly", Boolean.toString(this.fExportedEntriesOnly));
    }

    @Override
    public void initializeFrom(Element memento) throws CoreException {
        String name = memento.getAttribute("project");
        if (name == null) {
            this.abort(LaunchingMessages.DefaultProjectBuildpathEntry_3, null);
        }
        IScriptProject project = DLTKCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(name));
        this.setScriptProject(project);
        name = memento.getAttribute("exportedEntriesOnly");
        this.fExportedEntriesOnly = name == null ? false : Boolean.valueOf(name);
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    @Override
    public int getType() {
        return 5;
    }

    protected IProject getProject() {
        return this.getScriptProject().getProject();
    }

    @Override
    public String getLocation() {
        return this.getProject().getLocation().toOSString();
    }

    @Override
    public URI getLocationURI() {
        return this.getProject().getLocationURI();
    }

    @Override
    public IPath getPath() {
        return this.getProject().getFullPath();
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    @Override
    public IRuntimeBuildpathEntry[] getRuntimeBuildpathEntries(ILaunchConfiguration configuration) throws CoreException {
        IBuildpathEntry entry = DLTKCore.newProjectEntry((IPath)this.getScriptProject().getProject().getFullPath());
        ArrayList buildpathEntries = new ArrayList(5);
        ArrayList<IBuildpathEntry> expanding = new ArrayList<IBuildpathEntry>(5);
        this.expandProject(entry, buildpathEntries, expanding);
        IRuntimeBuildpathEntry[] runtimeEntries = new IRuntimeBuildpathEntry[buildpathEntries.size()];
        int i = 0;
        while (i < runtimeEntries.length) {
            Object e = buildpathEntries.get(i);
            if (e instanceof IBuildpathEntry) {
                IBuildpathEntry cpe = (IBuildpathEntry)e;
                runtimeEntries[i] = new RuntimeBuildpathEntry(cpe);
            } else {
                runtimeEntries[i] = (IRuntimeBuildpathEntry)e;
            }
            ++i;
        }
        ArrayList<IRuntimeBuildpathEntry> ordered = new ArrayList<IRuntimeBuildpathEntry>(runtimeEntries.length);
        int i2 = 0;
        while (i2 < runtimeEntries.length) {
            if (runtimeEntries[i2].getBuildpathProperty() == 3) {
                ordered.add(runtimeEntries[i2]);
            }
            ++i2;
        }
        return ordered.toArray(new IRuntimeBuildpathEntry[ordered.size()]);
    }

    private void expandProject(IBuildpathEntry projectEntry, List expandedPath, List<IBuildpathEntry> expanding) throws CoreException {
        expanding.add(projectEntry);
        IPath projectPath = projectEntry.getPath();
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(projectPath.lastSegment());
        if (res == null) {
            expandedPath.add(projectEntry);
            return;
        }
        IScriptProject project = (IScriptProject)DLTKCore.create((IResource)res);
        if (project == null || !project.getProject().isOpen() || !project.exists()) {
            expandedPath.add(projectEntry);
            return;
        }
        IBuildpathEntry[] buildPath = project.getRawBuildpath();
        ArrayList<IBuildpathEntry> unexpandedPath = new ArrayList<IBuildpathEntry>(buildPath.length);
        int i = 0;
        while (i < buildPath.length) {
            IBuildpathEntry buildpathEntry = buildPath[i];
            if (buildpathEntry.getEntryKind() == 3) {
                unexpandedPath.add(buildpathEntry);
            } else if (buildpathEntry.isExported()) {
                unexpandedPath.add(buildpathEntry);
            } else if (!this.isExportedEntriesOnly() || project.equals(this.getScriptProject())) {
                unexpandedPath.add(buildpathEntry);
            }
            ++i;
        }
        block10: for (IBuildpathEntry entry : unexpandedPath) {
            if (entry == projectEntry) {
                expandedPath.add(entry);
                continue;
            }
            switch (entry.getEntryKind()) {
                case 2: {
                    if (expanding.contains(entry)) continue block10;
                    this.expandProject(entry, expandedPath, expanding);
                    break;
                }
                case 5: {
                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)project);
                    int property = -1;
                    if (container == null) continue block10;
                    switch (container.getKind()) {
                        case 1: {
                            property = 3;
                            break;
                        }
                        case 3: {
                            property = 1;
                            break;
                        }
                        case 2: {
                            property = 2;
                        }
                    }
                    IRuntimeBuildpathEntry r = ScriptRuntime.newRuntimeContainerBuildpathEntry(entry.getPath(), property, project);
                    boolean duplicate = false;
                    BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer((String)r.getPath().segment(0));
                    int i2 = 0;
                    while (i2 < expandedPath.size()) {
                        IRuntimeBuildpathEntry re;
                        Object o = expandedPath.get(i2);
                        if (o instanceof IRuntimeBuildpathEntry && (re = (IRuntimeBuildpathEntry)o).getType() == 4) {
                            BuildpathContainerInitializer initializer2 = DLTKCore.getBuildpathContainerInitializer((String)re.getPath().segment(0));
                            Object id1 = null;
                            Object id2 = null;
                            id1 = initializer == null ? r.getPath().segment(0) : initializer.getComparisonID(r.getPath(), project);
                            if (initializer2 == null) {
                                id2 = re.getPath().segment(0);
                            } else {
                                IScriptProject context = re.getScriptProject();
                                if (context == null) {
                                    context = project;
                                }
                                id2 = initializer2.getComparisonID(re.getPath(), context);
                            }
                            duplicate = id1 == null ? id2 == null : id1.equals(id2);
                            if (duplicate) break;
                        }
                        ++i2;
                    }
                    if (duplicate) continue block10;
                    expandedPath.add(r);
                    break;
                }
                default: {
                    if (expandedPath.contains(entry)) continue block10;
                    expandedPath.add(entry);
                }
            }
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public String getName() {
        if (this.isExportedEntriesOnly()) {
            return MessageFormat.format((String)LaunchingMessages.DefaultProjectBuildpathEntry_2, (Object[])new Object[]{this.getScriptProject().getElementName()});
        }
        return MessageFormat.format((String)LaunchingMessages.DefaultProjectBuildpathEntry_4, (Object[])new Object[]{this.getScriptProject().getElementName()});
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultProjectBuildpathEntry) {
            DefaultProjectBuildpathEntry entry = (DefaultProjectBuildpathEntry)obj;
            return entry.getScriptProject().equals(this.getScriptProject()) && entry.isExportedEntriesOnly() == this.isExportedEntriesOnly();
        }
        return false;
    }

    public int hashCode() {
        return this.getScriptProject().hashCode();
    }

    public void setExportedEntriesOnly(boolean exportedOnly) {
        this.fExportedEntriesOnly = exportedOnly;
    }

    public boolean isExportedEntriesOnly() {
        return this.fExportedEntriesOnly;
    }
}

