/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ScriptConsoleHistory {
    private final List<String> lines = new ArrayList<String>();
    private int selection = 0;

    public ScriptConsoleHistory() {
        this.lines.add("");
    }

    private void addToHistory(String line) {
        int index = this.lines.indexOf(line);
        if (index >= 0 && index != this.lines.size() - 1) {
            this.lines.remove(index);
        }
        this.lines.set(this.lines.size() - 1, line);
    }

    public void add(String line) {
        if (line != null && line.length() != 0) {
            this.addToHistory(line);
            this.lines.add("");
            this.selection = this.lines.size() - 1;
        }
    }

    public boolean prev() {
        if (this.selection > 0) {
            --this.selection;
            return true;
        }
        return false;
    }

    public boolean next() {
        if (this.selection < this.lines.size() - 1) {
            ++this.selection;
            return true;
        }
        return false;
    }

    public String get() {
        return this.lines.get(this.selection);
    }

    public void updateSelectedLine(String line) {
        if (this.selection >= 0 && this.selection < this.lines.size()) {
            this.lines.set(this.selection, line);
        }
    }

    public void restoreState(String history) {
        if (history != null && history.length() != 0) {
            StringTokenizer st = new StringTokenizer(history, "\n");
            while (st.hasMoreTokens()) {
                this.add(st.nextToken());
            }
        }
    }

    public String saveState() {
        int size = Math.min(this.lines.size(), 50);
        StringBuffer sb = new StringBuffer(size * 10);
        int i = 0;
        while (i < size) {
            sb.append(this.lines.get(i));
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

